/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.util.PackedInteger;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.Importer;

final class IndexOutputBuffer
implements Comparable<IndexOutputBuffer> {
    private static final int REC_OVERHEAD = 5;
    private static final byte DEL = 0;
    private static final byte INS = 1;
    private final int size;
    private final byte[] buffer;
    private long bufferID;
    private int keyOffset;
    private int recordOffset;
    private int bytesLeft;
    private int keys;
    private int position;
    private Importer.IndexKey indexKey;
    private static final int CAP = 32;
    private ByteBuffer keyBuffer = ByteBuffer.allocate(32);
    private boolean discarded;

    public IndexOutputBuffer(int size) {
        this.size = size;
        this.buffer = new byte[size];
        this.bytesLeft = size;
        this.recordOffset = size - 1;
    }

    public void reset() {
        this.bytesLeft = this.size;
        this.keyOffset = 0;
        this.recordOffset = this.size - 1;
        this.keys = 0;
        this.position = 0;
        this.indexKey = null;
    }

    public static IndexOutputBuffer poison() {
        return new IndexOutputBuffer(0);
    }

    public void setBufferID(long bufferID) {
        this.bufferID = bufferID;
    }

    private long getBufferID() {
        return this.bufferID;
    }

    public boolean isPoison() {
        return this.size == 0;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public void discard() {
        this.discarded = true;
    }

    public boolean isSpaceAvailable(byte[] kBytes, long entryID) {
        return IndexOutputBuffer.getRequiredSize(kBytes.length, entryID) < this.bytesLeft;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void sort() {
        this.sort(0, this.keys);
    }

    public void add(byte[] keyBytes, EntryID entryID, int indexID, boolean insert) {
        this.recordOffset = this.addRecord(keyBytes, entryID.longValue(), indexID, insert);
        this.keyOffset += this.writeIntBytes(this.buffer, this.keyOffset, this.recordOffset);
        this.bytesLeft = this.recordOffset - this.keyOffset;
        ++this.keys;
    }

    private int addRecord(byte[] key, long entryID, int indexID, boolean insert) {
        int retOffset;
        int offSet = retOffset = this.recordOffset - IndexOutputBuffer.getRecordSize(key.length, entryID);
        this.buffer[offSet++] = insert ? (byte)1 : 0;
        offSet += this.writeIntBytes(this.buffer, offSet, indexID);
        offSet = PackedInteger.writeLong((byte[])this.buffer, (int)offSet, (long)entryID);
        offSet = PackedInteger.writeInt((byte[])this.buffer, (int)offSet, (int)key.length);
        System.arraycopy(key, 0, this.buffer, offSet, key.length);
        return retOffset;
    }

    public static int getRequiredSize(int keyLen, long entryID) {
        return IndexOutputBuffer.getRecordSize(keyLen, entryID) + 4;
    }

    private static int getRecordSize(int keyLen, long entryID) {
        return PackedInteger.getWriteIntLength((int)keyLen) + keyLen + PackedInteger.getWriteLongLength((long)entryID) + 5;
    }

    public void writeEntryID(ByteArrayOutputStream stream, int position) {
        int offSet = this.getOffset(position);
        int len = PackedInteger.getReadLongLength((byte[])this.buffer, (int)(offSet + 5));
        stream.write(this.buffer, offSet + 5, len);
    }

    public boolean isInsertRecord(int position) {
        int recOffset = this.getOffset(position);
        return this.buffer[recOffset] == 1;
    }

    public int getKeySize() {
        int offSet = this.getOffset(this.position) + 5;
        offSet += PackedInteger.getReadLongLength((byte[])this.buffer, (int)offSet);
        return PackedInteger.readInt((byte[])this.buffer, (int)offSet);
    }

    public byte[] getKey() {
        return this.getKey(this.position);
    }

    private ByteBuffer getKeyBuf(int position) {
        this.keyBuffer.clear();
        int offSet = this.getOffset(position) + 5;
        offSet += PackedInteger.getReadLongLength((byte[])this.buffer, (int)offSet);
        int keyLen = PackedInteger.readInt((byte[])this.buffer, (int)offSet);
        offSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offSet);
        if (keyLen > this.keyBuffer.capacity()) {
            this.keyBuffer = ByteBuffer.allocate(keyLen);
        }
        this.keyBuffer.put(this.buffer, offSet, keyLen);
        this.keyBuffer.flip();
        return this.keyBuffer;
    }

    private byte[] getKey(int position) {
        int offSet = this.getOffset(position) + 5;
        offSet += PackedInteger.getReadLongLength((byte[])this.buffer, (int)offSet);
        int keyLen = PackedInteger.readInt((byte[])this.buffer, (int)offSet);
        offSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offSet);
        byte[] key = new byte[keyLen];
        System.arraycopy(this.buffer, offSet, key, 0, keyLen);
        return key;
    }

    private int getOffset(int position) {
        return this.getIntegerValue(position * 4);
    }

    public int getIndexID() {
        return this.getIndexID(this.position);
    }

    private int getIndexID(int position) {
        return this.getIndexIDFromOffset(this.getOffset(position));
    }

    private int getIndexIDFromOffset(int offset) {
        return this.getIntegerValue(offset + 1);
    }

    private boolean is(CompareOp op, int xPosition, int yPosition) {
        int xoffSet = this.getOffset(xPosition);
        int xIndexID = this.getIndexIDFromOffset(xoffSet);
        xoffSet += 5;
        xoffSet += PackedInteger.getReadLongLength((byte[])this.buffer, (int)xoffSet);
        int xKeyLen = PackedInteger.readInt((byte[])this.buffer, (int)xoffSet);
        int xKey = PackedInteger.getReadIntLength((byte[])this.buffer, (int)xoffSet) + xoffSet;
        int yoffSet = this.getOffset(yPosition);
        int yIndexID = this.getIndexIDFromOffset(yoffSet);
        yoffSet += 5;
        yoffSet += PackedInteger.getReadLongLength((byte[])this.buffer, (int)yoffSet);
        int yKeyLen = PackedInteger.readInt((byte[])this.buffer, (int)yoffSet);
        int yKey = PackedInteger.getReadIntLength((byte[])this.buffer, (int)yoffSet) + yoffSet;
        int cmp = Importer.indexComparator.compare(this.buffer, xKey, xKeyLen, xIndexID, yKey, yKeyLen, yIndexID);
        return this.evaluateReturnCode(cmp, op);
    }

    private boolean is(CompareOp op, int xPosition, byte[] yKey, int yIndexID) {
        int xoffSet = this.getOffset(xPosition);
        int xIndexID = this.getIndexIDFromOffset(xoffSet);
        xoffSet += 5;
        xoffSet += PackedInteger.getReadLongLength((byte[])this.buffer, (int)xoffSet);
        int xKeyLen = PackedInteger.readInt((byte[])this.buffer, (int)xoffSet);
        int xKey = PackedInteger.getReadIntLength((byte[])this.buffer, (int)xoffSet) + xoffSet;
        int cmp = Importer.indexComparator.compare(this.buffer, xKey, xKeyLen, xIndexID, yKey, yKey.length, yIndexID);
        return this.evaluateReturnCode(cmp, op);
    }

    public boolean compare(byte[] b, int bIndexID) {
        int offset = this.getOffset(this.position);
        int indexID = this.getIndexIDFromOffset(offset);
        offset += 5;
        offset += PackedInteger.getReadLongLength((byte[])this.buffer, (int)offset);
        int keyLen = PackedInteger.readInt((byte[])this.buffer, (int)offset);
        int key = PackedInteger.getReadIntLength((byte[])this.buffer, (int)offset) + offset;
        return Importer.indexComparator.compare(this.buffer, key, keyLen, b, b.length) == 0 && indexID == bIndexID;
    }

    @Override
    public int compareTo(IndexOutputBuffer b) {
        ByteBuffer keyBuf = b.getKeyBuf(b.position);
        int offset = this.getOffset(this.position);
        int indexID = this.getIndexIDFromOffset(offset);
        offset += 5;
        offset += PackedInteger.getReadLongLength((byte[])this.buffer, (int)offset);
        int keyLen = PackedInteger.readInt((byte[])this.buffer, (int)offset);
        int key = PackedInteger.getReadIntLength((byte[])this.buffer, (int)offset) + offset;
        int cmp = Importer.indexComparator.compare(this.buffer, key, keyLen, keyBuf.array(), keyBuf.limit());
        if (cmp != 0) {
            return cmp;
        }
        int bIndexID = b.getIndexID();
        if (indexID == bIndexID) {
            return this.compare(this.bufferID, b.getBufferID());
        }
        if (indexID < bIndexID) {
            return -1;
        }
        return 1;
    }

    private int compare(long l1, long l2) {
        if (l1 == l2) {
            return 0;
        }
        if (l1 < l2) {
            return -1;
        }
        return 1;
    }

    public void writeKey(DataOutputStream dataStream) throws IOException {
        int offSet = this.getOffset(this.position) + 5;
        offSet += PackedInteger.getReadLongLength((byte[])this.buffer, (int)offSet);
        int keyLen = PackedInteger.readInt((byte[])this.buffer, (int)offSet);
        offSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offSet);
        dataStream.write(this.buffer, offSet, keyLen);
    }

    public boolean compare(int i) {
        return this.is(CompareOp.EQ, i, this.position);
    }

    public int getNumberKeys() {
        return this.keys;
    }

    public boolean hasMoreData() {
        return this.position + 1 < this.keys;
    }

    public void nextRecord() {
        ++this.position;
    }

    private int writeIntBytes(byte[] buffer, int offset, int val) {
        for (int i = offset + 4 - 1; i >= offset; --i) {
            buffer[i] = (byte)(val & 0xFF);
            val >>>= 8;
        }
        return 4;
    }

    private int getIntegerValue(int index) {
        int answer = 0;
        for (int i = 0; i < 4; ++i) {
            byte b = this.buffer[index + i];
            answer <<= 8;
            answer |= b & 0xFF;
        }
        return answer;
    }

    private int med3(int a, int b, int c) {
        return this.is(CompareOp.LT, a, b) ? (this.is(CompareOp.LT, b, c) ? b : (this.is(CompareOp.LT, a, c) ? c : a)) : (this.is(CompareOp.GT, b, c) ? b : (this.is(CompareOp.GT, a, c) ? c : a));
    }

    private void sort(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.is(CompareOp.GT, j - 1, j); --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        byte[] mKey = this.getKey(m);
        int mIndexID = this.getIndexID(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.is(CompareOp.LE, b, mKey, mIndexID)) {
                if (this.is(CompareOp.EQ, b, mKey, mIndexID)) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.is(CompareOp.GE, c, mKey, mIndexID)) {
                if (this.is(CompareOp.EQ, c, mKey, mIndexID)) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vectorSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vectorSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort(n - s, s);
        }
    }

    private void swap(int a, int b) {
        int aOffset = a * 4;
        int bOffset = b * 4;
        int bVal = this.getIntegerValue(bOffset);
        System.arraycopy(this.buffer, aOffset, this.buffer, bOffset, 4);
        this.writeIntBytes(this.buffer, aOffset, bVal);
    }

    private void vectorSwap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private boolean evaluateReturnCode(int rc, CompareOp op) {
        switch (op) {
            case LT: {
                return rc < 0;
            }
            case GT: {
                return rc > 0;
            }
            case LE: {
                return rc <= 0;
            }
            case GE: {
                return rc >= 0;
            }
            case EQ: {
                return rc == 0;
            }
        }
        return false;
    }

    public void setIndexKey(Importer.IndexKey indexKey) {
        this.indexKey = indexKey;
    }

    public Importer.IndexKey getIndexKey() {
        return this.indexKey;
    }

    public static class IndexComparator
    implements ComparatorBuffer<byte[]> {
        @Override
        public int compare(byte[] b, int offset, int length, int indexID, int otherOffset, int otherLength, int otherIndexID) {
            for (int i = 0; i < length && i < otherLength; ++i) {
                if (b[offset + i] > b[otherOffset + i]) {
                    return 1;
                }
                if (b[offset + i] >= b[otherOffset + i]) continue;
                return -1;
            }
            return this.compareLengthThenIndexID(length, indexID, otherLength, otherIndexID);
        }

        @Override
        public int compare(byte[] b, int offset, int length, int indexID, byte[] other, int otherLength, int otherIndexID) {
            for (int i = 0; i < length && i < otherLength; ++i) {
                if (b[offset + i] > other[i]) {
                    return 1;
                }
                if (b[offset + i] >= other[i]) continue;
                return -1;
            }
            return this.compareLengthThenIndexID(length, indexID, otherLength, otherIndexID);
        }

        private int compareLengthThenIndexID(int length, int indexID, int otherLength, int otherIndexID) {
            if (length == otherLength) {
                return this.compare(indexID, otherIndexID);
            }
            if (length > otherLength) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compare(byte[] b, int offset, int length, byte[] other, int otherLength) {
            for (int i = 0; i < length && i < otherLength; ++i) {
                if (b[offset + i] > other[i]) {
                    return 1;
                }
                if (b[offset + i] >= other[i]) continue;
                return -1;
            }
            return this.compare(length, otherLength);
        }

        private int compare(int i1, int i2) {
            if (i1 == i2) {
                return 0;
            }
            if (i1 > i2) {
                return 1;
            }
            return -1;
        }
    }

    public static interface ComparatorBuffer<T> {
        public int compare(T var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public int compare(T var1, int var2, int var3, int var4, T var5, int var6, int var7);

        public int compare(T var1, int var2, int var3, T var4, int var5);
    }

    private static enum CompareOp {
        LT,
        GT,
        LE,
        GE,
        EQ;

    }
}

