/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opends.messages.BackendMessages;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DatabaseEnvironmentMonitor;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.IndexQuery;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.FilterType;
import org.opends.server.types.SearchFilter;

public class IndexFilter {
    public static final int FILTER_CANDIDATE_THRESHOLD = 10;
    private final EntryContainer entryContainer;
    private final SearchOperation searchOp;
    private final StringBuilder buffer;
    private final DatabaseEnvironmentMonitor monitor;

    public IndexFilter(EntryContainer entryContainer, SearchOperation searchOp, StringBuilder debugBuilder, DatabaseEnvironmentMonitor monitor) {
        this.entryContainer = entryContainer;
        this.searchOp = searchOp;
        this.buffer = debugBuilder;
        this.monitor = monitor;
    }

    public EntryIDSet evaluate() {
        if (this.buffer != null) {
            this.buffer.append("filter=");
        }
        return this.evaluateFilter(this.searchOp.getFilter());
    }

    private EntryIDSet evaluateFilter(SearchFilter filter) {
        EntryIDSet candidates = this.evaluate(filter);
        if (this.buffer != null) {
            candidates.toString(this.buffer);
        }
        return candidates;
    }

    private EntryIDSet evaluate(SearchFilter filter) {
        switch (filter.getFilterType()) {
            case AND: {
                if (this.buffer != null) {
                    this.buffer.append("(&");
                }
                EntryIDSet res1 = this.evaluateLogicalAndFilter(filter);
                if (this.buffer != null) {
                    this.buffer.append(")");
                }
                return res1;
            }
            case OR: {
                if (this.buffer != null) {
                    this.buffer.append("(|");
                }
                EntryIDSet res2 = this.evaluateLogicalOrFilter(filter);
                if (this.buffer != null) {
                    this.buffer.append(")");
                }
                return res2;
            }
            case EQUALITY: {
                return this.evaluateFilterWithDiagnostic(AttributeIndex.IndexFilterType.EQUALITY, filter);
            }
            case GREATER_OR_EQUAL: {
                return this.evaluateFilterWithDiagnostic(AttributeIndex.IndexFilterType.GREATER_OR_EQUAL, filter);
            }
            case SUBSTRING: {
                return this.evaluateFilterWithDiagnostic(AttributeIndex.IndexFilterType.SUBSTRING, filter);
            }
            case LESS_OR_EQUAL: {
                return this.evaluateFilterWithDiagnostic(AttributeIndex.IndexFilterType.LESS_OR_EQUAL, filter);
            }
            case PRESENT: {
                return this.evaluateFilterWithDiagnostic(AttributeIndex.IndexFilterType.PRESENCE, filter);
            }
            case APPROXIMATE_MATCH: {
                return this.evaluateFilterWithDiagnostic(AttributeIndex.IndexFilterType.APPROXIMATE, filter);
            }
            case EXTENSIBLE_MATCH: {
                if (this.buffer != null) {
                    filter.toString(this.buffer);
                }
                return this.evaluateExtensibleFilter(filter);
            }
        }
        if (this.buffer != null) {
            filter.toString(this.buffer);
        }
        return new EntryIDSet();
    }

    private EntryIDSet evaluateLogicalAndFilter(SearchFilter andFilter) {
        ArrayList rangeList;
        EntryIDSet results = new EntryIDSet();
        ArrayList<SearchFilter> fastComps = new ArrayList<SearchFilter>();
        ArrayList<SearchFilter> otherComps = new ArrayList<SearchFilter>();
        HashMap<AttributeType, ArrayList> rangeComps = new HashMap<AttributeType, ArrayList>();
        for (SearchFilter filter : andFilter.getFilterComponents()) {
            FilterType filterType = filter.getFilterType();
            if (filterType == FilterType.GREATER_OR_EQUAL || filterType == FilterType.LESS_OR_EQUAL) {
                rangeList = (ArrayList)rangeComps.get(filter.getAttributeType());
                if (rangeList == null) {
                    rangeList = new ArrayList();
                    rangeComps.put(filter.getAttributeType(), rangeList);
                }
                rangeList.add(filter);
                continue;
            }
            if (filterType == FilterType.EQUALITY || filterType == FilterType.PRESENT || filterType == FilterType.APPROXIMATE_MATCH) {
                fastComps.add(filter);
                continue;
            }
            otherComps.add(filter);
        }
        if (this.evaluateFilters(results, fastComps) || this.evaluateFilters(results, otherComps) || rangeComps.isEmpty()) {
            return results;
        }
        ArrayList<SearchFilter> remainComps = new ArrayList<SearchFilter>();
        for (Map.Entry rangeEntry : rangeComps.entrySet()) {
            rangeList = (ArrayList)rangeEntry.getValue();
            if (rangeList.size() == 2) {
                SearchFilter filter1 = (SearchFilter)rangeList.get(0);
                SearchFilter filter2 = (SearchFilter)rangeList.get(1);
                AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex((AttributeType)rangeEntry.getKey());
                if (attributeIndex == null) {
                    if (!this.monitor.isFilterUseEnabled()) continue;
                    this.monitor.updateStats(SearchFilter.createANDFilter((Collection)rangeList), BackendMessages.INFO_INDEX_FILTER_INDEX_TYPE_DISABLED.get((Object)"ordering", (Object)((AttributeType)rangeEntry.getKey()).getNameOrOID()));
                    continue;
                }
                EntryIDSet set = attributeIndex.evaluateBoundedRange(filter1, filter2, this.buffer, this.monitor);
                if (this.monitor.isFilterUseEnabled() && set.isDefined()) {
                    this.monitor.updateStats(SearchFilter.createANDFilter((Collection)rangeList), set.size());
                }
                if (!this.retainAll(results, set)) continue;
                return results;
            }
            remainComps.addAll(rangeList);
        }
        this.evaluateFilters(results, remainComps);
        return results;
    }

    private boolean evaluateFilters(EntryIDSet results, ArrayList<SearchFilter> filters) {
        for (SearchFilter filter : filters) {
            EntryIDSet filteredSet = this.evaluateFilter(filter);
            if (!this.retainAll(results, filteredSet)) continue;
            return true;
        }
        return false;
    }

    private boolean retainAll(EntryIDSet a, EntryIDSet b) {
        a.retainAll(b);
        return a.isDefined() && a.size() <= 10L;
    }

    private EntryIDSet evaluateLogicalOrFilter(SearchFilter orFilter) {
        ArrayList<EntryIDSet> candidateSets = new ArrayList<EntryIDSet>(orFilter.getFilterComponents().size());
        for (SearchFilter filter : orFilter.getFilterComponents()) {
            EntryIDSet set = this.evaluateFilter(filter);
            if (!set.isDefined()) {
                return set;
            }
            candidateSets.add(set);
        }
        return EntryIDSet.unionOfSets(candidateSets, false);
    }

    private EntryIDSet evaluateFilterWithDiagnostic(AttributeIndex.IndexFilterType indexFilterType, SearchFilter filter) {
        if (this.buffer != null) {
            filter.toString(this.buffer);
        }
        return this.evaluateFilter(indexFilterType, filter);
    }

    private EntryIDSet evaluateFilter(AttributeIndex.IndexFilterType indexFilterType, SearchFilter filter) {
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(filter.getAttributeType());
        if (attributeIndex != null) {
            return attributeIndex.evaluateFilter(indexFilterType, filter, this.buffer, this.monitor);
        }
        if (this.monitor.isFilterUseEnabled()) {
            this.monitor.updateStats(filter, BackendMessages.INFO_INDEX_FILTER_INDEX_TYPE_DISABLED.get((Object)indexFilterType.toString(), (Object)filter.getAttributeType().getNameOrOID()));
        }
        return new EntryIDSet();
    }

    private EntryIDSet evaluateExtensibleFilter(SearchFilter extensibleFilter) {
        if (extensibleFilter.getDNAttributes()) {
            return IndexQuery.createNullIndexQuery().evaluate(null);
        }
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(extensibleFilter.getAttributeType());
        if (attributeIndex != null) {
            return attributeIndex.evaluateExtensibleFilter(extensibleFilter, this.buffer, this.monitor);
        }
        return IndexQuery.createNullIndexQuery().evaluate(null);
    }
}

