/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.SortValues;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.types.DirectoryException;

public class IndexBuffer {
    private final EntryContainer entryContainer;
    private final LinkedHashMap<Index, TreeMap<ByteString, BufferedIndexValues>> bufferedIndexes = new LinkedHashMap();
    private final LinkedHashMap<VLVIndex, BufferedVLVValues> bufferedVLVIndexes = new LinkedHashMap();

    public IndexBuffer(EntryContainer entryContainer) {
        this.entryContainer = entryContainer;
    }

    public BufferedVLVValues getVLVIndex(VLVIndex vlvIndex) {
        BufferedVLVValues bufferedValues = this.bufferedVLVIndexes.get(vlvIndex);
        if (bufferedValues == null) {
            bufferedValues = new BufferedVLVValues();
            this.bufferedVLVIndexes.put(vlvIndex, bufferedValues);
        }
        return bufferedValues;
    }

    BufferedIndexValues getBufferedIndexValues(Index index, ByteString keyBytes, Comparator<ByteSequence> bsComparator) {
        BufferedIndexValues values = null;
        TreeMap<Object, BufferedIndexValues> bufferedOperations = this.bufferedIndexes.get(index);
        if (bufferedOperations == null) {
            bufferedOperations = new TreeMap(bsComparator);
            this.bufferedIndexes.put(index, bufferedOperations);
        } else {
            values = bufferedOperations.get(keyBytes);
        }
        if (values == null) {
            values = new BufferedIndexValues();
            bufferedOperations.put(keyBytes, values);
        }
        return values;
    }

    public void flush(Transaction txn) throws DatabaseException, DirectoryException {
        DatabaseEntry key = new DatabaseEntry();
        for (AttributeIndex attributeIndex : this.entryContainer.getAttributeIndexes()) {
            for (Index index : attributeIndex.getAllIndexes()) {
                this.updateKeys(index, txn, key, (Map)this.bufferedIndexes.remove(index));
            }
        }
        for (VLVIndex vlvIndex : this.entryContainer.getVLVIndexes()) {
            BufferedVLVValues bufferedVLVValues = (BufferedVLVValues)this.bufferedVLVIndexes.remove(vlvIndex);
            if (bufferedVLVValues == null) continue;
            vlvIndex.updateIndex(txn, bufferedVLVValues.addedValues, bufferedVLVValues.deletedValues);
        }
        Index id2children = this.entryContainer.getID2Children();
        this.updateKeys(id2children, txn, key, (Map)this.bufferedIndexes.remove(id2children));
        Index id2subtree = this.entryContainer.getID2Subtree();
        TreeMap bufferedValues = (TreeMap)this.bufferedIndexes.remove(id2subtree);
        if (bufferedValues != null) {
            this.updateKeys(id2subtree, txn, key, bufferedValues.descendingMap());
        }
    }

    private void updateKeys(Index index, Transaction txn, DatabaseEntry key, Map<ByteString, BufferedIndexValues> bufferedValues) {
        if (bufferedValues != null) {
            Iterator<Map.Entry<ByteString, BufferedIndexValues>> it = bufferedValues.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ByteString, BufferedIndexValues> entry = it.next();
                ByteString bufferedKey = entry.getKey();
                BufferedIndexValues values = entry.getValue();
                key.setData(bufferedKey.toByteArray());
                index.updateKey(txn, key, values.deletedIDs, values.addedIDs);
                it.remove();
            }
        }
    }

    static class BufferedVLVValues {
        private TreeSet<SortValues> addedValues;
        private TreeSet<SortValues> deletedValues;

        BufferedVLVValues() {
        }

        void addValues(SortValues sortValues) {
            if (!this.remove(this.deletedValues, sortValues)) {
                if (this.addedValues == null) {
                    this.addedValues = new TreeSet();
                }
                this.addedValues.add(sortValues);
            }
        }

        void deleteValues(SortValues sortValues) {
            if (!this.remove(this.addedValues, sortValues)) {
                if (this.deletedValues == null) {
                    this.deletedValues = new TreeSet();
                }
                this.deletedValues.add(sortValues);
            }
        }

        private boolean remove(TreeSet<SortValues> values, SortValues sortValues) {
            if (values != null && values.contains(sortValues)) {
                values.remove(sortValues);
                return true;
            }
            return false;
        }
    }

    static class BufferedIndexValues {
        private EntryIDSet addedIDs;
        private EntryIDSet deletedIDs;

        BufferedIndexValues() {
        }

        void addEntryID(ByteString keyBytes, EntryID entryID) {
            if (!this.remove(this.deletedIDs, entryID)) {
                if (this.addedIDs == null) {
                    this.addedIDs = new EntryIDSet(keyBytes, null);
                }
                this.addedIDs.add(entryID);
            }
        }

        void deleteEntryID(ByteString keyBytes, EntryID entryID) {
            if (!this.remove(this.addedIDs, entryID)) {
                if (this.deletedIDs == null) {
                    this.deletedIDs = new EntryIDSet(keyBytes, null);
                }
                this.deletedIDs.add(entryID);
            }
        }

        private boolean remove(EntryIDSet ids, EntryID entryID) {
            if (ids != null && ids.contains(entryID)) {
                ids.remove(entryID);
                return true;
            }
            return false;
        }
    }
}

