/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.opends.messages.BackendMessages;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.ImportIDSet;
import org.opends.server.backends.jeb.IndexBuffer;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.backends.jeb.JEBUtils;
import org.opends.server.backends.jeb.State;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.util.StaticUtils;

public class Index
extends DatabaseContainer {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private Indexer indexer;
    private int indexEntryLimit;
    private final int cursorEntryLimit;
    private int entryLimitExceededCount;
    private final int phantomWriteRetries = 3;
    private final boolean maintainCount;
    private final State state;
    private boolean trusted;
    private final ImportIDSet newImportIDSet;

    Index(String name, Indexer indexer, State state, int indexEntryLimit, int cursorEntryLimit, boolean maintainCount, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        this.indexer = indexer;
        this.indexEntryLimit = indexEntryLimit;
        this.cursorEntryLimit = cursorEntryLimit;
        this.maintainCount = maintainCount;
        this.newImportIDSet = new ImportIDSet(indexEntryLimit, indexEntryLimit, maintainCount);
        this.dbConfig = JEBUtils.toDatabaseConfigNoDuplicates(env);
        this.dbConfig.setOverrideBtreeComparator(true);
        this.dbConfig.setBtreeComparator(indexer.getComparator().getClass());
        this.state = state;
        this.trusted = state.getIndexTrustState(null, this);
        if (!this.trusted && entryContainer.getHighestEntryID().longValue() == 0L) {
            this.setTrusted(null, true);
        }
    }

    void indexEntry(Entry entry, Set<ByteString> keys) {
        this.indexer.indexEntry(entry, keys);
    }

    void insertID(IndexBuffer buffer, ByteString keyBytes, EntryID entryID) {
        this.getBufferedIndexValues(buffer, keyBytes).addEntryID(keyBytes, entryID);
    }

    public void delete(DatabaseEntry key, ImportIDSet importIdSet, DatabaseEntry data) throws DatabaseException {
        if (this.read(null, key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            this.newImportIDSet.clear();
            this.newImportIDSet.remove(data.getData(), importIdSet);
            if (this.newImportIDSet.isDefined() && this.newImportIDSet.size() == 0) {
                this.delete(null, key);
            } else {
                data.setData(this.newImportIDSet.toDatabase());
                this.put(null, key, data);
            }
        } else {
            throw new RuntimeException();
        }
    }

    public void insert(DatabaseEntry key, ImportIDSet importIdSet, DatabaseEntry data) throws DatabaseException {
        OperationStatus status = this.read(null, key, data, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            this.newImportIDSet.clear();
            if (this.newImportIDSet.merge(data.getData(), importIdSet)) {
                ++this.entryLimitExceededCount;
            }
            data.setData(this.newImportIDSet.toDatabase());
            this.put(null, key, data);
        } else if (status == OperationStatus.NOTFOUND) {
            if (!importIdSet.isDefined()) {
                ++this.entryLimitExceededCount;
            }
            data.setData(importIdSet.toDatabase());
            this.put(null, key, data);
        } else {
            throw new RuntimeException();
        }
    }

    void updateKey(Transaction txn, DatabaseEntry key, EntryIDSet deletedIDs, EntryIDSet addedIDs) throws DatabaseException {
        block11: {
            OperationStatus status;
            DatabaseEntry data;
            block12: {
                block10: {
                    data = new DatabaseEntry();
                    if (deletedIDs == null && addedIDs == null) {
                        OperationStatus status2 = this.delete(txn, key);
                        if (status2 != OperationStatus.SUCCESS && logger.isTraceEnabled()) {
                            StringBuilder builder = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii((StringBuilder)builder, (byte[])key.getData(), (int)4);
                            logger.trace("The expected key does not exist in the index %s.\nKey:%s ", (Object)this.name, (Object)builder);
                        }
                        return;
                    }
                    if (this.isNullOrEmpty(deletedIDs) && this.isNullOrEmpty(addedIDs)) {
                        return;
                    }
                    if (!this.maintainCount) break block10;
                    for (int i = 0; i < 3; ++i) {
                        if (this.updateKeyWithRMW(txn, key, data, deletedIDs, addedIDs) != OperationStatus.SUCCESS) continue;
                        return;
                    }
                    break block11;
                }
                status = this.read(txn, key, data, LockMode.READ_COMMITTED);
                if (status != OperationStatus.SUCCESS) break block12;
                EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
                if (!entryIDList.isDefined()) break block11;
                for (int i = 0; i < 3; ++i) {
                    if (this.updateKeyWithRMW(txn, key, data, deletedIDs, addedIDs) != OperationStatus.SUCCESS) continue;
                    return;
                }
                break block11;
            }
            if (this.trusted) {
                if (deletedIDs != null) {
                    this.logIndexCorruptError(txn, key);
                }
                if (this.isNotNullOrEmpty(addedIDs)) {
                    data.setData(addedIDs.toDatabase());
                    status = this.insert(txn, key, data);
                    if (status == OperationStatus.KEYEXIST) {
                        for (int i = 1; i < 3; ++i) {
                            if (this.updateKeyWithRMW(txn, key, data, deletedIDs, addedIDs) != OperationStatus.SUCCESS) continue;
                            return;
                        }
                    }
                }
            }
        }
    }

    private boolean isNullOrEmpty(EntryIDSet entryIDSet) {
        return entryIDSet == null || entryIDSet.size() == 0L;
    }

    private boolean isNotNullOrEmpty(EntryIDSet entryIDSet) {
        return entryIDSet != null && entryIDSet.size() > 0L;
    }

    private OperationStatus updateKeyWithRMW(Transaction txn, DatabaseEntry key, DatabaseEntry data, EntryIDSet deletedIDs, EntryIDSet addedIDs) throws DatabaseException {
        OperationStatus status = this.read(txn, key, data, LockMode.RMW);
        if (status == OperationStatus.SUCCESS) {
            EntryIDSet entryIDList = this.computeEntryIDList(key, data, deletedIDs, addedIDs);
            byte[] after = entryIDList.toDatabase();
            if (after != null) {
                data.setData(after);
                return this.put(txn, key, data);
            }
            return this.delete(txn, key);
        }
        if (this.trusted) {
            if (deletedIDs != null) {
                this.logIndexCorruptError(txn, key);
            }
            if (this.isNotNullOrEmpty(addedIDs)) {
                data.setData(addedIDs.toDatabase());
                return this.insert(txn, key, data);
            }
        }
        return OperationStatus.SUCCESS;
    }

    private EntryIDSet computeEntryIDList(DatabaseEntry key, DatabaseEntry data, EntryIDSet deletedIDs, EntryIDSet addedIDs) {
        EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
        if (addedIDs != null) {
            if (entryIDList.isDefined() && this.indexEntryLimit > 0) {
                long idCountDelta = addedIDs.size();
                if (deletedIDs != null) {
                    idCountDelta -= deletedIDs.size();
                }
                if (idCountDelta + entryIDList.size() >= (long)this.indexEntryLimit) {
                    entryIDList = this.maintainCount ? new EntryIDSet(entryIDList.size() + idCountDelta) : new EntryIDSet();
                    ++this.entryLimitExceededCount;
                    if (logger.isTraceEnabled()) {
                        StringBuilder builder = new StringBuilder();
                        StaticUtils.byteArrayToHexPlusAscii((StringBuilder)builder, (byte[])key.getData(), (int)4);
                        logger.trace("Index entry exceeded in index %s. Limit: %d. ID list size: %d.\nKey:%s", new Object[]{this.name, this.indexEntryLimit, idCountDelta + addedIDs.size(), builder});
                    }
                } else {
                    entryIDList.addAll(addedIDs);
                    if (deletedIDs != null) {
                        entryIDList.deleteAll(deletedIDs);
                    }
                }
            } else {
                entryIDList.addAll(addedIDs);
                if (deletedIDs != null) {
                    entryIDList.deleteAll(deletedIDs);
                }
            }
        } else if (deletedIDs != null) {
            entryIDList.deleteAll(deletedIDs);
        }
        return entryIDList;
    }

    void removeID(IndexBuffer buffer, ByteString keyBytes, EntryID entryID) {
        this.getBufferedIndexValues(buffer, keyBytes).deleteEntryID(keyBytes, entryID);
    }

    private void logIndexCorruptError(Transaction txn, DatabaseEntry key) {
        if (logger.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder();
            StaticUtils.byteArrayToHexPlusAscii((StringBuilder)builder, (byte[])key.getData(), (int)4);
            logger.trace("The expected key does not exist in the index %s.\nKey:%s", (Object)this.name, (Object)builder);
        }
        this.setTrusted(txn, false);
        logger.error(BackendMessages.ERR_INDEX_CORRUPT_REQUIRES_REBUILD, (Object)this.name);
    }

    public void delete(IndexBuffer buffer, ByteString keyBytes) {
        this.getBufferedIndexValues(buffer, keyBytes);
    }

    private IndexBuffer.BufferedIndexValues getBufferedIndexValues(IndexBuffer buffer, ByteString keyBytes) {
        return buffer.getBufferedIndexValues(this, keyBytes, this.indexer.getBSComparator());
    }

    public ConditionResult containsID(Transaction txn, DatabaseEntry key, EntryID entryID) throws DatabaseException {
        DatabaseEntry data = new DatabaseEntry();
        OperationStatus status = this.read(txn, key, data, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
            if (!entryIDList.isDefined()) {
                return ConditionResult.UNDEFINED;
            }
            return ConditionResult.valueOf((boolean)entryIDList.contains(entryID));
        }
        if (this.trusted) {
            return ConditionResult.FALSE;
        }
        return ConditionResult.UNDEFINED;
    }

    public EntryIDSet readKey(DatabaseEntry key, Transaction txn, LockMode lockMode) {
        try {
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.read(txn, key, data, lockMode);
            if (status != OperationStatus.SUCCESS) {
                if (this.trusted) {
                    return new EntryIDSet(key.getData(), null);
                }
                return new EntryIDSet();
            }
            return new EntryIDSet(key.getData(), data.getData());
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            return new EntryIDSet();
        }
    }

    public void writeKey(Transaction txn, DatabaseEntry key, EntryIDSet entryIDList) throws DatabaseException {
        DatabaseEntry data = new DatabaseEntry();
        byte[] after = entryIDList.toDatabase();
        if (after != null) {
            if (!entryIDList.isDefined()) {
                ++this.entryLimitExceededCount;
            }
            data.setData(after);
            this.put(txn, key, data);
        } else {
            this.delete(txn, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EntryIDSet readRange(byte[] lower, byte[] upper, boolean lowerIncluded, boolean upperIncluded) {
        if (!this.trusted) {
            return new EntryIDSet();
        }
        try {
            int totalIDCount = 0;
            LockMode lockMode = LockMode.DEFAULT;
            DatabaseEntry data = new DatabaseEntry();
            ArrayList<EntryIDSet> lists = new ArrayList<EntryIDSet>();
            try (Cursor cursor = this.openCursor(null, CursorConfig.READ_COMMITTED);){
                int cmp;
                OperationStatus status;
                DatabaseEntry key;
                Comparator<byte[]> comparator = this.indexer.getComparator();
                if (lower.length > 0) {
                    key = new DatabaseEntry(lower);
                    status = cursor.getSearchKeyRange(key, data, lockMode);
                    if (status == OperationStatus.SUCCESS && !lowerIncluded && comparator.compare(key.getData(), lower) == 0) {
                        status = cursor.getNext(key, data, lockMode);
                    }
                } else {
                    key = new DatabaseEntry();
                    status = cursor.getNext(key, data, lockMode);
                }
                if (status != OperationStatus.SUCCESS) {
                    EntryIDSet entryIDSet = new EntryIDSet(key.getData(), null);
                    return entryIDSet;
                }
                while (status == OperationStatus.SUCCESS && (upper.length <= 0 || (cmp = comparator.compare(key.getData(), upper)) <= 0 && (cmp != 0 || upperIncluded))) {
                    EntryIDSet list = new EntryIDSet(key.getData(), data.getData());
                    if (!list.isDefined()) {
                        EntryIDSet entryIDSet = list;
                        return entryIDSet;
                    }
                    totalIDCount = (int)((long)totalIDCount + list.size());
                    if (this.cursorEntryLimit > 0 && totalIDCount > this.cursorEntryLimit) {
                        EntryIDSet entryIDSet = new EntryIDSet();
                        return entryIDSet;
                    }
                    lists.add(list);
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                }
                EntryIDSet entryIDSet = EntryIDSet.unionOfSets(lists, false);
                return entryIDSet;
            }
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            return new EntryIDSet();
        }
    }

    public int getEntryLimitExceededCount() {
        return this.entryLimitExceededCount;
    }

    public void addEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        HashSet<ByteString> addKeys = new HashSet<ByteString>();
        this.indexer.indexEntry(entry, addKeys);
        for (ByteString keyBytes : addKeys) {
            this.insertID(buffer, keyBytes, entryID);
        }
    }

    public void removeEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        HashSet<ByteString> delKeys = new HashSet<ByteString>();
        this.indexer.indexEntry(entry, delKeys);
        for (ByteString keyBytes : delKeys) {
            this.removeID(buffer, keyBytes, entryID);
        }
    }

    public void modifyEntry(IndexBuffer buffer, EntryID entryID, Entry oldEntry, Entry newEntry, List<Modification> mods) throws DatabaseException {
        TreeMap modifiedKeys = new TreeMap(this.indexer.getBSComparator());
        this.indexer.modifyEntry(oldEntry, newEntry, mods, modifiedKeys);
        for (Map.Entry modifiedKey : modifiedKeys.entrySet()) {
            if (((Boolean)modifiedKey.getValue()).booleanValue()) {
                this.insertID(buffer, (ByteString)modifiedKey.getKey(), entryID);
                continue;
            }
            this.removeID(buffer, (ByteString)modifiedKey.getKey(), entryID);
        }
    }

    public boolean setIndexEntryLimit(int indexEntryLimit) {
        boolean rebuildRequired = this.indexEntryLimit < indexEntryLimit && this.entryLimitExceededCount > 0;
        this.indexEntryLimit = indexEntryLimit;
        return rebuildRequired;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public int getIndexEntryLimit() {
        return this.indexEntryLimit;
    }

    public synchronized void setTrusted(Transaction txn, boolean trusted) throws DatabaseException {
        this.trusted = trusted;
        this.state.putIndexTrustState(txn, this, trusted);
    }

    public synchronized boolean isTrusted() {
        return this.trusted;
    }

    public synchronized boolean isRebuildRunning() {
        return false;
    }

    public boolean getMaintainCount() {
        return this.maintainCount;
    }

    public Comparator<byte[]> getComparator() {
        return this.indexer.getComparator();
    }
}

