/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.util.PackedInteger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.util.Utils;
import org.opends.messages.BackendMessages;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.admin.std.server.LocalDBIndexCfg;
import org.opends.server.api.DiskSpaceMonitorHandler;
import org.opends.server.backends.RebuildConfig;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EnvManager;
import org.opends.server.backends.jeb.ImportIDSet;
import org.opends.server.backends.jeb.ImportLDIFReader;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexInputBuffer;
import org.opends.server.backends.jeb.IndexOutputBuffer;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.Suffix;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ServerContext;
import org.opends.server.extensions.DiskSpaceMonitor;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.Platform;
import org.opends.server.util.StaticUtils;

final class Importer
implements DiskSpaceMonitorHandler {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final int TIMER_INTERVAL = 10000;
    private static final String DEFAULT_TMP_DIR = "import-tmp";
    private static final String TMPENV_DIR = "tmp-env";
    private static final int MAX_DB_CACHE_SIZE = 0x800000;
    private static final int MAX_DB_LOG_SIZE = 0xA00000;
    private static final int MIN_DB_CACHE_SIZE = 0x400000;
    private static final int READER_WRITER_BUFFER_SIZE = 8192;
    private static final int MIN_DB_CACHE_MEMORY = 0x1200000;
    private static final int BYTE_BUFFER_CAPACITY = 128;
    private static final int MAX_BUFFER_SIZE = 0x200000;
    private static final int MIN_BUFFER_SIZE = 4096;
    private static final int MIN_READ_AHEAD_CACHE_SIZE = 2048;
    private static final int SMALL_HEAP_SIZE = 0x10000000;
    private static final int MINIMUM_AVAILABLE_MEMORY = 0x2000000;
    private static final AttributeType dnType = DirectoryServer.getAttributeTypeOrDefault((String)"dn");
    static final IndexOutputBuffer.IndexComparator indexComparator = new IndexOutputBuffer.IndexComparator();
    private final AtomicInteger bufferCount = new AtomicInteger(0);
    private final AtomicLong importCount = new AtomicLong(0L);
    private int bufferSize;
    private final File tempDir;
    private final int indexCount;
    private int threadCount;
    private final boolean skipDNValidation;
    private final TmpEnv tmpEnv;
    private RootContainer rootContainer;
    private final LDIFImportConfig importConfiguration;
    private final LocalDBBackendCfg backendConfiguration;
    private ImportLDIFReader reader;
    private int migratedCount;
    private long tmpEnvCacheSize;
    private long availableMemory;
    private long dbCacheSize;
    private ExecutorService bufferSortService;
    private ExecutorService scratchFileWriterService;
    private final BlockingQueue<IndexOutputBuffer> freeBufferQueue = new LinkedBlockingQueue<IndexOutputBuffer>();
    private final Map<IndexKey, BlockingQueue<IndexOutputBuffer>> indexKeyQueueMap = new ConcurrentHashMap<IndexKey, BlockingQueue<IndexOutputBuffer>>();
    private final List<IndexManager> indexMgrList = new LinkedList<IndexManager>();
    private final List<IndexManager> DNIndexMgrList = new LinkedList<IndexManager>();
    private final List<Future<Void>> scratchFileWriterFutures;
    private final List<ScratchFileWriterTask> scratchFileWriterList;
    private final Map<DN, Suffix> dnSuffixMap = new LinkedHashMap<DN, Suffix>();
    private final ConcurrentHashMap<Integer, Index> idContainerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Suffix> idSuffixMap = new ConcurrentHashMap();
    private final Object synObj = new Object();
    private final RebuildIndexManager rebuildManager;
    private final boolean clearedBackend;
    private volatile boolean isCanceled;
    private volatile boolean isPhaseOneDone;
    private int phaseOneBufferCount;
    private final DiskSpaceMonitor diskSpaceMonitor;

    public Importer(RebuildConfig rebuildConfig, LocalDBBackendCfg cfg, EnvironmentConfig envConfig, ServerContext serverContext) throws InitializationException, JebException, ConfigException {
        this.importConfiguration = null;
        this.backendConfiguration = cfg;
        this.tmpEnv = null;
        this.threadCount = 1;
        this.diskSpaceMonitor = serverContext.getDiskSpaceMonitor();
        this.rebuildManager = new RebuildIndexManager(rebuildConfig, cfg);
        this.indexCount = this.rebuildManager.getIndexCount();
        this.clearedBackend = false;
        this.scratchFileWriterList = new ArrayList<ScratchFileWriterTask>(this.indexCount);
        this.scratchFileWriterFutures = new CopyOnWriteArrayList<Future<Void>>();
        this.tempDir = this.getTempDir(cfg, rebuildConfig.getTmpDirectory());
        this.recursiveDelete(this.tempDir);
        if (!this.tempDir.exists() && !this.tempDir.mkdirs()) {
            throw new InitializationException(BackendMessages.ERR_IMPORT_CREATE_TMPDIR_ERROR.get((Object)this.tempDir));
        }
        this.skipDNValidation = true;
        this.initializeDBEnv(envConfig);
    }

    public Importer(LDIFImportConfig importConfiguration, LocalDBBackendCfg localDBBackendCfg, EnvironmentConfig envConfig, ServerContext serverContext) throws InitializationException, ConfigException, DatabaseException {
        this.rebuildManager = null;
        this.importConfiguration = importConfiguration;
        this.backendConfiguration = localDBBackendCfg;
        this.diskSpaceMonitor = serverContext.getDiskSpaceMonitor();
        this.threadCount = importConfiguration.getThreadCount() == 0 ? Runtime.getRuntime().availableProcessors() * 2 : importConfiguration.getThreadCount();
        this.indexCount = this.getTotalIndexCount(localDBBackendCfg);
        this.clearedBackend = Importer.mustClearBackend(importConfiguration, localDBBackendCfg);
        this.scratchFileWriterList = new ArrayList<ScratchFileWriterTask>(this.indexCount);
        this.scratchFileWriterFutures = new CopyOnWriteArrayList<Future<Void>>();
        this.tempDir = this.getTempDir(localDBBackendCfg, importConfiguration.getTmpDirectory());
        this.recursiveDelete(this.tempDir);
        if (!this.tempDir.exists() && !this.tempDir.mkdirs()) {
            throw new InitializationException(BackendMessages.ERR_IMPORT_CREATE_TMPDIR_ERROR.get((Object)this.tempDir));
        }
        this.skipDNValidation = importConfiguration.getSkipDNValidation();
        this.initializeDBEnv(envConfig);
        if (!this.skipDNValidation) {
            File envPath = new File(this.tempDir, TMPENV_DIR);
            envPath.mkdirs();
            this.tmpEnv = new TmpEnv(envPath);
        } else {
            this.tmpEnv = null;
        }
    }

    public static boolean mustClearBackend(LDIFImportConfig importCfg, LocalDBBackendCfg backendCfg) {
        return !importCfg.appendToExistingData() && (importCfg.clearBackend() || backendCfg.getBaseDN().size() <= 1);
    }

    private File getTempDir(LocalDBBackendCfg localDBBackendCfg, String tmpDirectory) {
        File parentDir = tmpDirectory != null ? StaticUtils.getFileForPath((String)tmpDirectory) : StaticUtils.getFileForPath((String)DEFAULT_TMP_DIR);
        return new File(parentDir, localDBBackendCfg.getBackendId());
    }

    private int getTotalIndexCount(LocalDBBackendCfg localDBBackendCfg) throws ConfigException {
        int indexes = 2;
        for (String indexName : localDBBackendCfg.listLocalDBIndexes()) {
            LocalDBIndexCfg index = localDBBackendCfg.getLocalDBIndex(indexName);
            SortedSet types = index.getIndexType();
            if (types.contains(LocalDBIndexCfgDefn.IndexType.EXTENSIBLE)) {
                indexes += types.size() - 1 + index.getIndexExtensibleMatchingRule().size();
                continue;
            }
            indexes += types.size();
        }
        return indexes;
    }

    public static Suffix getMatchSuffix(DN dn, Map<DN, Suffix> map) {
        Suffix suffix = null;
        DN nodeDN = dn;
        while (suffix == null && nodeDN != null) {
            suffix = map.get(nodeDN);
            if (suffix != null) continue;
            nodeDN = nodeDN.getParentDNInSuffix();
        }
        return suffix;
    }

    private void initializeDBEnv(EnvironmentConfig envConfig) throws InitializationException {
        int oldThreadCount;
        block16: {
            this.calculateAvailableMemory();
            long usableMemory = this.availableMemory - (long)(this.indexCount * 8192);
            if (!this.skipDNValidation || this.rebuildManager != null) {
                if (System.getProperty("org.opends.server.RunningUnitTests") != null) {
                    this.dbCacheSize = 512000L;
                    this.tmpEnvCacheSize = 512000L;
                } else if (usableMemory < 0x1600000L) {
                    this.dbCacheSize = 0x400000L;
                    this.tmpEnvCacheSize = 0x400000L;
                } else if (!this.clearedBackend) {
                    this.dbCacheSize = usableMemory * 33L / 100L;
                    this.tmpEnvCacheSize = usableMemory * 33L / 100L;
                } else {
                    this.dbCacheSize = 0x800000L;
                    this.tmpEnvCacheSize = usableMemory * 66L / 100L;
                }
            } else {
                this.tmpEnvCacheSize = 0L;
                this.dbCacheSize = System.getProperty("org.opends.server.RunningUnitTests") != null ? 512000L : (usableMemory < 0x1200000L ? 0x400000L : 0x800000L);
            }
            long phaseOneBufferMemory = usableMemory - this.dbCacheSize - this.tmpEnvCacheSize;
            oldThreadCount = this.threadCount;
            if (this.indexCount != 0) {
                int totalPhaseOneBufferCount;
                while (true) {
                    this.phaseOneBufferCount = 2 * this.indexCount * this.threadCount;
                    totalPhaseOneBufferCount = this.phaseOneBufferCount + 4 * this.indexCount;
                    long longBufferSize = phaseOneBufferMemory / (long)totalPhaseOneBufferCount;
                    this.bufferSize = (int)Math.min(longBufferSize, 0x3FFFFFFFL);
                    if (this.bufferSize > 0x200000) {
                        if (!this.skipDNValidation) {
                            this.bufferSize = 0x200000;
                            long extraMemory = phaseOneBufferMemory - (long)(totalPhaseOneBufferCount * this.bufferSize);
                            if (!this.clearedBackend) {
                                this.dbCacheSize += extraMemory / 2L;
                                this.tmpEnvCacheSize += extraMemory / 2L;
                            } else {
                                this.tmpEnvCacheSize += extraMemory;
                            }
                        }
                        break block16;
                    }
                    if (this.bufferSize > 4096) break block16;
                    if (this.threadCount <= 1) break;
                    --this.threadCount;
                }
                long minimumPhaseOneBufferMemory = totalPhaseOneBufferCount * 4096;
                LocalizableMessage message = BackendMessages.ERR_IMPORT_LDIF_LACK_MEM.get((Object)usableMemory, (Object)(minimumPhaseOneBufferMemory + this.dbCacheSize + this.tmpEnvCacheSize));
                throw new InitializationException(message);
            }
        }
        if (oldThreadCount != this.threadCount) {
            logger.info(BackendMessages.NOTE_IMPORT_ADJUST_THREAD_COUNT, (Object)oldThreadCount, (Object)this.threadCount);
        }
        logger.info(BackendMessages.NOTE_IMPORT_LDIF_TOT_MEM_BUF, (Object)this.availableMemory, (Object)this.phaseOneBufferCount);
        if (this.tmpEnvCacheSize > 0L) {
            logger.info(BackendMessages.NOTE_IMPORT_LDIF_TMP_ENV_MEM, (Object)this.tmpEnvCacheSize);
        }
        envConfig.setConfigParam("je.maxMemory", Long.toString(this.dbCacheSize));
        logger.info(BackendMessages.NOTE_IMPORT_LDIF_DB_MEM_BUF_INFO, (Object)this.dbCacheSize, (Object)this.bufferSize);
    }

    private void calculateAvailableMemory() {
        long totalAvailableMemory;
        if (DirectoryServer.isRunning()) {
            Runtime runTime = Runtime.getRuntime();
            runTime.gc();
            runTime.gc();
            long usedMemory = runTime.totalMemory() - runTime.freeMemory();
            long maxUsableMemory = Platform.getUsableMemoryForCaching();
            long usableMemory = maxUsableMemory - usedMemory;
            long configuredMemory = this.backendConfiguration.getDBCacheSize() > 0L ? this.backendConfiguration.getDBCacheSize() : (long)this.backendConfiguration.getDBCachePercent() * Runtime.getRuntime().maxMemory() / 100L;
            totalAvailableMemory = Math.max(Math.min(usableMemory, configuredMemory), 0x2000000L);
        } else {
            totalAvailableMemory = Platform.getUsableMemoryForCaching();
        }
        int importMemPct = 90;
        if (totalAvailableMemory <= 0x10000000L) {
            importMemPct -= 25;
        }
        if (this.rebuildManager != null) {
            importMemPct -= 15;
        }
        this.availableMemory = totalAvailableMemory * (long)importMemPct / 100L;
    }

    private void initializeIndexBuffers() {
        for (int i = 0; i < this.phaseOneBufferCount; ++i) {
            this.freeBufferQueue.add(new IndexOutputBuffer(this.bufferSize));
        }
    }

    private void initializeSuffixes() throws DatabaseException, ConfigException, InitializationException {
        for (EntryContainer ec : this.rootContainer.getEntryContainers()) {
            Suffix suffix = this.getSuffix(ec);
            if (suffix == null) continue;
            this.dnSuffixMap.put(ec.getBaseDN(), suffix);
        }
    }

    private void generateIndexID(Suffix suffix) {
        for (AttributeIndex attributeIndex : suffix.getAttributeIndexes()) {
            for (Index index : attributeIndex.getAllIndexes()) {
                this.putInIdContainerMap(index);
            }
        }
    }

    private void putInIdContainerMap(Index index) {
        if (index != null) {
            this.idContainerMap.putIfAbsent(Importer.getIndexID(index), index);
        }
    }

    private static int getIndexID(DatabaseContainer index) {
        return System.identityHashCode(index);
    }

    private Suffix getSuffix(EntryContainer entryContainer) throws ConfigException, InitializationException {
        DN baseDN = entryContainer.getBaseDN();
        EntryContainer sourceEntryContainer = null;
        ArrayList<DN> includeBranches = new ArrayList<DN>();
        ArrayList<DN> excludeBranches = new ArrayList<DN>();
        if (!this.importConfiguration.appendToExistingData() && !this.importConfiguration.clearBackend()) {
            for (DN dn : this.importConfiguration.getExcludeBranches()) {
                if (baseDN.equals((Object)dn)) {
                    return null;
                }
                if (!baseDN.isAncestorOf(dn)) continue;
                excludeBranches.add(dn);
            }
            if (!this.importConfiguration.getIncludeBranches().isEmpty()) {
                for (DN dn : this.importConfiguration.getIncludeBranches()) {
                    if (!baseDN.isAncestorOf(dn)) continue;
                    includeBranches.add(dn);
                }
                if (includeBranches.isEmpty()) {
                    return null;
                }
                Iterator includeBranchIterator = includeBranches.iterator();
                while (includeBranchIterator.hasNext()) {
                    DN includeDN = (DN)includeBranchIterator.next();
                    if (this.isAnyNotEqualAndAncestorOf(includeBranches, includeDN)) continue;
                    includeBranchIterator.remove();
                }
                Iterator excludeBranchIterator = excludeBranches.iterator();
                while (excludeBranchIterator.hasNext()) {
                    DN excludeDN = (DN)excludeBranchIterator.next();
                    if (this.isAnyAncestorOf(includeBranches, excludeDN)) continue;
                    excludeBranchIterator.remove();
                }
                if (excludeBranches.isEmpty() && includeBranches.size() == 1 && ((DN)includeBranches.get(0)).equals((Object)baseDN)) {
                    this.clearSuffix(entryContainer);
                } else {
                    sourceEntryContainer = entryContainer;
                    entryContainer = this.rootContainer.openEntryContainer(baseDN, baseDN.toNormalizedUrlSafeString() + "_importTmp");
                }
            }
        }
        return new Suffix(entryContainer, sourceEntryContainer, includeBranches, excludeBranches);
    }

    private void clearSuffix(EntryContainer entryContainer) {
        entryContainer.lock();
        entryContainer.clear();
        entryContainer.unlock();
    }

    private boolean isAnyNotEqualAndAncestorOf(List<DN> dns, DN childDN) {
        for (DN dn : dns) {
            if (dn.equals((Object)childDN) || !dn.isAncestorOf(childDN)) continue;
            return false;
        }
        return true;
    }

    private boolean isAnyAncestorOf(List<DN> dns, DN childDN) {
        for (DN dn : dns) {
            if (!dn.isAncestorOf(childDN)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildIndexes(RootContainer rootContainer) throws ConfigException, InitializationException, JebException, InterruptedException, ExecutionException {
        this.rootContainer = rootContainer;
        long startTime = System.currentTimeMillis();
        this.updateDiskMonitor(this.tempDir, "backend index rebuild tmp directory");
        File parentDirectory = StaticUtils.getFileForPath((String)this.backendConfiguration.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.backendConfiguration.getBackendId());
        this.updateDiskMonitor(backendDirectory, "backend index rebuild DB directory");
        try {
            this.rebuildManager.initialize();
            this.rebuildManager.printStartMessage();
            this.rebuildManager.rebuildIndexes();
            this.recursiveDelete(this.tempDir);
            this.rebuildManager.printStopMessage(startTime);
        }
        finally {
            this.diskSpaceMonitor.deregisterMonitoredDirectory(this.tempDir, (DiskSpaceMonitorHandler)this);
            this.diskSpaceMonitor.deregisterMonitoredDirectory(backendDirectory, (DiskSpaceMonitorHandler)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDIFImportResult processImport(RootContainer rootContainer) throws ConfigException, InitializationException, JebException, InterruptedException, ExecutionException {
        LDIFImportResult lDIFImportResult;
        this.rootContainer = rootContainer;
        File parentDirectory = StaticUtils.getFileForPath((String)this.backendConfiguration.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.backendConfiguration.getBackendId());
        try {
            try {
                this.reader = new ImportLDIFReader(this.importConfiguration, rootContainer);
            }
            catch (IOException ioe) {
                throw new InitializationException(BackendMessages.ERR_IMPORT_LDIF_READER_IO_ERROR.get(), (Throwable)ioe);
            }
            this.updateDiskMonitor(this.tempDir, "backend import tmp directory");
            this.updateDiskMonitor(backendDirectory, "backend import DB directory");
            logger.info(BackendMessages.NOTE_IMPORT_STARTING, (Object)DirectoryServer.getVersionString(), (Object)DynamicConstants.BUILD_ID, (Object)DynamicConstants.REVISION_NUMBER);
            logger.info(BackendMessages.NOTE_IMPORT_THREAD_COUNT, (Object)this.threadCount);
            this.initializeSuffixes();
            this.setupIndexesForImport();
            long startTime = System.currentTimeMillis();
            this.phaseOne();
            this.isPhaseOneDone = true;
            long phaseOneFinishTime = System.currentTimeMillis();
            if (!this.skipDNValidation) {
                this.tmpEnv.shutdown();
            }
            if (this.isCanceled) {
                throw new InterruptedException("Import processing canceled.");
            }
            long phaseTwoTime = System.currentTimeMillis();
            this.phaseTwo();
            if (this.isCanceled) {
                throw new InterruptedException("Import processing canceled.");
            }
            long phaseTwoFinishTime = System.currentTimeMillis();
            this.setIndexesTrusted();
            this.switchEntryContainers();
            this.recursiveDelete(this.tempDir);
            long finishTime = System.currentTimeMillis();
            long importTime = finishTime - startTime;
            logger.info(BackendMessages.NOTE_IMPORT_PHASE_STATS, (Object)(importTime / 1000L), (Object)((phaseOneFinishTime - startTime) / 1000L), (Object)((phaseTwoFinishTime - phaseTwoTime) / 1000L));
            float rate = 0.0f;
            if (importTime > 0L) {
                rate = 1000.0f * (float)this.reader.getEntriesRead() / (float)importTime;
            }
            logger.info(BackendMessages.NOTE_IMPORT_FINAL_STATUS, (Object)this.reader.getEntriesRead(), (Object)this.importCount.get(), (Object)this.reader.getEntriesIgnored(), (Object)this.reader.getEntriesRejected(), (Object)this.migratedCount, (Object)(importTime / 1000L), (Object)Float.valueOf(rate));
            lDIFImportResult = new LDIFImportResult(this.reader.getEntriesRead(), this.reader.getEntriesRejected(), this.reader.getEntriesIgnored());
        }
        catch (Throwable throwable) {
            StaticUtils.close((Closeable[])new Closeable[]{this.reader});
            if (!this.skipDNValidation) {
                try {
                    this.tmpEnv.shutdown();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            this.diskSpaceMonitor.deregisterMonitoredDirectory(this.tempDir, (DiskSpaceMonitorHandler)this);
            this.diskSpaceMonitor.deregisterMonitoredDirectory(backendDirectory, (DiskSpaceMonitorHandler)this);
            throw throwable;
        }
        StaticUtils.close((Closeable[])new Closeable[]{this.reader});
        if (!this.skipDNValidation) {
            try {
                this.tmpEnv.shutdown();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        this.diskSpaceMonitor.deregisterMonitoredDirectory(this.tempDir, (DiskSpaceMonitorHandler)this);
        this.diskSpaceMonitor.deregisterMonitoredDirectory(backendDirectory, (DiskSpaceMonitorHandler)this);
        return lDIFImportResult;
    }

    private void updateDiskMonitor(File dir, String backendSuffix) {
        this.diskSpaceMonitor.registerMonitoredDirectory(this.backendConfiguration.getBackendId() + " " + backendSuffix, dir, this.backendConfiguration.getDiskLowThreshold(), this.backendConfiguration.getDiskFullThreshold(), (DiskSpaceMonitorHandler)this);
    }

    private void recursiveDelete(File dir) {
        if (dir.listFiles() != null) {
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    this.recursiveDelete(f);
                }
                f.delete();
            }
        }
        dir.delete();
    }

    private void switchEntryContainers() throws DatabaseException, JebException, InitializationException {
        for (Suffix suffix : this.dnSuffixMap.values()) {
            DN baseDN = suffix.getBaseDN();
            EntryContainer entryContainer = suffix.getSrcEntryContainer();
            if (entryContainer == null) continue;
            EntryContainer toDelete = this.rootContainer.unregisterEntryContainer(baseDN);
            toDelete.lock();
            toDelete.close();
            toDelete.delete();
            toDelete.unlock();
            EntryContainer replacement = suffix.getEntryContainer();
            replacement.lock();
            replacement.setDatabasePrefix(baseDN.toNormalizedUrlSafeString());
            replacement.unlock();
            this.rootContainer.registerEntryContainer(baseDN, replacement);
        }
    }

    private void setIndexesTrusted() throws JebException {
        try {
            for (Suffix s : this.dnSuffixMap.values()) {
                s.setIndexesTrusted();
            }
        }
        catch (DatabaseException ex) {
            throw new JebException(BackendMessages.NOTE_IMPORT_LDIF_TRUSTED_FAILED.get((Object)ex.getMessage()));
        }
    }

    private void setupIndexesForImport() {
        for (Suffix s : this.dnSuffixMap.values()) {
            s.setIndexesNotTrusted(this.importConfiguration.appendToExistingData());
            this.generateIndexID(s);
        }
    }

    private void phaseOne() throws InterruptedException, ExecutionException {
        this.initializeIndexBuffers();
        ScheduledThreadPoolExecutor timerService = new ScheduledThreadPoolExecutor(1);
        this.scheduleAtFixedRate(timerService, new FirstPhaseProgressTask());
        this.scratchFileWriterService = Executors.newFixedThreadPool(2 * this.indexCount);
        this.bufferSortService = Executors.newFixedThreadPool(this.threadCount);
        ExecutorService execService = Executors.newFixedThreadPool(this.threadCount);
        ArrayList<ImportTask> tasks = new ArrayList<ImportTask>(this.threadCount);
        tasks.add(new MigrateExistingTask());
        this.getAll(execService.invokeAll(tasks));
        tasks.clear();
        if (this.importConfiguration.appendToExistingData() && this.importConfiguration.replaceExistingEntries()) {
            for (int i = 0; i < this.threadCount; ++i) {
                tasks.add(new AppendReplaceTask());
            }
        } else {
            for (int i = 0; i < this.threadCount; ++i) {
                tasks.add(new ImportTask());
            }
        }
        this.getAll(execService.invokeAll(tasks));
        tasks.clear();
        tasks.add(new MigrateExcludedTask());
        this.getAll(execService.invokeAll(tasks));
        this.stopScratchFileWriters();
        this.getAll(this.scratchFileWriterFutures);
        this.shutdownAll(timerService, execService, this.bufferSortService, this.scratchFileWriterService);
        this.clearAll(this.scratchFileWriterList, this.scratchFileWriterFutures, this.freeBufferQueue);
        this.indexKeyQueueMap.clear();
    }

    private void scheduleAtFixedRate(ScheduledThreadPoolExecutor timerService, Runnable task) {
        timerService.scheduleAtFixedRate(task, 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    private void shutdownAll(ExecutorService ... executorServices) throws InterruptedException {
        for (ExecutorService executorService : executorServices) {
            executorService.shutdown();
        }
        for (ExecutorService executorService : executorServices) {
            executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private void clearAll(Collection<?> ... cols) {
        for (Collection<?> col : cols) {
            col.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void phaseTwo() throws InterruptedException, ExecutionException {
        ScheduledThreadPoolExecutor timerService = new ScheduledThreadPoolExecutor(1);
        this.scheduleAtFixedRate(timerService, new SecondPhaseProgressTask(this.reader.getEntriesRead()));
        try {
            this.processIndexFiles();
        }
        catch (Throwable throwable) {
            this.shutdownAll(timerService);
            throw throwable;
        }
        this.shutdownAll(timerService);
    }

    private void processIndexFiles() throws InterruptedException, ExecutionException {
        int readAheadSize;
        int buffers;
        int dbThreads;
        block5: {
            if (this.bufferCount.get() == 0) {
                return;
            }
            dbThreads = Runtime.getRuntime().availableProcessors();
            if (dbThreads < 4) {
                dbThreads = 4;
            }
            long usableMemory = this.availableMemory - this.dbCacheSize;
            while (true) {
                ArrayList<IndexManager> allIndexMgrs = new ArrayList<IndexManager>(this.DNIndexMgrList);
                allIndexMgrs.addAll(this.indexMgrList);
                Collections.sort(allIndexMgrs, Collections.reverseOrder());
                buffers = 0;
                int limit = Math.min(dbThreads, allIndexMgrs.size());
                for (int i = 0; i < limit; ++i) {
                    buffers += ((IndexManager)allIndexMgrs.get(i)).numberOfBuffers;
                }
                readAheadSize = (int)(usableMemory / (long)buffers);
                if (readAheadSize > this.bufferSize) {
                    readAheadSize = this.bufferSize;
                    break block5;
                }
                if (readAheadSize > 2048) break block5;
                if (dbThreads <= 1) break;
                --dbThreads;
            }
            readAheadSize = 2048;
            buffers = (int)(usableMemory / (long)readAheadSize);
            logger.warn(BackendMessages.WARN_IMPORT_LDIF_LACK_MEM_PHASE_TWO, (Object)usableMemory);
        }
        dbThreads = Math.max(2, dbThreads);
        logger.info(BackendMessages.NOTE_IMPORT_LDIF_PHASE_TWO_MEM_REPORT, (Object)this.availableMemory, (Object)readAheadSize, (Object)buffers);
        LinkedList futures = new LinkedList();
        ExecutorService dbService = Executors.newFixedThreadPool(dbThreads);
        Semaphore permits = new Semaphore(buffers);
        this.submitIndexDBWriteTasks(this.DNIndexMgrList, dbService, permits, buffers, readAheadSize, futures);
        this.submitIndexDBWriteTasks(this.indexMgrList, dbService, permits, buffers, readAheadSize, futures);
        this.getAll(futures);
        this.shutdownAll(dbService);
    }

    private void submitIndexDBWriteTasks(List<IndexManager> indexMgrs, ExecutorService dbService, Semaphore permits, int buffers, int readAheadSize, List<Future<Void>> futures) {
        for (IndexManager indexMgr : indexMgrs) {
            futures.add(dbService.submit(new IndexDBWriteTask(indexMgr, permits, buffers, readAheadSize)));
        }
    }

    private <T> void getAll(List<Future<T>> futures) throws InterruptedException, ExecutionException {
        for (Future<T> result : futures) {
            result.get();
        }
    }

    private void stopScratchFileWriters() {
        IndexOutputBuffer stopProcessing = IndexOutputBuffer.poison();
        for (ScratchFileWriterTask task : this.scratchFileWriterList) {
            task.queue.add(stopProcessing);
        }
    }

    public void diskLowThresholdReached(File directory, long thresholdInBytes) {
        this.diskFullThresholdReached(directory, thresholdInBytes);
    }

    public void diskFullThresholdReached(File directory, long thresholdInBytes) {
        this.isCanceled = true;
        LocalizableMessageDescriptor.Arg2 argMsg = !this.isPhaseOneDone ? BackendMessages.ERR_IMPORT_LDIF_LACK_DISK_PHASE_ONE : BackendMessages.ERR_IMPORT_LDIF_LACK_DISK_PHASE_TWO;
        logger.error(argMsg.get((Object)directory.getAbsolutePath(), (Object)thresholdInBytes));
    }

    public void diskSpaceRestored(File directory, long lowThresholdInBytes, long fullThresholdInBytes) {
    }

    static /* synthetic */ AttributeType access$1900() {
        return dnType;
    }

    private final class TmpEnv
    implements DNCache {
        private final String envPath;
        private final Environment environment;
        private static final String DB_NAME = "dn_cache";
        private final Database dnCache;
        private static final long FNV_INIT = -3750763034362895579L;
        private static final long FNV_PRIME = 1099511628211L;

        private TmpEnv(File envPath) throws DatabaseException {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setConfigParam("je.env.runCleaner", "true");
            envConfig.setReadOnly(false);
            envConfig.setAllowCreate(true);
            envConfig.setTransactional(false);
            envConfig.setConfigParam("je.env.isLocking", "true");
            envConfig.setConfigParam("je.env.runCheckpointer", "false");
            envConfig.setConfigParam("je.evictor.lruOnly", "false");
            envConfig.setConfigParam("je.evictor.nodesPerScan", "128");
            envConfig.setConfigParam("je.maxMemory", Long.toString(Importer.this.tmpEnvCacheSize));
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(false);
            dbConfig.setTemporary(true);
            this.environment = new Environment(envPath, envConfig);
            this.dnCache = this.environment.openDatabase(null, DB_NAME, dbConfig);
            this.envPath = envPath.getPath();
        }

        private byte[] hashCode(byte[] b) {
            long hash = -3750763034362895579L;
            for (byte aB : b) {
                hash ^= (long)aB;
                hash *= 1099511628211L;
            }
            return JebFormat.entryIDToDatabase(hash);
        }

        private void shutdown() throws JebException {
            this.dnCache.close();
            this.environment.close();
            EnvManager.removeFiles(this.envPath);
        }

        private boolean insert(DN dn, DatabaseEntry val, DatabaseEntry key) throws JebException {
            byte[] dnBytesForKey = dn.toNormalizedByteString().toByteArray();
            key.setData(this.hashCode(dnBytesForKey));
            byte[] dnBytesForValue = StaticUtils.getBytes((String)dn.toString());
            int len = PackedInteger.getWriteIntLength((int)dnBytesForValue.length);
            byte[] dataBytes = new byte[dnBytesForValue.length + len];
            int pos = PackedInteger.writeInt((byte[])dataBytes, (int)0, (int)dnBytesForValue.length);
            System.arraycopy(dnBytesForValue, 0, dataBytes, pos, dnBytesForValue.length);
            val.setData(dataBytes);
            return this.insert(key, val, dnBytesForValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean insert(DatabaseEntry key, DatabaseEntry val, byte[] dnBytesForValue) throws JebException {
            Cursor cursor;
            block5: {
                block6: {
                    boolean bl;
                    cursor = null;
                    try {
                        cursor = this.dnCache.openCursor(null, CursorConfig.DEFAULT);
                        OperationStatus status = cursor.putNoOverwrite(key, val);
                        if (status != OperationStatus.KEYEXIST) break block5;
                        DatabaseEntry dns = new DatabaseEntry();
                        status = cursor.getSearchKey(key, dns, LockMode.RMW);
                        if (status == OperationStatus.NOTFOUND) {
                            throw new JebException(LocalizableMessage.raw((CharSequence)"Search DN cache failed.", (Object[])new Object[0]));
                        }
                        if (this.isDNMatched(dns.getData(), dnBytesForValue)) break block6;
                        this.addDN(dns.getData(), cursor, dnBytesForValue);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        StaticUtils.close((Closeable[])new Closeable[]{cursor});
                        throw throwable;
                    }
                    StaticUtils.close((Closeable[])new Closeable[]{cursor});
                    return bl;
                }
                boolean bl = false;
                StaticUtils.close((Closeable[])new Closeable[]{cursor});
                return bl;
            }
            boolean bl = true;
            StaticUtils.close((Closeable[])new Closeable[]{cursor});
            return bl;
        }

        private void addDN(byte[] readDnBytes, Cursor cursor, byte[] dnBytesForValue) throws JebException {
            int pLen = PackedInteger.getWriteIntLength((int)dnBytesForValue.length);
            int totLen = readDnBytes.length + pLen + dnBytesForValue.length;
            byte[] newRec = new byte[totLen];
            System.arraycopy(readDnBytes, 0, newRec, 0, readDnBytes.length);
            int pos = PackedInteger.writeInt((byte[])newRec, (int)readDnBytes.length, (int)dnBytesForValue.length);
            System.arraycopy(dnBytesForValue, 0, newRec, pos, dnBytesForValue.length);
            DatabaseEntry newVal = new DatabaseEntry(newRec);
            OperationStatus status = cursor.putCurrent(newVal);
            if (status != OperationStatus.SUCCESS) {
                throw new JebException(LocalizableMessage.raw((CharSequence)"Add of DN to DN cache failed.", (Object[])new Object[0]));
            }
        }

        private boolean isDNMatched(byte[] readDnBytes, byte[] dnBytes) {
            int len;
            int pLen;
            for (int pos = 0; pos < readDnBytes.length; pos += pLen + len) {
                pLen = PackedInteger.getReadIntLength((byte[])readDnBytes, (int)pos);
                if (indexComparator.compare(readDnBytes, pos + pLen, len = PackedInteger.readInt((byte[])readDnBytes, (int)pos), dnBytes, dnBytes.length) != 0) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(DN dn) {
            boolean bl;
            Cursor cursor = null;
            DatabaseEntry key = new DatabaseEntry();
            byte[] dnBytesForKey = dn.toNormalizedByteString().toByteArray();
            key.setData(this.hashCode(dnBytesForKey));
            try {
                cursor = this.dnCache.openCursor(null, CursorConfig.DEFAULT);
                DatabaseEntry dns = new DatabaseEntry();
                OperationStatus status = cursor.getSearchKey(key, dns, LockMode.DEFAULT);
                byte[] dnBytesForValue = StaticUtils.getBytes((String)dn.toString());
                bl = status == OperationStatus.SUCCESS && this.isDNMatched(dns.getData(), dnBytesForValue);
            }
            catch (Throwable throwable) {
                StaticUtils.close((Closeable[])new Closeable[]{cursor});
                throw throwable;
            }
            StaticUtils.close((Closeable[])new Closeable[]{cursor});
            return bl;
        }

        private EnvironmentStats getEnvironmentStats(StatsConfig statsConfig) throws DatabaseException {
            return this.environment.getStats(statsConfig);
        }
    }

    public static interface DNCache {
        public boolean contains(DN var1) throws DatabaseException;
    }

    public static class IndexKey {
        private final AttributeType attributeType;
        private final String indexName;
        private final int entryLimit;

        private IndexKey(AttributeType attributeType, String indexName, int entryLimit) {
            this.attributeType = attributeType;
            this.indexName = indexName;
            this.entryLimit = entryLimit;
        }

        public boolean equals(Object obj) {
            IndexKey oKey;
            return obj instanceof IndexKey && this.attributeType.equals((Object)(oKey = (IndexKey)obj).getAttributeType()) && this.indexName.equals(oKey.indexName);
        }

        public int hashCode() {
            return this.attributeType.hashCode() + this.indexName.hashCode();
        }

        public AttributeType getAttributeType() {
            return this.attributeType;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getName() {
            return this.attributeType.getPrimaryName() + "." + StaticUtils.toLowerCase((String)this.indexName);
        }

        public int getEntryLimit() {
            return this.entryLimit;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(index=" + this.attributeType.getNameOrOID() + "." + this.indexName + ", entryLimit=" + this.entryLimit + ")";
        }
    }

    private static enum ImportIndexType {
        DN,
        EQUALITY,
        PRESENCE,
        SUBSTRING,
        ORDERING,
        APPROXIMATE,
        EX_SUBSTRING,
        EX_SHARED,
        VLV;

    }

    public class EntryInformation {
        private EntryID entryID;
        private Suffix suffix;

        public Suffix getSuffix() {
            return this.suffix;
        }

        public void setSuffix(Suffix suffix) {
            this.suffix = suffix;
        }

        public void setEntryID(EntryID entryID) {
            this.entryID = entryID;
        }

        public EntryID getEntryID() {
            return this.entryID;
        }
    }

    private class SecondPhaseProgressTask
    extends TimerTask {
        private long previousCount;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats previousStats;
        private boolean evicting;
        private long latestCount;

        public SecondPhaseProgressTask(long latestCount) {
            this.latestCount = latestCount;
            try {
                this.previousStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            long deltaCount = this.latestCount - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            try {
                Runtime runTime = Runtime.getRuntime();
                long freeMemory = runTime.freeMemory() / 0x100000L;
                EnvironmentStats environmentStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = environmentStats.getNCacheMiss() - this.previousStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                logger.info(BackendMessages.INFO_CACHE_AND_MEMORY_REPORT, (Object)freeMemory, (Object)Float.valueOf(cacheMissRate));
                long evictPasses = environmentStats.getNEvictPasses();
                long evictNodes = environmentStats.getNNodesExplicitlyEvicted();
                long evictBinsStrip = environmentStats.getNBINsStripped();
                long cleanerRuns = environmentStats.getNCleanerRuns();
                long cleanerDeletions = environmentStats.getNCleanerDeletions();
                long cleanerEntriesRead = environmentStats.getNCleanerEntriesRead();
                long cleanerINCleaned = environmentStats.getNINsCleaned();
                long checkPoints = environmentStats.getNCheckpoints();
                if (evictPasses != 0L) {
                    if (!this.evicting) {
                        this.evicting = true;
                    }
                    logger.info(BackendMessages.NOTE_JEB_IMPORT_LDIF_EVICTION_DETECTED_STATS, (Object)evictPasses, (Object)evictNodes, (Object)evictBinsStrip);
                }
                if (cleanerRuns != 0L) {
                    logger.info(BackendMessages.NOTE_JEB_IMPORT_LDIF_CLEANER_STATS, (Object)cleanerRuns, (Object)cleanerDeletions, (Object)cleanerEntriesRead, (Object)cleanerINCleaned);
                }
                if (checkPoints > 1L) {
                    logger.info(BackendMessages.NOTE_JEB_IMPORT_LDIF_BUFFER_CHECKPOINTS, (Object)checkPoints);
                }
                this.previousStats = environmentStats;
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            this.previousCount = this.latestCount;
            this.previousTime = latestTime;
            for (IndexManager indexMgrDN : Importer.this.DNIndexMgrList) {
                indexMgrDN.printStats(deltaTime);
            }
            for (IndexManager indexMgr : Importer.this.indexMgrList) {
                indexMgr.printStats(deltaTime);
            }
        }
    }

    private final class FirstPhaseProgressTask
    extends TimerTask {
        private long previousCount;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats previousStats;
        private boolean evicting;
        private long evictionEntryCount;

        public FirstPhaseProgressTask() {
            try {
                this.previousStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            long entriesRead = Importer.this.reader.getEntriesRead();
            long entriesIgnored = Importer.this.reader.getEntriesIgnored();
            long entriesRejected = Importer.this.reader.getEntriesRejected();
            long deltaCount = entriesRead - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
            logger.info(BackendMessages.NOTE_IMPORT_PROGRESS_REPORT, (Object)entriesRead, (Object)entriesIgnored, (Object)entriesRejected, (Object)Float.valueOf(rate));
            try {
                Runtime runTime = Runtime.getRuntime();
                long freeMemory = runTime.freeMemory() / 0x100000L;
                EnvironmentStats environmentStats = Importer.this.skipDNValidation ? Importer.this.rootContainer.getEnvironmentStats(new StatsConfig()) : Importer.this.tmpEnv.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = environmentStats.getNCacheMiss() - this.previousStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                logger.info(BackendMessages.INFO_CACHE_AND_MEMORY_REPORT, (Object)freeMemory, (Object)Float.valueOf(cacheMissRate));
                long evictPasses = environmentStats.getNEvictPasses();
                long evictNodes = environmentStats.getNNodesExplicitlyEvicted();
                long evictBinsStrip = environmentStats.getNBINsStripped();
                long cleanerRuns = environmentStats.getNCleanerRuns();
                long cleanerDeletions = environmentStats.getNCleanerDeletions();
                long cleanerEntriesRead = environmentStats.getNCleanerEntriesRead();
                long cleanerINCleaned = environmentStats.getNINsCleaned();
                long checkPoints = environmentStats.getNCheckpoints();
                if (evictPasses != 0L) {
                    if (!this.evicting) {
                        this.evicting = true;
                        this.evictionEntryCount = Importer.this.reader.getEntriesRead();
                        logger.info(BackendMessages.NOTE_JEB_IMPORT_LDIF_EVICTION_DETECTED, (Object)this.evictionEntryCount);
                    }
                    logger.info(BackendMessages.NOTE_JEB_IMPORT_LDIF_EVICTION_DETECTED_STATS, (Object)evictPasses, (Object)evictNodes, (Object)evictBinsStrip);
                }
                if (cleanerRuns != 0L) {
                    logger.info(BackendMessages.NOTE_JEB_IMPORT_LDIF_CLEANER_STATS, (Object)cleanerRuns, (Object)cleanerDeletions, (Object)cleanerEntriesRead, (Object)cleanerINCleaned);
                }
                if (checkPoints > 1L) {
                    logger.info(BackendMessages.NOTE_JEB_IMPORT_LDIF_BUFFER_CHECKPOINTS, (Object)checkPoints);
                }
                this.previousStats = environmentStats;
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            this.previousCount = entriesRead;
            this.previousTime = latestTime;
        }
    }

    private class RebuildFirstPhaseProgressTask
    extends TimerTask {
        private long previousProcessed;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats prevEnvStats;

        public RebuildFirstPhaseProgressTask() throws DatabaseException {
            this.prevEnvStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
        }

        @Override
        public void run() {
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            long entriesProcessed = Importer.this.rebuildManager.getEntriesProcessed();
            long deltaCount = entriesProcessed - this.previousProcessed;
            float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
            float completed = 0.0f;
            if (Importer.this.rebuildManager.getTotalEntries() > 0L) {
                completed = 100.0f * (float)entriesProcessed / (float)Importer.this.rebuildManager.getTotalEntries();
            }
            logger.info(BackendMessages.NOTE_REBUILD_PROGRESS_REPORT, (Object)Float.valueOf(completed), (Object)entriesProcessed, (Object)Importer.this.rebuildManager.getTotalEntries(), (Object)Float.valueOf(rate));
            try {
                Runtime runtime = Runtime.getRuntime();
                long freeMemory = runtime.freeMemory() / 0x100000L;
                EnvironmentStats envStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = envStats.getNCacheMiss() - this.prevEnvStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                logger.info(BackendMessages.INFO_CACHE_AND_MEMORY_REPORT, (Object)freeMemory, (Object)Float.valueOf(cacheMissRate));
                this.prevEnvStats = envStats;
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            this.previousProcessed = entriesProcessed;
            this.previousTime = latestTime;
        }
    }

    private class RebuildIndexManager
    extends ImportTask
    implements DiskSpaceMonitorHandler {
        private final RebuildConfig rebuildConfig;
        private final LocalDBBackendCfg cfg;
        private final Map<IndexKey, Index> indexMap;
        private final Map<IndexKey, Collection<Index>> extensibleIndexMap;
        private final List<VLVIndex> vlvIndexes;
        private long totalEntries;
        private final AtomicLong entriesProcessed;
        private Suffix suffix;
        private EntryContainer entryContainer;
        private boolean reBuildDN2ID;
        private boolean reBuildDN2URI;

        public RebuildIndexManager(RebuildConfig rebuildConfig, LocalDBBackendCfg cfg) {
            this.indexMap = new LinkedHashMap<IndexKey, Index>();
            this.extensibleIndexMap = new LinkedHashMap<IndexKey, Collection<Index>>();
            this.vlvIndexes = new LinkedList<VLVIndex>();
            this.entriesProcessed = new AtomicLong(0L);
            this.rebuildConfig = rebuildConfig;
            this.cfg = cfg;
        }

        public void initialize() throws ConfigException, InitializationException {
            this.entryContainer = Importer.this.rootContainer.getEntryContainer(this.rebuildConfig.getBaseDN());
            this.suffix = new Suffix(this.entryContainer, null, null, null);
        }

        public void printStartMessage() throws DatabaseException {
            this.totalEntries = this.suffix.getID2Entry().getRecordCount();
            switch (this.rebuildConfig.getRebuildMode()) {
                case ALL: {
                    logger.info(BackendMessages.NOTE_REBUILD_ALL_START, (Object)this.totalEntries);
                    break;
                }
                case DEGRADED: {
                    logger.info(BackendMessages.NOTE_REBUILD_DEGRADED_START, (Object)this.totalEntries);
                    break;
                }
                default: {
                    if (this.rebuildConfig.isClearDegradedState() || !logger.isInfoEnabled()) break;
                    String indexes = Utils.joinAsString((String)", ", (Iterable)this.rebuildConfig.getRebuildList());
                    logger.info(BackendMessages.NOTE_REBUILD_START, (Object)indexes, (Object)this.totalEntries);
                }
            }
        }

        public void printStopMessage(long startTime) {
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            float rate = 0.0f;
            if (totalTime > 0L) {
                rate = 1000.0f * (float)this.entriesProcessed.get() / (float)totalTime;
            }
            if (!this.rebuildConfig.isClearDegradedState()) {
                logger.info(BackendMessages.NOTE_REBUILD_FINAL_STATUS, (Object)this.entriesProcessed.get(), (Object)(totalTime / 1000L), (Object)Float.valueOf(rate));
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public Void call() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void rebuildIndexes() throws DatabaseException, InterruptedException, ExecutionException, JebException {
            this.setIndexesListsToBeRebuilt();
            if (!this.rebuildConfig.isClearDegradedState()) {
                this.setRebuildListIndexesTrusted(false);
                this.clearIndexes();
                this.phaseOne();
                if (Importer.this.isCanceled) {
                    throw new InterruptedException("Rebuild Index canceled.");
                }
                this.phaseTwo();
            } else {
                logger.info(BackendMessages.NOTE_REBUILD_CLEARDEGRADEDSTATE_FINAL_STATUS, (Object)this.rebuildConfig.getRebuildList());
            }
            this.setRebuildListIndexesTrusted(true);
        }

        private void setIndexesListsToBeRebuilt() throws JebException {
            RebuildConfig.RebuildMode mode = this.rebuildConfig.getRebuildMode();
            switch (mode) {
                case ALL: {
                    this.rebuildIndexMap(false);
                }
                case DEGRADED: {
                    if (mode == RebuildConfig.RebuildMode.ALL || !this.entryContainer.getID2Children().isTrusted() || !this.entryContainer.getID2Subtree().isTrusted()) {
                        this.reBuildDN2ID = true;
                    }
                    if (mode == RebuildConfig.RebuildMode.ALL || this.entryContainer.getDN2URI() == null) {
                        this.reBuildDN2URI = true;
                    }
                    if (mode == RebuildConfig.RebuildMode.DEGRADED || this.entryContainer.getAttributeIndexes().isEmpty()) {
                        this.rebuildIndexMap(true);
                    }
                    if (mode != RebuildConfig.RebuildMode.ALL && !this.vlvIndexes.isEmpty()) break;
                    this.vlvIndexes.addAll(this.entryContainer.getVLVIndexes());
                    break;
                }
                case USER_DEFINED: {
                    this.rebuildIndexMap(false);
                    break;
                }
            }
        }

        private void rebuildIndexMap(boolean onlyDegraded) {
            List rebuildList = this.rebuildConfig.getRebuildList();
            for (AttributeIndex attributeIndex : this.entryContainer.getAttributeIndexes()) {
                AttributeType attributeType = attributeIndex.getAttributeType();
                if (this.rebuildConfig.getRebuildMode() == RebuildConfig.RebuildMode.ALL || this.rebuildConfig.getRebuildMode() == RebuildConfig.RebuildMode.DEGRADED) {
                    this.rebuildAttributeIndexes(attributeIndex, attributeType, onlyDegraded);
                    continue;
                }
                if (rebuildList.isEmpty()) continue;
                for (String index : rebuildList) {
                    if (!attributeType.getNameOrOID().toLowerCase().equals(index.toLowerCase())) continue;
                    this.rebuildAttributeIndexes(attributeIndex, attributeType, onlyDegraded);
                }
            }
        }

        private void rebuildAttributeIndexes(AttributeIndex attrIndex, AttributeType attrType, boolean onlyDegraded) throws DatabaseException {
            for (Index index : attrIndex.getAllIndexes()) {
                this.fillIndexMap(attrType, index, onlyDegraded);
            }
        }

        private void fillIndexMap(AttributeType attrType, Index index, boolean onlyDegraded) {
            if (!(index == null || onlyDegraded && index.isTrusted() || this.rebuildConfig.isClearDegradedState() && index.getRecordCount() != 0L)) {
                Importer.this.putInIdContainerMap(index);
                IndexKey key = new IndexKey(attrType, index.getName(), index.getIndexEntryLimit());
                this.indexMap.put(key, index);
            }
        }

        private void clearIndexes() throws DatabaseException {
            if (this.reBuildDN2URI) {
                this.entryContainer.clearDatabase(this.entryContainer.getDN2URI());
            }
            if (this.reBuildDN2ID) {
                this.entryContainer.clearDatabase(this.entryContainer.getDN2ID());
                this.entryContainer.clearDatabase(this.entryContainer.getID2Children());
                this.entryContainer.clearDatabase(this.entryContainer.getID2Subtree());
            }
            if (!this.indexMap.isEmpty()) {
                for (Map.Entry<IndexKey, Index> entry : this.indexMap.entrySet()) {
                    if (entry.getValue().isTrusted()) continue;
                    this.entryContainer.clearDatabase(entry.getValue());
                }
            }
            if (!this.extensibleIndexMap.isEmpty()) {
                for (Collection collection : this.extensibleIndexMap.values()) {
                    if (collection == null) continue;
                    for (Index subIndex : collection) {
                        this.entryContainer.clearDatabase(subIndex);
                    }
                }
            }
            for (VLVIndex vLVIndex : this.entryContainer.getVLVIndexes()) {
                if (vLVIndex.isTrusted()) continue;
                this.entryContainer.clearDatabase(vLVIndex);
            }
        }

        private void setRebuildListIndexesTrusted(boolean trusted) throws JebException {
            try {
                if (this.reBuildDN2ID) {
                    this.suffix.forceTrustedDN2IDRelated(trusted);
                }
                this.setTrusted(this.indexMap.values(), trusted);
                if (!this.vlvIndexes.isEmpty()) {
                    for (VLVIndex vLVIndex : this.vlvIndexes) {
                        vLVIndex.setTrusted(null, trusted);
                    }
                }
                if (!this.extensibleIndexMap.isEmpty()) {
                    for (Collection collection : this.extensibleIndexMap.values()) {
                        this.setTrusted(collection, trusted);
                    }
                }
            }
            catch (DatabaseException ex) {
                throw new JebException(BackendMessages.NOTE_IMPORT_LDIF_TRUSTED_FAILED.get((Object)ex.getMessage()));
            }
        }

        private void setTrusted(Collection<Index> indexes, boolean trusted) {
            if (indexes != null && !indexes.isEmpty()) {
                for (Index index : indexes) {
                    index.setTrusted(null, trusted);
                }
            }
        }

        private void phaseOne() throws DatabaseException, InterruptedException, ExecutionException {
            Importer.this.initializeIndexBuffers();
            Timer timer = this.scheduleAtFixedRate(new RebuildFirstPhaseProgressTask());
            Importer.this.scratchFileWriterService = Executors.newFixedThreadPool(2 * Importer.this.indexCount);
            Importer.this.bufferSortService = Executors.newFixedThreadPool(Importer.this.threadCount);
            ExecutorService rebuildIndexService = Executors.newFixedThreadPool(Importer.this.threadCount);
            ArrayList<RebuildIndexManager> tasks = new ArrayList<RebuildIndexManager>(Importer.this.threadCount);
            for (int i = 0; i < Importer.this.threadCount; ++i) {
                tasks.add(this);
            }
            List results = rebuildIndexService.invokeAll(tasks);
            Importer.this.getAll(results);
            Importer.this.stopScratchFileWriters();
            Importer.this.getAll(Importer.this.scratchFileWriterFutures);
            Importer.this.shutdownAll(new ExecutorService[]{rebuildIndexService, Importer.this.bufferSortService, Importer.this.scratchFileWriterService});
            timer.cancel();
            Importer.this.clearAll(new Collection[]{tasks, results, Importer.this.scratchFileWriterList, Importer.this.scratchFileWriterFutures, Importer.this.freeBufferQueue});
            Importer.this.indexKeyQueueMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void phaseTwo() throws InterruptedException, ExecutionException {
            Timer timer = this.scheduleAtFixedRate(new SecondPhaseProgressTask(this.entriesProcessed.get()));
            try {
                Importer.this.processIndexFiles();
            }
            finally {
                timer.cancel();
            }
        }

        private Timer scheduleAtFixedRate(TimerTask task) {
            Timer timer = new Timer();
            timer.scheduleAtFixedRate(task, 10000L, 10000L);
            return timer;
        }

        private int getIndexCount() throws ConfigException, JebException, InitializationException {
            switch (this.rebuildConfig.getRebuildMode()) {
                case ALL: {
                    return Importer.this.getTotalIndexCount(this.cfg);
                }
                case DEGRADED: {
                    return Importer.this.getTotalIndexCount(this.cfg);
                }
            }
            return this.getRebuildListIndexCount(this.cfg);
        }

        private int getRebuildListIndexCount(LocalDBBackendCfg cfg) throws JebException, ConfigException, InitializationException {
            List rebuildList = this.rebuildConfig.getRebuildList();
            if (rebuildList.isEmpty()) {
                return 0;
            }
            int indexCount = 0;
            for (String index : rebuildList) {
                String lowerName = index.toLowerCase();
                if ("dn2id".equals(lowerName)) {
                    indexCount += 3;
                    continue;
                }
                if ("dn2uri".equals(lowerName)) {
                    ++indexCount;
                    continue;
                }
                if (lowerName.startsWith("vlv.")) {
                    if (lowerName.length() < 5) {
                        throw new JebException(BackendMessages.ERR_VLV_INDEX_NOT_CONFIGURED.get((Object)lowerName));
                    }
                    ++indexCount;
                    continue;
                }
                if ("id2subtree".equals(lowerName) || "id2children".equals(lowerName)) {
                    throw this.attributeIndexNotConfigured(index);
                }
                String[] attrIndexParts = lowerName.split("\\.");
                if (attrIndexParts.length <= 0 || attrIndexParts.length > 3) {
                    throw this.attributeIndexNotConfigured(index);
                }
                AttributeType attrType = DirectoryServer.getAttributeType((String)attrIndexParts[0]);
                if (attrType == null) {
                    throw this.attributeIndexNotConfigured(index);
                }
                if (attrIndexParts.length != 1) {
                    String indexType = attrIndexParts[1];
                    if (attrIndexParts.length == 2) {
                        if ("presence".equals(indexType) || "equality".equals(indexType) || "ordering".equals(indexType) || "substring".equals(indexType) || "approximate".equals(indexType)) {
                            ++indexCount;
                            continue;
                        }
                        throw this.attributeIndexNotConfigured(index);
                    }
                    if (!this.findExtensibleMatchingRule(cfg, indexType + "." + attrIndexParts[2])) {
                        throw this.attributeIndexNotConfigured(index);
                    }
                    ++indexCount;
                    continue;
                }
                boolean found = false;
                for (String idx : cfg.listLocalDBIndexes()) {
                    if (!idx.equalsIgnoreCase(index)) continue;
                    found = true;
                    LocalDBIndexCfg indexCfg = cfg.getLocalDBIndex(idx);
                    indexCount += this.getAttributeIndexCount(indexCfg.getIndexType(), LocalDBIndexCfgDefn.IndexType.PRESENCE, LocalDBIndexCfgDefn.IndexType.EQUALITY, LocalDBIndexCfgDefn.IndexType.ORDERING, LocalDBIndexCfgDefn.IndexType.SUBSTRING, LocalDBIndexCfgDefn.IndexType.APPROXIMATE);
                    indexCount += this.getExtensibleIndexCount(indexCfg);
                }
                if (found) continue;
                throw this.attributeIndexNotConfigured(index);
            }
            return indexCount;
        }

        private InitializationException attributeIndexNotConfigured(String index) {
            return new InitializationException(BackendMessages.ERR_ATTRIBUTE_INDEX_NOT_CONFIGURED.get((Object)index));
        }

        private boolean findExtensibleMatchingRule(LocalDBBackendCfg cfg, String indexExRuleName) throws ConfigException {
            for (String idx : cfg.listLocalDBIndexes()) {
                LocalDBIndexCfg indexCfg = cfg.getLocalDBIndex(idx);
                if (!indexCfg.getIndexType().contains(LocalDBIndexCfgDefn.IndexType.EXTENSIBLE)) continue;
                for (String exRule : indexCfg.getIndexExtensibleMatchingRule()) {
                    if (!exRule.equalsIgnoreCase(indexExRuleName)) continue;
                    return true;
                }
            }
            return false;
        }

        private int getAttributeIndexCount(SortedSet<LocalDBIndexCfgDefn.IndexType> indexTypes, LocalDBIndexCfgDefn.IndexType ... toFinds) {
            int result = 0;
            for (LocalDBIndexCfgDefn.IndexType toFind : toFinds) {
                if (!indexTypes.contains(toFind)) continue;
                ++result;
            }
            return result;
        }

        private int getExtensibleIndexCount(LocalDBIndexCfg indexCfg) {
            int result = 0;
            if (indexCfg.getIndexType().contains(LocalDBIndexCfgDefn.IndexType.EXTENSIBLE)) {
                boolean shared = false;
                for (String exRule : indexCfg.getIndexExtensibleMatchingRule()) {
                    if (exRule.endsWith(".sub")) {
                        ++result;
                        continue;
                    }
                    if (shared) continue;
                    shared = true;
                    ++result;
                }
            }
            return result;
        }

        private void processEntry(Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException, InterruptedException {
            if (this.reBuildDN2ID) {
                this.processDN2ID(this.suffix, entry.getName(), entryID);
            }
            if (this.reBuildDN2URI) {
                this.processDN2URI(this.suffix, null, entry);
            }
            this.processIndexes(entry, entryID);
            this.processExtensibleIndexes(entry, entryID);
            this.processVLVIndexes(entry, entryID);
        }

        private void processVLVIndexes(Entry entry, EntryID entryID) throws DatabaseException, JebException, DirectoryException {
            for (VLVIndex vlvIdx : this.suffix.getEntryContainer().getVLVIndexes()) {
                Transaction transaction = null;
                vlvIdx.addEntry(transaction, entryID, entry);
            }
        }

        private void processExtensibleIndexes(Entry entry, EntryID entryID) throws InterruptedException {
            for (Map.Entry<IndexKey, Collection<Index>> mapEntry : this.extensibleIndexMap.entrySet()) {
                IndexKey key = mapEntry.getKey();
                AttributeType attrType = key.getAttributeType();
                if (!entry.hasAttribute(attrType)) continue;
                for (Index index : mapEntry.getValue()) {
                    this.processAttribute(index, entry, entryID, key);
                }
            }
        }

        private void processIndexes(Entry entry, EntryID entryID) throws DatabaseException, InterruptedException {
            for (Map.Entry<IndexKey, Index> mapEntry : this.indexMap.entrySet()) {
                IndexKey key = mapEntry.getKey();
                AttributeType attrType = key.getAttributeType();
                if (!entry.hasAttribute(attrType)) continue;
                this.processAttribute(mapEntry.getValue(), entry, entryID, key);
            }
        }

        public long getEntriesProcessed() {
            return this.entriesProcessed.get();
        }

        public long getTotalEntries() {
            return this.totalEntries;
        }

        public void diskLowThresholdReached(File directory, long thresholdInBytes) {
            this.diskFullThresholdReached(directory, thresholdInBytes);
        }

        public void diskFullThresholdReached(File directory, long thresholdInBytes) {
            Importer.this.isCanceled = true;
            logger.error(BackendMessages.ERR_REBUILD_INDEX_LACK_DISK, (Object)directory.getAbsolutePath(), (Object)thresholdInBytes);
        }

        public void diskSpaceRestored(File directory, long lowThresholdInBytes, long fullThresholdInBytes) {
        }
    }

    final class IndexManager
    implements Comparable<IndexManager> {
        private final File bufferFile;
        private final String bufferFileName;
        private final File bufferIndexFile;
        private final boolean isDN2ID;
        private final int limit;
        private int numberOfBuffers;
        private long bufferFileSize;
        private long totalDNs;
        private volatile IndexDBWriteTask writer;

        private IndexManager(String fileName, boolean isDN2ID, int limit) {
            this.bufferFileName = fileName;
            this.bufferFile = new File(Importer.this.tempDir, this.bufferFileName);
            this.bufferIndexFile = new File(Importer.this.tempDir, this.bufferFileName + ".index");
            this.isDN2ID = isDN2ID;
            this.limit = limit > 0 ? limit : Integer.MAX_VALUE;
        }

        private void setIndexDBWriteTask(IndexDBWriteTask writer) {
            this.writer = writer;
        }

        private File getBufferFile() {
            return this.bufferFile;
        }

        private long getBufferFileSize() {
            return this.bufferFileSize;
        }

        private File getBufferIndexFile() {
            return this.bufferIndexFile;
        }

        private void setBufferInfo(int numberOfBuffers, long bufferFileSize) {
            this.numberOfBuffers = numberOfBuffers;
            this.bufferFileSize = bufferFileSize;
        }

        void addBytesRead(int bytesRead) {
            if (this.writer != null) {
                this.writer.addBytesRead(bytesRead);
            }
        }

        private void addTotDNCount(int delta) {
            this.totalDNs += (long)delta;
        }

        private long getDNCount() {
            return this.totalDNs;
        }

        private boolean isDN2ID() {
            return this.isDN2ID;
        }

        private void printStats(long deltaTime) {
            if (this.writer != null) {
                this.writer.printStats(deltaTime);
            }
        }

        String getBufferFileName() {
            return this.bufferFileName;
        }

        private int getLimit() {
            return this.limit;
        }

        @Override
        public int compareTo(IndexManager mgr) {
            return this.numberOfBuffers - mgr.numberOfBuffers;
        }

        private int getNumberOfBuffers() {
            return this.numberOfBuffers;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.bufferFileName + ": " + this.bufferFile + ")";
        }
    }

    private final class SortTask
    implements Callable<Void> {
        private final IndexOutputBuffer indexBuffer;

        public SortTask(IndexOutputBuffer indexBuffer) {
            this.indexBuffer = indexBuffer;
        }

        @Override
        public Void call() throws Exception {
            if (Importer.this.importConfiguration != null && Importer.this.importConfiguration.isCancelled() || Importer.this.isCanceled) {
                Importer.this.isCanceled = true;
                return null;
            }
            this.indexBuffer.sort();
            IndexKey indexKey = this.indexBuffer.getIndexKey();
            if (!Importer.this.indexKeyQueueMap.containsKey(indexKey)) {
                this.createIndexWriterTask(indexKey);
            }
            ((BlockingQueue)Importer.this.indexKeyQueueMap.get(indexKey)).add(this.indexBuffer);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createIndexWriterTask(IndexKey indexKey) throws FileNotFoundException {
            Object object = Importer.this.synObj;
            synchronized (object) {
                if (Importer.this.indexKeyQueueMap.containsKey(indexKey)) {
                    return;
                }
                boolean isDN2ID = ImportIndexType.DN.toString().equals(indexKey.getIndexName());
                IndexManager indexMgr = new IndexManager(indexKey.getName(), isDN2ID, indexKey.getEntryLimit());
                if (isDN2ID) {
                    Importer.this.DNIndexMgrList.add(indexMgr);
                } else {
                    Importer.this.indexMgrList.add(indexMgr);
                }
                ArrayBlockingQueue<IndexOutputBuffer> newQueue = new ArrayBlockingQueue<IndexOutputBuffer>(Importer.this.phaseOneBufferCount);
                ScratchFileWriterTask indexWriter = new ScratchFileWriterTask(newQueue, indexMgr);
                Importer.this.scratchFileWriterList.add(indexWriter);
                Importer.this.scratchFileWriterFutures.add(Importer.this.scratchFileWriterService.submit(indexWriter));
                Importer.this.indexKeyQueueMap.put(indexKey, newQueue);
            }
        }
    }

    private final class ScratchFileWriterTask
    implements Callable<Void> {
        private static final int DRAIN_TO = 3;
        private final IndexManager indexMgr;
        private final BlockingQueue<IndexOutputBuffer> queue;
        private final ByteArrayOutputStream insertByteStream;
        private final ByteArrayOutputStream deleteByteStream;
        private final DataOutputStream bufferStream;
        private final DataOutputStream bufferIndexStream;
        private final byte[] tmpArray;
        private final TreeSet<IndexOutputBuffer> indexSortedSet;
        private int insertKeyCount;
        private int deleteKeyCount;
        private int bufferCount;
        private boolean poisonSeen;

        public ScratchFileWriterTask(BlockingQueue<IndexOutputBuffer> queue, IndexManager indexMgr) throws FileNotFoundException {
            this.insertByteStream = new ByteArrayOutputStream(2 * Importer.this.bufferSize);
            this.deleteByteStream = new ByteArrayOutputStream(2 * Importer.this.bufferSize);
            this.tmpArray = new byte[8];
            this.indexSortedSet = new TreeSet();
            this.queue = queue;
            this.indexMgr = indexMgr;
            this.bufferStream = this.newDataOutputStream(indexMgr.getBufferFile());
            this.bufferIndexStream = this.newDataOutputStream(indexMgr.getBufferIndexFile());
        }

        private DataOutputStream newDataOutputStream(File file) throws FileNotFoundException {
            return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 8192));
        }

        @Override
        public Void call() throws IOException, InterruptedException {
            IndexOutputBuffer indexBuffer;
            long offset = 0L;
            LinkedList<IndexOutputBuffer> l = new LinkedList<IndexOutputBuffer>();
            try {
                do {
                    long bufferLen;
                    indexBuffer = this.queue.take();
                    long beginOffset = offset;
                    if (!this.queue.isEmpty()) {
                        this.queue.drainTo(l, 3);
                        l.add(indexBuffer);
                        bufferLen = this.writeIndexBuffers(l);
                        for (IndexOutputBuffer id : l) {
                            if (id.isDiscarded()) continue;
                            id.reset();
                            Importer.this.freeBufferQueue.add(id);
                        }
                        l.clear();
                    } else {
                        if (indexBuffer.isPoison()) break;
                        bufferLen = this.writeIndexBuffer(indexBuffer);
                        if (!indexBuffer.isDiscarded()) {
                            indexBuffer.reset();
                            Importer.this.freeBufferQueue.add(indexBuffer);
                        }
                    }
                    this.bufferIndexStream.writeLong(beginOffset);
                    this.bufferIndexStream.writeLong(offset += bufferLen);
                    ++this.bufferCount;
                    Importer.this.bufferCount.incrementAndGet();
                } while (!this.poisonSeen);
                indexBuffer = null;
            }
            catch (IOException e) {
                try {
                    logger.error(BackendMessages.ERR_IMPORT_LDIF_INDEX_FILEWRITER_ERR, (Object)this.indexMgr.getBufferFile().getAbsolutePath(), (Object)e.getMessage());
                    Importer.this.isCanceled = true;
                    throw e;
                }
                catch (Throwable throwable) {
                    StaticUtils.close((Closeable[])new Closeable[]{this.bufferStream, this.bufferIndexStream});
                    this.indexMgr.setBufferInfo(this.bufferCount, this.indexMgr.getBufferFile().length());
                    throw throwable;
                }
            }
            StaticUtils.close((Closeable[])new Closeable[]{this.bufferStream, this.bufferIndexStream});
            this.indexMgr.setBufferInfo(this.bufferCount, this.indexMgr.getBufferFile().length());
            return indexBuffer;
        }

        private long writeIndexBuffer(IndexOutputBuffer indexBuffer) throws IOException {
            indexBuffer.setPosition(-1);
            this.resetStreams();
            long bufferLen = 0L;
            int numberKeys = indexBuffer.getNumberKeys();
            for (int i = 0; i < numberKeys; ++i) {
                if (indexBuffer.getPosition() == -1) {
                    indexBuffer.setPosition(i);
                    this.insertOrDeleteKey(indexBuffer, i);
                    continue;
                }
                if (!indexBuffer.compare(i)) {
                    bufferLen += (long)this.writeRecord(indexBuffer);
                    indexBuffer.setPosition(i);
                    this.resetStreams();
                }
                this.insertOrDeleteKeyCheckEntryLimit(indexBuffer, i);
            }
            if (indexBuffer.getPosition() != -1) {
                bufferLen += (long)this.writeRecord(indexBuffer);
            }
            return bufferLen;
        }

        private long writeIndexBuffers(List<IndexOutputBuffer> buffers) throws IOException {
            this.resetStreams();
            long bufferID = 0L;
            long bufferLen = 0L;
            for (IndexOutputBuffer b : buffers) {
                if (b.isPoison()) {
                    this.poisonSeen = true;
                    continue;
                }
                b.setPosition(0);
                b.setBufferID(bufferID++);
                this.indexSortedSet.add(b);
            }
            byte[] saveKey = null;
            int saveIndexID = 0;
            while (!this.indexSortedSet.isEmpty()) {
                IndexOutputBuffer b = this.indexSortedSet.pollFirst();
                if (saveKey == null) {
                    saveKey = b.getKey();
                    saveIndexID = b.getIndexID();
                    this.insertOrDeleteKey(b, b.getPosition());
                } else if (!b.compare(saveKey, saveIndexID)) {
                    bufferLen += (long)this.writeRecord(saveKey, saveIndexID);
                    this.resetStreams();
                    saveKey = b.getKey();
                    saveIndexID = b.getIndexID();
                    this.insertOrDeleteKey(b, b.getPosition());
                } else {
                    this.insertOrDeleteKeyCheckEntryLimit(b, b.getPosition());
                }
                if (!b.hasMoreData()) continue;
                b.nextRecord();
                this.indexSortedSet.add(b);
            }
            if (saveKey != null) {
                bufferLen += (long)this.writeRecord(saveKey, saveIndexID);
            }
            return bufferLen;
        }

        private void resetStreams() {
            this.insertByteStream.reset();
            this.insertKeyCount = 0;
            this.deleteByteStream.reset();
            this.deleteKeyCount = 0;
        }

        private void insertOrDeleteKey(IndexOutputBuffer indexBuffer, int position) {
            if (indexBuffer.isInsertRecord(position)) {
                indexBuffer.writeEntryID(this.insertByteStream, position);
                ++this.insertKeyCount;
            } else {
                indexBuffer.writeEntryID(this.deleteByteStream, position);
                ++this.deleteKeyCount;
            }
        }

        private void insertOrDeleteKeyCheckEntryLimit(IndexOutputBuffer indexBuffer, int position) {
            if (indexBuffer.isInsertRecord(position)) {
                if (this.insertKeyCount++ <= this.indexMgr.getLimit()) {
                    indexBuffer.writeEntryID(this.insertByteStream, position);
                }
            } else {
                indexBuffer.writeEntryID(this.deleteByteStream, position);
                ++this.deleteKeyCount;
            }
        }

        private int writeByteStreams() throws IOException {
            if (this.insertKeyCount > this.indexMgr.getLimit()) {
                this.insertKeyCount = 1;
                this.insertByteStream.reset();
                this.writePackedLong(this.insertByteStream, -1L);
            }
            int insertSize = this.writePackedInt(this.bufferStream, this.insertKeyCount);
            if (this.insertByteStream.size() > 0) {
                this.insertByteStream.writeTo(this.bufferStream);
            }
            int deleteSize = this.writePackedInt(this.bufferStream, this.deleteKeyCount);
            if (this.deleteByteStream.size() > 0) {
                this.deleteByteStream.writeTo(this.bufferStream);
            }
            return insertSize + this.insertByteStream.size() + deleteSize + this.deleteByteStream.size();
        }

        private int writeHeader(int indexID, int keySize) throws IOException {
            this.bufferStream.writeInt(indexID);
            return 4 + this.writePackedInt(this.bufferStream, keySize);
        }

        private int writeRecord(IndexOutputBuffer b) throws IOException {
            int keySize = b.getKeySize();
            int headerSize = this.writeHeader(b.getIndexID(), keySize);
            b.writeKey(this.bufferStream);
            int bodySize = this.writeByteStreams();
            return headerSize + keySize + bodySize;
        }

        private int writeRecord(byte[] k, int indexID) throws IOException {
            int keySize = k.length;
            int headerSize = this.writeHeader(indexID, keySize);
            this.bufferStream.write(k);
            int bodySize = this.writeByteStreams();
            return headerSize + keySize + bodySize;
        }

        private int writePackedInt(OutputStream stream, int value) throws IOException {
            int writeSize = PackedInteger.getWriteIntLength((int)value);
            PackedInteger.writeInt((byte[])this.tmpArray, (int)0, (int)value);
            stream.write(this.tmpArray, 0, writeSize);
            return writeSize;
        }

        private int writePackedLong(OutputStream stream, long value) throws IOException {
            int writeSize = PackedInteger.getWriteLongLength((long)value);
            PackedInteger.writeLong((byte[])this.tmpArray, (int)0, (long)value);
            stream.write(this.tmpArray, 0, writeSize);
            return writeSize;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.indexMgr.getBufferFileName() + ": " + this.indexMgr.getBufferFile() + ")";
        }
    }

    private final class IndexDBWriteTask
    implements Callable<Void> {
        private final IndexManager indexMgr;
        private final DatabaseEntry dbKey;
        private final DatabaseEntry dbValue;
        private final int cacheSize;
        private final Map<Integer, DNState> dnStateMap = new HashMap<Integer, DNState>();
        private final Semaphore permits;
        private final int maxPermits;
        private final AtomicLong bytesRead = new AtomicLong();
        private long lastBytesRead;
        private final AtomicInteger keyCount = new AtomicInteger();
        private RandomAccessFile bufferFile;
        private DataInputStream bufferIndexFile;
        private int remainingBuffers;
        private volatile int totalBatches;
        private AtomicInteger batchNumber = new AtomicInteger();
        private int nextBufferID;
        private int ownedPermits;
        private volatile boolean isRunning;

        public IndexDBWriteTask(IndexManager indexMgr, Semaphore permits, int maxPermits, int cacheSize) {
            this.indexMgr = indexMgr;
            this.permits = permits;
            this.maxPermits = maxPermits;
            this.cacheSize = cacheSize;
            this.dbKey = new DatabaseEntry();
            this.dbValue = new DatabaseEntry();
        }

        public void beginWriteTask() throws IOException {
            this.bufferFile = new RandomAccessFile(this.indexMgr.getBufferFile(), "r");
            this.bufferIndexFile = new DataInputStream(new BufferedInputStream(new FileInputStream(this.indexMgr.getBufferIndexFile())));
            this.remainingBuffers = this.indexMgr.getNumberOfBuffers();
            this.totalBatches = this.remainingBuffers / this.maxPermits + 1;
            this.batchNumber.set(0);
            this.nextBufferID = 0;
            this.ownedPermits = 0;
            logger.info(BackendMessages.NOTE_IMPORT_LDIF_INDEX_STARTED, (Object)this.indexMgr.getBufferFileName(), (Object)this.remainingBuffers, (Object)this.totalBatches);
            this.indexMgr.setIndexDBWriteTask(this);
            this.isRunning = true;
        }

        public NavigableSet<IndexInputBuffer> getNextBufferBatch() throws Exception {
            int permitRequest;
            if (this.ownedPermits > 0) {
                this.permits.release(this.ownedPermits);
                this.ownedPermits = 0;
            }
            if ((permitRequest = Math.min(this.remainingBuffers, this.maxPermits)) == 0) {
                return null;
            }
            this.permits.acquire(permitRequest);
            this.ownedPermits = permitRequest;
            this.remainingBuffers -= permitRequest;
            this.batchNumber.incrementAndGet();
            TreeSet<IndexInputBuffer> buffers = new TreeSet<IndexInputBuffer>();
            for (int i = 0; i < permitRequest; ++i) {
                long bufferBegin = this.bufferIndexFile.readLong();
                long bufferEnd = this.bufferIndexFile.readLong();
                IndexInputBuffer b = new IndexInputBuffer(this.indexMgr, this.bufferFile.getChannel(), bufferBegin, bufferEnd, this.nextBufferID++, this.cacheSize);
                buffers.add(b);
            }
            return buffers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endWriteTask() {
            this.isRunning = false;
            if (this.ownedPermits > 0) {
                this.permits.release(this.ownedPermits);
                this.ownedPermits = 0;
            }
            try {
                if (this.indexMgr.isDN2ID()) {
                    for (DNState dnState : this.dnStateMap.values()) {
                        dnState.flush();
                    }
                    if (!Importer.this.isCanceled) {
                        logger.info(BackendMessages.NOTE_IMPORT_LDIF_DN_CLOSE, (Object)this.indexMgr.getDNCount());
                    }
                } else if (!Importer.this.isCanceled) {
                    logger.info(BackendMessages.NOTE_IMPORT_LDIF_INDEX_CLOSE, (Object)this.indexMgr.getBufferFileName());
                }
            }
            catch (Throwable throwable) {
                StaticUtils.close((Closeable[])new Closeable[]{this.bufferFile, this.bufferIndexFile});
                this.indexMgr.getBufferFile().delete();
                this.indexMgr.getBufferIndexFile().delete();
                throw throwable;
            }
            StaticUtils.close((Closeable[])new Closeable[]{this.bufferFile, this.bufferIndexFile});
            this.indexMgr.getBufferFile().delete();
            this.indexMgr.getBufferIndexFile().delete();
        }

        public void printStats(long deltaTime) {
            if (this.isRunning) {
                long bufferFileSize = this.indexMgr.getBufferFileSize();
                long tmpBytesRead = this.bytesRead.get();
                int currentBatch = this.batchNumber.get();
                long bytesReadInterval = tmpBytesRead - this.lastBytesRead;
                int bytesReadPercent = Math.round(100.0f * (float)tmpBytesRead / (float)bufferFileSize);
                long kiloBytesRate = bytesReadInterval / deltaTime;
                long kiloBytesRemaining = (bufferFileSize - tmpBytesRead) / 1024L;
                logger.info(BackendMessages.NOTE_IMPORT_LDIF_PHASE_TWO_REPORT, (Object)this.indexMgr.getBufferFileName(), (Object)bytesReadPercent, (Object)kiloBytesRemaining, (Object)kiloBytesRate, (Object)currentBatch, (Object)this.totalBatches);
                this.lastBytesRead = tmpBytesRead;
            }
        }

        @Override
        public Void call() throws Exception, DirectoryException {
            ByteBuffer key = null;
            ImportIDSet insertIDSet = null;
            ImportIDSet deleteIDSet = null;
            if (Importer.this.isCanceled) {
                return null;
            }
            try {
                Void void_;
                NavigableSet<IndexInputBuffer> bufferSet;
                this.beginWriteTask();
                while ((bufferSet = this.getNextBufferBatch()) != null) {
                    if (Importer.this.isCanceled) {
                        void_ = null;
                        return void_;
                    }
                    Integer indexID = null;
                    while (!bufferSet.isEmpty()) {
                        boolean doCount;
                        int limit;
                        Index index;
                        IndexInputBuffer b = bufferSet.pollFirst();
                        if (key == null) {
                            indexID = b.getIndexID();
                            if (this.indexMgr.isDN2ID()) {
                                insertIDSet = new ImportIDSet(1, 1, false);
                                deleteIDSet = new ImportIDSet(1, 1, false);
                            } else {
                                index = (Index)Importer.this.idContainerMap.get(indexID);
                                limit = index.getIndexEntryLimit();
                                doCount = index.getMaintainCount();
                                insertIDSet = new ImportIDSet(1, limit, doCount);
                                deleteIDSet = new ImportIDSet(1, limit, doCount);
                            }
                            key = ByteBuffer.allocate(b.getKeyLen());
                            key.flip();
                            b.fetchKey(key);
                            b.mergeIDSet(insertIDSet);
                            b.mergeIDSet(deleteIDSet);
                            insertIDSet.setKey(key);
                            deleteIDSet.setKey(key);
                        } else if (b.compare(key, indexID) != 0) {
                            this.addToDB(indexID, insertIDSet, deleteIDSet);
                            this.keyCount.incrementAndGet();
                            indexID = b.getIndexID();
                            if (this.indexMgr.isDN2ID()) {
                                insertIDSet = new ImportIDSet(1, 1, false);
                                deleteIDSet = new ImportIDSet(1, 1, false);
                            } else {
                                index = (Index)Importer.this.idContainerMap.get(indexID);
                                limit = index.getIndexEntryLimit();
                                doCount = index.getMaintainCount();
                                insertIDSet = new ImportIDSet(1, limit, doCount);
                                deleteIDSet = new ImportIDSet(1, limit, doCount);
                            }
                            key.clear();
                            if (b.getKeyLen() > key.capacity()) {
                                key = ByteBuffer.allocate(b.getKeyLen());
                            }
                            key.flip();
                            b.fetchKey(key);
                            b.mergeIDSet(insertIDSet);
                            b.mergeIDSet(deleteIDSet);
                            insertIDSet.setKey(key);
                            deleteIDSet.setKey(key);
                        } else {
                            b.mergeIDSet(insertIDSet);
                            b.mergeIDSet(deleteIDSet);
                        }
                        if (!b.hasMoreData()) continue;
                        b.fetchNextRecord();
                        bufferSet.add(b);
                    }
                    if (key == null) continue;
                    this.addToDB(indexID, insertIDSet, deleteIDSet);
                }
                void_ = null;
                return void_;
            }
            catch (Exception e) {
                logger.error(BackendMessages.ERR_IMPORT_LDIF_INDEX_WRITE_DB_ERR, (Object)this.indexMgr.getBufferFileName(), (Object)e.getMessage());
                throw e;
            }
            finally {
                this.endWriteTask();
            }
        }

        private void addToDB(int indexID, ImportIDSet insertSet, ImportIDSet deleteSet) throws DirectoryException {
            if (this.indexMgr.isDN2ID()) {
                this.addDN2ID(indexID, insertSet);
            } else {
                Index index;
                if (deleteSet.size() > 0 || !deleteSet.isDefined()) {
                    this.dbKey.setData(deleteSet.getKey().array(), 0, deleteSet.getKey().limit());
                    index = (Index)Importer.this.idContainerMap.get(indexID);
                    index.delete(this.dbKey, deleteSet, this.dbValue);
                }
                if (insertSet.size() > 0 || !insertSet.isDefined()) {
                    this.dbKey.setData(insertSet.getKey().array(), 0, insertSet.getKey().limit());
                    index = (Index)Importer.this.idContainerMap.get(indexID);
                    index.insert(this.dbKey, insertSet, this.dbValue);
                }
            }
        }

        private void addDN2ID(int indexID, ImportIDSet record) throws DirectoryException {
            DNState dnState;
            if (!this.dnStateMap.containsKey(indexID)) {
                dnState = new DNState((Suffix)Importer.this.idSuffixMap.get(indexID));
                this.dnStateMap.put(indexID, dnState);
            } else {
                dnState = this.dnStateMap.get(indexID);
            }
            if (dnState.checkParent(record)) {
                dnState.writeToDB();
            }
        }

        private void addBytesRead(int bytesRead) {
            this.bytesRead.addAndGet(bytesRead);
        }

        class DNState {
            private static final int DN_STATE_CACHE_SIZE = 65536;
            private ByteBuffer parentDN;
            private ByteBuffer lastDN;
            private EntryID parentID;
            private EntryID lastID;
            private EntryID entryID;
            private final DatabaseEntry dnKey;
            private final DatabaseEntry dnValue;
            private final TreeMap<ByteBuffer, EntryID> parentIDMap;
            private final EntryContainer entryContainer;
            private final boolean isSubordinatesEnabled;
            private Map<byte[], ImportIDSet> id2childTree;
            private Map<byte[], ImportIDSet> id2subtreeTree;
            private int childLimit;
            private int subTreeLimit;
            private boolean childDoCount;
            private boolean subTreeDoCount;
            private boolean updateID2Children;
            private boolean updateID2Subtree;

            DNState(Suffix suffix) {
                this.entryContainer = suffix.getEntryContainer();
                this.parentIDMap = new TreeMap();
                this.isSubordinatesEnabled = Importer.this.backendConfiguration.isSubordinateIndexesEnabled();
                if (suffix.isProcessID2Children()) {
                    this.childLimit = this.entryContainer.getID2Children().getIndexEntryLimit();
                    this.childDoCount = this.isSubordinatesEnabled && this.entryContainer.getID2Children().getMaintainCount();
                    this.id2childTree = new TreeMap<byte[], ImportIDSet>(this.entryContainer.getID2Children().getComparator());
                    this.updateID2Children = true;
                }
                if (suffix.isProcessID2Subtree()) {
                    this.subTreeLimit = this.entryContainer.getID2Subtree().getIndexEntryLimit();
                    this.subTreeDoCount = this.isSubordinatesEnabled && this.entryContainer.getID2Subtree().getMaintainCount();
                    this.id2subtreeTree = new TreeMap<byte[], ImportIDSet>(this.entryContainer.getID2Subtree().getComparator());
                    this.updateID2Subtree = true;
                }
                this.dnKey = new DatabaseEntry();
                this.dnValue = new DatabaseEntry();
                this.lastDN = ByteBuffer.allocate(128);
            }

            private ByteBuffer getParent(ByteBuffer buffer) {
                int parentIndex = JebFormat.findDNKeyParent(buffer.array(), 0, buffer.limit());
                if (parentIndex < 0) {
                    return null;
                }
                ByteBuffer parent = buffer.duplicate();
                parent.limit(parentIndex);
                return parent;
            }

            private ByteBuffer deepCopy(ByteBuffer srcBuffer, ByteBuffer destBuffer) {
                if (destBuffer == null || destBuffer.clear().remaining() < srcBuffer.limit()) {
                    byte[] bytes = new byte[srcBuffer.limit()];
                    System.arraycopy(srcBuffer.array(), 0, bytes, 0, srcBuffer.limit());
                    return ByteBuffer.wrap(bytes);
                }
                destBuffer.put(srcBuffer);
                destBuffer.flip();
                return destBuffer;
            }

            /*
             * Enabled aggressive block sorting
             */
            private boolean checkParent(ImportIDSet record) throws DatabaseException {
                this.dnKey.setData(record.getKey().array(), 0, record.getKey().limit());
                byte[] v = record.toDatabase();
                long v1 = JebFormat.entryIDFromDatabase(v);
                this.dnValue.setData(v);
                this.entryID = new EntryID(v1);
                this.parentDN = this.getParent(record.getKey());
                if (Importer.this.importConfiguration != null && Importer.this.importConfiguration.appendToExistingData()) {
                    if (this.parentDN == null) return true;
                    DatabaseEntry key = new DatabaseEntry(this.parentDN.array(), 0, this.parentDN.limit());
                    DatabaseEntry value = new DatabaseEntry();
                    OperationStatus status = this.entryContainer.getDN2ID().read(null, key, value, LockMode.DEFAULT);
                    if (status == OperationStatus.SUCCESS) {
                        this.parentID = new EntryID(value);
                        return true;
                    }
                    this.parentID = null;
                    return false;
                }
                if (this.parentIDMap.isEmpty()) {
                    this.parentIDMap.put(this.deepCopy(record.getKey(), null), this.entryID);
                    return true;
                }
                if (this.lastDN != null && this.lastDN.equals(this.parentDN)) {
                    this.parentIDMap.put(this.deepCopy(this.lastDN, null), this.lastID);
                    this.parentID = this.lastID;
                    this.lastDN = this.deepCopy(record.getKey(), this.lastDN);
                    this.lastID = this.entryID;
                    return true;
                }
                if (this.parentIDMap.lastKey().equals(this.parentDN)) {
                    this.parentID = this.parentIDMap.get(this.parentDN);
                    this.lastDN = this.deepCopy(record.getKey(), this.lastDN);
                    this.lastID = this.entryID;
                    return true;
                }
                if (!this.parentIDMap.containsKey(this.parentDN)) {
                    this.parentID = null;
                    return false;
                }
                EntryID newParentID = this.parentIDMap.get(this.parentDN);
                ByteBuffer key = this.parentIDMap.lastKey();
                while (true) {
                    if (this.parentDN.equals(key)) {
                        this.parentIDMap.put(this.deepCopy(record.getKey(), null), this.entryID);
                        this.parentID = newParentID;
                        this.lastDN = this.deepCopy(record.getKey(), this.lastDN);
                        this.lastID = this.entryID;
                        return true;
                    }
                    this.parentIDMap.remove(key);
                    key = this.parentIDMap.lastKey();
                }
            }

            private void id2child(EntryID childID) throws DirectoryException {
                if (this.parentID != null) {
                    ImportIDSet idSet;
                    byte[] parentIDBytes = this.parentID.getDatabaseEntry().getData();
                    if (!this.id2childTree.containsKey(parentIDBytes)) {
                        idSet = new ImportIDSet(1, this.childLimit, this.childDoCount);
                        this.id2childTree.put(parentIDBytes, idSet);
                    } else {
                        idSet = this.id2childTree.get(parentIDBytes);
                    }
                    idSet.addEntryID(childID);
                    if (this.id2childTree.size() > 65536) {
                        this.flushMapToDB(this.id2childTree, this.entryContainer.getID2Children(), true);
                    }
                } else {
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, BackendMessages.ERR_PARENT_ENTRY_IS_MISSING.get());
                }
            }

            private EntryID getParentID(ByteBuffer dn) throws DatabaseException {
                if (Importer.this.importConfiguration == null || !Importer.this.importConfiguration.appendToExistingData()) {
                    return this.parentIDMap.get(dn);
                }
                DatabaseEntry key = new DatabaseEntry(dn.array(), 0, dn.limit());
                DatabaseEntry value = new DatabaseEntry();
                OperationStatus status = this.entryContainer.getDN2ID().read(null, key, value, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS) {
                    return new EntryID(value);
                }
                return null;
            }

            private void id2SubTree(EntryID childID) throws DirectoryException {
                if (this.parentID != null) {
                    EntryID nodeID;
                    ImportIDSet idSet;
                    byte[] parentIDBytes = this.parentID.getDatabaseEntry().getData();
                    if (!this.id2subtreeTree.containsKey(parentIDBytes)) {
                        idSet = new ImportIDSet(1, this.subTreeLimit, this.subTreeDoCount);
                        this.id2subtreeTree.put(parentIDBytes, idSet);
                    } else {
                        idSet = this.id2subtreeTree.get(parentIDBytes);
                    }
                    idSet.addEntryID(childID);
                    ByteBuffer dn = this.getParent(this.parentDN);
                    while (dn != null && (nodeID = this.getParentID(dn)) != null) {
                        byte[] nodeIDBytes = nodeID.getDatabaseEntry().getData();
                        if (!this.id2subtreeTree.containsKey(nodeIDBytes)) {
                            idSet = new ImportIDSet(1, this.subTreeLimit, this.subTreeDoCount);
                            this.id2subtreeTree.put(nodeIDBytes, idSet);
                        } else {
                            idSet = this.id2subtreeTree.get(nodeIDBytes);
                        }
                        idSet.addEntryID(childID);
                        dn = this.getParent(dn);
                    }
                    if (this.id2subtreeTree.size() > 65536) {
                        this.flushMapToDB(this.id2subtreeTree, this.entryContainer.getID2Subtree(), true);
                    }
                } else {
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, BackendMessages.ERR_PARENT_ENTRY_IS_MISSING.get());
                }
            }

            public void writeToDB() throws DirectoryException {
                this.entryContainer.getDN2ID().put(null, this.dnKey, this.dnValue);
                IndexDBWriteTask.this.indexMgr.addTotDNCount(1);
                if (this.isSubordinatesEnabled && this.parentDN != null) {
                    if (this.updateID2Children) {
                        this.id2child(this.entryID);
                    }
                    if (this.updateID2Subtree) {
                        this.id2SubTree(this.entryID);
                    }
                }
            }

            private void flushMapToDB(Map<byte[], ImportIDSet> map, Index index, boolean clearMap) {
                for (Map.Entry<byte[], ImportIDSet> e : map.entrySet()) {
                    byte[] key = e.getKey();
                    ImportIDSet idSet = e.getValue();
                    this.dnKey.setData(key);
                    index.insert(this.dnKey, idSet, this.dnValue);
                }
                if (clearMap) {
                    map.clear();
                }
            }

            public void flush() {
                if (this.isSubordinatesEnabled) {
                    if (this.updateID2Children) {
                        this.flushMapToDB(this.id2childTree, this.entryContainer.getID2Children(), false);
                    }
                    if (this.updateID2Subtree) {
                        this.flushMapToDB(this.id2subtreeTree, this.entryContainer.getID2Subtree(), false);
                    }
                }
            }
        }
    }

    private class ImportTask
    implements Callable<Void> {
        private final Map<IndexKey, IndexOutputBuffer> indexBufferMap = new HashMap<IndexKey, IndexOutputBuffer>();
        private final Set<ByteString> insertKeySet = new HashSet<ByteString>();
        private final EntryInformation entryInfo = new EntryInformation();
        private final IndexKey dnIndexKey = new IndexKey(Importer.access$1900(), ImportIndexType.DN.toString(), 1);
        private DatabaseEntry keyEntry = new DatabaseEntry();
        private DatabaseEntry valEntry = new DatabaseEntry();

        private ImportTask() {
        }

        @Override
        public Void call() throws Exception {
            try {
                while (true) {
                    if (Importer.this.importConfiguration.isCancelled() || Importer.this.isCanceled) {
                        Importer.this.freeBufferQueue.add(IndexOutputBuffer.poison());
                        return null;
                    }
                    Entry entry = Importer.this.reader.readEntry(Importer.this.dnSuffixMap, this.entryInfo);
                    if (entry == null) break;
                    EntryID entryID = this.entryInfo.getEntryID();
                    Suffix suffix = this.entryInfo.getSuffix();
                    this.processEntry(entry, entryID, suffix);
                }
                this.flushIndexBuffers();
                return null;
            }
            catch (Exception e) {
                logger.error(BackendMessages.ERR_IMPORT_LDIF_IMPORT_TASK_ERR, (Object)e.getMessage());
                Importer.this.isCanceled = true;
                throw e;
            }
        }

        void processEntry(Entry entry, EntryID entryID, Suffix suffix) throws DatabaseException, DirectoryException, JebException, InterruptedException {
            DN entryDN = entry.getName();
            if (!Importer.this.skipDNValidation && !this.dnSanityCheck(entryDN, entry, suffix)) {
                suffix.removePending(entryDN);
                return;
            }
            suffix.removePending(entryDN);
            this.processDN2ID(suffix, entryDN, entryID);
            this.processDN2URI(suffix, null, entry);
            this.processIndexes(suffix, entry, entryID);
            suffix.getID2Entry().put(null, entryID, entry);
            Importer.this.importCount.getAndIncrement();
        }

        boolean dnSanityCheck(DN entryDN, Entry entry, Suffix suffix) throws JebException, InterruptedException {
            DN parentDN = suffix.getEntryContainer().getParentWithinBase(entryDN);
            if (parentDN != null && !suffix.isParentProcessed(parentDN, Importer.this.tmpEnv, Importer.this.clearedBackend)) {
                Importer.this.reader.rejectEntry(entry, BackendMessages.ERR_IMPORT_PARENT_NOT_FOUND.get((Object)parentDN));
                return false;
            }
            if (!Importer.this.clearedBackend) {
                EntryID id = suffix.getDN2ID().get(null, entryDN, LockMode.DEFAULT);
                if (id != null || !Importer.this.tmpEnv.insert(entryDN, this.keyEntry, this.valEntry)) {
                    Importer.this.reader.rejectEntry(entry, BackendMessages.WARN_IMPORT_ENTRY_EXISTS.get());
                    return false;
                }
            } else if (!Importer.this.tmpEnv.insert(entryDN, this.keyEntry, this.valEntry)) {
                Importer.this.reader.rejectEntry(entry, BackendMessages.WARN_IMPORT_ENTRY_EXISTS.get());
                return false;
            }
            return true;
        }

        void processIndexes(Suffix suffix, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException, InterruptedException {
            for (AttributeIndex attrIndex : suffix.getAttributeIndexes()) {
                AttributeType attributeType = attrIndex.getAttributeType();
                if (!entry.hasAttribute(attributeType)) continue;
                this.fillIndexKey(suffix, attrIndex, entry, attributeType, entryID);
            }
        }

        void fillIndexKey(Suffix suffix, AttributeIndex attrIndex, Entry entry, AttributeType attrType, EntryID entryID) throws DatabaseException, InterruptedException, DirectoryException, JebException {
            for (Index index : attrIndex.getAllIndexes()) {
                this.processAttribute(index, entry, attrType, entryID);
            }
            for (VLVIndex vlvIdx : suffix.getEntryContainer().getVLVIndexes()) {
                Transaction transaction = null;
                vlvIdx.addEntry(transaction, entryID, entry);
            }
        }

        private void processAttribute(Index index, Entry entry, AttributeType attributeType, EntryID entryID) throws InterruptedException {
            if (index != null) {
                this.processAttribute(index, entry, entryID, new IndexKey(attributeType, index.getName(), index.getIndexEntryLimit()));
            }
        }

        private void processAttributes(Collection<Index> indexes, Entry entry, AttributeType attributeType, EntryID entryID) throws InterruptedException {
            if (indexes != null) {
                for (Index index : indexes) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attributeType, index.getName(), index.getIndexEntryLimit()));
                }
            }
        }

        void processAttribute(Index index, Entry entry, EntryID entryID, IndexKey indexKey) throws DatabaseException, InterruptedException {
            this.insertKeySet.clear();
            index.indexEntry(entry, this.insertKeySet);
            for (ByteString key : this.insertKeySet) {
                this.processKey(index, key.toByteArray(), entryID, indexKey, true);
            }
        }

        void flushIndexBuffers() throws InterruptedException, ExecutionException {
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            Iterator<Map.Entry<IndexKey, IndexOutputBuffer>> it = this.indexBufferMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<IndexKey, IndexOutputBuffer> e = it.next();
                IndexKey indexKey = e.getKey();
                IndexOutputBuffer indexBuffer = e.getValue();
                it.remove();
                indexBuffer.setIndexKey(indexKey);
                indexBuffer.discard();
                futures.add(Importer.this.bufferSortService.submit(new SortTask(indexBuffer)));
            }
            Importer.this.getAll(futures);
        }

        int processKey(DatabaseContainer container, byte[] key, EntryID entryID, IndexKey indexKey, boolean insert) throws InterruptedException {
            int sizeNeeded = IndexOutputBuffer.getRequiredSize(key.length, entryID.longValue());
            IndexOutputBuffer indexBuffer = this.indexBufferMap.get(indexKey);
            if (indexBuffer == null) {
                indexBuffer = this.getNewIndexBuffer(sizeNeeded);
                this.indexBufferMap.put(indexKey, indexBuffer);
            } else if (!indexBuffer.isSpaceAvailable(key, entryID.longValue())) {
                indexBuffer.setIndexKey(indexKey);
                Importer.this.bufferSortService.submit(new SortTask(indexBuffer));
                indexBuffer = this.getNewIndexBuffer(sizeNeeded);
                this.indexBufferMap.put(indexKey, indexBuffer);
            }
            int indexID = Importer.getIndexID(container);
            indexBuffer.add(key, entryID, indexID, insert);
            return indexID;
        }

        IndexOutputBuffer getNewIndexBuffer(int size) throws InterruptedException {
            IndexOutputBuffer indexBuffer;
            if (size > Importer.this.bufferSize) {
                indexBuffer = new IndexOutputBuffer(size);
                indexBuffer.discard();
            } else {
                indexBuffer = (IndexOutputBuffer)Importer.this.freeBufferQueue.take();
                if (indexBuffer == null) {
                    throw new InterruptedException("Index buffer processing error.");
                }
            }
            if (indexBuffer.isPoison()) {
                throw new InterruptedException("Cancel processing received.");
            }
            return indexBuffer;
        }

        void processDN2ID(Suffix suffix, DN dn, EntryID entryID) throws InterruptedException {
            DN2ID dn2id = suffix.getDN2ID();
            byte[] dnBytes = JebFormat.dnToDNKey(dn, suffix.getBaseDN().size());
            int id = this.processKey(dn2id, dnBytes, entryID, this.dnIndexKey, true);
            Importer.this.idSuffixMap.putIfAbsent(id, suffix);
        }

        void processDN2URI(Suffix suffix, Entry oldEntry, Entry newEntry) throws DatabaseException {
            DN2URI dn2uri = suffix.getDN2URI();
            if (oldEntry != null) {
                dn2uri.replaceEntry(null, oldEntry, newEntry);
            } else {
                dn2uri.addEntry(null, newEntry);
            }
        }
    }

    private class AppendReplaceTask
    extends ImportTask {
        private final Set<ByteString> insertKeySet = new HashSet<ByteString>();
        private final Set<ByteString> deleteKeySet = new HashSet<ByteString>();
        private final EntryInformation entryInfo = new EntryInformation();
        private Entry oldEntry;
        private EntryID entryID;

        private AppendReplaceTask() {
        }

        @Override
        public Void call() throws Exception {
            try {
                while (true) {
                    if (Importer.this.importConfiguration.isCancelled() || Importer.this.isCanceled) {
                        Importer.this.freeBufferQueue.add(IndexOutputBuffer.poison());
                        return null;
                    }
                    this.oldEntry = null;
                    Entry entry = Importer.this.reader.readEntry(Importer.this.dnSuffixMap, this.entryInfo);
                    if (entry == null) break;
                    this.entryID = this.entryInfo.getEntryID();
                    Suffix suffix = this.entryInfo.getSuffix();
                    this.processEntry(entry, suffix);
                }
                this.flushIndexBuffers();
                return null;
            }
            catch (Exception e) {
                logger.error(BackendMessages.ERR_IMPORT_LDIF_APPEND_REPLACE_TASK_ERR, (Object)e.getMessage());
                Importer.this.isCanceled = true;
                throw e;
            }
        }

        void processEntry(Entry entry, Suffix suffix) throws DatabaseException, DirectoryException, JebException, InterruptedException {
            DN entryDN = entry.getName();
            DN2ID dn2id = suffix.getDN2ID();
            EntryID oldID = dn2id.get(null, entryDN, LockMode.DEFAULT);
            if (oldID != null) {
                this.oldEntry = suffix.getID2Entry().get(null, oldID, LockMode.DEFAULT);
            }
            if (this.oldEntry == null) {
                if (!Importer.this.skipDNValidation && !this.dnSanityCheck(entryDN, entry, suffix)) {
                    suffix.removePending(entryDN);
                    return;
                }
                suffix.removePending(entryDN);
                this.processDN2ID(suffix, entryDN, this.entryID);
            } else {
                suffix.removePending(entryDN);
                this.entryID = oldID;
            }
            this.processDN2URI(suffix, this.oldEntry, entry);
            suffix.getID2Entry().put(null, this.entryID, entry);
            if (this.oldEntry != null) {
                this.processAllIndexes(suffix, entry, this.entryID);
            } else {
                this.processIndexes(suffix, entry, this.entryID);
            }
            Importer.this.importCount.getAndIncrement();
        }

        void processAllIndexes(Suffix suffix, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException, InterruptedException {
            for (AttributeIndex attrIndex : suffix.getAttributeIndexes()) {
                this.fillIndexKey(suffix, attrIndex, entry, attrIndex.getAttributeType(), entryID);
            }
        }

        @Override
        void processAttribute(Index index, Entry entry, EntryID entryID, IndexKey indexKey) throws DatabaseException, InterruptedException {
            if (this.oldEntry != null) {
                this.deleteKeySet.clear();
                index.indexEntry(this.oldEntry, this.deleteKeySet);
                for (ByteString delKey : this.deleteKeySet) {
                    this.processKey(index, delKey.toByteArray(), entryID, indexKey, false);
                }
            }
            this.insertKeySet.clear();
            index.indexEntry(entry, this.insertKeySet);
            for (ByteString key : this.insertKeySet) {
                this.processKey(index, key.toByteArray(), entryID, indexKey, true);
            }
        }
    }

    private final class MigrateExistingTask
    extends ImportTask {
        private MigrateExistingTask() {
        }

        @Override
        public Void call() throws Exception {
            for (Suffix suffix : Importer.this.dnSuffixMap.values()) {
                EntryContainer entryContainer = suffix.getSrcEntryContainer();
                if (entryContainer == null || suffix.getIncludeBranches().isEmpty()) continue;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                LockMode lockMode = LockMode.DEFAULT;
                logger.info(BackendMessages.NOTE_IMPORT_MIGRATION_START, (Object)"existing", (Object)suffix.getBaseDN());
                Cursor cursor = entryContainer.getDN2ID().openCursor(null, null);
                try {
                    List<byte[]> includeBranches = this.includeBranchesAsBytes(suffix);
                    OperationStatus status = cursor.getFirst(key, data, lockMode);
                    while (status == OperationStatus.SUCCESS && !Importer.this.importConfiguration.isCancelled() && !Importer.this.isCanceled) {
                        if (!this.find(includeBranches, key.getData())) {
                            EntryID id = new EntryID(data);
                            Entry entry = entryContainer.getID2Entry().get(null, id, LockMode.DEFAULT);
                            this.processEntry(entry, Importer.this.rootContainer.getNextEntryID(), suffix);
                            Importer.this.migratedCount++;
                            status = cursor.getNext(key, data, lockMode);
                            continue;
                        }
                        byte[] begin = Arrays.copyOf(key.getData(), key.getSize() + 1);
                        begin[begin.length - 1] = 1;
                        key.setData(begin);
                        status = cursor.getSearchKeyRange(key, data, lockMode);
                    }
                    this.flushIndexBuffers();
                }
                catch (Exception e) {
                    try {
                        logger.error(BackendMessages.ERR_IMPORT_LDIF_MIGRATE_EXISTING_TASK_ERR, (Object)e.getMessage());
                        Importer.this.isCanceled = true;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        StaticUtils.close((Closeable[])new Closeable[]{cursor});
                        throw throwable;
                    }
                }
                StaticUtils.close((Closeable[])new Closeable[]{cursor});
            }
            return null;
        }

        private List<byte[]> includeBranchesAsBytes(Suffix suffix) {
            ArrayList<byte[]> includeBranches = new ArrayList<byte[]>(suffix.getIncludeBranches().size());
            for (DN includeBranch : suffix.getIncludeBranches()) {
                if (!includeBranch.isDescendantOf(suffix.getBaseDN())) continue;
                includeBranches.add(JebFormat.dnToDNKey(includeBranch, suffix.getBaseDN().size()));
            }
            return includeBranches;
        }

        private boolean find(List<byte[]> arrays, byte[] arrayToFind) {
            for (byte[] array : arrays) {
                if (!Arrays.equals(array, arrayToFind)) continue;
                return true;
            }
            return false;
        }
    }

    private final class MigrateExcludedTask
    extends ImportTask {
        private MigrateExcludedTask() {
        }

        @Override
        public Void call() throws Exception {
            for (Suffix suffix : Importer.this.dnSuffixMap.values()) {
                EntryContainer entryContainer = suffix.getSrcEntryContainer();
                if (entryContainer == null || suffix.getExcludeBranches().isEmpty()) continue;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                LockMode lockMode = LockMode.DEFAULT;
                logger.info(BackendMessages.NOTE_IMPORT_MIGRATION_START, (Object)"excluded", (Object)suffix.getBaseDN());
                Cursor cursor = entryContainer.getDN2ID().openCursor(null, CursorConfig.READ_COMMITTED);
                Comparator<byte[]> comparator = entryContainer.getDN2ID().getComparator();
                try {
                    for (DN excludedDN : suffix.getExcludeBranches()) {
                        byte[] bytes = JebFormat.dnToDNKey(excludedDN, suffix.getBaseDN().size());
                        key.setData(bytes);
                        OperationStatus status = cursor.getSearchKeyRange(key, data, lockMode);
                        if (status != OperationStatus.SUCCESS || !Arrays.equals(key.getData(), bytes)) continue;
                        byte[] end = Arrays.copyOf(bytes, bytes.length + 1);
                        end[end.length - 1] = 1;
                        while (status == OperationStatus.SUCCESS && comparator.compare(key.getData(), end) < 0 && !Importer.this.importConfiguration.isCancelled() && !Importer.this.isCanceled) {
                            EntryID id = new EntryID(data);
                            Entry entry = entryContainer.getID2Entry().get(null, id, LockMode.DEFAULT);
                            this.processEntry(entry, Importer.this.rootContainer.getNextEntryID(), suffix);
                            Importer.this.migratedCount++;
                            status = cursor.getNext(key, data, lockMode);
                        }
                    }
                    this.flushIndexBuffers();
                }
                catch (Exception e) {
                    try {
                        logger.error(BackendMessages.ERR_IMPORT_LDIF_MIGRATE_EXCLUDED_TASK_ERR, (Object)e.getMessage());
                        Importer.this.isCanceled = true;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        StaticUtils.close((Closeable[])new Closeable[]{cursor});
                        throw throwable;
                    }
                }
                StaticUtils.close((Closeable[])new Closeable[]{cursor});
            }
            return null;
        }
    }
}

