/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.util.Reject;
import org.opends.messages.UtilityMessages;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.Importer;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.Suffix;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.StaticUtils;

final class ImportLDIFReader
extends LDIFReader {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final RootContainer rootContainer;

    public ImportLDIFReader(LDIFImportConfig importConfig, RootContainer rootContainer) throws IOException {
        super(importConfig);
        Reject.ifNull((Object[])new Object[]{importConfig, rootContainer});
        this.rootContainer = rootContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Entry readEntry(Map<DN, Suffix> suffixesMap, Importer.EntryInformation entryInfo) throws IOException, LDIFException {
        Entry entry;
        EntryID entryID;
        Suffix suffix;
        boolean checkSchema = this.importConfig.validateSchema();
        while (true) {
            DN entryDN;
            LinkedList lines;
            ImportLDIFReader importLDIFReader = this;
            synchronized (importLDIFReader) {
                lines = this.readEntryLines();
                if (lines == null) {
                    return null;
                }
                this.lastEntryBodyLines = lines;
                this.lastEntryHeaderLines = new LinkedList();
                try {
                    entryDN = this.readDN(lines);
                }
                catch (LDIFException e) {
                    logger.traceException((Throwable)e);
                    continue;
                }
                if (entryDN == null) {
                    continue;
                }
                if (!this.importConfig.includeEntry(entryDN)) {
                    logger.trace("Skipping entry %s because the DN is not one that should be included based on the include and exclude branches.", (Object)entryDN);
                    this.entriesRead.incrementAndGet();
                    this.logToSkipWriter(lines, UtilityMessages.ERR_LDIF_SKIP.get((Object)entryDN));
                    continue;
                }
                suffix = Importer.getMatchSuffix(entryDN, suffixesMap);
                if (suffix == null) {
                    logger.trace("Skipping entry %s because the DN is not one that should be included based on a suffix match check.", (Object)entryDN);
                    this.entriesRead.incrementAndGet();
                    this.logToSkipWriter(lines, UtilityMessages.ERR_LDIF_SKIP.get((Object)entryDN));
                    continue;
                }
                this.entriesRead.incrementAndGet();
                entryID = this.rootContainer.getNextEntryID();
                suffix.addPending(entryDN);
            }
            entry = this.createEntry(lines, entryDN, checkSchema, suffix);
            if (entry != null && this.isIncludedInImport(entry, suffix, lines) && this.invokeImportPlugins(entry, suffix, lines) && (!checkSchema || this.isValidAgainstSchema(entry, suffix, lines))) break;
        }
        entryInfo.setEntryID(entryID);
        entryInfo.setSuffix(suffix);
        return entry;
    }

    private Entry createEntry(List<StringBuilder> lines, DN entryDN, boolean checkSchema, Suffix suffix) {
        HashMap objectClasses = new HashMap();
        HashMap userAttrBuilders = new HashMap();
        HashMap operationalAttrBuilders = new HashMap();
        try {
            for (StringBuilder line : lines) {
                this.readAttribute(lines, line, entryDN, objectClasses, userAttrBuilders, operationalAttrBuilders, checkSchema);
            }
        }
        catch (LDIFException e) {
            if (logger.isTraceEnabled()) {
                logger.trace("Skipping entry %s because readingits attributes failed.", (Object)entryDN);
            }
            this.logToSkipWriter(lines, UtilityMessages.ERR_LDIF_READ_ATTR_SKIP.get((Object)entryDN, (Object)e.getMessage()));
            suffix.removePending(entryDN);
            return null;
        }
        Entry entry = new Entry(entryDN, objectClasses, this.toAttributesMap(userAttrBuilders), this.toAttributesMap(operationalAttrBuilders));
        logger.trace("readEntry(), created entry: %s", (Object)entry);
        return entry;
    }

    private boolean isIncludedInImport(Entry entry, Suffix suffix, LinkedList<StringBuilder> lines) {
        DN entryDN = entry.getName();
        try {
            if (!this.importConfig.includeEntry(entry)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Skipping entry %s because the DN is not one that should be included based on the include and exclude filters.", (Object)entryDN);
                }
                this.logToSkipWriter(lines, UtilityMessages.ERR_LDIF_SKIP.get((Object)entryDN));
                suffix.removePending(entryDN);
                return false;
            }
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
            suffix.removePending(entryDN);
            this.logToSkipWriter(lines, UtilityMessages.ERR_LDIF_COULD_NOT_EVALUATE_FILTERS_FOR_IMPORT.get((Object)entry.getName(), (Object)this.lastEntryLineNumber, (Object)e));
            suffix.removePending(entryDN);
            return false;
        }
        return true;
    }

    private boolean invokeImportPlugins(Entry entry, Suffix suffix, LinkedList<StringBuilder> lines) {
        PluginResult.ImportLDIF pluginResult;
        if (this.importConfig.invokeImportPlugins() && !(pluginResult = this.pluginConfigManager.invokeLDIFImportPlugins(this.importConfig, entry)).continueProcessing()) {
            DN entryDN = entry.getName();
            LocalizableMessage rejectMessage = pluginResult.getErrorMessage();
            LocalizableMessage m = rejectMessage == null ? UtilityMessages.ERR_LDIF_REJECTED_BY_PLUGIN_NOMESSAGE.get((Object)entryDN) : UtilityMessages.ERR_LDIF_REJECTED_BY_PLUGIN.get((Object)entryDN, (Object)rejectMessage);
            this.logToRejectWriter(lines, m);
            suffix.removePending(entryDN);
            return false;
        }
        return true;
    }

    private boolean isValidAgainstSchema(Entry entry, Suffix suffix, LinkedList<StringBuilder> lines) {
        DN entryDN = entry.getName();
        this.addRDNAttributesIfNecessary(entryDN, entry.getUserAttributes(), entry.getOperationalAttributes());
        StaticUtils.addSuperiorObjectClasses((Map)entry.getObjectClasses());
        LocalizableMessageBuilder invalidReason = new LocalizableMessageBuilder();
        if (!entry.conformsToSchema(null, false, true, false, invalidReason)) {
            LocalizableMessage message = UtilityMessages.ERR_LDIF_SCHEMA_VIOLATION.get((Object)entryDN, (Object)this.lastEntryLineNumber, (Object)invalidReason);
            this.logToRejectWriter(lines, message);
            suffix.removePending(entryDN);
            return false;
        }
        return true;
    }
}

