/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.util.Utils;
import org.opends.messages.BackendMessages;
import org.opends.server.api.CompressedSchema;
import org.opends.server.backends.jeb.DataConfig;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JEBUtils;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;

public class ID2Entry
extends DatabaseContainer {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private DataConfig dataConfig;
    private static final ThreadLocal<EntryCodec> ENTRY_CODEC_CACHE = new ThreadLocal<EntryCodec>(){

        @Override
        protected EntryCodec initialValue() {
            return new EntryCodec();
        }
    };

    private static EntryCodec acquireEntryCodec() {
        EntryCodec codec = ENTRY_CODEC_CACHE.get();
        if (codec.maxBufferSize != DirectoryServer.getMaxInternalBufferSize()) {
            codec = new EntryCodec();
            ENTRY_CODEC_CACHE.set(codec);
        }
        return codec;
    }

    ID2Entry(String name, DataConfig dataConfig, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        this.dataConfig = dataConfig;
        this.dbConfig = JEBUtils.toDatabaseConfigNoDuplicates(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry entryFromDatabase(ByteString bytes, CompressedSchema compressedSchema) throws DirectoryException, DecodeException, LDAPException, DataFormatException, IOException {
        EntryCodec codec = ID2Entry.acquireEntryCodec();
        try {
            Entry entry = codec.decode(bytes, compressedSchema);
            return entry;
        }
        finally {
            codec.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteString entryToDatabase(Entry entry, DataConfig dataConfig) throws DirectoryException {
        EntryCodec codec = ID2Entry.acquireEntryCodec();
        try {
            ByteString byteString = codec.encodeCopy(entry, dataConfig);
            return byteString;
        }
        finally {
            codec.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insert(Transaction txn, EntryID id, Entry entry) throws DatabaseException, DirectoryException {
        DatabaseEntry key = id.getDatabaseEntry();
        EntryCodec codec = ID2Entry.acquireEntryCodec();
        try {
            DatabaseEntry data = codec.encodeInternal(entry, this.dataConfig);
            boolean bl = this.insert(txn, key, data) == OperationStatus.SUCCESS;
            return bl;
        }
        finally {
            codec.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Transaction txn, EntryID id, Entry entry) throws DatabaseException, DirectoryException {
        DatabaseEntry key = id.getDatabaseEntry();
        EntryCodec codec = ID2Entry.acquireEntryCodec();
        try {
            DatabaseEntry data = codec.encodeInternal(entry, this.dataConfig);
            boolean bl = this.put(txn, key, data) == OperationStatus.SUCCESS;
            return bl;
        }
        finally {
            codec.release();
        }
    }

    boolean remove(Transaction txn, EntryID id) throws DatabaseException {
        DatabaseEntry key = id.getDatabaseEntry();
        return this.delete(txn, key) == OperationStatus.SUCCESS;
    }

    public Entry get(Transaction txn, EntryID id, LockMode lockMode) throws DirectoryException, DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = id.getDatabaseEntry();
        if (this.read(txn, key, data = new DatabaseEntry(), lockMode) != OperationStatus.SUCCESS) {
            return null;
        }
        try {
            Entry entry = ID2Entry.entryFromDatabase(ByteString.wrap((byte[])data.getData()), this.entryContainer.getRootContainer().getCompressedSchema());
            entry.processVirtualAttributes();
            return entry;
        }
        catch (Exception e) {
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), BackendMessages.ERR_ENTRY_DATABASE_CORRUPT.get((Object)id));
        }
    }

    public void setDataConfig(DataConfig dataConfig) {
        this.dataConfig = dataConfig;
    }

    private static final class EntryCodec {
        private static final int BUFFER_INIT_SIZE = 512;
        private final ByteStringBuilder encodedBuffer = new ByteStringBuilder();
        private final ByteStringBuilder entryBuffer = new ByteStringBuilder();
        private final ByteStringBuilder compressedEntryBuffer = new ByteStringBuilder();
        private final ASN1Writer writer;
        private final int maxBufferSize = DirectoryServer.getMaxInternalBufferSize();

        private EntryCodec() {
            this.writer = ASN1.getWriter((ByteStringBuilder)this.encodedBuffer, (int)this.maxBufferSize);
        }

        private void release() {
            Utils.closeSilently((Closeable[])new Closeable[]{this.writer});
            this.encodedBuffer.clearAndTruncate(this.maxBufferSize, 512);
            this.entryBuffer.clearAndTruncate(this.maxBufferSize, 512);
            this.compressedEntryBuffer.clearAndTruncate(this.maxBufferSize, 512);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Entry decode(ByteString bytes, CompressedSchema compressedSchema) throws DirectoryException, DecodeException, LDAPException, DataFormatException, IOException {
            ASN1Reader reader;
            block3: {
                byte formatVersion = bytes.byteAt(0);
                if (formatVersion != 1) {
                    throw DecodeException.error((LocalizableMessage)BackendMessages.ERR_INCOMPATIBLE_ENTRY_VERSION.get((Object)formatVersion));
                }
                reader = ASN1.getReader((ByteSequence)bytes.subSequence(1, bytes.length()));
                reader.readStartSequence();
                int uncompressedSize = (int)reader.readInteger();
                if (uncompressedSize <= 0) break block3;
                reader.readOctetString(this.compressedEntryBuffer);
                InflaterOutputStream decompressor = null;
                try {
                    decompressor = new InflaterOutputStream(this.entryBuffer.asOutputStream());
                    this.compressedEntryBuffer.copyTo((OutputStream)decompressor);
                }
                catch (Throwable throwable) {
                    Utils.closeSilently((Closeable[])new Closeable[]{decompressor});
                    throw throwable;
                }
                Utils.closeSilently((Closeable[])new Closeable[]{decompressor});
                return Entry.decode((ByteSequenceReader)this.entryBuffer.asReader(), (CompressedSchema)compressedSchema);
            }
            ByteString encodedEntry = reader.readOctetString();
            return Entry.decode((ByteSequenceReader)encodedEntry.asReader(), (CompressedSchema)compressedSchema);
        }

        private ByteString encodeCopy(Entry entry, DataConfig dataConfig) throws DirectoryException {
            this.encodeVolatile(entry, dataConfig);
            return this.encodedBuffer.toByteString();
        }

        private DatabaseEntry encodeInternal(Entry entry, DataConfig dataConfig) throws DirectoryException {
            this.encodeVolatile(entry, dataConfig);
            return new DatabaseEntry(this.encodedBuffer.getBackingArray(), 0, this.encodedBuffer.length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void encodeVolatile(Entry entry, DataConfig dataConfig) throws DirectoryException {
            entry.encode(this.entryBuffer, dataConfig.getEntryEncodeConfig());
            this.encodedBuffer.append((byte)1);
            try {
                block5: {
                    block4: {
                        this.writer.writeStartSequence((byte)96);
                        if (!dataConfig.isCompressed()) break block4;
                        DeflaterOutputStream compressor = null;
                        try {
                            compressor = new DeflaterOutputStream(this.compressedEntryBuffer.asOutputStream());
                            this.entryBuffer.copyTo((OutputStream)compressor);
                        }
                        catch (Throwable throwable) {
                            Utils.closeSilently((Closeable[])new Closeable[]{compressor});
                            throw throwable;
                        }
                        Utils.closeSilently((Closeable[])new Closeable[]{compressor});
                        this.writer.writeInteger(this.entryBuffer.length());
                        this.writer.writeOctetString((ByteSequence)this.compressedEntryBuffer);
                        break block5;
                    }
                    this.writer.writeInteger(0);
                    this.writer.writeOctetString((ByteSequence)this.entryBuffer);
                }
                this.writer.writeEndSequence();
            }
            catch (IOException ioe) {
                logger.traceException((Throwable)ioe);
            }
        }
    }
}

