/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteString;
import org.opends.messages.BackendMessages;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.util.LDIFException;
import org.opends.server.util.StaticUtils;

public class ExportJob {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private LDIFExportConfig exportConfig;
    private long progressInterval = 10000L;
    private long exportedCount;
    private long skippedCount;

    public ExportJob(LDIFExportConfig exportConfig) {
        this.exportConfig = exportConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLDIF(RootContainer rootContainer) throws IOException, LDIFException, DatabaseException, JebException {
        List includeBranches = this.exportConfig.getIncludeBranches();
        ArrayList<EntryContainer> exportContainers = new ArrayList<EntryContainer>();
        block6: for (EntryContainer entryContainer : rootContainer.getEntryContainers()) {
            DN baseDN = entryContainer.getBaseDN();
            if (includeBranches == null || includeBranches.isEmpty()) {
                exportContainers.add(entryContainer);
                continue;
            }
            for (DN includeBranch : includeBranches) {
                if (!includeBranch.isDescendantOf(baseDN) && !includeBranch.isAncestorOf(baseDN)) continue;
                exportContainers.add(entryContainer);
                continue block6;
            }
        }
        long startTime = System.currentTimeMillis();
        Timer timer = new Timer();
        ProgressTask progressTask = new ProgressTask();
        timer.scheduleAtFixedRate((TimerTask)progressTask, this.progressInterval, this.progressInterval);
        try {
            for (EntryContainer exportContainer : exportContainers) {
                if (this.exportConfig.isCancelled()) {
                    break;
                }
                exportContainer.sharedLock.lock();
                try {
                    this.exportContainer(exportContainer);
                }
                finally {
                    exportContainer.sharedLock.unlock();
                }
            }
        }
        finally {
            timer.cancel();
        }
        long finishTime = System.currentTimeMillis();
        long totalTime = finishTime - startTime;
        float rate = 0.0f;
        if (totalTime > 0L) {
            rate = 1000.0f * (float)this.exportedCount / (float)totalTime;
        }
        logger.info(BackendMessages.NOTE_EXPORT_FINAL_STATUS, (Object)this.exportedCount, (Object)this.skippedCount, (Object)(totalTime / 1000L), (Object)Float.valueOf(rate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportContainer(EntryContainer entryContainer) throws DatabaseException, IOException, LDIFException {
        ID2Entry id2entry = entryContainer.getID2Entry();
        try (Cursor cursor = id2entry.openCursor(null, new CursorConfig());){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = cursor.getFirst(key, data, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                block15: {
                    if (this.exportConfig.isCancelled()) {
                        break;
                    }
                    EntryID entryID = null;
                    try {
                        entryID = new EntryID(key);
                    }
                    catch (Exception e) {
                        if (logger.isTraceEnabled()) {
                            logger.traceException((Throwable)e);
                            logger.trace("Malformed id2entry ID %s.%n", (Object)StaticUtils.bytesToHex((byte[])key.getData()));
                        }
                        ++this.skippedCount;
                        break block15;
                    }
                    if (entryID.longValue() != 0L) {
                        Entry entry = null;
                        try {
                            entry = ID2Entry.entryFromDatabase(ByteString.wrap((byte[])data.getData()), entryContainer.getRootContainer().getCompressedSchema());
                        }
                        catch (Exception e) {
                            if (logger.isTraceEnabled()) {
                                logger.traceException((Throwable)e);
                                logger.trace("Malformed id2entry record for ID %d:%n%s%n", (Object)entryID.longValue(), (Object)StaticUtils.bytesToHex((byte[])data.getData()));
                            }
                            ++this.skippedCount;
                            break block15;
                        }
                        if (entry.toLDIF(this.exportConfig)) {
                            ++this.exportedCount;
                        } else {
                            ++this.skippedCount;
                        }
                    }
                }
                status = cursor.getNext(key, data, LockMode.DEFAULT);
            }
        }
    }

    class ProgressTask
    extends TimerTask {
        private long previousCount;
        private long previousTime = System.currentTimeMillis();

        @Override
        public void run() {
            long latestCount = ExportJob.this.exportedCount;
            long deltaCount = latestCount - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
            logger.info(BackendMessages.NOTE_EXPORT_PROGRESS_REPORT, (Object)latestCount, (Object)ExportJob.this.skippedCount, (Object)Float.valueOf(rate));
            this.previousCount = latestCount;
            this.previousTime = latestTime;
        }
    }
}

