/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.io.File;
import java.io.FilenameFilter;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.opends.messages.BackendMessages;
import org.opends.server.backends.jeb.JebException;

public class EnvManager {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final FilenameFilter jeAllFilesFilter = new FilenameFilter(){

        @Override
        public boolean accept(File d, String name) {
            return name.endsWith(".jdb") || name.endsWith(".del") || name.startsWith("je.");
        }
    };

    public static void createHomeDir(String homeDir) throws JebException {
        File dir = new File(homeDir);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new JebException(BackendMessages.ERR_DIRECTORY_INVALID.get((Object)homeDir));
            }
            EnvManager.removeFiles(homeDir);
        } else {
            try {
                dir.mkdir();
            }
            catch (Exception e) {
                logger.traceException((Throwable)e);
                throw new JebException(BackendMessages.ERR_CREATE_FAIL.get((Object)e.getMessage()), e);
            }
        }
    }

    public static void removeFiles(String homeDir) throws JebException {
        File dir = new File(homeDir);
        if (!dir.exists()) {
            LocalizableMessage message = BackendMessages.ERR_DIRECTORY_DOES_NOT_EXIST.get((Object)homeDir);
            throw new JebException(message);
        }
        if (!dir.isDirectory()) {
            throw new JebException(BackendMessages.ERR_DIRECTORY_INVALID.get((Object)homeDir));
        }
        try {
            File[] jdbFiles;
            for (File f : jdbFiles = dir.listFiles(jeAllFilesFilter)) {
                f.delete();
            }
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
            throw new JebException(BackendMessages.ERR_REMOVE_FAIL.get((Object)e.getMessage()), e);
        }
    }
}

