/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.forgerock.opendj.ldap.ByteString;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.IDSetIterator;
import org.opends.server.backends.jeb.JebFormat;

public class EntryIDSet
implements Iterable<EntryID> {
    private long[] values;
    private long undefinedSize = Long.MAX_VALUE;
    private final ByteString keyBytes;

    public EntryIDSet() {
        this.keyBytes = null;
        this.undefinedSize = Long.MAX_VALUE;
    }

    public EntryIDSet(long size) {
        this.keyBytes = null;
        this.undefinedSize = size;
    }

    public EntryIDSet(byte[] keyBytes, byte[] bytes) {
        this(keyBytes != null ? ByteString.wrap((byte[])keyBytes) : null, bytes != null ? ByteString.wrap((byte[])bytes) : null);
    }

    public EntryIDSet(ByteString keyBytes, ByteString bytes) {
        this.keyBytes = keyBytes;
        if (bytes == null) {
            this.values = new long[0];
            return;
        }
        if (bytes.length() == 0) {
            this.undefinedSize = Long.MAX_VALUE;
        } else if ((bytes.byteAt(0) & 0x80) == 128) {
            this.undefinedSize = JebFormat.entryIDUndefinedSizeFromDatabase(bytes.toByteArray());
        } else {
            this.values = JebFormat.entryIDListFromDatabase(bytes.toByteArray());
        }
    }

    EntryIDSet(long[] values, int pos, int len) {
        this.keyBytes = null;
        this.values = new long[len];
        System.arraycopy(values, pos, this.values, 0, len);
    }

    public static EntryIDSet unionOfSets(ArrayList<EntryIDSet> sets, boolean allowDuplicates) {
        int count = 0;
        boolean undefined = false;
        for (EntryIDSet l : sets) {
            if (!l.isDefined()) {
                if (l.undefinedSize == Long.MAX_VALUE) {
                    return new EntryIDSet();
                }
                undefined = true;
            }
            count = (int)((long)count + l.size());
        }
        if (undefined) {
            return new EntryIDSet(count);
        }
        boolean needSort = false;
        long[] n = new long[count];
        int pos = 0;
        for (EntryIDSet l : sets) {
            if (l.values.length == 0) continue;
            if (!needSort && pos > 0 && l.values[0] < n[pos - 1]) {
                needSort = true;
            }
            System.arraycopy(l.values, 0, n, pos, l.values.length);
            pos += l.values.length;
        }
        if (needSort) {
            Arrays.sort(n);
        }
        if (allowDuplicates) {
            EntryIDSet ret = new EntryIDSet();
            ret.values = n;
            return ret;
        }
        long[] n1 = new long[n.length];
        long last = -1L;
        int j = 0;
        for (long l : n) {
            if (l == last) continue;
            int n2 = j++;
            long l2 = l;
            n1[n2] = l2;
            last = l2;
        }
        if (j == n1.length) {
            EntryIDSet ret = new EntryIDSet();
            ret.values = n1;
            return ret;
        }
        return new EntryIDSet(n1, 0, j);
    }

    public long size() {
        if (this.values != null) {
            return this.values.length;
        }
        return this.undefinedSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(16);
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        if (!this.isDefined()) {
            if (this.keyBytes != null) {
                if (this.undefinedSize == Long.MAX_VALUE) {
                    buffer.append("[LIMIT-EXCEEDED]");
                } else {
                    buffer.append("[LIMIT-EXCEEDED:");
                    buffer.append(this.undefinedSize);
                    buffer.append("]");
                }
            } else {
                buffer.append("[NOT-INDEXED]");
            }
        } else {
            buffer.append("[COUNT:");
            buffer.append(this.size());
            buffer.append("]");
        }
    }

    public boolean isDefined() {
        return this.values != null;
    }

    public byte[] toDatabase() {
        if (this.isDefined()) {
            return JebFormat.entryIDListToDatabase(this.values);
        }
        return JebFormat.entryIDUndefinedSizeToDatabase(this.undefinedSize);
    }

    public boolean add(EntryID entryID) {
        if (this.values == null) {
            if (this.undefinedSize != Long.MAX_VALUE) {
                ++this.undefinedSize;
            }
            return true;
        }
        long id = entryID.longValue();
        if (this.values.length == 0) {
            this.values = new long[]{id};
            return true;
        }
        if (id > this.values[this.values.length - 1]) {
            long[] updatedValues = Arrays.copyOf(this.values, this.values.length + 1);
            updatedValues[this.values.length] = id;
            this.values = updatedValues;
        } else {
            int pos = Arrays.binarySearch(this.values, id);
            if (pos >= 0) {
                return false;
            }
            pos = -(pos + 1);
            long[] updatedValues = new long[this.values.length + 1];
            System.arraycopy(this.values, 0, updatedValues, 0, pos);
            System.arraycopy(this.values, pos, updatedValues, pos + 1, this.values.length - pos);
            updatedValues[pos] = id;
            this.values = updatedValues;
        }
        return true;
    }

    public boolean remove(EntryID entryID) {
        if (this.values == null) {
            if (this.undefinedSize != Long.MAX_VALUE) {
                --this.undefinedSize;
            }
            return true;
        }
        if (this.values.length == 0) {
            return false;
        }
        long id = entryID.longValue();
        int pos = Arrays.binarySearch(this.values, id);
        if (pos >= 0) {
            long[] updatedValues = new long[this.values.length - 1];
            System.arraycopy(this.values, 0, updatedValues, 0, pos);
            System.arraycopy(this.values, pos + 1, updatedValues, pos, this.values.length - pos - 1);
            this.values = updatedValues;
            return true;
        }
        return false;
    }

    public boolean contains(EntryID entryID) {
        if (this.values == null) {
            return true;
        }
        long id = entryID.longValue();
        return this.values.length != 0 && id <= this.values[this.values.length - 1] && Arrays.binarySearch(this.values, id) >= 0;
    }

    public void retainAll(EntryIDSet that) {
        if (!this.isDefined()) {
            this.values = that.values;
            this.undefinedSize = that.undefinedSize;
            return;
        }
        if (!that.isDefined()) {
            return;
        }
        long[] a = this.values;
        long[] b = that.values;
        int ai = 0;
        int bi = 0;
        int ci = 0;
        long[] c = new long[Math.min(a.length, b.length)];
        while (ai < a.length && bi < b.length) {
            if (a[ai] == b[bi]) {
                c[ci] = a[ai];
                ++ai;
                ++bi;
                ++ci;
                continue;
            }
            if (a[ai] > b[bi]) {
                ++bi;
                continue;
            }
            ++ai;
        }
        this.values = ci < c.length ? Arrays.copyOf(c, ci) : c;
    }

    public void addAll(EntryIDSet that) {
        int bRemain;
        long[] n;
        if (!that.isDefined()) {
            return;
        }
        if (!this.isDefined()) {
            if (this.undefinedSize != Long.MAX_VALUE) {
                this.undefinedSize += that.size();
            }
            return;
        }
        long[] a = this.values;
        long[] b = that.values;
        if (a.length == 0) {
            this.values = b;
            return;
        }
        if (b.length == 0) {
            return;
        }
        if (b[0] > a[a.length - 1]) {
            long[] n2 = new long[a.length + b.length];
            System.arraycopy(a, 0, n2, 0, a.length);
            System.arraycopy(b, 0, n2, a.length, b.length);
            this.values = n2;
            return;
        }
        if (a[0] > b[b.length - 1]) {
            long[] n3 = new long[a.length + b.length];
            System.arraycopy(b, 0, n3, 0, b.length);
            System.arraycopy(a, 0, n3, b.length, a.length);
            this.values = n3;
            return;
        }
        if (b.length < a.length) {
            n = a;
            a = b;
            b = n;
        }
        n = new long[a.length + b.length];
        int ni = 0;
        int ai = 0;
        int bi = 0;
        while (ai < a.length && bi < b.length) {
            if (a[ai] < b[bi]) {
                n[ni++] = a[ai++];
                continue;
            }
            if (b[bi] < a[ai]) {
                n[ni++] = b[bi++];
                continue;
            }
            n[ni++] = a[ai];
            ++ai;
            ++bi;
        }
        int aRemain = a.length - ai;
        if (aRemain > 0) {
            System.arraycopy(a, ai, n, ni, aRemain);
            ni += aRemain;
        }
        if ((bRemain = b.length - bi) > 0) {
            System.arraycopy(b, bi, n, ni, bRemain);
            ni += bRemain;
        }
        this.values = ni < n.length ? Arrays.copyOf(n, ni) : n;
    }

    public void deleteAll(EntryIDSet that) {
        if (!that.isDefined()) {
            return;
        }
        if (!this.isDefined()) {
            if (this.undefinedSize != Long.MAX_VALUE) {
                this.undefinedSize -= that.size();
            }
            return;
        }
        long[] a = this.values;
        long[] b = that.values;
        if (a.length == 0 || b.length == 0 || b[0] > a[a.length - 1] || a[0] > b[b.length - 1]) {
            return;
        }
        long[] n = new long[a.length];
        int ni = 0;
        int ai = 0;
        int bi = 0;
        while (ai < a.length && bi < b.length) {
            if (a[ai] < b[bi]) {
                n[ni++] = a[ai++];
                continue;
            }
            if (b[bi] < a[ai]) {
                ++bi;
                continue;
            }
            ++ai;
            ++bi;
        }
        System.arraycopy(a, ai, n, ni, a.length - ai);
        this.values = (ni += a.length - ai) < a.length ? Arrays.copyOf(n, ni) : n;
    }

    @Override
    public Iterator<EntryID> iterator() {
        return this.iterator(null);
    }

    public Iterator<EntryID> iterator(EntryID begin) {
        if (this.values != null) {
            return new IDSetIterator(this.values, begin);
        }
        return new IDSetIterator(new long[0]);
    }
}

