/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import org.opends.server.backends.jeb.JebFormat;

public class EntryID
implements Comparable<EntryID> {
    private final long id;
    private DatabaseEntry data;

    public EntryID(long id) {
        this.id = id;
    }

    public EntryID(DatabaseEntry databaseEntry) {
        this.data = databaseEntry;
        this.id = JebFormat.entryIDFromDatabase(this.data.getData());
    }

    public long longValue() {
        return this.id;
    }

    public DatabaseEntry getDatabaseEntry() {
        if (this.data == null) {
            this.data = new DatabaseEntry();
            this.data.setData(JebFormat.entryIDToDatabase(this.id));
        }
        return this.data;
    }

    @Override
    public int compareTo(EntryID that) throws ClassCastException {
        long result = this.id - that.id;
        if (result < 0L) {
            return -1;
        }
        if (result > 0L) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof EntryID)) {
            return false;
        }
        return this.id == ((EntryID)that).id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public String toString() {
        return Long.toString(this.id);
    }
}

