/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.util.Utils;
import org.opends.messages.BackendMessages;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.admin.std.server.LocalDBIndexCfg;
import org.opends.server.admin.std.server.LocalDBVLVIndexCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.EntryCache;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.DataConfig;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.EntryIDSetSorter;
import org.opends.server.backends.jeb.ID2CIndexer;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.ID2SIndexer;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexBuffer;
import org.opends.server.backends.jeb.IndexFilter;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.NullIndex;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.State;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.backends.pluggable.SuffixContainer;
import org.opends.server.controls.PagedResultsControl;
import org.opends.server.controls.ServerSideSortRequestControl;
import org.opends.server.controls.ServerSideSortResponseControl;
import org.opends.server.controls.SubtreeDeleteControl;
import org.opends.server.controls.VLVRequestControl;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Attributes;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.RDN;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SortKey;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.types.operation.SubordinateModifyDNOperation;
import org.opends.server.util.StaticUtils;

public class EntryContainer
implements SuffixContainer,
ConfigurationChangeListener<LocalDBBackendCfg> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String ID2ENTRY_DATABASE_NAME = "id2entry";
    public static final String DN2ID_DATABASE_NAME = "dn2id";
    private static final String ID2CHILDREN_DATABASE_NAME = "id2children";
    private static final String ID2SUBTREE_DATABASE_NAME = "id2subtree";
    private static final String REFERRAL_DATABASE_NAME = "referral";
    private static final String STATE_DATABASE_NAME = "state";
    private final AttributeJEIndexCfgManager attributeJEIndexCfgManager;
    private final VLVJEIndexCfgManager vlvJEIndexCfgManager;
    private final String backendID;
    private final RootContainer rootContainer;
    private final DN baseDN;
    private LocalDBBackendCfg config;
    private final Environment env;
    private DN2ID dn2id;
    private ID2Entry id2entry;
    private Index id2children;
    private Index id2subtree;
    private DN2URI dn2uri;
    private State state;
    private final HashMap<AttributeType, AttributeIndex> attrIndexMap = new HashMap();
    private final HashMap<String, VLVIndex> vlvIndexMap = new HashMap();
    private String databasePrefix;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final Lock sharedLock = this.lock.readLock();
    final Lock exclusiveLock = this.lock.writeLock();

    EntryContainer(DN baseDN, String databasePrefix, String backendID, LocalDBBackendCfg config, Environment env, RootContainer rootContainer) throws ConfigException {
        this.backendID = backendID;
        this.baseDN = baseDN;
        this.config = config;
        this.env = env;
        this.rootContainer = rootContainer;
        this.databasePrefix = this.preparePrefix(databasePrefix);
        config.addLocalDBChangeListener((ConfigurationChangeListener)this);
        this.attributeJEIndexCfgManager = new AttributeJEIndexCfgManager();
        config.addLocalDBIndexAddListener((ConfigurationAddListener)this.attributeJEIndexCfgManager);
        config.addLocalDBIndexDeleteListener((ConfigurationDeleteListener)this.attributeJEIndexCfgManager);
        this.vlvJEIndexCfgManager = new VLVJEIndexCfgManager();
        config.addLocalDBVLVIndexAddListener((ConfigurationAddListener)this.vlvJEIndexCfgManager);
        config.addLocalDBVLVIndexDeleteListener((ConfigurationDeleteListener)this.vlvJEIndexCfgManager);
    }

    void open() throws DatabaseException, ConfigException {
        try {
            DataConfig entryDataConfig = new DataConfig(this.config.isEntriesCompressed(), this.config.isCompactEncoding(), this.rootContainer.getCompressedSchema());
            this.id2entry = new ID2Entry(this.databasePrefix + "_" + ID2ENTRY_DATABASE_NAME, entryDataConfig, this.env, this);
            this.id2entry.open();
            this.dn2id = new DN2ID(this.databasePrefix + "_" + DN2ID_DATABASE_NAME, this.env, this);
            this.dn2id.open();
            this.state = new State(this.databasePrefix + "_" + STATE_DATABASE_NAME, this.env, this);
            this.state.open();
            if (this.config.isSubordinateIndexesEnabled()) {
                this.openSubordinateIndexes();
            } else {
                this.id2children = new NullIndex(this.databasePrefix + "_" + ID2CHILDREN_DATABASE_NAME, new ID2CIndexer(), this.state, this.env, this);
                if (!this.env.getConfig().getReadOnly()) {
                    this.state.putIndexTrustState(null, this.id2children, false);
                }
                this.id2children.open();
                this.id2subtree = new NullIndex(this.databasePrefix + "_" + ID2SUBTREE_DATABASE_NAME, new ID2SIndexer(), this.state, this.env, this);
                if (!this.env.getConfig().getReadOnly()) {
                    this.state.putIndexTrustState(null, this.id2subtree, false);
                }
                this.id2subtree.open();
                logger.info(BackendMessages.NOTE_JEB_SUBORDINATE_INDEXES_DISABLED, (Object)this.backendID);
            }
            this.dn2uri = new DN2URI(this.databasePrefix + "_" + REFERRAL_DATABASE_NAME, this.env, this);
            this.dn2uri.open();
            for (String idx : this.config.listLocalDBIndexes()) {
                LocalDBIndexCfg indexCfg = this.config.getLocalDBIndex(idx);
                AttributeIndex index = new AttributeIndex(indexCfg, this);
                index.open();
                if (!index.isTrusted()) {
                    logger.info(BackendMessages.NOTE_INDEX_ADD_REQUIRES_REBUILD, (Object)index.getName());
                }
                this.attrIndexMap.put(indexCfg.getAttribute(), index);
            }
            for (String idx : this.config.listLocalDBVLVIndexes()) {
                LocalDBVLVIndexCfg vlvIndexCfg = this.config.getLocalDBVLVIndex(idx);
                VLVIndex vlvIndex = new VLVIndex(vlvIndexCfg, this.state, this.env, this);
                vlvIndex.open();
                if (!vlvIndex.isTrusted()) {
                    logger.info(BackendMessages.NOTE_INDEX_ADD_REQUIRES_REBUILD, (Object)vlvIndex.getName());
                }
                this.vlvIndexMap.put(vlvIndexCfg.getName().toLowerCase(), vlvIndex);
            }
        }
        catch (DatabaseException de) {
            logger.traceException((Throwable)de);
            this.close();
            throw de;
        }
    }

    public void close() throws DatabaseException {
        this.dn2id.close();
        this.id2entry.close();
        this.dn2uri.close();
        this.id2children.close();
        this.id2subtree.close();
        this.state.close();
        Utils.closeSilently(this.attrIndexMap.values());
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.close();
        }
        this.config.removeLocalDBChangeListener((ConfigurationChangeListener)this);
        this.config.removeLocalDBIndexAddListener((ConfigurationAddListener)this.attributeJEIndexCfgManager);
        this.config.removeLocalDBIndexDeleteListener((ConfigurationDeleteListener)this.attributeJEIndexCfgManager);
        this.config.removeLocalDBVLVIndexAddListener((ConfigurationAddListener)this.vlvJEIndexCfgManager);
        this.config.removeLocalDBVLVIndexDeleteListener((ConfigurationDeleteListener)this.vlvJEIndexCfgManager);
    }

    public RootContainer getRootContainer() {
        return this.rootContainer;
    }

    public DN2ID getDN2ID() {
        return this.dn2id;
    }

    public ID2Entry getID2Entry() {
        return this.id2entry;
    }

    public DN2URI getDN2URI() {
        return this.dn2uri;
    }

    public Index getID2Children() {
        return this.id2children;
    }

    public Index getID2Subtree() {
        return this.id2subtree;
    }

    public State getState() {
        return this.state;
    }

    AttributeIndex getAttributeIndex(AttributeType attrType) {
        return this.attrIndexMap.get(attrType);
    }

    VLVIndex getVLVIndex(String vlvIndexName) {
        return this.vlvIndexMap.get(vlvIndexName);
    }

    public Collection<AttributeIndex> getAttributeIndexes() {
        return this.attrIndexMap.values();
    }

    public Collection<VLVIndex> getVLVIndexes() {
        return this.vlvIndexMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryID getHighestEntryID() throws DatabaseException {
        try (Cursor cursor = this.id2entry.openCursor(null, null);){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            if (cursor.getLast(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                EntryID entryID = new EntryID(key);
                return entryID;
            }
            EntryID entryID = new EntryID(0L);
            return entryID;
        }
    }

    long getNumSubordinates(DN entryDN, boolean subtree) throws DatabaseException {
        EntryID entryID = this.dn2id.get(null, entryDN, LockMode.DEFAULT);
        if (entryID != null) {
            EntryIDSet entryIDSet;
            long count;
            DatabaseEntry key = new DatabaseEntry(JebFormat.entryIDToDatabase(entryID.longValue()));
            if (subtree) {
                count = this.dn2id.get(null, entryDN, LockMode.DEFAULT) != null ? 1L : 0L;
                entryIDSet = this.id2subtree.readKey(key, null, LockMode.DEFAULT);
            } else {
                count = 0L;
                entryIDSet = this.id2children.readKey(key, null, LockMode.DEFAULT);
            }
            if (entryIDSet.size() == Long.MAX_VALUE) {
                return -1L;
            }
            return count + entryIDSet.size();
        }
        return -1L;
    }

    void search(SearchOperation searchOperation) throws DirectoryException, DatabaseException, CanceledOperationException {
        boolean candidatesAreInScope;
        EntryIDSet entryIDList;
        StringBuilder debugBuffer;
        ServerSideSortRequestControl sortRequest;
        PagedResultsControl pageRequest;
        block37: {
            DN aBaseDN = searchOperation.getBaseDN();
            SearchScope searchScope = searchOperation.getScope();
            pageRequest = (PagedResultsControl)searchOperation.getRequestControl(PagedResultsControl.DECODER);
            sortRequest = (ServerSideSortRequestControl)searchOperation.getRequestControl(ServerSideSortRequestControl.DECODER);
            if (sortRequest != null && !sortRequest.containsSortKeys() && sortRequest.isCritical()) {
                searchOperation.addResponseControl((Control)new ServerSideSortResponseControl(16, null));
                searchOperation.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                return;
            }
            VLVRequestControl vlvRequest = (VLVRequestControl)searchOperation.getRequestControl(VLVRequestControl.DECODER);
            if (vlvRequest != null && pageRequest != null) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, BackendMessages.ERR_SEARCH_CANNOT_MIX_PAGEDRESULTS_AND_VLV.get());
            }
            if (pageRequest != null) {
                if (pageRequest.getSize() == 0) {
                    PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, null);
                    searchOperation.getResponseControls().add(control);
                    return;
                }
                if (searchOperation.getSizeLimit() > 0 && pageRequest.getSize() >= searchOperation.getSizeLimit()) {
                    pageRequest = null;
                }
            }
            if (searchScope == SearchScope.BASE_OBJECT) {
                Entry baseEntry = this.fetchBaseEntry(aBaseDN, searchScope);
                if (!EntryContainer.isManageDsaITOperation((Operation)searchOperation)) {
                    this.dn2uri.checkTargetForReferral(baseEntry, searchOperation.getScope());
                }
                if (searchOperation.getFilter().matchesEntry(baseEntry)) {
                    searchOperation.returnEntry(baseEntry, null);
                }
                if (pageRequest != null) {
                    PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, null);
                    searchOperation.getResponseControls().add(control);
                }
                return;
            }
            debugBuffer = null;
            if (searchOperation.getAttributes().contains("debugsearchindex")) {
                debugBuffer = new StringBuilder();
            }
            entryIDList = null;
            candidatesAreInScope = false;
            if (sortRequest != null) {
                for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
                    try {
                        entryIDList = vlvIndex.evaluate(null, searchOperation, sortRequest, vlvRequest, debugBuffer);
                        if (entryIDList == null) continue;
                        searchOperation.addResponseControl((Control)new ServerSideSortResponseControl(0, null));
                        candidatesAreInScope = true;
                        break;
                    }
                    catch (DirectoryException de) {
                        searchOperation.addResponseControl((Control)new ServerSideSortResponseControl(de.getResultCode().intValue(), null));
                        if (!sortRequest.isCritical()) continue;
                        throw de;
                    }
                }
            }
            if (entryIDList == null) {
                for (VirtualAttributeRule rule : DirectoryServer.getVirtualAttributes()) {
                    if (!rule.getProvider().isSearchable(rule, searchOperation, true)) continue;
                    rule.getProvider().processSearch(rule, searchOperation);
                    return;
                }
                IndexFilter indexFilter = new IndexFilter(this, searchOperation, debugBuffer, this.rootContainer.getMonitorProvider());
                entryIDList = indexFilter.evaluate();
                if (entryIDList.size() > 10L) {
                    EntryIDSet scopeList;
                    EntryID baseID = this.dn2id.get(null, aBaseDN, LockMode.DEFAULT);
                    if (baseID == null) {
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, BackendMessages.ERR_SEARCH_NO_SUCH_OBJECT.get((Object)aBaseDN), this.getMatchedDN(aBaseDN), null);
                    }
                    DatabaseEntry baseIDData = baseID.getDatabaseEntry();
                    if (searchScope == SearchScope.SINGLE_LEVEL) {
                        scopeList = this.id2children.readKey(baseIDData, null, LockMode.DEFAULT);
                    } else {
                        scopeList = this.id2subtree.readKey(baseIDData, null, LockMode.DEFAULT);
                        if (searchScope == SearchScope.WHOLE_SUBTREE) {
                            scopeList.add(baseID);
                        }
                    }
                    entryIDList.retainAll(scopeList);
                    if (debugBuffer != null) {
                        debugBuffer.append(" scope=");
                        debugBuffer.append(searchScope);
                        scopeList.toString(debugBuffer);
                    }
                    if (scopeList.isDefined()) {
                        candidatesAreInScope = true;
                    }
                }
                if (sortRequest != null) {
                    try {
                        entryIDList = EntryIDSetSorter.sort(this, entryIDList, searchOperation, sortRequest.getSortOrder(), vlvRequest);
                        if (sortRequest.containsSortKeys()) {
                            searchOperation.addResponseControl((Control)new ServerSideSortResponseControl(0, null));
                        } else {
                            searchOperation.addResponseControl((Control)new ServerSideSortResponseControl(16, null));
                        }
                    }
                    catch (DirectoryException de) {
                        searchOperation.addResponseControl((Control)new ServerSideSortResponseControl(de.getResultCode().intValue(), null));
                        if (!sortRequest.isCritical()) break block37;
                        throw de;
                    }
                }
            }
        }
        if (debugBuffer != null) {
            debugBuffer.append(" final=");
            entryIDList.toString(debugBuffer);
            Attribute attr = Attributes.create((String)"debugsearchindex", (String)debugBuffer.toString());
            Entry debugEntry = new Entry(DN.valueOf((String)"cn=debugsearch"), null, null, null);
            debugEntry.addAttribute(attr, new ArrayList());
            searchOperation.returnEntry(debugEntry, null);
            return;
        }
        if (entryIDList.isDefined()) {
            if (this.rootContainer.getMonitorProvider().isFilterUseEnabled()) {
                this.rootContainer.getMonitorProvider().updateIndexedSearchCount();
            }
            this.searchIndexed(entryIDList, candidatesAreInScope, searchOperation, pageRequest);
        } else {
            if (this.rootContainer.getMonitorProvider().isFilterUseEnabled()) {
                this.rootContainer.getMonitorProvider().updateUnindexedSearchCount();
            }
            searchOperation.addAdditionalLogItem(AdditionalLogItem.keyOnly(this.getClass(), (String)"unindexed"));
            for (VirtualAttributeRule rule : DirectoryServer.getVirtualAttributes()) {
                if (!rule.getProvider().isSearchable(rule, searchOperation, false)) continue;
                rule.getProvider().processSearch(rule, searchOperation);
                return;
            }
            ClientConnection clientConnection = searchOperation.getClientConnection();
            if (!clientConnection.hasPrivilege(Privilege.UNINDEXED_SEARCH, (Operation)searchOperation)) {
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, BackendMessages.ERR_SEARCH_UNINDEXED_INSUFFICIENT_PRIVILEGES.get());
            }
            if (sortRequest != null) {
                searchOperation.addResponseControl((Control)new ServerSideSortResponseControl(53, null));
                if (sortRequest.isCritical()) {
                    throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, BackendMessages.ERR_SEARCH_CANNOT_SORT_UNINDEXED.get());
                }
            }
            this.searchNotIndexed(searchOperation, pageRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchNotIndexed(SearchOperation searchOperation, PagedResultsControl pageRequest) throws DirectoryException, CanceledOperationException {
        byte[] begin;
        DN aBaseDN = searchOperation.getBaseDN();
        SearchScope searchScope = searchOperation.getScope();
        boolean manageDsaIT = EntryContainer.isManageDsaITOperation((Operation)searchOperation);
        if (pageRequest == null || pageRequest.getCookie().length() == 0) {
            Entry baseEntry = this.fetchBaseEntry(aBaseDN, searchScope);
            if (!manageDsaIT) {
                this.dn2uri.checkTargetForReferral(baseEntry, searchScope);
            }
            if (searchScope == SearchScope.WHOLE_SUBTREE && searchOperation.getFilter().matchesEntry(baseEntry)) {
                searchOperation.returnEntry(baseEntry, null);
            }
            if (!manageDsaIT && !this.dn2uri.returnSearchReferences(searchOperation) && pageRequest != null) {
                PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, null);
                searchOperation.getResponseControls().add(control);
            }
        }
        byte[] baseDNKey = JebFormat.dnToDNKey(aBaseDN, this.baseDN.size());
        boolean special = false;
        byte[] suffix = Arrays.copyOf(baseDNKey, baseDNKey.length + 1);
        suffix[suffix.length - 1] = 0;
        byte[] end = Arrays.copyOf(suffix, suffix.length);
        end[end.length - 1] = 1;
        if (pageRequest != null && pageRequest.getCookie().length() != 0) {
            try {
                begin = pageRequest.getCookie().toByteArray();
            }
            catch (Exception e) {
                logger.traceException((Throwable)e);
                LocalizableMessage msg = BackendMessages.ERR_INVALID_PAGED_RESULTS_COOKIE.get((Object)pageRequest.getCookie().toHexString());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg, (Throwable)e);
            }
        } else {
            begin = suffix;
        }
        DatabaseEntry data = new DatabaseEntry();
        DatabaseEntry key = new DatabaseEntry(begin);
        int lookthroughCount = 0;
        int lookthroughLimit = searchOperation.getClientConnection().getLookthroughLimit();
        try (Cursor cursor = this.dn2id.openCursor(null, null);){
            OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                Entry entry;
                boolean isInScope;
                if (lookthroughLimit > 0 && lookthroughCount > lookthroughLimit) {
                    searchOperation.setResultCode(ResultCode.ADMIN_LIMIT_EXCEEDED);
                    searchOperation.appendErrorMessage(BackendMessages.NOTE_LOOKTHROUGH_LIMIT_EXCEEDED.get((Object)lookthroughLimit));
                    return;
                }
                int cmp = this.dn2id.getComparator().compare(key.getData(), end);
                if (cmp >= 0) {
                    break;
                }
                EntryID entryID = new EntryID(data);
                boolean bl = isInScope = searchScope != SearchScope.SINGLE_LEVEL || JebFormat.findDNKeyParent(key.getData()) == baseDNKey.length;
                if (isInScope && (entry = this.getEntry(entryID)) != null) {
                    ++lookthroughCount;
                    if ((manageDsaIT || entry.getReferralURLs() == null) && searchOperation.getFilter().matchesEntry(entry)) {
                        if (pageRequest != null && searchOperation.getEntriesSent() == pageRequest.getSize()) {
                            ByteString cookie = ByteString.wrap((byte[])key.getData());
                            PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, cookie);
                            searchOperation.getResponseControls().add(control);
                            return;
                        }
                        if (!searchOperation.returnEntry(entry, null)) {
                            return;
                        }
                    }
                }
                searchOperation.checkIfCanceled(false);
                status = cursor.getNext(key, data, LockMode.DEFAULT);
            }
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
        }
        if (pageRequest != null) {
            PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, null);
            searchOperation.getResponseControls().add(control);
        }
    }

    Entry getEntry(EntryID entryID) throws DirectoryException {
        EntryCache entryCache = DirectoryServer.getEntryCache();
        Entry cacheEntry = entryCache.getEntry(this.backendID, entryID.longValue());
        if (cacheEntry != null) {
            return cacheEntry;
        }
        Entry entry = this.id2entry.get(null, entryID, LockMode.DEFAULT);
        if (entry != null) {
            entryCache.putEntryIfAbsent(entry, this.backendID, entryID.longValue());
        }
        return entry;
    }

    private void searchIndexed(EntryIDSet entryIDList, boolean candidatesAreInScope, SearchOperation searchOperation, PagedResultsControl pageRequest) throws DirectoryException, CanceledOperationException {
        SearchScope searchScope = searchOperation.getScope();
        DN aBaseDN = searchOperation.getBaseDN();
        boolean manageDsaIT = EntryContainer.isManageDsaITOperation((Operation)searchOperation);
        boolean continueSearch = true;
        EntryID begin = null;
        if (pageRequest != null && pageRequest.getCookie().length() != 0) {
            try {
                begin = new EntryID(pageRequest.getCookie().toLong());
            }
            catch (Exception e) {
                logger.traceException((Throwable)e);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, BackendMessages.ERR_INVALID_PAGED_RESULTS_COOKIE.get((Object)pageRequest.getCookie().toHexString()), (Throwable)e);
            }
        } else if (!manageDsaIT) {
            continueSearch = this.dn2uri.returnSearchReferences(searchOperation);
        }
        int lookthroughLimit = searchOperation.getClientConnection().getLookthroughLimit();
        if (lookthroughLimit > 0 && entryIDList.size() > (long)lookthroughLimit) {
            searchOperation.setResultCode(ResultCode.ADMIN_LIMIT_EXCEEDED);
            searchOperation.appendErrorMessage(BackendMessages.NOTE_LOOKTHROUGH_LIMIT_EXCEEDED.get((Object)lookthroughLimit));
            continueSearch = false;
        }
        if (continueSearch) {
            Iterator<EntryID> it = entryIDList.iterator(begin);
            while (it.hasNext()) {
                Entry entry;
                EntryID id = it.next();
                try {
                    entry = this.getEntry(id);
                }
                catch (Exception e) {
                    logger.traceException((Throwable)e);
                    continue;
                }
                if (entry == null || !this.isInScope(candidatesAreInScope, searchScope, aBaseDN, entry) || !manageDsaIT && entry.getReferralURLs() != null || !searchOperation.getFilter().matchesEntry(entry)) continue;
                if (pageRequest != null && searchOperation.getEntriesSent() == pageRequest.getSize()) {
                    byte[] cookieBytes = id.getDatabaseEntry().getData();
                    ByteString cookie = ByteString.wrap((byte[])cookieBytes);
                    PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, cookie);
                    searchOperation.getResponseControls().add(control);
                    return;
                }
                if (searchOperation.returnEntry(entry, null)) continue;
                break;
            }
            searchOperation.checkIfCanceled(false);
        }
        if (searchOperation.getEntriesSent() == 0 && searchOperation.getReferencesSent() == 0) {
            Entry baseEntry = this.fetchBaseEntry(aBaseDN, searchScope);
            if (!manageDsaIT) {
                this.dn2uri.checkTargetForReferral(baseEntry, searchScope);
            }
        }
        if (pageRequest != null) {
            PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, null);
            searchOperation.getResponseControls().add(control);
        }
    }

    private boolean isInScope(boolean candidatesAreInScope, SearchScope searchScope, DN aBaseDN, Entry entry) {
        DN entryDN = entry.getName();
        if (candidatesAreInScope) {
            return true;
        }
        return searchScope == SearchScope.SINGLE_LEVEL ? entryDN.size() == aBaseDN.size() + 1 && entryDN.isDescendantOf(aBaseDN) : (searchScope == SearchScope.WHOLE_SUBTREE ? entryDN.isDescendantOf(aBaseDN) : searchScope == SearchScope.SUBORDINATES && entryDN.size() > aBaseDN.size() && entryDN.isDescendantOf(aBaseDN));
    }

    void addEntry(Entry entry, AddOperation addOperation) throws DatabaseException, DirectoryException, CanceledOperationException {
        Transaction txn = this.beginTransaction();
        DN parentDN = this.getParentWithinBase(entry.getName());
        try {
            if (this.dn2id.get(txn, entry.getName(), LockMode.DEFAULT) != null) {
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, BackendMessages.ERR_ADD_ENTRY_ALREADY_EXISTS.get((Object)entry.getName()));
            }
            EntryID parentID = null;
            if (parentDN != null) {
                this.dn2uri.targetEntryReferrals(entry.getName(), null);
                parentID = this.dn2id.get(txn, parentDN, LockMode.DEFAULT);
                if (parentID == null) {
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, BackendMessages.ERR_ADD_NO_SUCH_OBJECT.get((Object)entry.getName()), this.getMatchedDN(this.baseDN), null);
                }
            }
            EntryID entryID = this.rootContainer.getNextEntryID();
            if (!this.dn2id.insert(txn, entry.getName(), entryID)) {
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, BackendMessages.ERR_ADD_ENTRY_ALREADY_EXISTS.get((Object)entry.getName()));
            }
            if (!this.dn2uri.addEntry(txn, entry)) {
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, BackendMessages.ERR_ADD_ENTRY_ALREADY_EXISTS.get((Object)entry.getName()));
            }
            if (!this.id2entry.insert(txn, entryID, entry)) {
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, BackendMessages.ERR_ADD_ENTRY_ALREADY_EXISTS.get((Object)entry.getName()));
            }
            IndexBuffer indexBuffer = new IndexBuffer(this);
            this.indexInsertEntry(indexBuffer, entry, entryID);
            if (parentDN != null) {
                ByteString parentIDKeyBytes = this.toByteString(parentID);
                this.id2children.insertID(indexBuffer, parentIDKeyBytes, entryID);
                this.id2subtree.insertID(indexBuffer, parentIDKeyBytes, entryID);
                DN dn = this.getParentWithinBase(parentDN);
                while (dn != null) {
                    EntryID nodeID = this.dn2id.get(txn, dn, LockMode.DEFAULT);
                    if (nodeID == null) {
                        throw new JebException(BackendMessages.ERR_MISSING_DN2ID_RECORD.get((Object)dn));
                    }
                    this.id2subtree.insertID(indexBuffer, this.toByteString(nodeID), entryID);
                    dn = this.getParentWithinBase(dn);
                }
            }
            indexBuffer.flush(txn);
            if (addOperation != null) {
                addOperation.checkIfCanceled(true);
            }
            EntryContainer.transactionCommit(txn);
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.putEntry(entry, this.backendID, entryID.longValue());
            }
        }
        catch (DatabaseException | CanceledOperationException | DirectoryException e) {
            EntryContainer.transactionAbort(txn);
            throw e;
        }
        catch (Exception e) {
            EntryContainer.transactionAbort(txn);
            String msg = e.getMessage();
            if (msg == null) {
                msg = StaticUtils.stackTraceToSingleLineString((Throwable)e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), BackendMessages.ERR_UNCHECKED_EXCEPTION.get((Object)msg), (Throwable)e);
        }
    }

    private ByteString toByteString(EntryID entryID) {
        return ByteString.wrap((byte[])entryID.getDatabaseEntry().getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException, DatabaseException, CanceledOperationException {
        Transaction txn = this.beginTransaction();
        IndexBuffer indexBuffer = new IndexBuffer(this);
        try {
            this.dn2uri.targetEntryReferrals(entryDN, null);
            boolean isSubtreeDelete = deleteOperation != null && deleteOperation.getRequestControl(SubtreeDeleteControl.DECODER) != null;
            byte[] entryDNKey = JebFormat.dnToDNKey(entryDN, this.baseDN.size());
            byte special = 0;
            byte[] suffix = Arrays.copyOf(entryDNKey, entryDNKey.length + 1);
            suffix[suffix.length - 1] = special;
            byte[] end = Arrays.copyOf(suffix, suffix.length);
            end[end.length - 1] = (byte)(special + 1);
            int subordinateEntriesDeleted = 0;
            DatabaseEntry data = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry(suffix);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadCommitted(true);
            try (Cursor cursor = this.dn2id.openCursor(txn, cursorConfig);){
                OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                while (status == OperationStatus.SUCCESS && this.dn2id.getComparator().compare(key.getData(), suffix) <= 0) {
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                }
                while (status == OperationStatus.SUCCESS) {
                    int cmp = this.dn2id.getComparator().compare(key.getData(), end);
                    if (cmp >= 0) {
                        break;
                    }
                    if (!isSubtreeDelete) {
                        throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, BackendMessages.ERR_DELETE_NOT_ALLOWED_ON_NONLEAF.get((Object)entryDN));
                    }
                    EntryID entryID = new EntryID(data);
                    if (deleteOperation != null && !deleteOperation.isSynchronizationOperation()) {
                        Entry subordinateEntry = this.id2entry.get(txn, entryID, LockMode.DEFAULT);
                        PluginResult.SubordinateDelete pluginResult = DirectoryServer.getPluginConfigManager().invokeSubordinateDeletePlugins(deleteOperation, subordinateEntry);
                        if (!pluginResult.continueProcessing()) {
                            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), BackendMessages.ERR_DELETE_ABORTED_BY_SUBORDINATE_PLUGIN.get((Object)subordinateEntry.getName()));
                        }
                    }
                    this.deleteEntry(txn, indexBuffer, true, entryDN, key, entryID);
                    ++subordinateEntriesDeleted;
                    if (deleteOperation != null) {
                        deleteOperation.checkIfCanceled(false);
                    }
                    data = new DatabaseEntry();
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                }
            }
            this.deleteEntry(txn, indexBuffer, isSubtreeDelete || EntryContainer.isManageDsaITOperation((Operation)deleteOperation), entryDN, null, null);
            indexBuffer.flush(txn);
            if (deleteOperation != null) {
                deleteOperation.checkIfCanceled(true);
            }
            EntryContainer.transactionCommit(txn);
            if (isSubtreeDelete) {
                deleteOperation.addAdditionalLogItem(AdditionalLogItem.unquotedKeyValue(this.getClass(), (String)"deletedEntries", (Object)(subordinateEntriesDeleted + 1)));
            }
        }
        catch (DatabaseException | CanceledOperationException | DirectoryException e) {
            EntryContainer.transactionAbort(txn);
            throw e;
        }
        catch (Exception e) {
            EntryContainer.transactionAbort(txn);
            String msg = e.getMessage();
            if (msg == null) {
                msg = StaticUtils.stackTraceToSingleLineString((Throwable)e);
            }
            LocalizableMessage message = BackendMessages.ERR_UNCHECKED_EXCEPTION.get((Object)msg);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, (Throwable)e);
        }
    }

    private void deleteEntry(Transaction txn, IndexBuffer indexBuffer, boolean manageDsaIT, DN targetDN, DatabaseEntry leafDNKey, EntryID leafID) throws DatabaseException, DirectoryException, JebException {
        if (leafID == null || leafDNKey == null) {
            DatabaseEntry value;
            OperationStatus status;
            if (leafDNKey == null) {
                leafDNKey = new DatabaseEntry(JebFormat.dnToDNKey(targetDN, this.baseDN.size()));
            }
            if ((status = this.dn2id.read(txn, leafDNKey, value = new DatabaseEntry(), LockMode.RMW)) != OperationStatus.SUCCESS) {
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, BackendMessages.ERR_DELETE_NO_SUCH_OBJECT.get((Object)leafDNKey), this.getMatchedDN(this.baseDN), null);
            }
            leafID = new EntryID(value);
        }
        if (this.dn2id.delete(txn, leafDNKey) != OperationStatus.SUCCESS) {
            LocalizableMessage message = BackendMessages.ERR_DELETE_NO_SUCH_OBJECT.get((Object)leafDNKey);
            DN matchedDN = this.getMatchedDN(this.baseDN);
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
        }
        Entry entry = this.id2entry.get(txn, leafID, LockMode.RMW);
        if (entry == null) {
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), BackendMessages.ERR_MISSING_ID2ENTRY_RECORD.get((Object)leafID));
        }
        if (!manageDsaIT) {
            this.dn2uri.checkTargetForReferral(entry, null);
        }
        this.dn2uri.deleteEntry(txn, entry);
        if (!this.id2entry.remove(txn, leafID)) {
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), BackendMessages.ERR_MISSING_ID2ENTRY_RECORD.get((Object)leafID));
        }
        this.indexRemoveEntry(indexBuffer, entry, leafID);
        ByteString leafIDKeyBytes = ByteString.valueOf((long)leafID.longValue());
        this.id2children.delete(indexBuffer, leafIDKeyBytes);
        this.id2subtree.delete(indexBuffer, leafIDKeyBytes);
        boolean isParent = true;
        DN parentDN = this.getParentWithinBase(targetDN);
        while (parentDN != null) {
            EntryID parentID = this.dn2id.get(txn, parentDN, LockMode.DEFAULT);
            if (parentID == null) {
                throw new JebException(BackendMessages.ERR_MISSING_DN2ID_RECORD.get((Object)parentDN));
            }
            ByteString parentIDBytes = ByteString.valueOf((long)parentID.longValue());
            if (isParent) {
                this.id2children.removeID(indexBuffer, parentIDBytes, leafID);
                isParent = false;
            }
            this.id2subtree.removeID(indexBuffer, parentIDBytes, leafID);
            parentDN = this.getParentWithinBase(parentDN);
        }
        EntryCache entryCache = DirectoryServer.getEntryCache();
        if (entryCache != null) {
            entryCache.removeEntry(entry.getName());
        }
    }

    boolean entryExists(DN entryDN) throws DirectoryException {
        EntryCache entryCache = DirectoryServer.getEntryCache();
        if (entryCache != null && entryCache.containsEntry(entryDN)) {
            return true;
        }
        try {
            return this.dn2id.get(null, entryDN, LockMode.DEFAULT) != null;
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            return false;
        }
    }

    Entry getEntry(DN entryDN) throws DatabaseException, DirectoryException {
        Entry entry;
        EntryCache entryCache = DirectoryServer.getEntryCache();
        if (entryCache != null && (entry = entryCache.getEntry(entryDN)) != null) {
            return entry;
        }
        EntryID entryID = this.dn2id.get(null, entryDN, LockMode.DEFAULT);
        if (entryID == null) {
            this.dn2uri.targetEntryReferrals(entryDN, null);
            return null;
        }
        Entry entry2 = this.id2entry.get(null, entryID, LockMode.DEFAULT);
        if (entry2 != null && entryCache != null) {
            entryCache.putEntryIfAbsent(entry2, this.backendID, entryID.longValue());
        }
        return entry2;
    }

    void replaceEntry(Entry oldEntry, Entry newEntry, ModifyOperation modifyOperation) throws DatabaseException, DirectoryException, CanceledOperationException {
        Transaction txn = this.beginTransaction();
        try {
            EntryID entryID = this.dn2id.get(txn, newEntry.getName(), LockMode.RMW);
            if (entryID == null) {
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, BackendMessages.ERR_MODIFY_NO_SUCH_OBJECT.get((Object)newEntry.getName()), this.getMatchedDN(this.baseDN), null);
            }
            if (!EntryContainer.isManageDsaITOperation((Operation)modifyOperation)) {
                this.dn2uri.checkTargetForReferral(oldEntry, null);
            }
            if (modifyOperation != null) {
                List mods = modifyOperation.getModifications();
                this.dn2uri.modifyEntry(txn, oldEntry, newEntry, mods);
            } else {
                this.dn2uri.replaceEntry(txn, oldEntry, newEntry);
            }
            this.id2entry.put(txn, entryID, newEntry);
            IndexBuffer indexBuffer = new IndexBuffer(this);
            if (modifyOperation != null) {
                List mods = modifyOperation.getModifications();
                this.indexModifications(indexBuffer, oldEntry, newEntry, entryID, mods);
            } else {
                this.indexRemoveEntry(indexBuffer, oldEntry, entryID);
                this.indexInsertEntry(indexBuffer, newEntry, entryID);
            }
            indexBuffer.flush(txn);
            if (modifyOperation != null) {
                modifyOperation.checkIfCanceled(true);
            }
            EntryContainer.transactionCommit(txn);
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.putEntry(newEntry, this.backendID, entryID.longValue());
            }
        }
        catch (DatabaseException | CanceledOperationException | DirectoryException e) {
            EntryContainer.transactionAbort(txn);
            throw e;
        }
        catch (Exception e) {
            EntryContainer.transactionAbort(txn);
            String msg = e.getMessage();
            if (msg == null) {
                msg = StaticUtils.stackTraceToSingleLineString((Throwable)e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), BackendMessages.ERR_UNCHECKED_EXCEPTION.get((Object)msg), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DatabaseException, DirectoryException, CanceledOperationException {
        Transaction txn = this.beginTransaction();
        DN oldSuperiorDN = this.getParentWithinBase(currentDN);
        DN newSuperiorDN = this.getParentWithinBase(entry.getName());
        boolean isApexEntryMoved = oldSuperiorDN != null ? !oldSuperiorDN.equals((Object)newSuperiorDN) : (newSuperiorDN != null ? !newSuperiorDN.equals((Object)oldSuperiorDN) : false);
        IndexBuffer buffer = new IndexBuffer(this);
        try {
            MovedEntry head;
            if (!currentDN.equals((Object)entry.getName()) && this.dn2id.get(txn, entry.getName(), LockMode.DEFAULT) != null) {
                LocalizableMessage message = BackendMessages.ERR_MODIFYDN_ALREADY_EXISTS.get((Object)entry.getName());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
            }
            EntryID oldApexID = this.dn2id.get(txn, currentDN, LockMode.DEFAULT);
            if (oldApexID == null) {
                this.dn2uri.targetEntryReferrals(currentDN, null);
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, BackendMessages.ERR_MODIFYDN_NO_SUCH_OBJECT.get((Object)currentDN), this.getMatchedDN(this.baseDN), null);
            }
            Entry oldApexEntry = this.id2entry.get(txn, oldApexID, LockMode.DEFAULT);
            if (oldApexEntry == null) {
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), BackendMessages.ERR_MISSING_ID2ENTRY_RECORD.get((Object)oldApexID));
            }
            if (!EntryContainer.isManageDsaITOperation((Operation)modifyDNOperation)) {
                this.dn2uri.checkTargetForReferral(oldApexEntry, null);
            }
            EntryID newApexID = oldApexID;
            if (newSuperiorDN != null && isApexEntryMoved) {
                EntryID newSuperiorID = this.dn2id.get(txn, newSuperiorDN, LockMode.DEFAULT);
                if (newSuperiorID == null) {
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, BackendMessages.ERR_NEW_SUPERIOR_NO_SUCH_OBJECT.get((Object)newSuperiorDN), this.getMatchedDN(this.baseDN), null);
                }
                if (newSuperiorID.compareTo(oldApexID) > 0) {
                    newApexID = this.rootContainer.getNextEntryID();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Move of target entry requires renumberingall entries in the subtree. Old DN: %s New DN: %s Old entry ID: %d New entry ID: %d New Superior ID: %d" + oldApexEntry.getName(), new Object[]{entry.getName(), oldApexID.longValue(), newApexID.longValue(), newSuperiorID.longValue()});
                    }
                }
            }
            MovedEntry current = head = new MovedEntry(null, null, false);
            this.removeApexEntry(txn, buffer, oldSuperiorDN, oldApexID, newApexID, oldApexEntry, entry, isApexEntryMoved, modifyDNOperation, current);
            current = current.next;
            byte[] currentDNKey = JebFormat.dnToDNKey(currentDN, this.baseDN.size());
            byte special = 0;
            byte[] suffix = Arrays.copyOf(currentDNKey, currentDNKey.length + 1);
            suffix[suffix.length - 1] = special;
            byte[] end = Arrays.copyOf(suffix, suffix.length);
            end[end.length - 1] = (byte)(special + 1);
            DatabaseEntry data = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry(suffix);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadCommitted(true);
            try (Cursor cursor = this.dn2id.openCursor(txn, cursorConfig);){
                OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                while (status == OperationStatus.SUCCESS && this.dn2id.getComparator().compare(key.getData(), suffix) <= 0) {
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                }
                while (status == OperationStatus.SUCCESS) {
                    int cmp = this.dn2id.getComparator().compare(key.getData(), end);
                    if (cmp >= 0) {
                        break;
                    }
                    EntryID oldID = new EntryID(data);
                    Entry oldEntry = this.id2entry.get(txn, oldID, LockMode.DEFAULT);
                    DN newDN = EntryContainer.modDN(oldEntry.getName(), currentDN.size(), entry.getName());
                    EntryID newID = oldID;
                    if (!newApexID.equals(oldApexID)) {
                        newID = this.rootContainer.getNextEntryID();
                        if (logger.isTraceEnabled()) {
                            logger.trace("Move of subordinate entry requires renumbering. Old DN: %s New DN: %s Old entry ID: %d New entry ID: %d", new Object[]{oldEntry.getName(), newDN, oldID.longValue(), newID.longValue()});
                        }
                    }
                    this.removeSubordinateEntry(txn, buffer, oldSuperiorDN, oldID, newID, oldEntry, newDN, isApexEntryMoved, modifyDNOperation, current);
                    current = current.next;
                    if (modifyDNOperation != null) {
                        modifyDNOperation.checkIfCanceled(false);
                    }
                    data = new DatabaseEntry();
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                }
            }
            current = head.next;
            head = null;
            while (current != null) {
                this.addRenamedEntry(txn, buffer, current.entryID, current.entry, isApexEntryMoved, current.renumbered, modifyDNOperation);
                current = current.next;
            }
            buffer.flush(txn);
            if (modifyDNOperation != null) {
                modifyDNOperation.checkIfCanceled(true);
            }
            EntryContainer.transactionCommit(txn);
        }
        catch (DatabaseException | CanceledOperationException | DirectoryException e) {
            EntryContainer.transactionAbort(txn);
            throw e;
        }
        catch (Exception e) {
            EntryContainer.transactionAbort(txn);
            String msg = e.getMessage();
            if (msg == null) {
                msg = StaticUtils.stackTraceToSingleLineString((Throwable)e);
            }
            LocalizableMessage message = BackendMessages.ERR_UNCHECKED_EXCEPTION.get((Object)msg);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, (Throwable)e);
        }
    }

    private void addRenamedEntry(Transaction txn, IndexBuffer buffer, EntryID newID, Entry newEntry, boolean isApexEntryMoved, boolean renumbered, ModifyDNOperation modifyDNOperation) throws DirectoryException, DatabaseException {
        if (!this.dn2id.insert(txn, newEntry.getName(), newID)) {
            throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, BackendMessages.ERR_MODIFYDN_ALREADY_EXISTS.get((Object)newEntry.getName()));
        }
        this.id2entry.put(txn, newID, newEntry);
        this.dn2uri.addEntry(txn, newEntry);
        if (renumbered || modifyDNOperation == null) {
            this.indexInsertEntry(buffer, newEntry, newID);
        }
        if (isApexEntryMoved) {
            boolean isParent = true;
            DN dn = this.getParentWithinBase(newEntry.getName());
            while (dn != null) {
                EntryID parentID = this.dn2id.get(txn, dn, LockMode.DEFAULT);
                ByteString parentIDKeyBytes = ByteString.valueOf((long)parentID.longValue());
                if (isParent) {
                    this.id2children.insertID(buffer, parentIDKeyBytes, newID);
                    isParent = false;
                }
                this.id2subtree.insertID(buffer, parentIDKeyBytes, newID);
                dn = this.getParentWithinBase(dn);
            }
        }
    }

    private void removeApexEntry(Transaction txn, IndexBuffer buffer, DN oldSuperiorDN, EntryID oldID, EntryID newID, Entry oldEntry, Entry newEntry, boolean isApexEntryMoved, ModifyDNOperation modifyDNOperation, MovedEntry tail) throws DirectoryException, DatabaseException {
        DN oldDN = oldEntry.getName();
        this.dn2id.remove(txn, oldDN);
        if (!newID.equals(oldID)) {
            this.id2entry.remove(txn, oldID);
        }
        this.dn2uri.deleteEntry(txn, oldEntry);
        tail.next = new MovedEntry(newID, newEntry, !newID.equals(oldID));
        if (oldSuperiorDN != null && isApexEntryMoved) {
            boolean isParent = true;
            DN dn = oldSuperiorDN;
            while (dn != null) {
                EntryID parentID = this.dn2id.get(txn, dn, LockMode.DEFAULT);
                ByteString parentIDKeyBytes = ByteString.valueOf((long)parentID.longValue());
                if (isParent) {
                    this.id2children.removeID(buffer, parentIDKeyBytes, oldID);
                    isParent = false;
                }
                this.id2subtree.removeID(buffer, parentIDKeyBytes, oldID);
                dn = this.getParentWithinBase(dn);
            }
        }
        if (!newID.equals(oldID) || modifyDNOperation == null) {
            ByteString oldIDKeyBytes = ByteString.valueOf((long)oldID.longValue());
            this.id2children.delete(buffer, oldIDKeyBytes);
            this.id2subtree.delete(buffer, oldIDKeyBytes);
            this.indexRemoveEntry(buffer, oldEntry, oldID);
        } else {
            this.indexModifications(buffer, oldEntry, newEntry, oldID, modifyDNOperation.getModifications());
        }
        EntryCache entryCache = DirectoryServer.getEntryCache();
        if (entryCache != null) {
            entryCache.removeEntry(oldDN);
        }
    }

    private void removeSubordinateEntry(Transaction txn, IndexBuffer buffer, DN oldSuperiorDN, EntryID oldID, EntryID newID, Entry oldEntry, DN newDN, boolean isApexEntryMoved, ModifyDNOperation modifyDNOperation, MovedEntry tail) throws DirectoryException, DatabaseException {
        DN oldDN = oldEntry.getName();
        Entry newEntry = oldEntry.duplicate(false);
        newEntry.setDN(newDN);
        List<Modification> modifications = Collections.unmodifiableList(new ArrayList(0));
        if (modifyDNOperation != null && !modifyDNOperation.isSynchronizationOperation()) {
            LocalizableMessageBuilder invalidReason;
            PluginResult.SubordinateModifyDN pluginResult = DirectoryServer.getPluginConfigManager().invokeSubordinateModifyDNPlugins((SubordinateModifyDNOperation)modifyDNOperation, oldEntry, newEntry, modifications);
            if (!pluginResult.continueProcessing()) {
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), BackendMessages.ERR_MODIFYDN_ABORTED_BY_SUBORDINATE_PLUGIN.get((Object)oldDN, (Object)newDN));
            }
            if (!modifications.isEmpty() && !newEntry.conformsToSchema(null, false, false, false, invalidReason = new LocalizableMessageBuilder())) {
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), BackendMessages.ERR_MODIFYDN_ABORTED_BY_SUBORDINATE_SCHEMA_ERROR.get((Object)oldDN, (Object)newDN, (Object)invalidReason));
            }
        }
        this.dn2id.remove(txn, oldDN);
        if (!newID.equals(oldID)) {
            this.id2entry.remove(txn, oldID);
        }
        this.dn2uri.deleteEntry(txn, oldEntry);
        tail.next = new MovedEntry(newID, newEntry, !newID.equals(oldID));
        if (isApexEntryMoved) {
            DN dn = oldSuperiorDN;
            while (dn != null) {
                EntryID parentID = this.dn2id.get(txn, dn, LockMode.DEFAULT);
                ByteString parentIDKeyBytes = ByteString.valueOf((long)parentID.longValue());
                this.id2subtree.removeID(buffer, parentIDKeyBytes, oldID);
                dn = this.getParentWithinBase(dn);
            }
        }
        if (!newID.equals(oldID)) {
            ByteString oldIDKeyBytes = ByteString.valueOf((long)oldID.longValue());
            this.id2children.delete(buffer, oldIDKeyBytes);
            this.id2subtree.delete(buffer, oldIDKeyBytes);
            this.indexRemoveEntry(buffer, oldEntry, oldID);
        } else if (!modifications.isEmpty()) {
            this.indexModifications(buffer, oldEntry, newEntry, oldID, modifications);
        }
        EntryCache entryCache = DirectoryServer.getEntryCache();
        if (entryCache != null) {
            entryCache.removeEntry(oldDN);
        }
    }

    static DN modDN(DN oldDN, int oldSuffixLen, DN newSuffixDN) {
        int i;
        int oldDNNumComponents = oldDN.size();
        int oldDNKeepComponents = oldDNNumComponents - oldSuffixLen;
        int newSuffixDNComponents = newSuffixDN.size();
        RDN[] newDNComponents = new RDN[oldDNKeepComponents + newSuffixDNComponents];
        for (i = 0; i < oldDNKeepComponents; ++i) {
            newDNComponents[i] = oldDN.getRDN(i);
        }
        i = oldDNKeepComponents;
        for (int j = 0; j < newSuffixDNComponents; ++j) {
            newDNComponents[i] = newSuffixDN.getRDN(j);
            ++i;
        }
        return new DN(newDNComponents);
    }

    private void indexInsertEntry(IndexBuffer buffer, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.addEntry(buffer, entryID, entry);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.addEntry(buffer, entryID, entry);
        }
    }

    private void indexRemoveEntry(IndexBuffer buffer, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.removeEntry(buffer, entryID, entry);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.removeEntry(buffer, entryID, entry);
        }
    }

    private void indexModifications(IndexBuffer buffer, Entry oldEntry, Entry newEntry, EntryID entryID, List<Modification> mods) throws DatabaseException, DirectoryException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            if (!this.isAttributeModified(index, mods)) continue;
            index.modifyEntry(buffer, entryID, oldEntry, newEntry, mods);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.modifyEntry(buffer, entryID, oldEntry, newEntry, mods);
        }
    }

    public long getEntryCount() throws DatabaseException {
        EntryID entryID = this.dn2id.get(null, this.baseDN, LockMode.DEFAULT);
        if (entryID != null) {
            DatabaseEntry key = new DatabaseEntry(JebFormat.entryIDToDatabase(entryID.longValue()));
            EntryIDSet entryIDSet = this.id2subtree.readKey(key, null, LockMode.DEFAULT);
            long count = entryIDSet.size();
            if (count != Long.MAX_VALUE) {
                return ++count;
            }
            return this.id2entry.getRecordCount();
        }
        return 0L;
    }

    public int getEntryLimitExceededCount() {
        int count = 0;
        count += this.id2children.getEntryLimitExceededCount();
        count += this.id2subtree.getEntryLimitExceededCount();
        for (AttributeIndex index : this.attrIndexMap.values()) {
            count = (int)((long)count + index.getEntryLimitExceededCount());
        }
        return count;
    }

    public void listDatabases(List<DatabaseContainer> dbList) {
        dbList.add(this.dn2id);
        dbList.add(this.id2entry);
        dbList.add(this.dn2uri);
        if (this.config.isSubordinateIndexesEnabled()) {
            dbList.add(this.id2children);
            dbList.add(this.id2subtree);
        }
        dbList.add(this.state);
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.listDatabases(dbList);
        }
        dbList.addAll(this.vlvIndexMap.values());
    }

    private static boolean isManageDsaITOperation(Operation operation) {
        List controls;
        if (operation != null && (controls = operation.getRequestControls()) != null) {
            for (Control control : controls) {
                if (!"2.16.840.1.113730.3.4.2".equals(control.getOID())) continue;
                return true;
            }
        }
        return false;
    }

    public Transaction beginTransaction() throws DatabaseException {
        Transaction parentTxn = null;
        TransactionConfig txnConfig = null;
        Transaction txn = this.env.beginTransaction(parentTxn, txnConfig);
        if (logger.isTraceEnabled()) {
            logger.trace("beginTransaction", (Object)("begin txnid=" + txn.getId()));
        }
        return txn;
    }

    public static void transactionCommit(Transaction txn) throws DatabaseException {
        if (txn != null) {
            txn.commit();
            if (logger.isTraceEnabled()) {
                logger.trace("commit txnid=%d", (Object)txn.getId());
            }
        }
    }

    public static void transactionAbort(Transaction txn) throws DatabaseException {
        if (txn != null) {
            txn.abort();
            if (logger.isTraceEnabled()) {
                logger.trace("abort txnid=%d", (Object)txn.getId());
            }
        }
    }

    void delete() throws DatabaseException {
        ArrayList<DatabaseContainer> databases = new ArrayList<DatabaseContainer>();
        this.listDatabases(databases);
        if (this.env.getConfig().getTransactional()) {
            Transaction txn = this.beginTransaction();
            try {
                for (DatabaseContainer db : databases) {
                    this.env.removeDatabase(txn, db.getName());
                }
                EntryContainer.transactionCommit(txn);
            }
            catch (DatabaseException de) {
                EntryContainer.transactionAbort(txn);
                throw de;
            }
        } else {
            for (DatabaseContainer db : databases) {
                this.env.removeDatabase(null, db.getName());
            }
        }
    }

    void deleteDatabase(DatabaseContainer database) throws DatabaseException {
        if (database == this.state) {
            return;
        }
        database.close();
        if (this.env.getConfig().getTransactional()) {
            Transaction txn = this.beginTransaction();
            try {
                this.env.removeDatabase(txn, database.getName());
                if (database instanceof Index) {
                    this.state.removeIndexTrustState(txn, database);
                }
                EntryContainer.transactionCommit(txn);
            }
            catch (DatabaseException de) {
                EntryContainer.transactionAbort(txn);
                throw de;
            }
        } else {
            this.env.removeDatabase(null, database.getName());
            if (database instanceof Index) {
                this.state.removeIndexTrustState(null, database);
            }
        }
    }

    private void deleteAttributeIndex(AttributeIndex attributeIndex) throws DatabaseException {
        attributeIndex.close();
        Transaction txn = this.env.getConfig().getTransactional() ? this.beginTransaction() : null;
        try {
            for (Index index : attributeIndex.getAllIndexes()) {
                this.env.removeDatabase(txn, index.getName());
                this.state.removeIndexTrustState(txn, index);
            }
            if (txn != null) {
                EntryContainer.transactionCommit(txn);
            }
        }
        catch (DatabaseException de) {
            if (txn != null) {
                EntryContainer.transactionAbort(txn);
            }
            throw de;
        }
    }

    public String getDatabasePrefix() {
        return this.databasePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDatabasePrefix(String newDatabasePrefix) throws DatabaseException, JebException {
        block12: {
            ArrayList<DatabaseContainer> databases = new ArrayList<DatabaseContainer>();
            this.listDatabases(databases);
            newDatabasePrefix = this.preparePrefix(newDatabasePrefix);
            for (DatabaseContainer db : databases) {
                db.close();
            }
            try {
                if (this.env.getConfig().getTransactional()) {
                    Transaction txn = this.beginTransaction();
                    try {
                        String newName;
                        String oldName;
                        for (DatabaseContainer db : databases) {
                            oldName = db.getName();
                            newName = oldName.replace(this.databasePrefix, newDatabasePrefix);
                            this.env.renameDatabase(txn, oldName, newName);
                        }
                        EntryContainer.transactionCommit(txn);
                        for (DatabaseContainer db : databases) {
                            oldName = db.getName();
                            newName = oldName.replace(this.databasePrefix, newDatabasePrefix);
                            db.setName(newName);
                        }
                        this.databasePrefix = newDatabasePrefix;
                        break block12;
                    }
                    catch (Exception e) {
                        EntryContainer.transactionAbort(txn);
                        String msg = e.getMessage();
                        if (msg == null) {
                            msg = StaticUtils.stackTraceToSingleLineString((Throwable)e);
                        }
                        throw new JebException(BackendMessages.ERR_UNCHECKED_EXCEPTION.get((Object)msg), e);
                    }
                }
                for (DatabaseContainer db : databases) {
                    String oldName = db.getName();
                    String newName = oldName.replace(this.databasePrefix, newDatabasePrefix);
                    this.env.renameDatabase(null, oldName, newName);
                    db.setName(newName);
                }
                this.databasePrefix = newDatabasePrefix;
            }
            finally {
                for (DatabaseContainer db : databases) {
                    db.open();
                }
            }
        }
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    DN getParentWithinBase(DN dn) {
        if (dn.equals((Object)this.baseDN)) {
            return null;
        }
        return dn.parent();
    }

    public boolean isConfigurationChangeAcceptable(LocalDBBackendCfg cfg, List<LocalizableMessage> unacceptableReasons) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigChangeResult applyConfigurationChange(LocalDBBackendCfg cfg) {
        ConfigChangeResult ccr = new ConfigChangeResult();
        this.exclusiveLock.lock();
        try {
            if (this.config.isSubordinateIndexesEnabled() != cfg.isSubordinateIndexesEnabled()) {
                if (cfg.isSubordinateIndexesEnabled()) {
                    this.openSubordinateIndexes();
                } else {
                    this.id2children.close();
                    this.id2children = new NullIndex(this.databasePrefix + "_" + ID2CHILDREN_DATABASE_NAME, new ID2CIndexer(), this.state, this.env, this);
                    this.state.putIndexTrustState(null, this.id2children, false);
                    this.id2children.open();
                    this.id2subtree.close();
                    this.id2subtree = new NullIndex(this.databasePrefix + "_" + ID2SUBTREE_DATABASE_NAME, new ID2SIndexer(), this.state, this.env, this);
                    this.state.putIndexTrustState(null, this.id2subtree, false);
                    this.id2subtree.open();
                    logger.info(BackendMessages.NOTE_JEB_SUBORDINATE_INDEXES_DISABLED, (Object)cfg.getBackendId());
                }
            }
            if (this.config.getIndexEntryLimit() != cfg.getIndexEntryLimit()) {
                if (this.id2children.setIndexEntryLimit(cfg.getIndexEntryLimit())) {
                    ccr.setAdminActionRequired(true);
                    ccr.addMessage(BackendMessages.NOTE_CONFIG_INDEX_ENTRY_LIMIT_REQUIRES_REBUILD.get((Object)this.id2children.getName()));
                }
                if (this.id2subtree.setIndexEntryLimit(cfg.getIndexEntryLimit())) {
                    ccr.setAdminActionRequired(true);
                    ccr.addMessage(BackendMessages.NOTE_CONFIG_INDEX_ENTRY_LIMIT_REQUIRES_REBUILD.get((Object)this.id2subtree.getName()));
                }
            }
            DataConfig entryDataConfig = new DataConfig(cfg.isEntriesCompressed(), cfg.isCompactEncoding(), this.rootContainer.getCompressedSchema());
            this.id2entry.setDataConfig(entryDataConfig);
            this.config = cfg;
        }
        catch (DatabaseException e) {
            ccr.addMessage(LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToSingleLineString((Throwable)e), (Object[])new Object[0]));
            ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
        }
        finally {
            this.exclusiveLock.unlock();
        }
        return ccr;
    }

    public EnvironmentConfig getEnvironmentConfig() throws DatabaseException {
        return this.env.getConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws DatabaseException {
        block22: {
            Transaction txn;
            ArrayList<DatabaseContainer> databases = new ArrayList<DatabaseContainer>();
            this.listDatabases(databases);
            for (DatabaseContainer db : databases) {
                db.close();
            }
            try {
                if (this.env.getConfig().getTransactional()) {
                    txn = this.beginTransaction();
                    try {
                        for (DatabaseContainer db : databases) {
                            this.env.truncateDatabase(txn, db.getName(), false);
                        }
                        EntryContainer.transactionCommit(txn);
                        break block22;
                    }
                    catch (DatabaseException de) {
                        EntryContainer.transactionAbort(txn);
                        throw de;
                    }
                }
                for (DatabaseContainer db : databases) {
                    this.env.truncateDatabase(null, db.getName(), false);
                }
            }
            finally {
                for (DatabaseContainer db : databases) {
                    db.open();
                }
                txn = null;
                try {
                    if (this.env.getConfig().getTransactional()) {
                        txn = this.beginTransaction();
                    }
                    for (DatabaseContainer db : databases) {
                        if (!(db instanceof Index)) continue;
                        Index index = (Index)db;
                        index.setTrusted(txn, true);
                    }
                    if (this.env.getConfig().getTransactional()) {
                        EntryContainer.transactionCommit(txn);
                    }
                }
                catch (Exception de) {
                    logger.traceException((Throwable)de);
                    try {
                        if (txn != null) {
                            EntryContainer.transactionAbort(txn);
                        }
                    }
                    catch (Exception e) {
                        logger.traceException((Throwable)de);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDatabase(DatabaseContainer database) throws DatabaseException {
        block7: {
            database.close();
            try {
                if (this.env.getConfig().getTransactional()) {
                    Transaction txn = this.beginTransaction();
                    try {
                        this.env.removeDatabase(txn, database.getName());
                        EntryContainer.transactionCommit(txn);
                        break block7;
                    }
                    catch (DatabaseException de) {
                        EntryContainer.transactionAbort(txn);
                        throw de;
                    }
                }
                this.env.removeDatabase(null, database.getName());
            }
            finally {
                database.open();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Cleared the database %s", (Object)database.getName());
        }
    }

    private DN getMatchedDN(DN baseDN) throws DirectoryException {
        for (DN parentDN = baseDN.getParentDNInSuffix(); parentDN != null && parentDN.isDescendantOf(this.getBaseDN()); parentDN = parentDN.getParentDNInSuffix()) {
            if (!this.entryExists(parentDN)) continue;
            return parentDN;
        }
        return null;
    }

    private void openSubordinateIndexes() {
        this.id2children = this.newIndex(ID2CHILDREN_DATABASE_NAME, new ID2CIndexer());
        this.id2subtree = this.newIndex(ID2SUBTREE_DATABASE_NAME, new ID2SIndexer());
    }

    private Index newIndex(String name, Indexer indexer) {
        Index index = new Index(this.databasePrefix + "_" + name, indexer, this.state, this.config.getIndexEntryLimit(), 0, true, this.env, this);
        index.open();
        if (!index.isTrusted()) {
            logger.info(BackendMessages.NOTE_INDEX_ADD_REQUIRES_REBUILD, (Object)index.getName());
        }
        return index;
    }

    Index newIndexForAttribute(String indexName, Indexer indexer, int indexEntryLimit) {
        int cursorEntryLimit = 100000;
        return new Index(indexName, indexer, this.state, indexEntryLimit, 100000, false, this.env, this);
    }

    private boolean isAttributeModified(AttributeIndex index, List<Modification> mods) {
        boolean attributeModified = false;
        AttributeType indexAttributeType = index.getAttributeType();
        Iterable subTypes = DirectoryServer.getSchema().getSubTypes(indexAttributeType);
        block0: for (Modification mod : mods) {
            Attribute modAttr = mod.getAttribute();
            AttributeType modAttrType = modAttr.getAttributeType();
            if (modAttrType.equals((Object)indexAttributeType)) {
                attributeModified = true;
                break;
            }
            for (AttributeType subType : subTypes) {
                if (!modAttrType.equals((Object)subType)) continue;
                attributeModified = true;
                continue block0;
            }
        }
        return attributeModified;
    }

    private Entry fetchBaseEntry(DN baseDN, SearchScope searchScope) throws DirectoryException {
        Entry baseEntry = null;
        try {
            baseEntry = this.getEntry(baseDN);
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
        }
        if (baseEntry == null) {
            this.dn2uri.targetEntryReferrals(baseDN, searchScope);
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, BackendMessages.ERR_SEARCH_NO_SUCH_OBJECT.get((Object)baseDN), this.getMatchedDN(baseDN), null);
        }
        return baseEntry;
    }

    private String preparePrefix(String databasePrefix) {
        StringBuilder builder = new StringBuilder(databasePrefix.length());
        for (int i = 0; i < databasePrefix.length(); ++i) {
            char ch = databasePrefix.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                builder.append(ch);
                continue;
            }
            builder.append('_');
        }
        return builder.toString();
    }

    public void lock() {
        this.exclusiveLock.lock();
    }

    public void unlock() {
        this.exclusiveLock.unlock();
    }

    public String toString() {
        return this.databasePrefix;
    }

    private static final class MovedEntry {
        private EntryID entryID;
        private Entry entry;
        private MovedEntry next;
        private boolean renumbered;

        private MovedEntry(EntryID entryID, Entry entry, boolean renumbered) {
            this.entryID = entryID;
            this.entry = entry;
            this.renumbered = renumbered;
        }
    }

    private class VLVJEIndexCfgManager
    implements ConfigurationAddListener<LocalDBVLVIndexCfg>,
    ConfigurationDeleteListener<LocalDBVLVIndexCfg> {
        private VLVJEIndexCfgManager() {
        }

        public boolean isConfigurationAddAcceptable(LocalDBVLVIndexCfg cfg, List<LocalizableMessage> unacceptableReasons) {
            try {
                SearchFilter.createFilterFromString((String)cfg.getFilter());
            }
            catch (Exception e) {
                unacceptableReasons.add(BackendMessages.ERR_CONFIG_VLV_INDEX_BAD_FILTER.get((Object)cfg.getFilter(), (Object)cfg.getName(), (Object)e.getLocalizedMessage()));
                return false;
            }
            String[] sortAttrs = cfg.getSortOrder().split(" ");
            SortKey[] sortKeys = new SortKey[sortAttrs.length];
            boolean[] ascending = new boolean[sortAttrs.length];
            for (int i = 0; i < sortAttrs.length; ++i) {
                try {
                    if (sortAttrs[i].startsWith("-")) {
                        ascending[i] = false;
                        sortAttrs[i] = sortAttrs[i].substring(1);
                    } else {
                        ascending[i] = true;
                        if (sortAttrs[i].startsWith("+")) {
                            sortAttrs[i] = sortAttrs[i].substring(1);
                        }
                    }
                }
                catch (Exception e) {
                    unacceptableReasons.add(BackendMessages.ERR_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get((Object)sortKeys[i], (Object)cfg.getName()));
                    return false;
                }
                AttributeType attrType = DirectoryServer.getAttributeType((String)sortAttrs[i].toLowerCase());
                if (attrType == null) {
                    unacceptableReasons.add(BackendMessages.ERR_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get((Object)sortAttrs[i], (Object)cfg.getName()));
                    return false;
                }
                sortKeys[i] = new SortKey(attrType, ascending[i]);
            }
            return true;
        }

        public ConfigChangeResult applyConfigurationAdd(LocalDBVLVIndexCfg cfg) {
            ConfigChangeResult ccr = new ConfigChangeResult();
            try {
                VLVIndex vlvIndex = new VLVIndex(cfg, EntryContainer.this.state, EntryContainer.this.env, EntryContainer.this);
                vlvIndex.open();
                if (!vlvIndex.isTrusted()) {
                    ccr.setAdminActionRequired(true);
                    ccr.addMessage(BackendMessages.NOTE_INDEX_ADD_REQUIRES_REBUILD.get((Object)cfg.getName()));
                }
                EntryContainer.this.vlvIndexMap.put(cfg.getName().toLowerCase(), vlvIndex);
            }
            catch (Exception e) {
                ccr.addMessage(LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToSingleLineString((Throwable)e), (Object[])new Object[0]));
                ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
            }
            return ccr;
        }

        public boolean isConfigurationDeleteAcceptable(LocalDBVLVIndexCfg cfg, List<LocalizableMessage> unacceptableReasons) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConfigChangeResult applyConfigurationDelete(LocalDBVLVIndexCfg cfg) {
            ConfigChangeResult ccr = new ConfigChangeResult();
            EntryContainer.this.exclusiveLock.lock();
            try {
                VLVIndex vlvIndex = (VLVIndex)EntryContainer.this.vlvIndexMap.get(cfg.getName().toLowerCase());
                EntryContainer.this.deleteDatabase(vlvIndex);
                EntryContainer.this.vlvIndexMap.remove(cfg.getName());
            }
            catch (DatabaseException de) {
                ccr.addMessage(LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToSingleLineString((Throwable)de), (Object[])new Object[0]));
                ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
            }
            finally {
                EntryContainer.this.exclusiveLock.unlock();
            }
            return ccr;
        }
    }

    private class AttributeJEIndexCfgManager
    implements ConfigurationAddListener<LocalDBIndexCfg>,
    ConfigurationDeleteListener<LocalDBIndexCfg> {
        private AttributeJEIndexCfgManager() {
        }

        public boolean isConfigurationAddAcceptable(LocalDBIndexCfg cfg, List<LocalizableMessage> unacceptableReasons) {
            try {
                new AttributeIndex(cfg, EntryContainer.this);
                return true;
            }
            catch (Exception e) {
                unacceptableReasons.add(LocalizableMessage.raw((CharSequence)e.getLocalizedMessage(), (Object[])new Object[0]));
                return false;
            }
        }

        public ConfigChangeResult applyConfigurationAdd(LocalDBIndexCfg cfg) {
            ConfigChangeResult ccr = new ConfigChangeResult();
            try {
                AttributeIndex index = new AttributeIndex(cfg, EntryContainer.this);
                index.open();
                if (!index.isTrusted()) {
                    ccr.setAdminActionRequired(true);
                    ccr.addMessage(BackendMessages.NOTE_INDEX_ADD_REQUIRES_REBUILD.get((Object)cfg.getAttribute().getNameOrOID()));
                }
                EntryContainer.this.attrIndexMap.put(cfg.getAttribute(), index);
            }
            catch (Exception e) {
                ccr.addMessage(LocalizableMessage.raw((CharSequence)e.getLocalizedMessage(), (Object[])new Object[0]));
                ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
            }
            return ccr;
        }

        public boolean isConfigurationDeleteAcceptable(LocalDBIndexCfg cfg, List<LocalizableMessage> unacceptableReasons) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConfigChangeResult applyConfigurationDelete(LocalDBIndexCfg cfg) {
            ConfigChangeResult ccr = new ConfigChangeResult();
            EntryContainer.this.exclusiveLock.lock();
            try {
                AttributeIndex index = (AttributeIndex)EntryContainer.this.attrIndexMap.get(cfg.getAttribute());
                EntryContainer.this.deleteAttributeIndex(index);
                EntryContainer.this.attrIndexMap.remove(cfg.getAttribute());
            }
            catch (DatabaseException de) {
                ccr.addMessage(LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToSingleLineString((Throwable)de), (Object[])new Object[0]));
                ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
            }
            finally {
                EntryContainer.this.exclusiveLock.unlock();
            }
            return ccr;
        }
    }
}

