/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DiskOrderedCursor;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.Transaction;
import java.io.Closeable;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public abstract class DatabaseContainer
implements Closeable {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    protected final EntryContainer entryContainer;
    protected String name;
    protected DatabaseConfig dbConfig;
    private final Environment env;
    private Database database;

    protected DatabaseContainer(String name, Environment env, EntryContainer entryContainer) {
        this.env = env;
        this.entryContainer = entryContainer;
        this.name = name;
    }

    public void open() throws DatabaseException {
        if (this.dbConfig.getTransactional()) {
            Transaction txn = this.entryContainer.beginTransaction();
            try {
                this.database = this.env.openDatabase(txn, this.name, this.dbConfig);
                if (logger.isTraceEnabled()) {
                    logger.trace("JE database %s opened. txnid=%d", (Object)this.database.getDatabaseName(), (Object)txn.getId());
                }
                EntryContainer.transactionCommit(txn);
            }
            catch (DatabaseException e) {
                EntryContainer.transactionAbort(txn);
                throw e;
            }
        } else {
            this.database = this.env.openDatabase(null, this.name, this.dbConfig);
            if (logger.isTraceEnabled()) {
                logger.trace("JE database %s opened. txnid=none", (Object)this.database.getDatabaseName());
            }
        }
    }

    @Override
    public synchronized void close() throws DatabaseException {
        if (this.dbConfig.getDeferredWrite()) {
            this.database.sync();
        }
        this.database.close();
        this.database = null;
        if (logger.isTraceEnabled()) {
            logger.trace("Closed database %s", (Object)this.name);
        }
    }

    OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        OperationStatus status = this.database.put(txn, key, data);
        if (logger.isTraceEnabled()) {
            logger.trace(this.messageToLog(status, this.database, txn, key, data));
        }
        return status;
    }

    OperationStatus read(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status = this.database.get(txn, key, data, lockMode);
        if (logger.isTraceEnabled()) {
            logger.trace(this.messageToLog(status, this.database, txn, key, data));
        }
        return status;
    }

    OperationStatus insert(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        OperationStatus status = this.database.putNoOverwrite(txn, key, data);
        if (logger.isTraceEnabled()) {
            logger.trace(this.messageToLog(status, this.database, txn, key, data));
        }
        return status;
    }

    OperationStatus delete(Transaction txn, DatabaseEntry key) throws DatabaseException {
        OperationStatus status = this.database.delete(txn, key);
        if (logger.isTraceEnabled()) {
            logger.trace(this.messageToLog(status, this.database, txn, key, null));
        }
        return status;
    }

    public Cursor openCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return this.database.openCursor(txn, cursorConfig);
    }

    public DiskOrderedCursor openCursor(DiskOrderedCursorConfig cursorConfig) throws DatabaseException {
        return this.database.openCursor(cursorConfig);
    }

    public long getRecordCount() throws DatabaseException {
        long count = this.database.count();
        if (logger.isTraceEnabled()) {
            logger.trace(this.messageToLog(OperationStatus.SUCCESS, this.database, null, null, null));
        }
        return count;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public PreloadStats preload(PreloadConfig config) throws DatabaseException {
        return this.database.preload(config);
    }

    void setName(String name) {
        this.name = name;
    }

    private String messageToLog(OperationStatus status, Database database, Transaction txn, DatabaseEntry key, DatabaseEntry data) {
        StringBuilder builder = new StringBuilder();
        builder.append(" (");
        builder.append(status);
        builder.append(")");
        builder.append(" db=");
        try {
            builder.append(database.getDatabaseName());
        }
        catch (DatabaseException de) {
            builder.append((Object)de);
        }
        if (txn != null) {
            builder.append(" txnid=");
            try {
                builder.append(txn.getId());
            }
            catch (DatabaseException de) {
                builder.append((Object)de);
            }
        } else {
            builder.append(" txnid=none");
        }
        builder.append(ServerConstants.EOL);
        if (key != null) {
            builder.append("key:");
            builder.append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii((StringBuilder)builder, (byte[])key.getData(), (int)4);
        }
        if (status == OperationStatus.SUCCESS && data != null) {
            builder.append("data(len=");
            builder.append(data.getSize());
            builder.append("):");
            builder.append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii((StringBuilder)builder, (byte[])data.getData(), (int)4);
        }
        return builder.toString();
    }
}

