/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import org.forgerock.util.Reject;
import org.opends.server.api.CompressedSchema;
import org.opends.server.types.EntryEncodeConfig;

public final class DataConfig {
    private boolean compressed;
    private EntryEncodeConfig encodeConfig = new EntryEncodeConfig();

    public DataConfig(boolean compressed, boolean compactEncoding, CompressedSchema compressedSchema) {
        this.compressed = compressed;
        this.setCompactEncoding(compactEncoding, compressedSchema);
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public boolean isCompactEncoding() {
        return this.encodeConfig.compressAttributeDescriptions();
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public void setCompactEncoding(boolean compactEncoding, CompressedSchema compressedSchema) {
        if (compressedSchema == null) {
            Reject.ifTrue((boolean)compactEncoding);
            this.encodeConfig = new EntryEncodeConfig(false, compactEncoding, false);
        } else {
            this.encodeConfig = new EntryEncodeConfig(false, compactEncoding, compactEncoding, compressedSchema);
        }
    }

    public EntryEncodeConfig getEntryEncodeConfig() {
        return this.encodeConfig;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataConfig(compressed=");
        builder.append(this.compressed);
        builder.append(", ");
        this.encodeConfig.toString(builder);
        builder.append(")");
        return builder.toString();
    }
}

