/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.util.Pair;
import org.opends.messages.BackendMessages;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.JEBUtils;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.Modification;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.StaticUtils;

public class DN2URI
extends DatabaseContainer {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final byte STRING_SEPARATOR = 0;
    private final Comparator<byte[]> dn2uriComparator;
    private final int prefixRDNComponents;
    private final AttributeType referralType = DirectoryServer.getAttributeType((String)"ref");
    private volatile ConditionResult containsReferrals = ConditionResult.UNDEFINED;

    DN2URI(String name, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        this.dn2uriComparator = new AttributeIndex.KeyComparator();
        this.prefixRDNComponents = entryContainer.getBaseDN().size();
        this.dbConfig = JEBUtils.toDatabaseConfigAllowDuplicates(env);
        this.dbConfig.setBtreeComparator(this.dn2uriComparator.getClass());
    }

    private boolean insert(Transaction txn, DN dn, String labeledURI) throws DatabaseException {
        DatabaseEntry data;
        byte[] normDN = JebFormat.dnToDNKey(dn, this.prefixRDNComponents);
        DatabaseEntry key = new DatabaseEntry(normDN);
        if (this.put(txn, key, data = new DatabaseEntry(this.encodeURIAndDN(labeledURI, dn))) == OperationStatus.SUCCESS) {
            this.containsReferrals = ConditionResult.TRUE;
            return true;
        }
        return false;
    }

    private byte[] encodeURIAndDN(String labeledURI, DN dn) {
        return new ByteStringBuilder().append(labeledURI).append((byte)0).append(dn.toString()).toByteArray();
    }

    private Pair<String, DN> decodeURIAndDN(byte[] data) throws DirectoryException {
        try {
            ByteSequenceReader reader = ByteString.valueOf((byte[])data).asReader();
            String labeledURI = reader.getString(this.getNextStringLength(reader));
            reader.skip(1);
            DN dn = DN.valueOf((String)reader.getString(reader.remaining()));
            return Pair.of((Object)labeledURI, (Object)dn);
        }
        catch (Exception e) {
            throw new DirectoryException(ResultCode.OPERATIONS_ERROR, BackendMessages.ERR_DATABASE_EXCEPTION.get((Object)e));
        }
    }

    private int getNextStringLength(ByteSequenceReader reader) {
        int length = 0;
        while (reader.peek(length) != 0) {
            ++length;
        }
        return length;
    }

    boolean delete(Transaction txn, DN dn) throws DatabaseException {
        byte[] normDN = JebFormat.dnToDNKey(dn, this.prefixRDNComponents);
        DatabaseEntry key = new DatabaseEntry(normDN);
        if (this.delete(txn, key) == OperationStatus.SUCCESS) {
            this.containsReferrals = this.containsReferrals(txn);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delete(Transaction txn, DN dn, String labeledURI) throws DatabaseException {
        CursorConfig cursorConfig = null;
        byte[] normDN = JebFormat.dnToDNKey(dn, this.prefixRDNComponents);
        byte[] URIBytes = StaticUtils.getBytes((String)labeledURI);
        DatabaseEntry key = new DatabaseEntry(normDN);
        DatabaseEntry data = new DatabaseEntry(URIBytes);
        try (Cursor cursor = this.openCursor(txn, cursorConfig);){
            OperationStatus status = cursor.getSearchBoth(key, data, null);
            if (status == OperationStatus.SUCCESS) {
                status = cursor.delete();
            }
            if (status == OperationStatus.SUCCESS) {
                this.containsReferrals = this.containsReferrals(txn);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private ConditionResult containsReferrals(Transaction txn) {
        try {
            Cursor cursor = this.openCursor(txn, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = cursor.getFirst(key, data, null);
            cursor.close();
            if (status == OperationStatus.SUCCESS) {
                return ConditionResult.TRUE;
            }
            if (status == OperationStatus.NOTFOUND) {
                return ConditionResult.FALSE;
            }
            return ConditionResult.UNDEFINED;
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
            return ConditionResult.UNDEFINED;
        }
    }

    void modifyEntry(Transaction txn, Entry before, Entry after, List<Modification> mods) throws DatabaseException {
        DN entryDN = before.getName();
        block6: for (Modification mod : mods) {
            Attribute modAttr = mod.getAttribute();
            AttributeType modAttrType = modAttr.getAttributeType();
            if (!modAttrType.equals((Object)this.referralType)) continue;
            Attribute a = mod.getAttribute();
            switch (mod.getModificationType().asEnum()) {
                case ADD: {
                    if (a == null) break;
                    for (ByteString v : a) {
                        this.insert(txn, entryDN, v.toString());
                    }
                    continue block6;
                }
                case DELETE: {
                    if (a == null || a.isEmpty()) {
                        this.delete(txn, entryDN);
                        break;
                    }
                    for (ByteString v : a) {
                        this.delete(txn, entryDN, v.toString());
                    }
                    continue block6;
                }
                case INCREMENT: {
                    break;
                }
                case REPLACE: {
                    this.delete(txn, entryDN);
                    if (a == null) break;
                    for (ByteString v : a) {
                        this.insert(txn, entryDN, v.toString());
                    }
                    break;
                }
            }
        }
    }

    public void replaceEntry(Transaction txn, Entry before, Entry after) throws DatabaseException {
        this.deleteEntry(txn, before);
        this.addEntry(txn, after);
    }

    public boolean addEntry(Transaction txn, Entry entry) throws DatabaseException {
        boolean success = true;
        Set labeledURIs = entry.getReferralURLs();
        if (labeledURIs != null) {
            DN dn = entry.getName();
            for (String labeledURI : labeledURIs) {
                if (this.insert(txn, dn, labeledURI)) continue;
                success = false;
            }
        }
        return success;
    }

    void deleteEntry(Transaction txn, Entry entry) throws DatabaseException {
        Set labeledURIs = entry.getReferralURLs();
        if (labeledURIs != null) {
            this.delete(txn, entry.getName());
        }
    }

    void checkTargetForReferral(Entry entry, SearchScope searchScope) throws DirectoryException {
        Set referralURLs = entry.getReferralURLs();
        if (referralURLs != null) {
            this.throwReferralException(entry.getName(), entry.getName(), referralURLs, searchScope);
        }
    }

    private void throwReferralException(DN targetDN, DN referralDN, Set<String> labeledURIs, SearchScope searchScope) throws DirectoryException {
        ArrayList<String> URIList = new ArrayList<String>(labeledURIs.size());
        Iterator<String> i$ = labeledURIs.iterator();
        while (i$.hasNext()) {
            String labeledURI;
            String uri = labeledURI = i$.next();
            int i = labeledURI.indexOf(32);
            if (i != -1) {
                uri = labeledURI.substring(0, i);
            }
            try {
                LDAPURL ldapurl = LDAPURL.decode((String)uri, (boolean)false);
                if ("ldap".equalsIgnoreCase(ldapurl.getScheme())) {
                    DN urlBaseDN = targetDN;
                    if (!referralDN.equals((Object)ldapurl.getBaseDN())) {
                        urlBaseDN = EntryContainer.modDN(targetDN, referralDN.size(), ldapurl.getBaseDN());
                    }
                    ldapurl.setBaseDN(urlBaseDN);
                    if (searchScope == null) {
                        StringBuilder builder = new StringBuilder(uri.length());
                        ldapurl.toString(builder, true);
                        uri = builder.toString();
                    } else {
                        ldapurl.getAttributes().clear();
                        ldapurl.setScope(searchScope);
                        ldapurl.setFilter(null);
                        uri = ldapurl.toString();
                    }
                }
            }
            catch (DirectoryException e) {
                logger.traceException((Throwable)e);
            }
            URIList.add(uri);
        }
        LocalizableMessage msg = BackendMessages.NOTE_REFERRAL_RESULT_MESSAGE.get((Object)referralDN);
        throw new DirectoryException(ResultCode.REFERRAL, msg, referralDN, URIList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void targetEntryReferrals(DN targetDN, SearchScope searchScope) throws DirectoryException {
        if (this.containsReferrals == ConditionResult.UNDEFINED) {
            this.containsReferrals = this.containsReferrals(null);
        }
        if (this.containsReferrals == ConditionResult.FALSE) {
            return;
        }
        Transaction txn = null;
        CursorConfig cursorConfig = null;
        try (Cursor cursor = this.openCursor(txn, cursorConfig);){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            DN dn = this.entryContainer.getParentWithinBase(targetDN);
            while (dn != null) {
                key.setData(JebFormat.dnToDNKey(dn, this.prefixRDNComponents));
                OperationStatus status = cursor.getSearchKey(key, data, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS) {
                    LinkedHashSet<String> labeledURIs = new LinkedHashSet<String>(cursor.count());
                    do {
                        Pair<String, DN> uriAndDN = this.decodeURIAndDN(data.getData());
                        String labeledURI = (String)uriAndDN.getFirst();
                        labeledURIs.add(labeledURI);
                    } while ((status = cursor.getNextDup(key, data, LockMode.DEFAULT)) == OperationStatus.SUCCESS);
                    this.throwReferralException(targetDN, dn, labeledURIs, searchScope);
                }
                dn = this.entryContainer.getParentWithinBase(dn);
            }
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean returnSearchReferences(SearchOperation searchOp) throws DirectoryException {
        if (this.containsReferrals == ConditionResult.UNDEFINED) {
            this.containsReferrals = this.containsReferrals(null);
        }
        if (this.containsReferrals == ConditionResult.FALSE) {
            return true;
        }
        Transaction txn = null;
        CursorConfig cursorConfig = null;
        byte[] baseDN = JebFormat.dnToDNKey(searchOp.getBaseDN(), this.prefixRDNComponents);
        boolean special = false;
        byte[] suffix = Arrays.copyOf(baseDN, baseDN.length + 1);
        suffix[suffix.length - 1] = 0;
        byte[] end = Arrays.copyOf(suffix, suffix.length);
        end[end.length - 1] = 1;
        DatabaseEntry data = new DatabaseEntry();
        DatabaseEntry key = new DatabaseEntry(suffix);
        try (Cursor cursor = this.openCursor(txn, cursorConfig);){
            OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                int cmp = this.dn2uriComparator.compare(key.getData(), end);
                if (cmp >= 0) {
                    return true;
                }
                Pair<String, DN> uriAndDN = this.decodeURIAndDN(data.getData());
                String labeledURI = (String)uriAndDN.getFirst();
                DN dn = (DN)uriAndDN.getSecond();
                if (searchOp.getScope() != SearchScope.SINGLE_LEVEL || JebFormat.findDNKeyParent(key.getData()) == baseDN.length) {
                    ArrayList<String> URIList = new ArrayList<String>(cursor.count());
                    do {
                        String uri = labeledURI;
                        int i = labeledURI.indexOf(32);
                        if (i != -1) {
                            uri = labeledURI.substring(0, i);
                        }
                        try {
                            LDAPURL ldapurl = LDAPURL.decode((String)uri, (boolean)false);
                            if ("ldap".equalsIgnoreCase(ldapurl.getScheme())) {
                                if (ldapurl.getBaseDN().isRootDN()) {
                                    ldapurl.setBaseDN(dn);
                                }
                                ldapurl.getAttributes().clear();
                                if (searchOp.getScope() == SearchScope.SINGLE_LEVEL) {
                                    ldapurl.setScope(SearchScope.BASE_OBJECT);
                                } else {
                                    ldapurl.setScope(SearchScope.WHOLE_SUBTREE);
                                }
                                ldapurl.setFilter(null);
                                uri = ldapurl.toString();
                            }
                        }
                        catch (DirectoryException e) {
                            logger.traceException((Throwable)e);
                        }
                        URIList.add(uri);
                    } while ((status = cursor.getNextDup(key, data, LockMode.DEFAULT)) == OperationStatus.SUCCESS);
                    SearchResultReference reference = new SearchResultReference(URIList);
                    if (!searchOp.returnReference(dn, reference)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                status = cursor.getNextNoDup(key, data, LockMode.DEFAULT);
            }
            return true;
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
        }
        return true;
    }
}

