/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.Comparator;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JEBUtils;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.types.DN;

public class DN2ID
extends DatabaseContainer {
    private final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();
    private final int prefixRDNComponents;

    DN2ID(String name, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        this.prefixRDNComponents = entryContainer.getBaseDN().size();
        this.dbConfig = JEBUtils.toDatabaseConfigNoDuplicates(env);
        this.dbConfig.setKeyPrefixing(true);
        this.dbConfig.setBtreeComparator(this.comparator.getClass());
    }

    boolean insert(Transaction txn, DN dn, EntryID id) throws DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = new DatabaseEntry(JebFormat.dnToDNKey(dn, this.prefixRDNComponents));
        return this.insert(txn, key, data = id.getDatabaseEntry()) == OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return super.put(txn, key, data);
    }

    boolean remove(Transaction txn, DN dn) throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry(JebFormat.dnToDNKey(dn, this.prefixRDNComponents));
        return this.delete(txn, key) == OperationStatus.SUCCESS;
    }

    public EntryID get(Transaction txn, DN dn, LockMode lockMode) throws DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = new DatabaseEntry(JebFormat.dnToDNKey(dn, this.prefixRDNComponents));
        if (this.read(txn, key, data = new DatabaseEntry(), LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            return new EntryID(data);
        }
        return null;
    }

    @Override
    public OperationStatus read(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return super.read(txn, key, data, lockMode);
    }

    public Comparator<byte[]> getComparator() {
        return this.comparator;
    }
}

