/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.cli.TableBuilder;
import com.forgerock.opendj.cli.TablePrinter;
import com.forgerock.opendj.cli.TextTablePrinter;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.cli.VersionHandler;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.SortValuesSet;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.JDKLogging;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.SortKey;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.StaticUtils;

public class DBTest {
    private final PrintStream err;
    private final PrintStream out;
    private boolean globalArgumentsInitialized;
    private final SubCommandArgumentParser parser;
    private BooleanArgument showUsageArgument;
    private StringArgument configClass;
    private StringArgument configFile;
    private boolean subCommandsInitialized;

    public static void main(String[] args) {
        int exitCode = DBTest.main(args, true, System.out, System.err);
        if (exitCode != 0) {
            System.exit(Utils.filterExitCode((int)exitCode));
        }
    }

    public static int main(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        DBTest app = new DBTest(outStream, errStream);
        return app.run(args, initializeServer);
    }

    public DBTest(OutputStream out, OutputStream err) {
        this.out = NullOutputStream.wrapOrNullStream((OutputStream)out);
        this.err = NullOutputStream.wrapOrNullStream((OutputStream)err);
        JDKLogging.disableLogging();
        LocalizableMessage toolDescription = ToolMessages.INFO_DESCRIPTION_DBTEST_TOOL.get();
        this.parser = new SubCommandArgumentParser(this.getClass().getName(), toolDescription, false);
        this.parser.setShortToolDescription(ToolMessages.REF_SHORT_DESC_DBTEST.get());
        this.parser.setVersionHandler((VersionHandler)new DirectoryServer.DirectoryServerVersionHandler());
    }

    private void initializeGlobalArguments() throws ArgumentException {
        if (!this.globalArgumentsInitialized) {
            this.configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            this.configClass.setHidden(true);
            this.configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            this.configFile.setHidden(true);
            this.showUsageArgument = CommonArguments.getShowUsage();
            this.parser.addGlobalArgument((Argument)this.showUsageArgument);
            this.parser.setUsageArgument((Argument)this.showUsageArgument, (OutputStream)this.out);
            this.parser.addGlobalArgument((Argument)this.configClass);
            this.parser.addGlobalArgument((Argument)this.configFile);
            this.globalArgumentsInitialized = true;
        }
    }

    private void initializeSubCommands() throws ArgumentException {
        if (!this.subCommandsInitialized) {
            SubCommand sub = new SubCommand(this.parser, "list-root-containers", ToolMessages.INFO_DESCRIPTION_DBTEST_SUBCMD_LIST_ROOT_CONTAINERS.get());
            sub = new SubCommand(this.parser, "list-entry-containers", ToolMessages.INFO_DESCRIPTION_DBTEST_SUBCMD_LIST_ENTRY_CONTAINERS.get());
            StringArgument backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", true, false, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BACKEND_ID.get());
            sub.addArgument((Argument)backendID);
            sub = new SubCommand(this.parser, "list-database-containers", ToolMessages.INFO_DESCRIPTION_DBTEST_SUBCMD_LIST_DATABASE_CONTAINERS.get());
            backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", true, false, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BACKEND_ID.get());
            sub.addArgument((Argument)backendID);
            StringArgument baseDN = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, false, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BASE_DN.get());
            sub.addArgument((Argument)baseDN);
            sub = new SubCommand(this.parser, "dump-database-container", ToolMessages.INFO_DESCRIPTION_DBTEST_SUBCMD_DUMP_DATABASE_CONTAINER.get());
            backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", true, false, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BACKEND_ID.get());
            sub.addArgument((Argument)backendID);
            baseDN = new StringArgument("basedn", Character.valueOf('b'), "baseDN", true, false, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BASE_DN.get());
            sub.addArgument((Argument)baseDN);
            StringArgument databaseName = new StringArgument("databasename", Character.valueOf('d'), "databaseName", true, false, true, ToolMessages.INFO_DATABASE_NAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_DATABASE_NAME.get());
            sub.addArgument((Argument)databaseName);
            BooleanArgument skipDecode = new BooleanArgument("skipdecode", Character.valueOf('p'), "skipDecode", ToolMessages.INFO_DESCRIPTION_DBTEST_SKIP_DECODE.get());
            sub.addArgument((Argument)skipDecode);
            BooleanArgument statsOnly = new BooleanArgument("statsonly", Character.valueOf('q'), "statsOnly", ToolMessages.INFO_DESCRIPTION_DBTEST_STATS_ONLY.get());
            sub.addArgument((Argument)statsOnly);
            StringArgument maxKeyValue = new StringArgument("maxkeyvalue", Character.valueOf('K'), "maxKeyValue", false, false, true, ToolMessages.INFO_MAX_KEY_VALUE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_MAX_KEY_VALUE.get());
            sub.addArgument((Argument)maxKeyValue);
            StringArgument minKeyValue = new StringArgument("minkeyvalue", Character.valueOf('k'), "minKeyValue", false, false, true, ToolMessages.INFO_MIN_KEY_VALUE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_MIN_KEY_VALUE.get());
            sub.addArgument((Argument)minKeyValue);
            IntegerArgument maxDataSize = new IntegerArgument("maxdatasize", Character.valueOf('S'), "maxDataSize", false, false, true, ToolMessages.INFO_MAX_DATA_SIZE_PLACEHOLDER.get(), -1, null, ToolMessages.INFO_DESCRIPTION_DBTEST_MAX_DATA_SIZE.get());
            sub.addArgument((Argument)maxDataSize);
            IntegerArgument minDataSize = new IntegerArgument("mindatasize", Character.valueOf('s'), "minDataSize", false, false, true, ToolMessages.INFO_MIN_DATA_SIZE_PLACEHOLDER.get(), -1, null, ToolMessages.INFO_DESCRIPTION_DBTEST_MIN_DATA_SIZE.get());
            sub.addArgument((Argument)minDataSize);
            sub = new SubCommand(this.parser, "list-index-status", ToolMessages.INFO_DESCRIPTION_DBTEST_SUBCMD_LIST_INDEX_STATUS.get());
            sub.setDocDescriptionSupplement(ToolMessages.SUPPLEMENT_DESCRIPTION_DBTEST_SUBCMD_LIST_INDEX_STATUS.get());
            backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", true, false, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BACKEND_ID.get());
            sub.addArgument((Argument)backendID);
            baseDN = new StringArgument("basedn", Character.valueOf('b'), "baseDN", true, true, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BASE_DN.get());
            sub.addArgument((Argument)baseDN);
            this.subCommandsInitialized = true;
        }
    }

    private int run(String[] args, boolean initializeServer) {
        try {
            this.initializeGlobalArguments();
            this.initializeSubCommands();
        }
        catch (ArgumentException e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)e.getMessage()));
            return 1;
        }
        try {
            this.parser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            this.parser.displayMessageAndUsageReference(this.err, ToolMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            return 1;
        }
        if (this.parser.usageOrVersionDisplayed()) {
            return 0;
        }
        try {
            BuildVersion.checkVersionMismatch();
        }
        catch (InitializationException e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)e.getMessageObject());
            return 1;
        }
        if (initializeServer) {
            DirectoryServer directoryServer = DirectoryServer.getInstance();
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get((Object)StaticUtils.getExceptionMessage((Throwable)e)));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(this.configClass.getValue(), this.configFile.getValue());
            }
            catch (InitializationException ie) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_CANNOT_LOAD_CONFIG.get((Object)ie.getMessage()));
                return 1;
            }
            catch (Exception e) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_CANNOT_LOAD_CONFIG.get((Object)StaticUtils.getExceptionMessage((Throwable)e)));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException | InitializationException e) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get((Object)e.getMessage()));
                return 1;
            }
            catch (Exception e) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get((Object)StaticUtils.getExceptionMessage((Throwable)e)));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager(directoryServer.getServerContext());
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException | InitializationException e) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get((Object)e.getMessage()));
                return 1;
            }
            catch (Exception e) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get((Object)StaticUtils.getExceptionMessage((Throwable)e)));
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException | InitializationException e) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get((Object)e.getMessage()));
                return 1;
            }
            catch (Exception e) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get((Object)StaticUtils.getExceptionMessage((Throwable)e)));
                return 1;
            }
        }
        if (this.parser.getSubCommand() == null) {
            this.parser.displayMessageAndUsageReference(this.err, ToolMessages.ERR_DBTEST_MISSING_SUBCOMMAND.get());
            return 1;
        }
        SubCommand subCommand = this.parser.getSubCommand();
        try {
            if ("list-root-containers".equals(subCommand.getName())) {
                return this.listRootContainers();
            }
            if ("list-entry-containers".equals(subCommand.getName())) {
                return this.listEntryContainers(subCommand.getArgument("backendid"));
            }
            if ("list-database-containers".equals(subCommand.getName())) {
                return this.listDatabaseContainers(subCommand.getArgument("backendid"), subCommand.getArgument("basedn"));
            }
            if ("dump-database-container".equals(subCommand.getName())) {
                return this.dumpDatabaseContainer(subCommand.getArgument("backendid"), subCommand.getArgument("basedn"), subCommand.getArgument("databasename"), subCommand.getArgument("skipdecode"), subCommand.getArgument("statsonly"), subCommand.getArgument("maxkeyvalue"), subCommand.getArgument("minkeyvalue"), subCommand.getArgument("maxdatasize"), subCommand.getArgument("mindatasize"));
            }
            if ("list-index-status".equals(subCommand.getName())) {
                return this.listIndexStatus(subCommand.getArgument("backendid"), subCommand.getArgument("basedn"));
            }
            return 0;
        }
        catch (Exception e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToString((Throwable)e), (Object[])new Object[0]));
            return 1;
        }
    }

    private int listRootContainers() {
        Map<LocalDBBackendCfg, BackendImpl> jeBackends = DBTest.getJEBackends(null);
        int count = 0;
        TableBuilder builder = new TableBuilder();
        builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_BACKEND_ID.get());
        builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_DB_DIRECTORY.get());
        for (Map.Entry<LocalDBBackendCfg, BackendImpl> backend : jeBackends.entrySet()) {
            builder.startRow();
            builder.appendCell((Object)backend.getValue().getBackendID());
            builder.appendCell((Object)backend.getKey().getDBDirectory());
            ++count;
        }
        TextTablePrinter printer = new TextTablePrinter((OutputStream)this.out);
        builder.print((TablePrinter)printer);
        this.out.format("%nTotal: %d%n", count);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int listEntryContainers(Argument backendID) {
        RootContainer rc;
        BackendImpl backend = this.getBackendById(backendID);
        if (backend == null) {
            return 1;
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName((Backend)backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock((String)lockFile, (StringBuilder)failureReason)) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get((Object)backend.getBackendID(), (Object)failureReason));
                return 1;
            }
        }
        catch (Exception e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get((Object)backend.getBackendID(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
            return 1;
        }
        try {
            rc = backend.getReadOnlyRootContainer();
        }
        catch (Exception e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_ERROR_INITIALIZING_BACKEND.get((Object)backend.getBackendID(), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e)));
            return 1;
        }
        try {
            TableBuilder builder = new TableBuilder();
            int count = 0;
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_BASE_DN.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_JE_DATABASE_PREFIX.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_ENTRY_COUNT.get());
            for (EntryContainer ec : rc.getEntryContainers()) {
                builder.startRow();
                builder.appendCell((Object)ec.getBaseDN());
                builder.appendCell((Object)ec.getDatabasePrefix());
                builder.appendCell(ec.getEntryCount());
                ++count;
            }
            TextTablePrinter printer = new TextTablePrinter((OutputStream)this.out);
            builder.print((TablePrinter)printer);
            this.out.format("%nTotal: %d%n", count);
            int n = 0;
            return n;
        }
        catch (DatabaseException de) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_ERROR_READING_DATABASE.get((Object)StaticUtils.stackTraceToSingleLineString((Throwable)de)));
            int n = 1;
            return n;
        }
        finally {
            this.close(rc);
            this.releaseSharedLock(backend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int listDatabaseContainers(Argument backendID, Argument baseDN) {
        RootContainer rc;
        BackendImpl backend = this.getBackendById(backendID);
        if (backend == null) {
            return 1;
        }
        DN base = null;
        if (baseDN.isPresent()) {
            try {
                base = DN.valueOf((String)baseDN.getValue());
            }
            catch (DirectoryException de) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_DECODE_BASE_DN.get((Object)baseDN.getValue(), (Object)StaticUtils.getExceptionMessage((Throwable)de)));
                return 1;
            }
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName((Backend)backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock((String)lockFile, (StringBuilder)failureReason)) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get((Object)backend.getBackendID(), (Object)failureReason));
                return 1;
            }
        }
        catch (Exception e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get((Object)backend.getBackendID(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
            return 1;
        }
        try {
            rc = backend.getReadOnlyRootContainer();
        }
        catch (Exception e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_ERROR_INITIALIZING_BACKEND.get((Object)backend.getBackendID(), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e)));
            return 1;
        }
        try {
            TableBuilder builder = new TableBuilder();
            int count = 0;
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_DATABASE_NAME.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_DATABASE_TYPE.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_JE_DATABASE_NAME.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_ENTRY_COUNT.get());
            if (base != null) {
                EntryContainer ec = rc.getEntryContainer(base);
                if (ec == null) {
                    Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_NO_ENTRY_CONTAINERS_FOR_BASE_DN.get((Object)base, (Object)backend.getBackendID()));
                    int n = 1;
                    return n;
                }
                count = this.appendDatabaseContainerRows(builder, ec, count);
            } else {
                for (EntryContainer ec : rc.getEntryContainers()) {
                    builder.startRow();
                    builder.appendCell((Object)("Base DN: " + ec.getBaseDN()));
                    count = this.appendDatabaseContainerRows(builder, ec, count);
                }
            }
            TextTablePrinter printer = new TextTablePrinter((OutputStream)this.out);
            builder.print((TablePrinter)printer);
            this.out.format("%nTotal: %d%n", count);
            int n = 0;
            return n;
        }
        catch (DatabaseException de) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_ERROR_READING_DATABASE.get((Object)StaticUtils.stackTraceToSingleLineString((Throwable)de)));
            int n = 1;
            return n;
        }
        finally {
            this.close(rc);
            this.releaseSharedLock(backend);
        }
    }

    private int appendDatabaseContainerRows(TableBuilder builder, EntryContainer ec, int count) {
        ArrayList<DatabaseContainer> databaseContainers = new ArrayList<DatabaseContainer>();
        ec.listDatabases(databaseContainers);
        String toReplace = ec.getDatabasePrefix() + "_";
        for (DatabaseContainer dc : databaseContainers) {
            builder.startRow();
            builder.appendCell((Object)dc.getName().replace(toReplace, ""));
            builder.appendCell((Object)dc.getClass().getSimpleName());
            builder.appendCell((Object)dc.getName());
            builder.appendCell(dc.getRecordCount());
            ++count;
        }
        return count;
    }

    private void close(RootContainer rc) {
        try {
            rc.close();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    private void releaseSharedLock(BackendImpl backend) {
        try {
            String lockFile = LockFileManager.getBackendLockFileName((Backend)backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock((String)lockFile, (StringBuilder)failureReason)) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get((Object)backend.getBackendID(), (Object)failureReason));
            }
        }
        catch (Exception e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get((Object)backend.getBackendID(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
        }
    }

    private BackendImpl getBackendById(Argument backendId) {
        String backendID = backendId.getValue();
        ArrayList otherBackends = new ArrayList();
        Map<LocalDBBackendCfg, BackendImpl> jeBackends = DBTest.getJEBackends(otherBackends);
        for (BackendImpl backendImpl : jeBackends.values()) {
            if (!backendImpl.getBackendID().equalsIgnoreCase(backendID)) continue;
            return backendImpl;
        }
        for (Backend backend : otherBackends) {
            if (!backend.getBackendID().equalsIgnoreCase(backendID)) continue;
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_NOT_JE_BACKEND.get((Object)backendID));
            return null;
        }
        Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_NO_BACKENDS_FOR_ID.get((Object)backendID));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int listIndexStatus(Argument backendID, Argument baseDN) {
        RootContainer rc;
        BackendImpl backend = this.getBackendById(backendID);
        if (backend == null) {
            return 1;
        }
        DN base = null;
        if (baseDN.isPresent()) {
            try {
                base = DN.valueOf((String)baseDN.getValue());
            }
            catch (DirectoryException de) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_DECODE_BASE_DN.get((Object)baseDN.getValue(), (Object)StaticUtils.getExceptionMessage((Throwable)de)));
                return 1;
            }
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName((Backend)backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock((String)lockFile, (StringBuilder)failureReason)) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get((Object)backend.getBackendID(), (Object)failureReason));
                return 1;
            }
        }
        catch (Exception e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get((Object)backend.getBackendID(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
            return 1;
        }
        try {
            rc = backend.getReadOnlyRootContainer();
        }
        catch (Exception e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_ERROR_INITIALIZING_BACKEND.get((Object)backend.getBackendID(), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e)));
            return 1;
        }
        try {
            TableBuilder builder = new TableBuilder();
            int count = 0;
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_INDEX_NAME.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_INDEX_TYPE.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_JE_DATABASE_NAME.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_INDEX_STATUS.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_JE_RECORD_COUNT.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_INDEX_UNDEFINED_RECORD_COUNT.get());
            builder.appendHeading(LocalizableMessage.raw((CharSequence)"95%", (Object[])new Object[0]));
            builder.appendHeading(LocalizableMessage.raw((CharSequence)"90%", (Object[])new Object[0]));
            builder.appendHeading(LocalizableMessage.raw((CharSequence)"85%", (Object[])new Object[0]));
            EntryContainer ec = rc.getEntryContainer(base);
            if (ec == null) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_NO_ENTRY_CONTAINERS_FOR_BASE_DN.get((Object)base, (Object)backend.getBackendID()));
                int n = 1;
                return n;
            }
            ArrayList<DatabaseContainer> databaseContainers = new ArrayList<DatabaseContainer>();
            HashMap<Index, StringBuilder> undefinedKeys = new HashMap<Index, StringBuilder>();
            ec.listDatabases(databaseContainers);
            String toReplace = ec.getDatabasePrefix() + "_";
            for (DatabaseContainer dc : databaseContainers) {
                if (!(dc instanceof Index) && !(dc instanceof VLVIndex)) continue;
                builder.startRow();
                builder.appendCell((Object)dc.getName().replace(toReplace, ""));
                builder.appendCell((Object)dc.getClass().getSimpleName());
                builder.appendCell((Object)dc.getName());
                builder.appendCell(ec.getState().getIndexTrustState(null, dc));
                builder.appendCell(dc.getRecordCount());
                if (dc instanceof Index) {
                    Index index = (Index)dc;
                    long undefined = 0L;
                    long ninetyFive = 0L;
                    long ninety = 0L;
                    long eighty = 0L;
                    DatabaseEntry key = new DatabaseEntry();
                    DatabaseEntry data = new DatabaseEntry();
                    LockMode lockMode = LockMode.DEFAULT;
                    Cursor cursor = dc.openCursor(null, CursorConfig.DEFAULT);
                    OperationStatus status = cursor.getFirst(key, data, lockMode);
                    while (status == OperationStatus.SUCCESS) {
                        byte[] bytes = data.getData();
                        if (bytes.length == 0 || (bytes[0] & 0x80) == 128) {
                            ++undefined;
                            StringBuilder keyList = (StringBuilder)undefinedKeys.get(index);
                            if (keyList == null) {
                                keyList = new StringBuilder();
                                undefinedKeys.put(index, keyList);
                            } else {
                                keyList.append(" ");
                            }
                            if (index == ec.getID2Children() || index == ec.getID2Subtree()) {
                                keyList.append("[").append(JebFormat.entryIDFromDatabase(key.getData())).append("]");
                            } else {
                                keyList.append("[").append(new String(key.getData())).append("]");
                            }
                        } else {
                            double percentFull = (double)bytes.length / 8.0 / (double)index.getIndexEntryLimit();
                            if (percentFull >= 0.8) {
                                if (percentFull < 0.9) {
                                    ++eighty;
                                } else if (percentFull < 0.95) {
                                    ++ninety;
                                } else {
                                    ++ninetyFive;
                                }
                            }
                        }
                        status = cursor.getNext(key, data, lockMode);
                    }
                    builder.appendCell(undefined);
                    builder.appendCell(ninetyFive);
                    builder.appendCell(ninety);
                    builder.appendCell(eighty);
                    cursor.close();
                } else {
                    builder.appendCell((Object)"-");
                    builder.appendCell((Object)"-");
                    builder.appendCell((Object)"-");
                    builder.appendCell((Object)"-");
                }
                ++count;
            }
            TextTablePrinter printer = new TextTablePrinter((OutputStream)this.out);
            builder.print((TablePrinter)printer);
            this.out.format("%nTotal: %d%n", count);
            for (Map.Entry e : undefinedKeys.entrySet()) {
                this.out.format("%nIndex: %s%n", ((Index)e.getKey()).getName().replace(toReplace, ""));
                this.out.format("Undefined keys: %s%n", ((StringBuilder)e.getValue()).toString());
            }
            int n = 0;
            return n;
        }
        catch (DatabaseException de) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_ERROR_READING_DATABASE.get((Object)StaticUtils.stackTraceToSingleLineString((Throwable)de)));
            int n = 1;
            return n;
        }
        finally {
            this.close(rc);
            this.releaseSharedLock(backend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dumpDatabaseContainer(Argument backendID, Argument baseDN, Argument databaseName, Argument skipDecode, Argument statsOnly, Argument maxKeyValue, Argument minKeyValue, Argument maxDataSize, Argument minDataSize) {
        RootContainer rc;
        BackendImpl backend = this.getBackendById(backendID);
        if (backend == null) {
            return 1;
        }
        DN base = null;
        try {
            base = DN.valueOf((String)baseDN.getValue());
        }
        catch (DirectoryException de) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_DECODE_BASE_DN.get((Object)baseDN.getValue(), (Object)StaticUtils.getExceptionMessage((Throwable)de)));
            return 1;
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName((Backend)backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock((String)lockFile, (StringBuilder)failureReason)) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get((Object)backend.getBackendID(), (Object)failureReason));
                return 1;
            }
        }
        catch (Exception e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get((Object)backend.getBackendID(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
            return 1;
        }
        try {
            rc = backend.getReadOnlyRootContainer();
        }
        catch (Exception e) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_ERROR_INITIALIZING_BACKEND.get((Object)backend.getBackendID(), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e)));
            return 1;
        }
        try {
            EntryContainer ec = rc.getEntryContainer(base);
            if (ec == null) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_NO_ENTRY_CONTAINERS_FOR_BASE_DN.get((Object)base, (Object)backend.getBackendID()));
                int n = 1;
                return n;
            }
            DatabaseContainer databaseContainer = null;
            ArrayList<DatabaseContainer> databaseContainers = new ArrayList<DatabaseContainer>();
            ec.listDatabases(databaseContainers);
            String toReplace = ec.getDatabasePrefix() + "_";
            for (DatabaseContainer dc : databaseContainers) {
                if (!dc.getName().replace(toReplace, "").equalsIgnoreCase(databaseName.getValue())) continue;
                databaseContainer = dc;
                break;
            }
            if (databaseContainer == null) {
                Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_NO_DATABASE_CONTAINERS_FOR_NAME.get((Object)databaseName.getValue(), (Object)base, (Object)backend.getBackendID()));
                int i$ = 1;
                return i$;
            }
            int count = 0;
            long totalKeySize = 0L;
            long totalDataSize = 0L;
            int indent = 4;
            try (Cursor cursor = databaseContainer.openCursor(null, CursorConfig.DEFAULT);){
                OperationStatus status;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                LockMode lockMode = LockMode.DEFAULT;
                byte[] start = null;
                byte[] end = null;
                int minSize = -1;
                int maxSize = -1;
                if (maxDataSize.isPresent()) {
                    try {
                        maxSize = maxDataSize.getIntValue();
                    }
                    catch (Exception e) {
                        Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_DECODE_SIZE.get((Object)maxDataSize.getValue(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
                        int n = 1;
                        cursor.close();
                        this.close(rc);
                        this.releaseSharedLock(backend);
                        return n;
                    }
                }
                if (minDataSize.isPresent()) {
                    try {
                        minSize = minDataSize.getIntValue();
                    }
                    catch (Exception e) {
                        Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_DECODE_SIZE.get((Object)minDataSize.getValue(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
                        int n = 1;
                        cursor.close();
                        this.close(rc);
                        this.releaseSharedLock(backend);
                        return n;
                    }
                }
                if (minKeyValue.isPresent()) {
                    try {
                        start = this.parseKeyValue(minKeyValue.getValue(), databaseContainer);
                    }
                    catch (Exception e) {
                        Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_DECODE_KEY.get((Object)minKeyValue.getValue(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
                        int n = 1;
                        cursor.close();
                        this.close(rc);
                        this.releaseSharedLock(backend);
                        return n;
                    }
                }
                if (maxKeyValue.isPresent()) {
                    try {
                        end = this.parseKeyValue(maxKeyValue.getValue(), databaseContainer);
                    }
                    catch (Exception e) {
                        Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_CANNOT_DECODE_KEY.get((Object)maxKeyValue.getValue(), (Object)StaticUtils.getExceptionMessage((Throwable)e)));
                        int n = 1;
                        cursor.close();
                        this.close(rc);
                        this.releaseSharedLock(backend);
                        return n;
                    }
                }
                if (start != null) {
                    key.setData(start);
                    status = cursor.getSearchKey(key, data, lockMode);
                } else {
                    status = cursor.getFirst(key, data, lockMode);
                }
                String lineSep = System.getProperty("line.separator");
                while (status == OperationStatus.SUCCESS) {
                    if (minSize > 0 && data.getSize() < minSize || maxSize > 0 && data.getSize() > maxSize) {
                        status = cursor.getNext(key, data, lockMode);
                        continue;
                    }
                    if (end != null && this.getComparator(databaseContainer).compare(key.getData(), end) > 0) {
                        break;
                    }
                    if (!statsOnly.isPresent()) {
                        LocalizableMessage keyLabel = ToolMessages.INFO_LABEL_DBTEST_KEY.get();
                        LocalizableMessage dataLabel = ToolMessages.INFO_LABEL_DBTEST_DATA.get();
                        String formatedKey = null;
                        String formatedData = null;
                        if (!skipDecode.isPresent()) {
                            if (databaseContainer instanceof DN2ID) {
                                try {
                                    formatedKey = new String(key.getData()) + ec.getBaseDN();
                                    keyLabel = ToolMessages.INFO_LABEL_DBTEST_ENTRY_DN.get();
                                }
                                catch (Exception e) {
                                    Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_DECODE_FAIL.get((Object)StaticUtils.getExceptionMessage((Throwable)e)));
                                }
                                formatedData = String.valueOf(JebFormat.entryIDFromDatabase(data.getData()));
                                dataLabel = ToolMessages.INFO_LABEL_DBTEST_ENTRY_ID.get();
                            } else if (databaseContainer instanceof ID2Entry) {
                                formatedKey = String.valueOf(JebFormat.entryIDFromDatabase(key.getData()));
                                keyLabel = ToolMessages.INFO_LABEL_DBTEST_ENTRY_ID.get();
                                try {
                                    formatedData = lineSep + ID2Entry.entryFromDatabase(ByteString.wrap((byte[])data.getData()), ec.getRootContainer().getCompressedSchema()).toLDIFString();
                                    dataLabel = ToolMessages.INFO_LABEL_DBTEST_ENTRY.get();
                                }
                                catch (Exception e) {
                                    Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_DECODE_FAIL.get((Object)StaticUtils.getExceptionMessage((Throwable)e)));
                                }
                            } else if (databaseContainer instanceof DN2URI) {
                                try {
                                    formatedKey = new String(key.getData());
                                    keyLabel = ToolMessages.INFO_LABEL_DBTEST_ENTRY_DN.get();
                                }
                                catch (Exception e) {
                                    Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_DECODE_FAIL.get((Object)StaticUtils.getExceptionMessage((Throwable)e)));
                                }
                                formatedData = new String(key.getData());
                                dataLabel = ToolMessages.INFO_LABEL_DBTEST_URI.get();
                            } else if (databaseContainer instanceof Index) {
                                formatedKey = new String(key.getData());
                                keyLabel = ToolMessages.INFO_LABEL_DBTEST_INDEX_VALUE.get();
                                EntryIDSet idSet = new EntryIDSet(key.getData(), data.getData());
                                if (idSet.isDefined()) {
                                    int lineCount = 0;
                                    StringBuilder builder = new StringBuilder();
                                    for (EntryID entryID : idSet) {
                                        builder.append(entryID);
                                        if (lineCount == 10) {
                                            builder.append(lineSep);
                                            lineCount = 0;
                                            continue;
                                        }
                                        builder.append(" ");
                                        ++lineCount;
                                    }
                                    formatedData = builder.toString();
                                } else {
                                    formatedData = idSet.toString();
                                }
                                dataLabel = ToolMessages.INFO_LABEL_DBTEST_INDEX_ENTRY_ID_LIST.get();
                            } else if (databaseContainer instanceof VLVIndex) {
                                StringBuilder builder;
                                VLVIndex index = (VLVIndex)databaseContainer;
                                SortKey[] sortKeys = index.sortOrder.getSortKeys();
                                int pos = 0;
                                byte[] keyBytes = key.getData();
                                if (keyBytes.length > 0) {
                                    builder = new StringBuilder();
                                    for (SortKey sortKey : sortKeys) {
                                        int valueLength;
                                        if (keyBytes[pos++] != (valueLength = keyBytes[pos] & 0x7F)) {
                                            int numLengthBytes = valueLength;
                                            valueLength = 0;
                                            int k = 0;
                                            while (k < numLengthBytes) {
                                                valueLength = valueLength << 8 | keyBytes[pos] & 0xFF;
                                                ++k;
                                                ++pos;
                                            }
                                        }
                                        byte[] valueBytes = new byte[valueLength];
                                        System.arraycopy(keyBytes, pos, valueBytes, 0, valueLength);
                                        builder.append(sortKey.getAttributeType().getNameOrOID());
                                        builder.append(": ");
                                        if (valueBytes.length == 0) {
                                            builder.append("NULL");
                                        } else {
                                            builder.append(new String(valueBytes));
                                        }
                                        builder.append(" ");
                                        pos += valueLength;
                                    }
                                    byte[] entryIDBytes = new byte[8];
                                    System.arraycopy(keyBytes, pos, entryIDBytes, 0, entryIDBytes.length);
                                    long entryID = JebFormat.entryIDFromDatabase(entryIDBytes);
                                    formatedKey = lineSep + entryID + ": " + builder;
                                } else {
                                    formatedKey = "UNBOUNDED";
                                }
                                keyLabel = ToolMessages.INFO_LABEL_DBTEST_VLV_INDEX_LAST_SORT_KEYS.get();
                                try {
                                    builder = new StringBuilder();
                                    SortValuesSet svs = new SortValuesSet(key.getData(), data.getData(), index);
                                    long[] entryIDs = svs.getEntryIDs();
                                    for (int i = 0; i < entryIDs.length; ++i) {
                                        builder.append(entryIDs[i]);
                                        builder.append(": ");
                                        for (int j = 0; j < sortKeys.length; ++j) {
                                            SortKey sortKey = index.sortOrder.getSortKeys()[j];
                                            ByteString value = svs.getValue(i * sortKeys.length + j);
                                            builder.append(sortKey.getAttributeType().getNameOrOID());
                                            builder.append(": ");
                                            if (value == null) {
                                                builder.append("NULL");
                                            } else if (value.length() == 0) {
                                                builder.append("SIZE-EXCEEDED");
                                            } else {
                                                builder.append(value);
                                            }
                                            builder.append(" ");
                                        }
                                        builder.append(lineSep);
                                    }
                                    formatedData = lineSep + builder;
                                    dataLabel = ToolMessages.INFO_LABEL_DBTEST_INDEX_ENTRY_ID_LIST.get();
                                }
                                catch (Exception e) {
                                    Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_DECODE_FAIL.get((Object)StaticUtils.getExceptionMessage((Throwable)e)));
                                }
                            }
                        }
                        if (formatedKey == null) {
                            StringBuilder keyBuilder = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii((StringBuilder)keyBuilder, (byte[])key.getData(), (int)indent);
                            formatedKey = lineSep + keyBuilder;
                        }
                        if (formatedData == null) {
                            StringBuilder dataBuilder = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii((StringBuilder)dataBuilder, (byte[])data.getData(), (int)indent);
                            formatedData = lineSep + dataBuilder;
                        }
                        this.out.format("%s (%d bytes): %s%n", keyLabel, key.getData().length, formatedKey);
                        this.out.format("%s (%d bytes): %s%n%n", dataLabel, data.getData().length, formatedData);
                    }
                    status = cursor.getNext(key, data, lockMode);
                    ++count;
                    totalKeySize += (long)key.getData().length;
                    totalDataSize += (long)data.getData().length;
                }
            }
            this.out.format("%nTotal Records: %d%n", count);
            if (count > 0) {
                this.out.format("Total / Average Key Size: %d bytes / %d bytes%n", totalKeySize, totalKeySize / (long)count);
                this.out.format("Total / Average Data Size: %d bytes / %d bytes%n", totalDataSize, totalDataSize / (long)count);
            }
            int n = 0;
            return n;
        }
        catch (DatabaseException de) {
            Utils.printWrappedText((PrintStream)this.err, (LocalizableMessage)ToolMessages.ERR_DBTEST_ERROR_READING_DATABASE.get((Object)StaticUtils.stackTraceToSingleLineString((Throwable)de)));
            int n = 1;
            return n;
        }
        finally {
            this.close(rc);
            this.releaseSharedLock(backend);
        }
    }

    private byte[] parseKeyValue(String value, DatabaseContainer databaseContainer) throws ParseException, DirectoryException {
        if (value.startsWith("0x")) {
            return StaticUtils.hexStringToByteArray((String)value.substring(2));
        }
        if (databaseContainer instanceof DN2ID || databaseContainer instanceof DN2URI) {
            return DN.valueOf((String)value).toNormalizedByteString().toByteArray();
        }
        if (databaseContainer instanceof ID2Entry) {
            return JebFormat.entryIDToDatabase(Long.parseLong(value));
        }
        if (databaseContainer instanceof VLVIndex) {
            byte[] vBytes = StaticUtils.getBytes((String)value);
            ByteStringBuilder builder = new ByteStringBuilder();
            builder.appendBERLength(vBytes.length);
            builder.append(vBytes);
            return builder.toByteArray();
        }
        return StaticUtils.getBytes((String)value);
    }

    private Comparator<byte[]> getComparator(DatabaseContainer databaseContainer) {
        if (databaseContainer instanceof Index) {
            return ((Index)databaseContainer).getComparator();
        }
        if (databaseContainer instanceof VLVIndex) {
            return ((VLVIndex)databaseContainer).comparator;
        }
        return ByteSequence.BYTE_ARRAY_COMPARATOR;
    }

    private static Map<LocalDBBackendCfg, BackendImpl> getJEBackends(Collection<Backend<?>> otherBackends) {
        ArrayList backendList = new ArrayList();
        ArrayList entryList = new ArrayList();
        ArrayList dnList = new ArrayList();
        BackendToolUtils.getBackends(backendList, entryList, dnList);
        LinkedHashMap<LocalDBBackendCfg, BackendImpl> jeBackends = new LinkedHashMap<LocalDBBackendCfg, BackendImpl>();
        for (int i = 0; i < backendList.size(); ++i) {
            Backend backend = (Backend)backendList.get(i);
            if (backend instanceof BackendImpl) {
                jeBackends.put((LocalDBBackendCfg)entryList.get(i), (BackendImpl)backend);
                continue;
            }
            if (otherBackends == null) continue;
            otherBackends.add(backend);
        }
        return jeBackends;
    }
}

