/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.util.Reject;
import org.opends.messages.BackendMessages;
import org.opends.messages.UtilityMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.api.Backupable;
import org.opends.server.api.DiskSpaceMonitorHandler;
import org.opends.server.api.MonitorProvider;
import org.opends.server.backends.RebuildConfig;
import org.opends.server.backends.VerifyConfig;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.ConfigurableEnvironment;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EnvManager;
import org.opends.server.backends.jeb.ExportJob;
import org.opends.server.backends.jeb.Importer;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.VerifyJob;
import org.opends.server.backends.pluggable.spi.StorageStatus;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.ServerContext;
import org.opends.server.extensions.DiskSpaceMonitor;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IdentifiedException;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.RestoreConfig;
import org.opends.server.util.BackupManager;
import org.opends.server.util.CollectionUtils;
import org.opends.server.util.RuntimeInformation;
import org.opends.server.util.StaticUtils;

public class BackendImpl
extends Backend<LocalDBBackendCfg>
implements ConfigurationChangeListener<LocalDBBackendCfg>,
AlertGenerator,
DiskSpaceMonitorHandler,
Backupable {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private LocalDBBackendCfg cfg;
    private RootContainer rootContainer;
    private final AtomicInteger threadTotalCount = new AtomicInteger(0);
    private final AtomicInteger threadWriteCount = new AtomicInteger(0);
    private DN[] baseDNs;
    private MonitorProvider<?> rootContainerMonitor;
    private DiskSpaceMonitor diskMonitor;
    private StorageStatus storageStatus = StorageStatus.working();
    private static final Set<String> supportedControls = CollectionUtils.newHashSet((Object[])new String[]{"1.2.840.113556.1.4.805", "1.2.840.113556.1.4.319", "2.16.840.1.113730.3.4.2", "1.2.840.113556.1.4.473", "2.16.840.1.113730.3.4.9"});

    private void readerBegin() {
        this.threadTotalCount.getAndIncrement();
    }

    private void readerEnd() {
        this.threadTotalCount.getAndDecrement();
    }

    private void writerBegin() {
        this.threadTotalCount.getAndIncrement();
        this.threadWriteCount.getAndIncrement();
    }

    private void writerEnd() {
        this.threadWriteCount.getAndDecrement();
        this.threadTotalCount.getAndDecrement();
    }

    private void waitUntilQuiescent() {
        while (this.threadTotalCount.get() > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.traceException((Throwable)e);
            }
        }
    }

    public void configureBackend(LocalDBBackendCfg cfg, ServerContext serverContext) throws ConfigException {
        Reject.ifNull((Object)cfg);
        this.cfg = cfg;
        this.baseDNs = this.cfg.getBaseDN().toArray(new DN[0]);
        this.diskMonitor = serverContext.getDiskSpaceMonitor();
    }

    public void openBackend() throws ConfigException, InitializationException {
        if (this.mustOpenRootContainer()) {
            this.rootContainer = this.initializeRootContainer(ConfigurableEnvironment.parseConfigEntry(this.cfg));
        }
        this.rootContainer.preload(this.cfg.getPreloadTimeLimit());
        try {
            logger.info(BackendMessages.NOTE_BACKEND_STARTED, (Object)this.cfg.getBackendId(), (Object)this.rootContainer.getEntryCount());
        }
        catch (DatabaseException databaseException) {
            logger.traceException((Throwable)databaseException);
            throw new InitializationException(BackendMessages.WARN_GET_ENTRY_COUNT_FAILED.get((Object)databaseException.getMessage()), (Throwable)databaseException);
        }
        for (DN dn : this.cfg.getBaseDN()) {
            try {
                DirectoryServer.registerBaseDN((DN)dn, (Backend)this, (boolean)false);
            }
            catch (Exception e) {
                logger.traceException((Throwable)e);
                throw new InitializationException(BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get((Object)dn, (Object)e), (Throwable)e);
            }
        }
        this.rootContainerMonitor = this.rootContainer.getMonitorProvider();
        DirectoryServer.registerMonitorProvider(this.rootContainerMonitor);
        this.diskMonitor.registerMonitoredDirectory(this.getBackendID(), this.getDirectory(), this.cfg.getDiskLowThreshold(), this.cfg.getDiskFullThreshold(), (DiskSpaceMonitorHandler)this);
        DirectoryServer.registerAlertGenerator((AlertGenerator)this);
        this.cfg.addLocalDBChangeListener((ConfigurationChangeListener)this);
    }

    public File getDirectory() {
        File parentDirectory = StaticUtils.getFileForPath((String)this.cfg.getDBDirectory());
        return new File(parentDirectory, this.cfg.getBackendId());
    }

    public void closeBackend() {
        this.cfg.removeLocalDBChangeListener((ConfigurationChangeListener)this);
        for (DN dn : this.rootContainer.getBaseDNs()) {
            try {
                DirectoryServer.deregisterBaseDN((DN)dn);
            }
            catch (Exception e) {
                logger.traceException((Throwable)e);
            }
        }
        DirectoryServer.deregisterMonitorProvider(this.rootContainerMonitor);
        this.diskMonitor.deregisterMonitoredDirectory(this.getDirectory(), (DiskSpaceMonitorHandler)this);
        this.waitUntilQuiescent();
        try {
            this.rootContainer.close();
            this.rootContainer = null;
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            logger.error(BackendMessages.ERR_DATABASE_EXCEPTION, (Object)e.getMessage());
        }
        DirectoryServer.deregisterAlertGenerator((AlertGenerator)this);
        this.threadTotalCount.set(0);
        this.threadWriteCount.set(0);
        logger.info(BackendMessages.NOTE_BACKEND_OFFLINE, (Object)this.cfg.getBackendId());
    }

    public boolean isIndexed(AttributeType attributeType, IndexType indexType) {
        try {
            EntryContainer ec = this.rootContainer.getEntryContainer(this.baseDNs[0]);
            AttributeIndex ai = ec.getAttributeIndex(attributeType);
            if (ai == null) {
                return false;
            }
            SortedSet indexTypes = ai.getConfiguration().getIndexType();
            switch (indexType) {
                case PRESENCE: {
                    return indexTypes.contains(LocalDBIndexCfgDefn.IndexType.PRESENCE);
                }
                case EQUALITY: {
                    return indexTypes.contains(LocalDBIndexCfgDefn.IndexType.EQUALITY);
                }
                case SUBSTRING: 
                case SUBINITIAL: 
                case SUBANY: 
                case SUBFINAL: {
                    return indexTypes.contains(LocalDBIndexCfgDefn.IndexType.SUBSTRING);
                }
                case GREATER_OR_EQUAL: 
                case LESS_OR_EQUAL: {
                    return indexTypes.contains(LocalDBIndexCfgDefn.IndexType.ORDERING);
                }
                case APPROXIMATE: {
                    return indexTypes.contains(LocalDBIndexCfgDefn.IndexType.APPROXIMATE);
                }
            }
            return false;
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
            return false;
        }
    }

    public boolean supports(Backend.BackendOperation backendOperation) {
        return true;
    }

    public Set<String> getSupportedFeatures() {
        return Collections.emptySet();
    }

    public Set<String> getSupportedControls() {
        return supportedControls;
    }

    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    public long getEntryCount() {
        if (this.rootContainer != null) {
            try {
                return this.rootContainer.getEntryCount();
            }
            catch (Exception e) {
                logger.traceException((Throwable)e);
            }
        }
        return -1L;
    }

    public ConditionResult hasSubordinates(DN entryDN) throws DirectoryException {
        long ret = this.numSubordinates(entryDN, false);
        if (ret < 0L) {
            return ConditionResult.UNDEFINED;
        }
        return ConditionResult.valueOf((ret != 0L ? 1 : 0) != 0);
    }

    public long getNumberOfEntriesInBaseDN(DN baseDN) throws DirectoryException {
        Reject.checkNotNull((Object)baseDN, (String)"baseDN must not be null");
        EntryContainer ec = this.rootContainer.getEntryContainer(baseDN);
        if (ec == null || !ec.getBaseDN().equals((Object)baseDN)) {
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, BackendMessages.ERR_SEARCH_NO_SUCH_OBJECT.get((Object)baseDN));
        }
        return this.numSubordinates(baseDN, true);
    }

    public long getNumberOfChildren(DN parentDN) throws DirectoryException {
        Reject.checkNotNull((Object)parentDN, (String)"parentDN must not be null");
        return this.numSubordinates(parentDN, false);
    }

    private long numSubordinates(DN entryDN, boolean subtree) throws DirectoryException {
        this.checkRootContainerInitialized();
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        if (ec == null) {
            return -1L;
        }
        this.readerBegin();
        ec.sharedLock.lock();
        try {
            long count = ec.getNumSubordinates(entryDN, subtree);
            if (count == Long.MAX_VALUE) {
                long l = -1L;
                return l;
            }
            long l = count;
            return l;
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.readerEnd();
        }
    }

    public Entry getEntry(DN entryDN) throws DirectoryException {
        this.readerBegin();
        this.checkRootContainerInitialized();
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        ec.sharedLock.lock();
        try {
            Entry entry = ec.getEntry(entryDN);
            return entry;
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.readerEnd();
        }
    }

    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException, CanceledOperationException {
        this.checkDiskSpace((Operation)addOperation);
        this.writerBegin();
        this.checkRootContainerInitialized();
        EntryContainer ec = this.rootContainer.getEntryContainer(entry.getName());
        ec.sharedLock.lock();
        try {
            ec.addEntry(entry, addOperation);
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.writerEnd();
        }
    }

    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException, CanceledOperationException {
        this.checkDiskSpace((Operation)deleteOperation);
        this.writerBegin();
        this.checkRootContainerInitialized();
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        ec.sharedLock.lock();
        try {
            ec.deleteEntry(entryDN, deleteOperation);
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.writerEnd();
        }
    }

    public void replaceEntry(Entry oldEntry, Entry newEntry, ModifyOperation modifyOperation) throws DirectoryException, CanceledOperationException {
        this.checkDiskSpace((Operation)modifyOperation);
        this.writerBegin();
        this.checkRootContainerInitialized();
        EntryContainer ec = this.rootContainer.getEntryContainer(newEntry.getName());
        ec.sharedLock.lock();
        try {
            ec.replaceEntry(oldEntry, newEntry, modifyOperation);
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.writerEnd();
        }
    }

    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException, CanceledOperationException {
        this.checkDiskSpace((Operation)modifyDNOperation);
        this.writerBegin();
        this.checkRootContainerInitialized();
        EntryContainer currentContainer = this.rootContainer.getEntryContainer(currentDN);
        EntryContainer container = this.rootContainer.getEntryContainer(entry.getName());
        if (currentContainer != container) {
            LocalizableMessage msg = BackendMessages.WARN_FUNCTION_NOT_SUPPORTED.get();
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        currentContainer.sharedLock.lock();
        try {
            currentContainer.renameEntry(currentDN, entry, modifyDNOperation);
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            throw this.createDirectoryException(e);
        }
        finally {
            currentContainer.sharedLock.unlock();
            this.writerEnd();
        }
    }

    public void search(SearchOperation searchOperation) throws DirectoryException, CanceledOperationException {
        this.readerBegin();
        this.checkRootContainerInitialized();
        EntryContainer ec = this.rootContainer.getEntryContainer(searchOperation.getBaseDN());
        ec.sharedLock.lock();
        try {
            ec.search(searchOperation);
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            throw this.createDirectoryException(e);
        }
        finally {
            ec.sharedLock.unlock();
            this.readerEnd();
        }
    }

    private void checkRootContainerInitialized() throws DirectoryException {
        if (this.rootContainer == null) {
            LocalizableMessage msg = BackendMessages.ERR_ROOT_CONTAINER_NOT_INITIALIZED.get((Object)this.getBackendID());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), msg);
        }
    }

    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        boolean openRootContainer = this.mustOpenRootContainer();
        ResultCode errorRC = DirectoryServer.getServerErrorResultCode();
        try {
            if (openRootContainer) {
                this.rootContainer = this.getReadOnlyRootContainer();
            }
            ExportJob exportJob = new ExportJob(exportConfig);
            exportJob.exportLDIF(this.rootContainer);
        }
        catch (IOException ioe) {
            logger.traceException((Throwable)ioe);
            throw new DirectoryException(errorRC, BackendMessages.ERR_EXPORT_IO_ERROR.get((Object)ioe.getMessage()), (Throwable)ioe);
        }
        catch (DatabaseException de) {
            logger.traceException((Throwable)de);
            throw this.createDirectoryException(de);
        }
        catch (ConfigException ce) {
            throw new DirectoryException(errorRC, ce.getMessageObject(), (Throwable)ce);
        }
        catch (IdentifiedException e) {
            if (e instanceof DirectoryException) {
                throw (DirectoryException)((Object)e);
            }
            logger.traceException((Throwable)e);
            throw new DirectoryException(errorRC, e.getMessageObject(), (Throwable)e);
        }
        finally {
            this.closeTemporaryRootContainer(openRootContainer);
        }
    }

    private boolean mustOpenRootContainer() {
        return this.rootContainer == null;
    }

    public LDIFImportResult importLDIF(LDIFImportConfig importConfig, ServerContext serverContext) throws DirectoryException {
        RuntimeInformation.logInfo();
        boolean openRootContainer = this.rootContainer == null;
        ResultCode errorRC = DirectoryServer.getServerErrorResultCode();
        if (!openRootContainer) {
            throw new DirectoryException(errorRC, BackendMessages.ERR_IMPORT_BACKEND_ONLINE.get());
        }
        try {
            File parentDirectory;
            File backendDirectory;
            if (Importer.mustClearBackend(importConfig, this.cfg) && (backendDirectory = new File(parentDirectory = StaticUtils.getFileForPath((String)this.cfg.getDBDirectory()), this.cfg.getBackendId())).exists()) {
                EnvManager.removeFiles(backendDirectory.getPath());
            }
            EnvironmentConfig envConfig = this.getEnvConfigForImport();
            Importer importer = new Importer(importConfig, this.cfg, envConfig, serverContext);
            this.rootContainer = this.initializeRootContainer(envConfig);
            LDIFImportResult lDIFImportResult = importer.processImport(this.rootContainer);
            return lDIFImportResult;
        }
        catch (ExecutionException execEx) {
            logger.traceException((Throwable)execEx);
            if (execEx.getCause() instanceof DirectoryException) {
                throw (DirectoryException)execEx.getCause();
            }
            throw new DirectoryException(errorRC, BackendMessages.ERR_EXECUTION_ERROR.get((Object)execEx.getMessage()));
        }
        catch (InterruptedException intEx) {
            logger.traceException((Throwable)intEx);
            throw new DirectoryException(errorRC, BackendMessages.ERR_INTERRUPTED_ERROR.get((Object)intEx.getMessage()));
        }
        catch (ConfigException | JebException | InitializationException e) {
            logger.traceException((Throwable)e);
            throw new DirectoryException(errorRC, ((LocalizableException)e).getMessageObject());
        }
        finally {
            try {
                if (this.rootContainer != null) {
                    long startTime = System.currentTimeMillis();
                    this.rootContainer.close();
                    long finishTime = System.currentTimeMillis();
                    long closeTime = (finishTime - startTime) / 1000L;
                    logger.info(BackendMessages.NOTE_IMPORT_LDIF_ROOTCONTAINER_CLOSE, (Object)closeTime);
                    this.rootContainer = null;
                }
                logger.info(BackendMessages.NOTE_IMPORT_CLOSING_DATABASE);
            }
            catch (DatabaseException de) {
                logger.traceException((Throwable)de);
            }
        }
    }

    private EnvironmentConfig getEnvConfigForImport() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(false);
        envConfig.setDurability(Durability.COMMIT_NO_SYNC);
        envConfig.setLockTimeout(0L, TimeUnit.SECONDS);
        envConfig.setTxnTimeout(0L, TimeUnit.SECONDS);
        envConfig.setConfigParam("je.cleaner.minFileUtilization", String.valueOf(this.cfg.getDBCleanerMinUtilization()));
        envConfig.setConfigParam("je.log.fileMax", String.valueOf(this.cfg.getDBLogFileMax()));
        return envConfig;
    }

    public long verifyBackend(VerifyConfig verifyConfig) throws InitializationException, ConfigException, DirectoryException {
        boolean openRootContainer = this.mustOpenRootContainer();
        try {
            if (openRootContainer) {
                this.rootContainer = this.getReadOnlyRootContainer();
            }
            VerifyJob verifyJob = new VerifyJob(verifyConfig);
            long l = verifyJob.verifyBackend(this.rootContainer);
            return l;
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            throw this.createDirectoryException(e);
        }
        catch (JebException e) {
            logger.traceException((Throwable)((Object)e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        finally {
            this.closeTemporaryRootContainer(openRootContainer);
        }
    }

    public void rebuildBackend(RebuildConfig rebuildConfig, ServerContext serverContext) throws InitializationException, ConfigException, DirectoryException {
        boolean openRootContainer = this.mustOpenRootContainer();
        ResultCode errorRC = DirectoryServer.getServerErrorResultCode();
        if (!openRootContainer && rebuildConfig.includesSystemIndex()) {
            throw new DirectoryException(errorRC, BackendMessages.ERR_REBUILD_BACKEND_ONLINE.get());
        }
        try {
            EnvironmentConfig envConfig;
            if (openRootContainer) {
                envConfig = this.getEnvConfigForImport();
                this.rootContainer = this.initializeRootContainer(envConfig);
            } else {
                envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
            }
            Importer importer = new Importer(rebuildConfig, this.cfg, envConfig, serverContext);
            importer.rebuildIndexes(this.rootContainer);
        }
        catch (ExecutionException execEx) {
            logger.traceException((Throwable)execEx);
            throw new DirectoryException(errorRC, BackendMessages.ERR_EXECUTION_ERROR.get((Object)execEx.getMessage()));
        }
        catch (InterruptedException intEx) {
            logger.traceException((Throwable)intEx);
            throw new DirectoryException(errorRC, BackendMessages.ERR_INTERRUPTED_ERROR.get((Object)intEx.getMessage()));
        }
        catch (ConfigException | JebException e) {
            logger.traceException((Throwable)e);
            throw new DirectoryException(errorRC, ((LocalizableException)e).getMessageObject());
        }
        catch (InitializationException e) {
            logger.traceException((Throwable)e);
            throw new InitializationException(e.getMessageObject());
        }
        finally {
            this.closeTemporaryRootContainer(openRootContainer);
        }
    }

    private void closeTemporaryRootContainer(boolean openRootContainer) {
        if (openRootContainer && this.rootContainer != null) {
            try {
                this.rootContainer.close();
                this.rootContainer = null;
            }
            catch (DatabaseException e) {
                logger.traceException((Throwable)e);
            }
        }
    }

    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        new BackupManager(this.getBackendID()).createBackup((Backupable)this, backupConfig);
    }

    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        new BackupManager(this.getBackendID()).removeBackup(backupDirectory, backupID);
    }

    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        new BackupManager(this.getBackendID()).restoreBackup((Backupable)this, restoreConfig);
    }

    public ListIterator<Path> getFilesToBackup() throws DirectoryException {
        return new JELogFilesIterator(this.getDirectory(), this.cfg.getBackendId());
    }

    public boolean isDirectRestore() {
        return false;
    }

    public Path beforeRestore() throws DirectoryException {
        return null;
    }

    public void afterRestore(Path restoreDirectory, Path saveDirectory) throws DirectoryException {
        File targetDirectory = this.getDirectory();
        StaticUtils.recursiveDelete((File)targetDirectory);
        try {
            Files.move(restoreDirectory, targetDirectory.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            LocalizableMessage msg = UtilityMessages.ERR_CANNOT_RENAME_RESTORE_DIRECTORY.get((Object)restoreDirectory, (Object)targetDirectory.getPath());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), msg);
        }
    }

    public boolean isConfigurationAcceptable(LocalDBBackendCfg config, List<LocalizableMessage> unacceptableReasons, ServerContext serverContext) {
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    public boolean isConfigurationChangeAcceptable(LocalDBBackendCfg cfg, List<LocalizableMessage> unacceptableReasons) {
        try {
            Level.parse(cfg.getDBLoggingLevel());
            return true;
        }
        catch (Exception e) {
            unacceptableReasons.add(BackendMessages.ERR_JEB_INVALID_LOGGING_LEVEL.get((Object)cfg.getDBLoggingLevel(), (Object)cfg.dn()));
            return false;
        }
    }

    public ConfigChangeResult applyConfigurationChange(LocalDBBackendCfg newCfg) {
        ConfigChangeResult ccr = new ConfigChangeResult();
        try {
            if (this.rootContainer != null) {
                SortedSet newBaseDNs = newCfg.getBaseDN();
                DN[] newBaseDNsArray = newBaseDNs.toArray(new DN[newBaseDNs.size()]);
                this.removeDeletedBaseDNs(newBaseDNs);
                ConfigChangeResult failure = this.createNewBaseDNs(newBaseDNsArray, ccr);
                if (failure != null) {
                    return failure;
                }
                this.baseDNs = newBaseDNsArray;
            }
            this.updateDiskMonitor(this.diskMonitor, newCfg);
            this.cfg = newCfg;
        }
        catch (Exception e) {
            ccr.addMessage(LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToSingleLineString((Throwable)e), (Object[])new Object[0]));
            ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
        }
        return ccr;
    }

    private void updateDiskMonitor(DiskSpaceMonitor dm, LocalDBBackendCfg newCfg) {
        this.diskMonitor.registerMonitoredDirectory(this.getBackendID(), this.getDirectory(), newCfg.getDiskLowThreshold(), newCfg.getDiskFullThreshold(), (DiskSpaceMonitorHandler)this);
    }

    private void removeDeletedBaseDNs(SortedSet<DN> newBaseDNs) throws DirectoryException {
        for (DN baseDN : this.cfg.getBaseDN()) {
            if (newBaseDNs.contains(baseDN)) continue;
            DirectoryServer.deregisterBaseDN((DN)baseDN);
            EntryContainer ec = this.rootContainer.unregisterEntryContainer(baseDN);
            ec.close();
            ec.delete();
        }
    }

    private ConfigChangeResult createNewBaseDNs(DN[] newBaseDNsArray, ConfigChangeResult ccr) {
        for (DN baseDN : newBaseDNsArray) {
            if (this.rootContainer.getBaseDNs().contains(baseDN)) continue;
            try {
                EntryContainer ec = this.rootContainer.openEntryContainer(baseDN, null);
                this.rootContainer.registerEntryContainer(baseDN, ec);
                DirectoryServer.registerBaseDN((DN)baseDN, (Backend)this, (boolean)false);
            }
            catch (Exception e) {
                logger.traceException((Throwable)e);
                ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
                ccr.addMessage(BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get((Object)baseDN, (Object)e));
                return ccr;
            }
        }
        return null;
    }

    public RootContainer getRootContainer() {
        return this.rootContainer;
    }

    public RootContainer getReadOnlyRootContainer() throws ConfigException, InitializationException {
        EnvironmentConfig envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
        envConfig.setReadOnly(true);
        envConfig.setAllowCreate(false);
        envConfig.setTransactional(false);
        envConfig.setConfigParam("je.env.isLocking", "true");
        envConfig.setConfigParam("je.env.runCheckpointer", "true");
        return this.initializeRootContainer(envConfig);
    }

    public void clearBackend() throws ConfigException, JebException {
        File parentDirectory = StaticUtils.getFileForPath((String)this.cfg.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.cfg.getBackendId());
        EnvManager.removeFiles(backendDirectory.getPath());
    }

    private DirectoryException createDirectoryException(DatabaseException e) {
        String jeMessage;
        if (e instanceof EnvironmentFailureException && !this.rootContainer.isValid()) {
            LocalizableMessage message = BackendMessages.NOTE_BACKEND_ENVIRONMENT_UNUSABLE.get((Object)this.getBackendID());
            logger.info(message);
            DirectoryServer.sendAlertNotification((AlertGenerator)DirectoryServer.getInstance(), (String)"org.opends.server.BackendRunRecovery", (LocalizableMessage)message);
        }
        if ((jeMessage = e.getMessage()) == null) {
            jeMessage = StaticUtils.stackTraceToSingleLineString((Throwable)e);
        }
        LocalizableMessage message = BackendMessages.ERR_DATABASE_EXCEPTION.get((Object)jeMessage);
        return new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, (Throwable)e);
    }

    public String getClassName() {
        return BackendImpl.class.getName();
    }

    public Map<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.BackendRunRecovery", "This alert type will be used to provide notification that the JE backend throws a RunRecoveryException and Directory Server needs to be restarted.");
        alerts.put("org.opends.server.DiskSpaceLow", "This alert type will be used to provide notification that the free disk space has reached the low threshold.");
        alerts.put("org.opends.server.DiskFull", "This alert type will be used to provide notification that the free disk space has reached the full threshold.");
        return alerts;
    }

    public DN getComponentEntryDN() {
        return this.cfg.dn();
    }

    private RootContainer initializeRootContainer(EnvironmentConfig envConfig) throws ConfigException, InitializationException {
        try {
            RootContainer rc = new RootContainer(this, this.cfg);
            rc.open(envConfig);
            return rc;
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
            LocalizableMessage message = BackendMessages.ERR_OPEN_ENV_FAIL.get((Object)e.getMessage());
            throw new InitializationException(message, (Throwable)e);
        }
    }

    public void diskLowThresholdReached(File directory, long thresholdInBytes) {
        this.storageStatus = StorageStatus.lockedDown((LocalizableMessage)BackendMessages.WARN_DISK_SPACE_LOW_THRESHOLD_CROSSED.get((Object)directory.getFreeSpace(), (Object)directory.getAbsolutePath(), (Object)thresholdInBytes, (Object)this.getBackendID()));
    }

    public void diskFullThresholdReached(File directory, long thresholdInBytes) {
        this.storageStatus = StorageStatus.unusable((LocalizableMessage)BackendMessages.WARN_DISK_SPACE_FULL_THRESHOLD_CROSSED.get((Object)directory.getFreeSpace(), (Object)directory.getAbsolutePath(), (Object)thresholdInBytes, (Object)this.getBackendID()));
    }

    public void diskSpaceRestored(File directory, long lowThresholdInBytes, long fullThresholdInBytes) {
        this.storageStatus = StorageStatus.working();
    }

    private void checkDiskSpace(Operation operation) throws DirectoryException {
        if (this.storageStatus.isUnusable() || this.storageStatus.isLockedDown() && operation != null && !operation.getClientConnection().hasPrivilege(Privilege.BYPASS_LOCKDOWN, operation)) {
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, BackendMessages.WARN_OUT_OF_DISK_SPACE.get());
        }
    }

    private static class JELogFileFilter
    implements FileFilter {
        private final String latestFilename;
        private final long latestFileSize;

        JELogFileFilter(String latestFilename, long latestFileSize) {
            this.latestFilename = latestFilename;
            this.latestFileSize = latestFileSize;
        }

        JELogFileFilter() {
            this("", 0L);
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            int cmp = name.compareTo(this.latestFilename);
            return name.endsWith(".jdb") && (cmp > 0 || cmp == 0 && file.length() > this.latestFileSize);
        }
    }

    static class JELogFilesIterator
    implements ListIterator<Path> {
        private ListIterator<Path> iterator;
        private final File rootDirectory;
        private final String backendID;
        private List<Path> files;
        private String lastFileName = "";
        private long lastFileSize;

        JELogFilesIterator(File rootDirectory, String backendID) throws DirectoryException {
            this.rootDirectory = rootDirectory;
            this.backendID = backendID;
            this.setFiles(BackupManager.getFiles((File)rootDirectory, (FileFilter)new JELogFileFilter(), (String)backendID));
        }

        private void setFiles(List<Path> files) {
            this.files = files;
            Collections.sort(files);
            if (!files.isEmpty()) {
                Path lastFile = files.get(files.size() - 1);
                this.lastFileName = lastFile.getFileName().toString();
                this.lastFileSize = lastFile.toFile().length();
            }
            this.iterator = files.listIterator();
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.iterator.hasNext();
            if (!hasNext && !this.files.isEmpty()) {
                try {
                    List allFiles = BackupManager.getFiles((File)this.rootDirectory, (FileFilter)new JELogFileFilter(), (String)this.backendID);
                    ArrayList<Path> compare = new ArrayList<Path>(this.files);
                    compare.removeAll(allFiles);
                    if (!compare.isEmpty()) {
                        List newFiles = BackupManager.getFiles((File)this.rootDirectory, (FileFilter)new JELogFileFilter(this.lastFileName, this.lastFileSize), (String)this.backendID);
                        logger.info(BackendMessages.NOTE_JEB_BACKUP_CLEANER_ACTIVITY.get((Object)newFiles.size()));
                        if (!newFiles.isEmpty()) {
                            this.setFiles(newFiles);
                            hasNext = this.iterator.hasNext();
                        }
                    }
                }
                catch (DirectoryException e) {
                    logger.error(BackendMessages.ERR_BACKEND_LIST_FILES_TO_BACKUP.get((Object)this.backendID, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e)));
                }
            }
            return hasNext;
        }

        @Override
        public Path next() {
            if (this.hasNext()) {
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public Path previous() {
            return this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not implemented");
        }

        @Override
        public void set(Path e) {
            throw new UnsupportedOperationException("set() is not implemented");
        }

        @Override
        public void add(Path e) {
            throw new UnsupportedOperationException("add() is not implemented");
        }
    }
}

