/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.Schema;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

public final class AttributeIndexer
extends Indexer {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final AttributeType attributeType;
    private final org.forgerock.opendj.ldap.spi.Indexer indexer;

    public AttributeIndexer(AttributeType attributeType, org.forgerock.opendj.ldap.spi.Indexer extensibleIndexer) {
        this.attributeType = attributeType;
        this.indexer = extensibleIndexer;
    }

    @Override
    public String toString() {
        return this.attributeType.getNameOrOID() + "." + this.indexer.getIndexID();
    }

    @Override
    public void indexEntry(Entry entry, Set<ByteString> keys) {
        List attrList = entry.getAttribute(this.attributeType);
        if (attrList != null) {
            this.indexAttribute(attrList, keys);
        }
    }

    @Override
    public void modifyEntry(Entry oldEntry, Entry newEntry, List<Modification> mods, Map<ByteString, Boolean> modifiedKeys) {
        List newAttributes = newEntry.getAttribute(this.attributeType, true);
        List oldAttributes = oldEntry.getAttribute(this.attributeType, true);
        this.indexAttribute(oldAttributes, modifiedKeys, false);
        this.indexAttribute(newAttributes, modifiedKeys, true);
    }

    private void indexAttribute(List<Attribute> attrList, Set<ByteString> keys) {
        if (attrList == null) {
            return;
        }
        for (Attribute attr : attrList) {
            if (attr.isVirtual()) continue;
            for (ByteString value : attr) {
                try {
                    this.indexer.createKeys(Schema.getDefaultSchema(), (ByteSequence)value, keys);
                }
                catch (DecodeException e) {
                    logger.traceException((Throwable)e);
                }
            }
        }
    }

    private void indexAttribute(List<Attribute> attrList, Map<ByteString, Boolean> modifiedKeys, Boolean insert) {
        if (attrList == null) {
            return;
        }
        HashSet<ByteString> keys = new HashSet<ByteString>();
        this.indexAttribute(attrList, keys);
        AttributeIndexer.computeModifiedKeys(modifiedKeys, insert, keys);
    }

    private static void computeModifiedKeys(Map<ByteString, Boolean> modifiedKeys, Boolean insert, Set<ByteString> keys) {
        for (ByteString key : keys) {
            Boolean cInsert = modifiedKeys.get(key);
            if (cInsert == null) {
                modifiedKeys.put(key, insert);
                continue;
            }
            if (cInsert.equals(insert)) continue;
            modifiedKeys.remove(key);
        }
    }
}

