/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.forgerock.opendj.ldap.spi.IndexingOptions;
import org.forgerock.util.Utils;
import org.opends.messages.BackendMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.admin.std.server.LocalDBIndexCfg;
import org.opends.server.backends.jeb.AttributeIndexer;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.DatabaseEnvironmentMonitor;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexBuffer;
import org.opends.server.backends.jeb.IndexQuery;
import org.opends.server.backends.jeb.IndexQueryFactoryImpl;
import org.opends.server.backends.jeb.PresenceIndexer;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.FilterType;
import org.opends.server.types.Modification;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

public class AttributeIndex
implements ConfigurationChangeListener<LocalDBIndexCfg>,
Closeable {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final EntryContainer entryContainer;
    private LocalDBIndexCfg indexConfig;
    private IndexingOptions indexingOptions;
    private Map<String, Index> indexIdToIndexes;
    private IndexQueryFactory<IndexQuery> indexQueryFactory;

    public AttributeIndex(LocalDBIndexCfg indexConfig, EntryContainer entryContainer) throws ConfigException {
        this.entryContainer = entryContainer;
        this.indexConfig = indexConfig;
        this.indexingOptions = new JEIndexingOptions(indexConfig.getSubstringLength());
        this.indexIdToIndexes = Collections.unmodifiableMap(AttributeIndex.buildIndexes(entryContainer, indexConfig, this.indexingOptions));
        this.indexQueryFactory = new IndexQueryFactoryImpl(this.indexIdToIndexes, this.indexingOptions, indexConfig.getAttribute());
    }

    private static Map<String, Index> buildIndexes(EntryContainer entryContainer, LocalDBIndexCfg config, IndexingOptions options) throws ConfigException {
        HashMap<String, Index> indexes = new HashMap<String, Index>();
        AttributeType attributeType = config.getAttribute();
        int indexEntryLimit = config.getIndexEntryLimit();
        for (LocalDBIndexCfgDefn.IndexType indexType : config.getIndexType()) {
            List indexers;
            switch (indexType) {
                case PRESENCE: {
                    indexes.put(indexType.toString(), AttributeIndex.newPresenceIndex(entryContainer, config));
                    indexers = Collections.emptyList();
                    break;
                }
                case EXTENSIBLE: {
                    indexers = AttributeIndex.getExtensibleIndexers(config.getAttribute(), config.getIndexExtensibleMatchingRule(), options);
                    break;
                }
                case APPROXIMATE: {
                    indexers = AttributeIndex.throwIfNoMatchingRule(attributeType, indexType, attributeType.getApproximateMatchingRule()).createIndexers(options);
                    break;
                }
                case EQUALITY: {
                    indexers = AttributeIndex.throwIfNoMatchingRule(attributeType, indexType, attributeType.getEqualityMatchingRule()).createIndexers(options);
                    break;
                }
                case ORDERING: {
                    indexers = AttributeIndex.throwIfNoMatchingRule(attributeType, indexType, attributeType.getOrderingMatchingRule()).createIndexers(options);
                    break;
                }
                case SUBSTRING: {
                    indexers = AttributeIndex.throwIfNoMatchingRule(attributeType, indexType, attributeType.getSubstringMatchingRule()).createIndexers(options);
                    break;
                }
                default: {
                    throw new ConfigException(BackendMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get((Object)attributeType, (Object)indexType.toString()));
                }
            }
            AttributeIndex.buildAndRegisterIndexesWithIndexers(entryContainer, attributeType, indexEntryLimit, indexers, indexes);
        }
        return indexes;
    }

    private static Index newPresenceIndex(EntryContainer entryContainer, LocalDBIndexCfg cfg) {
        AttributeType attrType = cfg.getAttribute();
        String indexName = AttributeIndex.getIndexName(entryContainer, attrType, LocalDBIndexCfgDefn.IndexType.PRESENCE.toString());
        PresenceIndexer indexer = new PresenceIndexer(attrType);
        return entryContainer.newIndexForAttribute(indexName, indexer, cfg.getIndexEntryLimit());
    }

    private static MatchingRule throwIfNoMatchingRule(AttributeType attributeType, LocalDBIndexCfgDefn.IndexType type, MatchingRule rule) throws ConfigException {
        if (rule == null) {
            throw new ConfigException(BackendMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get((Object)attributeType, (Object)type.toString()));
        }
        return rule;
    }

    private static void buildAndRegisterIndexesWithIndexers(EntryContainer entryContainer, AttributeType attributeType, int indexEntryLimit, Collection<? extends Indexer> indexers, Map<String, Index> indexes) {
        for (Indexer indexer : indexers) {
            String indexID = indexer.getIndexID();
            if (indexes.containsKey(indexID)) continue;
            Index index = AttributeIndex.newAttributeIndex(entryContainer, attributeType, indexer, indexEntryLimit);
            indexes.put(indexID, index);
        }
    }

    private static Collection<Indexer> getExtensibleIndexers(AttributeType attributeType, Set<String> extensibleRules, IndexingOptions options) throws ConfigException {
        if (extensibleRules == null || extensibleRules.isEmpty()) {
            throw new ConfigException(BackendMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get((Object)attributeType, (Object)LocalDBIndexCfgDefn.IndexType.EXTENSIBLE.toString()));
        }
        ArrayList<Indexer> indexers = new ArrayList<Indexer>();
        for (String ruleName : extensibleRules) {
            MatchingRule rule = DirectoryServer.getMatchingRule((String)StaticUtils.toLowerCase((String)ruleName));
            if (rule == null) {
                logger.error(BackendMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_VALID_MATCHING_RULE, (Object)attributeType, (Object)ruleName);
                continue;
            }
            indexers.addAll(rule.createIndexers(options));
        }
        return indexers;
    }

    private static MatchingRule getMatchingRule(LocalDBIndexCfgDefn.IndexType indexType, AttributeType attrType) {
        switch (indexType) {
            case APPROXIMATE: {
                return attrType.getApproximateMatchingRule();
            }
            case EQUALITY: {
                return attrType.getEqualityMatchingRule();
            }
            case ORDERING: {
                return attrType.getOrderingMatchingRule();
            }
            case SUBSTRING: {
                return attrType.getSubstringMatchingRule();
            }
        }
        throw new IllegalArgumentException("Not implemented for index type " + indexType);
    }

    private static Index newAttributeIndex(EntryContainer entryContainer, AttributeType attributeType, Indexer indexer, int indexEntryLimit) {
        String indexName = AttributeIndex.getIndexName(entryContainer, attributeType, indexer.getIndexID());
        AttributeIndexer attrIndexer = new AttributeIndexer(attributeType, indexer);
        return entryContainer.newIndexForAttribute(indexName, attrIndexer, indexEntryLimit);
    }

    private static String getIndexName(EntryContainer entryContainer, AttributeType attrType, String indexID) {
        return entryContainer.getDatabasePrefix() + "_" + attrType.getNameOrOID() + "." + indexID;
    }

    public void open() throws DatabaseException {
        for (Index index : this.indexIdToIndexes.values()) {
            index.open();
        }
        this.indexConfig.addChangeListener((ConfigurationChangeListener)this);
    }

    @Override
    public void close() {
        Utils.closeSilently(this.indexIdToIndexes.values());
        this.indexConfig.removeChangeListener((ConfigurationChangeListener)this);
    }

    public AttributeType getAttributeType() {
        return this.indexConfig.getAttribute();
    }

    public IndexingOptions getIndexingOptions() {
        return this.indexQueryFactory.getIndexingOptions();
    }

    public LocalDBIndexCfg getConfiguration() {
        return this.indexConfig;
    }

    public void addEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        for (Index index : this.indexIdToIndexes.values()) {
            index.addEntry(buffer, entryID, entry);
        }
    }

    public void removeEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        for (Index index : this.indexIdToIndexes.values()) {
            index.removeEntry(buffer, entryID, entry);
        }
    }

    public void modifyEntry(IndexBuffer buffer, EntryID entryID, Entry oldEntry, Entry newEntry, List<Modification> mods) throws DatabaseException {
        for (Index index : this.indexIdToIndexes.values()) {
            index.modifyEntry(buffer, entryID, oldEntry, newEntry, mods);
        }
    }

    private static ByteString makeSubstringKey(byte[] bytes, int pos, int len) {
        byte[] keyBytes = new byte[len];
        System.arraycopy(bytes, pos, keyBytes, 0, len);
        return ByteString.wrap((byte[])keyBytes);
    }

    Set<ByteString> substringKeys(byte[] value) {
        HashSet<ByteString> set = new HashSet<ByteString>();
        int substrLength = this.indexConfig.getSubstringLength();
        int i = 0;
        for (int remain = value.length; remain > 0; --remain) {
            int len = Math.min(substrLength, remain);
            set.add(AttributeIndex.makeSubstringKey(value, i, len));
            ++i;
        }
        return set;
    }

    private EntryIDSet evaluateIndexQuery(IndexQuery indexQuery, String indexName, SearchFilter filter, StringBuilder debugBuffer, DatabaseEnvironmentMonitor monitor) {
        LocalizableMessageBuilder debugMessage = monitor.isFilterUseEnabled() ? new LocalizableMessageBuilder() : null;
        EntryIDSet results = indexQuery.evaluate(debugMessage);
        if (debugBuffer != null) {
            debugBuffer.append("[INDEX:").append(this.indexConfig.getAttribute().getNameOrOID()).append(".").append(indexName).append("]");
        }
        if (monitor.isFilterUseEnabled()) {
            if (results.isDefined()) {
                monitor.updateStats(filter, results.size());
            } else {
                monitor.updateStats(filter, debugMessage.toMessage());
            }
        }
        return results;
    }

    public EntryIDSet evaluateBoundedRange(SearchFilter filter1, SearchFilter filter2, StringBuilder debugBuffer, DatabaseEnvironmentMonitor monitor) {
        StringBuilder tmpBuff1 = debugBuffer != null ? new StringBuilder() : null;
        StringBuilder tmpBuff2 = debugBuffer != null ? new StringBuilder() : null;
        EntryIDSet results1 = this.evaluate(filter1, tmpBuff1, monitor);
        EntryIDSet results2 = this.evaluate(filter2, tmpBuff2, monitor);
        if (debugBuffer != null) {
            debugBuffer.append(filter1).append((CharSequence)tmpBuff1).append(results1).append(filter2).append((CharSequence)tmpBuff2).append(results2);
        }
        results1.retainAll(results2);
        return results1;
    }

    private EntryIDSet evaluate(SearchFilter filter, StringBuilder debugBuffer, DatabaseEnvironmentMonitor monitor) {
        boolean isLessOrEqual = filter.getFilterType() == FilterType.LESS_OR_EQUAL;
        IndexFilterType indexFilterType = isLessOrEqual ? IndexFilterType.LESS_OR_EQUAL : IndexFilterType.GREATER_OR_EQUAL;
        return this.evaluateFilter(indexFilterType, filter, debugBuffer, monitor);
    }

    public EntryIDSet evaluateFilter(IndexFilterType indexFilterType, SearchFilter filter, StringBuilder debugBuffer, DatabaseEnvironmentMonitor monitor) {
        try {
            IndexQuery indexQuery = this.getIndexQuery(indexFilterType, filter);
            return this.evaluateIndexQuery(indexQuery, indexFilterType.toString(), filter, debugBuffer, monitor);
        }
        catch (DecodeException e) {
            logger.traceException((Throwable)e);
            return new EntryIDSet();
        }
    }

    private IndexQuery getIndexQuery(IndexFilterType indexFilterType, SearchFilter filter) throws DecodeException {
        switch (indexFilterType) {
            case EQUALITY: {
                MatchingRule rule = filter.getAttributeType().getEqualityMatchingRule();
                Assertion assertion = rule.getAssertion((ByteSequence)filter.getAssertionValue());
                return (IndexQuery)assertion.createIndexQuery(this.indexQueryFactory);
            }
            case PRESENCE: {
                return (IndexQuery)this.indexQueryFactory.createMatchAllQuery();
            }
            case GREATER_OR_EQUAL: {
                MatchingRule rule = filter.getAttributeType().getOrderingMatchingRule();
                Assertion assertion = rule.getGreaterOrEqualAssertion((ByteSequence)filter.getAssertionValue());
                return (IndexQuery)assertion.createIndexQuery(this.indexQueryFactory);
            }
            case LESS_OR_EQUAL: {
                MatchingRule rule = filter.getAttributeType().getOrderingMatchingRule();
                Assertion assertion = rule.getLessOrEqualAssertion((ByteSequence)filter.getAssertionValue());
                return (IndexQuery)assertion.createIndexQuery(this.indexQueryFactory);
            }
            case SUBSTRING: {
                MatchingRule rule = filter.getAttributeType().getSubstringMatchingRule();
                Assertion assertion = rule.getSubstringAssertion((ByteSequence)filter.getSubInitialElement(), filter.getSubAnyElements(), (ByteSequence)filter.getSubFinalElement());
                return (IndexQuery)assertion.createIndexQuery(this.indexQueryFactory);
            }
            case APPROXIMATE: {
                MatchingRule rule = filter.getAttributeType().getApproximateMatchingRule();
                Assertion assertion = rule.getAssertion((ByteSequence)filter.getAssertionValue());
                return (IndexQuery)assertion.createIndexQuery(this.indexQueryFactory);
            }
        }
        return null;
    }

    public long getEntryLimitExceededCount() {
        long entryLimitExceededCount = 0L;
        for (Index index : this.indexIdToIndexes.values()) {
            entryLimitExceededCount += (long)index.getEntryLimitExceededCount();
        }
        return entryLimitExceededCount;
    }

    public void listDatabases(List<DatabaseContainer> dbList) {
        dbList.addAll(this.indexIdToIndexes.values());
    }

    public String toString() {
        return this.getName();
    }

    public synchronized boolean isConfigurationChangeAcceptable(LocalDBIndexCfg cfg, List<LocalizableMessage> unacceptableReasons) {
        SortedSet newRules;
        if (!(AttributeIndex.isIndexAcceptable(cfg, LocalDBIndexCfgDefn.IndexType.EQUALITY, unacceptableReasons) && AttributeIndex.isIndexAcceptable(cfg, LocalDBIndexCfgDefn.IndexType.SUBSTRING, unacceptableReasons) && AttributeIndex.isIndexAcceptable(cfg, LocalDBIndexCfgDefn.IndexType.ORDERING, unacceptableReasons) && AttributeIndex.isIndexAcceptable(cfg, LocalDBIndexCfgDefn.IndexType.APPROXIMATE, unacceptableReasons))) {
            return false;
        }
        AttributeType attrType = cfg.getAttribute();
        if (cfg.getIndexType().contains(LocalDBIndexCfgDefn.IndexType.EXTENSIBLE) && ((newRules = cfg.getIndexExtensibleMatchingRule()) == null || newRules.isEmpty())) {
            unacceptableReasons.add(BackendMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get((Object)attrType, (Object)"extensible"));
            return false;
        }
        return true;
    }

    private static boolean isIndexAcceptable(LocalDBIndexCfg cfg, LocalDBIndexCfgDefn.IndexType indexType, List<LocalizableMessage> unacceptableReasons) {
        AttributeType attrType = cfg.getAttribute();
        if (cfg.getIndexType().contains(indexType) && AttributeIndex.getMatchingRule(indexType, attrType) == null) {
            unacceptableReasons.add(BackendMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get((Object)attrType, (Object)indexType.toString()));
            return false;
        }
        return true;
    }

    public synchronized ConfigChangeResult applyConfigurationChange(LocalDBIndexCfg newConfiguration) {
        ConfigChangeResult ccr = new ConfigChangeResult();
        JEIndexingOptions newIndexingOptions = new JEIndexingOptions(newConfiguration.getSubstringLength());
        try {
            Map<String, Index> newIndexIdToIndexes = AttributeIndex.buildIndexes(this.entryContainer, newConfiguration, newIndexingOptions);
            HashMap<String, Index> removedIndexes = new HashMap<String, Index>(this.indexIdToIndexes);
            removedIndexes.keySet().removeAll(newIndexIdToIndexes.keySet());
            HashMap<String, Index> addedIndexes = new HashMap<String, Index>(newIndexIdToIndexes);
            addedIndexes.keySet().removeAll(this.indexIdToIndexes.keySet());
            HashMap<String, Index> updatedIndexes = new HashMap<String, Index>(this.indexIdToIndexes);
            updatedIndexes.keySet().retainAll(newIndexIdToIndexes.keySet());
            newIndexIdToIndexes.putAll(updatedIndexes);
            for (Index addedIndex : addedIndexes.values()) {
                AttributeIndex.openIndex(addedIndex, ccr);
            }
            this.indexConfig = newConfiguration;
            this.indexingOptions = newIndexingOptions;
            this.indexIdToIndexes = Collections.unmodifiableMap(newIndexIdToIndexes);
            this.indexQueryFactory = new IndexQueryFactoryImpl(this.indexIdToIndexes, this.indexingOptions, this.indexConfig.getAttribute());
            for (Index removedIndex : removedIndexes.values()) {
                AttributeIndex.deleteIndex(this.entryContainer, removedIndex);
            }
            for (Index updatedIndex : updatedIndexes.values()) {
                AttributeIndex.updateIndex(updatedIndex, newConfiguration.getIndexEntryLimit(), ccr);
            }
        }
        catch (Exception e) {
            ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
            ccr.addMessage(LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToSingleLineString((Throwable)e), (Object[])new Object[0]));
        }
        return ccr;
    }

    private static void openIndex(Index index, ConfigChangeResult ccr) {
        index.open();
        if (!index.isTrusted()) {
            ccr.setAdminActionRequired(true);
            ccr.addMessage(BackendMessages.NOTE_INDEX_ADD_REQUIRES_REBUILD.get((Object)index.getName()));
        }
    }

    private static void updateIndex(Index updatedIndex, int newIndexEntryLimit, ConfigChangeResult ccr) {
        if (updatedIndex.setIndexEntryLimit(newIndexEntryLimit)) {
            ccr.setAdminActionRequired(true);
            ccr.addMessage(BackendMessages.NOTE_CONFIG_INDEX_ENTRY_LIMIT_REQUIRES_REBUILD.get((Object)updatedIndex.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteIndex(EntryContainer entryContainer, Index index) {
        entryContainer.exclusiveLock.lock();
        try {
            entryContainer.deleteDatabase(index);
        }
        finally {
            entryContainer.exclusiveLock.unlock();
        }
    }

    public boolean isTrusted() {
        for (Index index : this.indexIdToIndexes.values()) {
            if (index.isTrusted()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.entryContainer.getDatabasePrefix() + "_" + this.indexConfig.getAttribute().getNameOrOID();
    }

    Index getIndex(String indexID) {
        return this.indexIdToIndexes.get(indexID);
    }

    public Collection<Index> getAllIndexes() {
        return this.indexIdToIndexes.values();
    }

    public EntryIDSet evaluateExtensibleFilter(SearchFilter filter, StringBuilder debugBuffer, DatabaseEnvironmentMonitor monitor) {
        String matchRuleOID = filter.getMatchingRuleID();
        MatchingRule eqRule = this.indexConfig.getAttribute().getEqualityMatchingRule();
        if (matchRuleOID == null || matchRuleOID.equals(eqRule.getOID()) || matchRuleOID.equalsIgnoreCase(eqRule.getNameOrOID())) {
            return this.evaluateFilter(IndexFilterType.EQUALITY, filter, debugBuffer, monitor);
        }
        MatchingRule rule = DirectoryServer.getMatchingRule((String)matchRuleOID);
        if (!this.ruleHasAtLeasOneIndex(rule)) {
            if (monitor.isFilterUseEnabled()) {
                monitor.updateStats(filter, BackendMessages.INFO_INDEX_FILTER_MATCHING_RULE_NOT_INDEXED.get((Object)matchRuleOID, (Object)this.indexConfig.getAttribute().getNameOrOID()));
            }
            return IndexQuery.createNullIndexQuery().evaluate(null);
        }
        try {
            if (debugBuffer != null) {
                debugBuffer.append("[INDEX:");
                for (Indexer indexer : rule.createIndexers(this.indexingOptions)) {
                    debugBuffer.append(" ").append(filter.getAttributeType().getNameOrOID()).append(".").append(indexer.getIndexID());
                }
                debugBuffer.append("]");
            }
            IndexQuery indexQuery = (IndexQuery)rule.getAssertion((ByteSequence)filter.getAssertionValue()).createIndexQuery(this.indexQueryFactory);
            LocalizableMessageBuilder debugMessage = monitor.isFilterUseEnabled() ? new LocalizableMessageBuilder() : null;
            EntryIDSet results = indexQuery.evaluate(debugMessage);
            if (monitor.isFilterUseEnabled()) {
                if (results.isDefined()) {
                    monitor.updateStats(filter, results.size());
                } else {
                    monitor.updateStats(filter, debugMessage.toMessage());
                }
            }
            return results;
        }
        catch (DecodeException e) {
            logger.traceException((Throwable)e);
            return IndexQuery.createNullIndexQuery().evaluate(null);
        }
    }

    private boolean ruleHasAtLeasOneIndex(MatchingRule rule) {
        for (Indexer indexer : rule.createIndexers(this.indexingOptions)) {
            if (!this.indexIdToIndexes.containsKey(indexer.getIndexID())) continue;
            return true;
        }
        return false;
    }

    private static final class JEIndexingOptions
    implements IndexingOptions {
        private int substringLength;

        private JEIndexingOptions(int substringLength) {
            this.substringLength = substringLength;
        }

        public int substringKeySize() {
            return this.substringLength;
        }
    }

    public static class KeyComparator
    implements Comparator<byte[]> {
        public static final KeyComparator INSTANCE = new KeyComparator();

        @Override
        public int compare(byte[] a, byte[] b) {
            return ByteSequence.BYTE_ARRAY_COMPARATOR.compare(a, b);
        }
    }

    static enum IndexFilterType {
        EQUALITY(LocalDBIndexCfgDefn.IndexType.EQUALITY),
        PRESENCE(LocalDBIndexCfgDefn.IndexType.PRESENCE),
        GREATER_OR_EQUAL(LocalDBIndexCfgDefn.IndexType.ORDERING),
        LESS_OR_EQUAL(LocalDBIndexCfgDefn.IndexType.ORDERING),
        SUBSTRING(LocalDBIndexCfgDefn.IndexType.SUBSTRING),
        APPROXIMATE(LocalDBIndexCfgDefn.IndexType.APPROXIMATE);

        private final LocalDBIndexCfgDefn.IndexType indexType;

        private IndexFilterType(LocalDBIndexCfgDefn.IndexType indexType) {
            this.indexType = indexType;
        }

        public String toString() {
            return this.indexType.toString();
        }
    }
}

