/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opends.server.loggers.OpenDJLoggerAdapter;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public final class OpenDJLoggerFactory
implements ILoggerFactory {
    private final ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public Logger getLogger(String name) {
        Logger slf4jLogger;
        if (name.equalsIgnoreCase("ROOT")) {
            name = "org.forgerock";
        }
        if ((slf4jLogger = (Logger)this.loggerMap.get(name)) != null) {
            return slf4jLogger;
        }
        OpenDJLoggerAdapter newInstance = new OpenDJLoggerAdapter(name);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }
}

