/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedMarker;
import org.opends.messages.Severity;
import org.opends.server.loggers.DebugLogger;
import org.opends.server.loggers.DebugTracer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.LoggingCategoryNames;
import org.slf4j.Logger;
import org.slf4j.Marker;

final class OpenDJLoggerAdapter
implements Logger {
    private final String name;
    private final DebugTracer tracer;

    public OpenDJLoggerAdapter(String name) {
        this.tracer = DebugLogger.getTracer((String)name);
        this.name = LoggingCategoryNames.getCategoryName((String)name);
    }

    public String getName() {
        return this.name;
    }

    private void logTraceMessage(String msg) {
        this.tracer.trace(msg);
    }

    private void logTraceException(String message, Throwable t) {
        this.tracer.traceException(message, t);
    }

    private void logError(Marker marker, Severity severity, Throwable throwable) {
        if (!(marker instanceof LocalizedMarker)) {
            throw new IllegalStateException("Expecting the marker to be an instance of LocalizedMarker");
        }
        LocalizableMessage message = ((LocalizedMarker)marker).getMessage();
        ErrorLogger.log((String)this.name, (Severity)severity, (LocalizableMessage)message, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return DebugLogger.debugEnabled() && this.tracer.enabled();
    }

    public void trace(String msg) {
        this.logTraceMessage(msg);
    }

    public void trace(Marker marker, String msg) {
        this.logTraceMessage(msg);
    }

    public void trace(String msg, Throwable t) {
        this.logTraceException(msg, t);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.logTraceException(msg, t);
    }

    public boolean isDebugEnabled() {
        return ErrorLogger.isEnabledFor((String)this.name, (Severity)Severity.INFORMATION);
    }

    public void debug(Marker marker, String msg) {
        this.logError(marker, Severity.INFORMATION, null);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.logError(marker, Severity.INFORMATION, t);
    }

    public boolean isInfoEnabled() {
        return ErrorLogger.isEnabledFor((String)this.name, (Severity)Severity.NOTICE);
    }

    public void info(Marker marker, String msg) {
        this.logError(marker, Severity.NOTICE, null);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.logError(marker, Severity.NOTICE, t);
    }

    public boolean isWarnEnabled() {
        return ErrorLogger.isEnabledFor((String)this.name, (Severity)Severity.WARNING);
    }

    public void warn(Marker marker, String msg) {
        this.logError(marker, Severity.WARNING, null);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.logError(marker, Severity.WARNING, t);
    }

    public boolean isErrorEnabled() {
        return ErrorLogger.isEnabledFor((String)this.name, (Severity)Severity.ERROR);
    }

    public void error(Marker marker, String msg) {
        this.logError(marker, Severity.ERROR, null);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.logError(marker, Severity.ERROR, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void trace(String format, Object arg) {
        throw new UnsupportedOperationException("Use #trace(String) instead.");
    }

    public void trace(String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("Use #trace(String) instead.");
    }

    public void trace(String format, Object ... argArray) {
        throw new UnsupportedOperationException("Use #trace(String) instead.");
    }

    public void trace(Marker marker, String format, Object arg) {
        throw new UnsupportedOperationException("Use #trace(Marker, String) instead.");
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("Use #trace(Marker, String) instead.");
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        throw new UnsupportedOperationException("Use #trace(Marker, String) instead.");
    }

    public void debug(String msg) {
        throw new UnsupportedOperationException("Use #debug(Marker, String) instead.");
    }

    public void debug(String format, Object arg) {
        throw new UnsupportedOperationException("Use #debug(Marker, String) instead.");
    }

    public void debug(String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("Use #debug(Marker, String) instead.");
    }

    public void debug(String format, Object ... argArray) {
        throw new UnsupportedOperationException("Use #debug(Marker, String) instead.");
    }

    public void debug(String msg, Throwable t) {
        throw new UnsupportedOperationException("Use #debug(Marker, String, Throwable) instead.");
    }

    public void debug(Marker marker, String format, Object arg) {
        throw new UnsupportedOperationException("Use #debug(Marker, String) instead.");
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("Use #debug(Marker, String) instead.");
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        throw new UnsupportedOperationException("Use #debug(Marker, String) instead.");
    }

    public void info(String msg) {
        throw new UnsupportedOperationException("Use #info(Marker, String) instead.");
    }

    public void info(String format, Object arg) {
        throw new UnsupportedOperationException("Use #info(Marker, String) instead.");
    }

    public void info(String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("Use #info(Marker, String) instead.");
    }

    public void info(String format, Object ... argArray) {
        throw new UnsupportedOperationException("Use #info(Marker, String) instead.");
    }

    public void info(String msg, Throwable t) {
        throw new UnsupportedOperationException("Use #info(Marker, String, Throwable) instead.");
    }

    public void info(Marker marker, String format, Object arg) {
        throw new UnsupportedOperationException("Use #info(Marker, String) instead.");
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("Use #info(Marker, String) instead.");
    }

    public void info(Marker marker, String format, Object ... arguments) {
        throw new UnsupportedOperationException("Use #info(Marker, String) instead.");
    }

    public void warn(String msg) {
        throw new UnsupportedOperationException("Use #warn(Marker, String) instead.");
    }

    public void warn(String format, Object arg) {
        throw new UnsupportedOperationException("Use #warn(Marker, String) instead.");
    }

    public void warn(String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("Use #warn(Marker, String) instead.");
    }

    public void warn(String format, Object ... argArray) {
        throw new UnsupportedOperationException("Use #warn(Marker, String) instead.");
    }

    public void warn(String msg, Throwable t) {
        throw new UnsupportedOperationException("Use #warn(Marker, String, Throwable) instead.");
    }

    public void warn(Marker marker, String format, Object arg) {
        throw new UnsupportedOperationException("Use #warn(Marker, String) instead.");
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("Use #warn(Marker, String) instead.");
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        throw new UnsupportedOperationException("Use #warn(Marker, String) instead.");
    }

    public void error(String msg) {
        throw new UnsupportedOperationException("Use #error(Marker, String) instead.");
    }

    public void error(String format, Object arg) {
        throw new UnsupportedOperationException("Use #error(Marker, String) instead.");
    }

    public void error(String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("Use #error(Marker, String) instead.");
    }

    public void error(String format, Object ... arguments) {
        throw new UnsupportedOperationException("Use #error(Marker, String) instead.");
    }

    public void error(String msg, Throwable t) {
        throw new UnsupportedOperationException("Use #error(Marker, String, Throwable) instead.");
    }

    public void error(Marker marker, String format, Object arg) {
        throw new UnsupportedOperationException("Use #error(Marker, String) instead.");
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException("Use #error(Marker, String) instead.");
    }

    public void error(Marker marker, String format, Object ... arguments) {
        throw new UnsupportedOperationException("Use #error(Marker, String) instead.");
    }
}

