/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.fluent;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.fluent.JsonValueWrapper;

public class JsonValueMap
implements JsonValueWrapper,
Map<String, Object> {
    private JsonValue jsonValue;

    public JsonValueMap(JsonValue jsonValue) {
        this.jsonValue = jsonValue.expect(Map.class);
    }

    @Override
    public JsonValue unwrap() {
        return this.jsonValue;
    }

    @Override
    public int size() {
        return this.jsonValue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jsonValue.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return key != null && key instanceof String && this.jsonValue.isDefined((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.jsonValue.contains(value);
    }

    @Override
    public Object get(Object key) {
        Object result = null;
        if (key != null && key instanceof String) {
            result = this.jsonValue.get((String)key).getWrappedObject();
        }
        return result;
    }

    @Override
    public Object put(String key, Object value) {
        Object result = this.get(key);
        this.jsonValue.put(key, value);
        return result;
    }

    @Override
    public Object remove(Object key) {
        Object result = this.get(key);
        if (key instanceof String) {
            this.jsonValue.remove((String)key);
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.jsonValue.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.jsonValue.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.jsonValue.keys();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> result = new ArrayList<Object>(this.size());
        for (JsonValue jv : this.jsonValue) {
            result.add(jv.getObject());
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> result = new HashSet<Map.Entry<String, Object>>(this.size());
        for (String key : this.jsonValue.keys()) {
            result.add(new AbstractMap.SimpleEntry<String, Object>(key, this.get(key)));
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return this.jsonValue.getObject().equals(o);
    }

    @Override
    public int hashCode() {
        return this.jsonValue.getObject().hashCode();
    }
}

