/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.fluent;

import java.util.AbstractList;
import java.util.List;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.fluent.JsonValueWrapper;

public class JsonValueList<E>
extends AbstractList<E>
implements JsonValueWrapper {
    private JsonValue jsonValue;

    public JsonValueList(JsonValue jsonValue) {
        this.jsonValue = jsonValue.expect(List.class);
    }

    @Override
    public JsonValue unwrap() {
        return this.jsonValue;
    }

    @Override
    public int size() {
        return this.jsonValue.size();
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.jsonValue.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (E)this.jsonValue.get(index).getWrappedObject();
    }

    @Override
    public E set(int index, E element) {
        E result = this.get(index);
        this.jsonValue.put(index, element);
        return result;
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 || index > this.jsonValue.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.jsonValue.add(index, element);
    }

    @Override
    public E remove(int index) {
        E result = this.get(index);
        this.jsonValue.remove(index);
        return result;
    }

    @Override
    public void clear() {
        this.jsonValue.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.jsonValue.getObject().equals(o);
    }

    @Override
    public int hashCode() {
        return this.jsonValue.getObject().hashCode();
    }
}

