/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.fluent;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.forgerock.json.fluent.JsonException;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonTransformer;
import org.forgerock.json.fluent.JsonValueException;
import org.forgerock.json.fluent.JsonValueKeyAccessChecker;
import org.forgerock.json.fluent.JsonValueList;
import org.forgerock.json.fluent.JsonValueMap;
import org.forgerock.json.fluent.JsonValueWrapper;
import org.forgerock.util.RangeSet;

public class JsonValue
implements Cloneable,
Iterable<JsonValue> {
    private Object object;
    private JsonPointer pointer;
    private final ArrayList<JsonTransformer> transformers = new ArrayList(0);

    public static List<Object> array(Object ... objects) {
        return new ArrayList<Object>(Arrays.asList(objects));
    }

    public static Map.Entry<String, Object> field(String key, Object value) {
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
    }

    public static JsonValue json(Object object) {
        return object instanceof JsonValue ? (JsonValue)object : new JsonValue(object);
    }

    public static Object object(Map.Entry ... fields) {
        LinkedHashMap object = new LinkedHashMap(fields.length);
        for (Map.Entry field : fields) {
            if (field == null) continue;
            object.put(field.getKey(), field.getValue());
        }
        return object;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private static int toIndex(String key) {
        int result;
        try {
            result = Integer.parseInt(key);
        }
        catch (NumberFormatException nfe) {
            result = -1;
        }
        return result >= 0 ? result : -1;
    }

    public JsonValue(Object object) {
        this(object, null, null);
    }

    public JsonValue(Object object, Collection<? extends JsonTransformer> transformers) {
        this(object, null, transformers);
    }

    public JsonValue(Object object, JsonPointer pointer) {
        this(object, pointer, null);
    }

    public JsonValue(Object object, JsonPointer pointer, Collection<? extends JsonTransformer> transformers) {
        this.object = object;
        this.pointer = pointer;
        JsonValue jv = this.unwrapObject(object);
        if (jv != null) {
            this.object = jv.object;
            if (pointer == null) {
                this.pointer = jv.pointer;
            }
            if (transformers == null) {
                this.transformers.addAll(jv.transformers);
            }
        }
        if (transformers != null) {
            this.transformers.addAll(transformers);
        }
        if (this.pointer == null) {
            this.pointer = new JsonPointer();
        }
        if (this.transformers.size() > 0) {
            this.applyTransformers();
        }
    }

    public JsonValue add(int index, Object object) {
        List<Object> list = this.required().asList();
        if (index < 0 || index > list.size()) {
            throw new JsonValueException(this, "List index out of range: " + index);
        }
        list.add(index, object);
        return this;
    }

    public JsonValue add(JsonPointer pointer, Object object) {
        this.navigateToParentOf(pointer).required().addToken(pointer.leaf(), object);
        return this;
    }

    public JsonValue add(Object object) {
        return this.add(this.size(), object);
    }

    public JsonValue add(String key, Object object) {
        if (this.isMap()) {
            Map<String, Object> map = this.asMap();
            if (map.containsKey(key)) {
                throw new JsonValueException(this, "Map key " + key + " already exists");
            }
            map.put(key, object);
        } else if (this.isList()) {
            this.add(JsonValue.toIndex(key), object);
        } else {
            throw new JsonValueException(this, "Expecting a Map or List");
        }
        return this;
    }

    public JsonValue addPermissive(JsonPointer pointer, Object object) {
        this.navigateToParentOfPermissive(pointer).addToken(pointer.leaf(), object);
        return this;
    }

    public void applyTransformers() {
        Object object = this.object;
        for (int n = 0; n < Integer.MAX_VALUE; ++n) {
            boolean affected = false;
            for (JsonTransformer transformer : this.transformers) {
                transformer.transform(this);
                if (JsonValue.eq(object, this.object)) continue;
                object = this.object;
                affected = true;
                break;
            }
            if (affected) continue;
            return;
        }
        throw new JsonException("Transformer iteration overflow");
    }

    public Boolean asBoolean() {
        return this.object == null ? null : (Boolean)this.expect(Boolean.class).object;
    }

    public Charset asCharset() {
        try {
            return this.object == null ? null : Charset.forName(this.asString());
        }
        catch (IllegalCharsetNameException icne) {
            throw new JsonValueException(this, (Throwable)icne);
        }
        catch (UnsupportedCharsetException uce) {
            throw new JsonValueException(this, (Throwable)uce);
        }
    }

    public Double asDouble() {
        return this.object == null ? null : Double.valueOf(this.asNumber().doubleValue());
    }

    public <T extends Enum<T>> T asEnum(Class<T> type) {
        Enum result = null;
        String string = this.asString();
        if (string != null) {
            Enum[] constants = (Enum[])type.getEnumConstants();
            if (constants == null) {
                throw new IllegalArgumentException("Type is not an enum class");
            }
            for (Enum constant : constants) {
                if (!string.equalsIgnoreCase(constant.toString())) continue;
                result = constant;
                break;
            }
            if (result == null) {
                StringBuilder sb = new StringBuilder("Expecting String containing one of:");
                for (Enum constant : constants) {
                    sb.append(' ').append(constant.toString());
                }
                throw new JsonValueException(this, sb.toString());
            }
        }
        return (T)result;
    }

    public File asFile() {
        String string = this.asString();
        return string != null ? new File(string) : null;
    }

    public Integer asInteger() {
        return this.object == null ? null : Integer.valueOf(this.asNumber().intValue());
    }

    public List<Object> asList() {
        return this.asList(Object.class);
    }

    public <E> List<E> asList(Class<E> type) {
        if (this.object != null) {
            this.expect(List.class);
            if (type != Object.class) {
                List list = (List)this.object;
                for (Object element : list) {
                    if (element == null || type.isInstance(element)) continue;
                    throw new JsonValueException(this, "Expecting a List of " + type.getName() + " elements");
                }
            }
        }
        return (List)this.object;
    }

    public Long asLong() {
        return this.object == null ? null : Long.valueOf(this.asNumber().longValue());
    }

    public Map<String, Object> asMap() {
        return this.object == null ? null : (Map)this.expect(Map.class).object;
    }

    public Number asNumber() {
        return this.object == null ? (Number)null : (Number)((Number)this.expect(Number.class).object);
    }

    public Pattern asPattern() {
        try {
            return this.object == null ? null : Pattern.compile(this.asString());
        }
        catch (PatternSyntaxException pse) {
            throw new JsonValueException(this, (Throwable)pse);
        }
    }

    public JsonPointer asPointer() {
        try {
            return this.object == null ? null : new JsonPointer(this.asString());
        }
        catch (JsonException je) {
            throw je instanceof JsonValueException ? je : new JsonValueException(this, (Throwable)je);
        }
    }

    public String asString() {
        return this.object == null ? null : (String)this.expect(String.class).object;
    }

    public URI asURI() {
        try {
            return this.object == null ? null : new URI(this.asString());
        }
        catch (URISyntaxException use) {
            throw new JsonValueException(this, (Throwable)use);
        }
    }

    public UUID asUUID() {
        try {
            return this.object == null ? null : UUID.fromString(this.asString());
        }
        catch (IllegalArgumentException iae) {
            throw new JsonValueException(this, (Throwable)iae);
        }
    }

    public JsonValue recordKeyAccesses() {
        return new JsonValueKeyAccessChecker(this);
    }

    public void verifyAllKeysAccessed() {
    }

    public void clear() {
        if (this.isMap()) {
            this.asMap().clear();
        } else if (this.isList()) {
            this.asList().clear();
        }
    }

    public JsonValue clone() {
        JsonValue result = new JsonValue(this.object, this.pointer);
        result.transformers.addAll(this.transformers);
        if (this.isMap()) {
            result.object = new HashMap<String, Object>(this.asMap());
        } else if (this.isList()) {
            result.object = new ArrayList<Object>(this.asList());
        }
        return result;
    }

    public boolean contains(Object object) {
        boolean result = false;
        if (this.isMap()) {
            result = this.asMap().containsValue(object);
        } else if (this.isList()) {
            result = this.asList().contains(object);
        }
        return result;
    }

    public JsonValue copy() {
        JsonValue result = new JsonValue(this.object, this.pointer);
        if (this.isMap()) {
            HashMap<String, Object> map = new HashMap<String, Object>(this.size());
            for (String key : this.keys()) {
                map.put(key, this.get(key).copy().getObject());
            }
            result.object = map;
        } else if (this.isList()) {
            ArrayList<Object> list = new ArrayList<Object>(this.size());
            for (JsonValue element : this) {
                list.add(element.copy().getObject());
            }
            result.object = list;
        }
        return result;
    }

    public JsonValue defaultTo(Object object) {
        return this.object != null ? this : new JsonValue(object, this.pointer, this.transformers);
    }

    public JsonValue expect(Class<?> type) {
        if (this.object != null && !type.isInstance(this.object)) {
            throw new JsonValueException(this, "Expecting a " + type.getName());
        }
        return this;
    }

    public JsonValue get(int index) {
        List<Object> list;
        Object result = null;
        if (index < 0) {
            throw new JsonValueException(this, "List index out of range: " + index);
        }
        if (this.isList() && index >= 0 && index < (list = this.asList()).size()) {
            result = list.get(index);
        }
        return new JsonValue(result, this.pointer.child(index), this.transformers);
    }

    public JsonValue get(JsonPointer pointer) {
        JsonValue result = this;
        for (String token : pointer) {
            JsonValue member = result.get(token);
            if (member.isNull() && !result.isDefined(token)) {
                return null;
            }
            result = member;
        }
        return result;
    }

    public JsonValue get(String key) {
        Object result = null;
        if (this.isMap()) {
            result = this.asMap().get(key);
        } else if (this.isList()) {
            List<Object> list = this.asList();
            int index = JsonValue.toIndex(key);
            if (index >= 0 && index < list.size()) {
                result = list.get(index);
            }
        }
        return new JsonValue(result, this.pointer.child(key), this.transformers);
    }

    public Object getObject() {
        return this.object;
    }

    public JsonPointer getPointer() {
        return this.pointer;
    }

    public List<JsonTransformer> getTransformers() {
        return this.transformers;
    }

    public Object getWrappedObject() {
        if (this.isMap()) {
            return new JsonValueMap(this);
        }
        if (this.isList()) {
            return new JsonValueList(this);
        }
        return this.object;
    }

    public boolean isBoolean() {
        return this.object != null && this.object instanceof Boolean;
    }

    public boolean isDefined(String key) {
        boolean result = false;
        if (this.isMap()) {
            result = this.asMap().containsKey(key);
        } else if (this.isList()) {
            int index = JsonValue.toIndex(key);
            result = index >= 0 && index < this.asList().size();
        }
        return result;
    }

    public boolean isList() {
        return this.object != null && this.object instanceof List;
    }

    public boolean isMap() {
        return this.object != null && this.object instanceof Map;
    }

    public boolean isNull() {
        return this.object == null;
    }

    public boolean isNumber() {
        return this.object != null && this.object instanceof Number;
    }

    public boolean isString() {
        return this.object != null && this.object instanceof String;
    }

    @Override
    public Iterator<JsonValue> iterator() {
        if (this.isList()) {
            return new Iterator<JsonValue>(){
                int cursor = 0;
                Iterator<Object> i = JsonValue.this.asList().iterator();

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public JsonValue next() {
                    Object element = this.i.next();
                    return new JsonValue(element, JsonValue.this.pointer.child(this.cursor++), JsonValue.this.transformers);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<JsonValue>(){
            Iterator<String> i;
            {
                this.i = JsonValue.this.keys().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public JsonValue next() {
                return JsonValue.this.get(this.i.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Set<String> keys() {
        Set<Object> result;
        if (this.isMap()) {
            result = new HashSet();
            for (String key : this.asMap().keySet()) {
                if (!(key instanceof String)) continue;
                result.add(key);
            }
        } else {
            result = this.isList() ? new AbstractSet<String>(){
                final RangeSet range;
                {
                    this.range = new RangeSet(JsonValue.this.size());
                }

                @Override
                public boolean contains(Object o) {
                    boolean result = false;
                    if (o instanceof String) {
                        try {
                            result = this.range.contains((Object)Integer.valueOf((String)o));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return result;
                }

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        Iterator<Integer> i;
                        {
                            this.i = range.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public String next() {
                            return this.i.next().toString();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return this.range.size();
                }
            } : Collections.emptySet();
        }
        return result;
    }

    public JsonValue put(int index, Object object) {
        List<Object> list = this.required().asList();
        if (index < 0 || index > list.size()) {
            throw new JsonValueException(this, "List index out of range: " + index);
        }
        if (index == list.size()) {
            list.add(object);
        } else {
            list.set(index, object);
        }
        return this;
    }

    public JsonValue put(JsonPointer pointer, Object object) {
        this.navigateToParentOf(pointer).required().putToken(pointer.leaf(), object);
        return this;
    }

    public JsonValue put(String key, Object object) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.isMap()) {
            this.asMap().put(key, object);
        } else if (this.isList()) {
            this.put(JsonValue.toIndex(key), object);
        } else {
            throw new JsonValueException(this, "Expecting a Map or List");
        }
        return this;
    }

    public JsonValue putPermissive(JsonPointer pointer, Object object) {
        this.navigateToParentOfPermissive(pointer).putToken(pointer.leaf(), object);
        return this;
    }

    public void remove(int index) {
        List<Object> list;
        if (index >= 0 && this.isList() && index < (list = this.asList()).size()) {
            list.remove(index);
        }
    }

    public void remove(JsonPointer pointer) {
        this.navigateToParentOf(pointer).remove(pointer.leaf());
    }

    public void remove(String key) {
        if (this.isMap()) {
            this.asMap().remove(key);
        } else if (this.isList()) {
            this.remove(JsonValue.toIndex(key));
        }
    }

    public JsonValue required() {
        if (this.object == null) {
            throw new JsonValueException(this, "Expecting a value");
        }
        return this;
    }

    public void setObject(Object object) {
        this.object = object;
        JsonValue jv = this.unwrapObject(object);
        if (jv != null) {
            this.object = jv.object;
            this.transformers.addAll(jv.transformers);
        }
    }

    public int size() {
        if (this.isMap()) {
            return this.asMap().size();
        }
        if (this.isList()) {
            return this.asList().size();
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNull()) {
            sb.append("null");
        } else if (this.isMap()) {
            sb.append("{ ");
            Map map = (Map)this.object;
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                sb.append('\"').append(key.toString()).append("\": ");
                sb.append(new JsonValue(map.get(key)).toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(" }");
        } else if (this.isList()) {
            sb.append("[ ");
            Iterator i = ((List)this.object).iterator();
            while (i.hasNext()) {
                sb.append(new JsonValue(i.next()).toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(" ]");
        } else if (this.isString()) {
            sb.append('\"').append(this.object).append('\"');
        } else {
            sb.append(this.object.toString());
        }
        return sb.toString();
    }

    private void addToken(String token, Object object) {
        if (this.isEndOfListToken(token) && this.isList()) {
            this.add(object);
        } else {
            this.add(token, object);
        }
    }

    private boolean isEndOfListToken(String token) {
        return token.equals("-");
    }

    private boolean isIndexToken(String token) {
        if (token.isEmpty()) {
            return false;
        }
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private JsonValue navigateToParentOf(JsonPointer pointer) {
        JsonValue jv = this;
        int size = pointer.size();
        for (int n = 0; n < size - 1 && !(jv = jv.get(pointer.get(n))).isNull(); ++n) {
        }
        return jv;
    }

    private JsonValue navigateToParentOfPermissive(JsonPointer pointer) {
        JsonValue jv = this;
        int size = pointer.size();
        for (int n = 0; n < size - 1; ++n) {
            String token = pointer.get(n);
            JsonValue next = jv.get(token);
            if (!next.isNull()) {
                jv = next;
                continue;
            }
            if (this.isIndexToken(token)) {
                throw new JsonValueException(this, "Expecting a value");
            }
            String nextToken = pointer.get(n + 1);
            if (this.isEndOfListToken(nextToken)) {
                jv.add(token, new ArrayList());
                jv = jv.get(token);
                continue;
            }
            if (this.isIndexToken(nextToken)) {
                throw new JsonValueException(this, "Expecting a value");
            }
            jv.add(token, new LinkedHashMap());
            jv = jv.get(token);
        }
        return jv;
    }

    private void putToken(String token, Object object) {
        if (this.isEndOfListToken(token) && this.isList()) {
            this.add(object);
        } else {
            this.put(token, object);
        }
    }

    private JsonValue unwrapObject(Object object) {
        JsonValue result = null;
        if (object != null && object instanceof JsonValueWrapper) {
            object = ((JsonValueWrapper)object).unwrap();
        }
        if (object != null && object instanceof JsonValue) {
            result = (JsonValue)object;
        }
        return result;
    }
}

