/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.servlet;

import javax.servlet.http.HttpServletRequest;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.RootContext;
import org.forgerock.json.resource.SecurityContext;
import org.forgerock.json.resource.servlet.HttpServletContextFactory;
import org.forgerock.json.resource.servlet.SecurityContextFactory;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.rest2ldap.AuthenticatedConnectionContext;

public final class Rest2LDAPContextFactory
implements HttpServletContextFactory {
    public static final String ATTRIBUTE_AUTHN_CONNECTION = "org.forgerock.opendj.rest2ldap.authn-connection";
    private static final Rest2LDAPContextFactory INSTANCE = new Rest2LDAPContextFactory();

    public static Rest2LDAPContextFactory getHttpServletContextFactory() {
        return INSTANCE;
    }

    private Rest2LDAPContextFactory() {
    }

    public Context createContext(Context parent, HttpServletRequest request) throws ResourceException {
        Connection connection;
        SecurityContext securityContext = SecurityContextFactory.getHttpServletContextFactory().createContext(parent, request);
        try {
            connection = (Connection)request.getAttribute(ATTRIBUTE_AUTHN_CONNECTION);
        }
        catch (ClassCastException e) {
            throw new InternalServerErrorException("The rest2ldap authenticated connection context could not be created because the connection attribute, org.forgerock.opendj.rest2ldap.authn-connection, contained in the HTTP servlet request did not have the correct type", (Throwable)e);
        }
        if (connection != null) {
            return new AuthenticatedConnectionContext((Context)securityContext, connection);
        }
        return securityContext;
    }

    public Context createContext(HttpServletRequest request) throws ResourceException {
        return this.createContext((Context)new RootContext(), request);
    }
}

