/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.fluent.JsonValueException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.servlet.ServletApiVersionAdapter;
import org.forgerock.json.resource.servlet.ServletSynchronizer;
import org.forgerock.opendj.ldap.AuthenticationException;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.MultipleEntriesFoundException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;

public final class Rest2LDAPAuthnFilter
implements javax.servlet.Filter {
    private static final String INIT_PARAM_CONFIG_FILE = "config-file";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    private String altAuthenticationPasswordHeader;
    private String altAuthenticationUsernameHeader;
    private AuthenticationMethod authenticationMethod = AuthenticationMethod.SEARCH_SIMPLE;
    private ConnectionFactory bindLDAPConnectionFactory;
    private boolean isEnabled;
    private boolean reuseAuthenticatedConnection = true;
    private String saslAuthzIdTemplate;
    private final Schema schema = Schema.getDefaultSchema();
    private DN searchBaseDN;
    private String searchFilterTemplate;
    private ConnectionFactory searchLDAPConnectionFactory;
    private SearchScope searchScope = SearchScope.WHOLE_SUBTREE;
    private boolean supportAltAuthentication;
    private boolean supportHTTPBasicAuthentication = true;
    private ServletApiVersionAdapter syncFactory;

    public void destroy() {
        if (this.searchLDAPConnectionFactory != null) {
            this.searchLDAPConnectionFactory.close();
        }
        if (this.bindLDAPConnectionFactory != null) {
            this.bindLDAPConnectionFactory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        if (!this.isEnabled) {
            chain.doFilter(request, response);
            return;
        }
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("non-HTTP request or response");
        }
        final HttpServletRequest req = (HttpServletRequest)request;
        final HttpServletResponse res = (HttpServletResponse)response;
        final AtomicReference<Connection> savedConnection = new AtomicReference<Connection>();
        final ServletSynchronizer sync = this.syncFactory.createServletSynchronizer(req, res);
        sync.addAsyncListener(new Runnable(){

            @Override
            public void run() {
                Rest2LDAPAuthnFilter.this.closeConnection(savedConnection);
            }
        });
        try {
            char[] password;
            String username;
            String headerAuthorization;
            String headerUsername = this.supportAltAuthentication ? req.getHeader(this.altAuthenticationUsernameHeader) : null;
            String headerPassword = this.supportAltAuthentication ? req.getHeader(this.altAuthenticationPasswordHeader) : null;
            String string = headerAuthorization = this.supportHTTPBasicAuthentication ? req.getHeader("Authorization") : null;
            if (headerUsername != null) {
                if (headerPassword == null || headerUsername.isEmpty() || headerPassword.isEmpty()) {
                    throw ResourceException.getException((int)401);
                }
                username = headerUsername;
                password = headerPassword.toCharArray();
            } else if (headerAuthorization != null) {
                StringTokenizer st = new StringTokenizer(headerAuthorization);
                String method = st.nextToken();
                if (method == null || !"BASIC".equalsIgnoreCase(method)) {
                    throw ResourceException.getException((int)401);
                }
                String b64Credentials = st.nextToken();
                if (b64Credentials == null) {
                    throw ResourceException.getException((int)401);
                }
                String credentials = ByteString.valueOfBase64((String)b64Credentials).toString();
                String[] usernameAndPassword = credentials.split(":");
                if (usernameAndPassword.length != 2) {
                    throw ResourceException.getException((int)401);
                }
                username = usernameAndPassword[0];
                password = usernameAndPassword[1].toCharArray();
            } else {
                throw ResourceException.getException((int)401);
            }
            switch (this.authenticationMethod) {
                case SIMPLE: {
                    Map<Object, Object> authzid = new LinkedHashMap<String, String>(2);
                    authzid.put("dn", username);
                    authzid.put("id", username);
                    this.doBind(req, (ServletResponse)res, (BindRequest)Requests.newSimpleBindRequest((String)username, (char[])password), chain, savedConnection, sync, username, authzid);
                    break;
                }
                case SASL_PLAIN: {
                    String bindId;
                    Map<Object, Object> authzid;
                    if (this.saslAuthzIdTemplate.startsWith("dn:")) {
                        String bindDN = DN.format((String)this.saslAuthzIdTemplate.substring(3), (Schema)this.schema, (Object[])new Object[]{username}).toString();
                        bindId = "dn:" + bindDN;
                        authzid = new LinkedHashMap(2);
                        authzid.put("dn", bindDN);
                        authzid.put("id", username);
                    } else {
                        bindId = String.format(this.saslAuthzIdTemplate, username);
                        authzid = Collections.singletonMap("id", username);
                    }
                    this.doBind(req, (ServletResponse)res, (BindRequest)Requests.newPlainSASLBindRequest((String)bindId, (char[])password), chain, savedConnection, sync, username, authzid);
                    break;
                }
                default: {
                    Filter filter = Filter.format((String)this.searchFilterTemplate, (Object[])new Object[]{username});
                    final SearchRequest searchRequest = Requests.newSearchRequest((DN)this.searchBaseDN, (SearchScope)this.searchScope, (Filter)filter, (String[])new String[]{"1.1"});
                    this.searchLDAPConnectionFactory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, SearchResultEntry, LdapException>(){

                        public Promise<SearchResultEntry, LdapException> apply(Connection connection) throws LdapException {
                            savedConnection.set(connection);
                            return connection.searchSingleEntryAsync(searchRequest);
                        }
                    }).thenOnResult((ResultHandler)new ResultHandler<SearchResultEntry>(){

                        public void handleResult(SearchResultEntry result) {
                            ((Connection)savedConnection.get()).close();
                            String bindDN = result.getName().toString();
                            LinkedHashMap<String, String> authzid = new LinkedHashMap<String, String>(2);
                            authzid.put("dn", bindDN);
                            authzid.put("id", username);
                            Rest2LDAPAuthnFilter.this.doBind(req, (ServletResponse)res, (BindRequest)Requests.newSimpleBindRequest((String)bindDN, (char[])password), chain, savedConnection, sync, username, authzid);
                        }
                    }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                        public void handleException(LdapException exception) {
                            LdapException normalizedError = exception;
                            if (savedConnection.get() != null) {
                                ((Connection)savedConnection.get()).close();
                                normalizedError = exception instanceof EntryNotFoundException || exception instanceof MultipleEntriesFoundException ? LdapException.newLdapException((ResultCode)ResultCode.INVALID_CREDENTIALS, (Throwable)exception) : (exception instanceof AuthenticationException || exception instanceof AuthorizationException ? LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_LOCAL_ERROR, (Throwable)exception) : exception);
                            }
                            sync.signalAndComplete((Throwable)Rest2LDAP.asResourceException((Throwable)normalizedError));
                        }
                    });
                    break;
                }
            }
            sync.awaitIfNeeded();
            if (!sync.isAsync()) {
                chain.doFilter(request, response);
            }
        }
        catch (Throwable t) {
            sync.signalAndComplete(t);
        }
        finally {
            if (!sync.isAsync()) {
                this.closeConnection(savedConnection);
            }
        }
    }

    public void init(FilterConfig config) throws ServletException {
        String configFileName = config.getInitParameter(INIT_PARAM_CONFIG_FILE);
        if (configFileName == null) {
            throw new ServletException("Authentication filter initialization parameter 'config-file' not specified");
        }
        InputStream configFile = config.getServletContext().getResourceAsStream(configFileName);
        if (configFile == null) {
            throw new ServletException("Servlet filter configuration file '" + configFileName + "' not found");
        }
        try {
            Object content = JSON_MAPPER.readValue(configFile, Object.class);
            if (!(content instanceof Map)) {
                throw new ServletException("Servlet filter configuration file '" + configFileName + "' does not contain a valid JSON configuration");
            }
            JsonValue configuration = new JsonValue(content);
            JsonValue authnConfig = configuration.get("authenticationFilter");
            if (!authnConfig.isNull()) {
                String ldapFactoryName;
                this.supportHTTPBasicAuthentication = authnConfig.get("supportHTTPBasicAuthentication").required().asBoolean();
                this.supportAltAuthentication = authnConfig.get("supportAltAuthentication").required().asBoolean();
                if (this.supportAltAuthentication) {
                    this.altAuthenticationUsernameHeader = authnConfig.get("altAuthenticationUsernameHeader").required().asString();
                    this.altAuthenticationPasswordHeader = authnConfig.get("altAuthenticationPasswordHeader").required().asString();
                }
                this.reuseAuthenticatedConnection = authnConfig.get("reuseAuthenticatedConnection").required().asBoolean();
                this.authenticationMethod = this.parseAuthenticationMethod(authnConfig);
                switch (this.authenticationMethod) {
                    case SIMPLE: {
                        break;
                    }
                    case SASL_PLAIN: {
                        this.saslAuthzIdTemplate = authnConfig.get("saslAuthzIdTemplate").required().asString();
                        break;
                    }
                    case SEARCH_SIMPLE: {
                        this.searchBaseDN = DN.valueOf((String)authnConfig.get("searchBaseDN").required().asString(), (Schema)this.schema);
                        this.searchScope = this.parseSearchScope(authnConfig);
                        this.searchFilterTemplate = authnConfig.get("searchFilterTemplate").required().asString();
                        ldapFactoryName = authnConfig.get("searchLDAPConnectionFactory").required().asString();
                        this.searchLDAPConnectionFactory = Rest2LDAP.configureConnectionFactory((JsonValue)configuration.get("ldapConnectionFactories").required(), (String)ldapFactoryName);
                    }
                }
                ldapFactoryName = authnConfig.get("bindLDAPConnectionFactory").required().asString();
                this.bindLDAPConnectionFactory = Rest2LDAP.configureConnectionFactory((JsonValue)configuration.get("ldapConnectionFactories").required(), (String)ldapFactoryName);
                this.syncFactory = ServletApiVersionAdapter.getInstance((ServletContext)config.getServletContext());
                this.isEnabled = true;
            }
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Servlet filter configuration file '" + configFileName + "' could not be read: " + e.getMessage());
        }
        finally {
            try {
                configFile.close();
            }
            catch (Exception e) {}
        }
    }

    private void closeConnection(AtomicReference<Connection> savedConnection) {
        Connection connection = savedConnection.get();
        if (connection != null) {
            connection.close();
        }
    }

    private void doBind(final HttpServletRequest request, final ServletResponse response, final BindRequest bindRequest, final FilterChain chain, final AtomicReference<Connection> savedConnection, final ServletSynchronizer sync, final String authcid, final Map<String, Object> authzid) {
        this.bindLDAPConnectionFactory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, BindResult, LdapException>(){

            public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                savedConnection.set(connection);
                return connection.bindAsync(bindRequest);
            }
        }).thenOnResult((ResultHandler)new ResultHandler<BindResult>(){

            public void handleResult(BindResult result) {
                if (Rest2LDAPAuthnFilter.this.reuseAuthenticatedConnection) {
                    request.setAttribute("org.forgerock.opendj.rest2ldap.authn-connection", (Object)Connections.uncloseable((Connection)((Connection)savedConnection.get())));
                }
                request.setAttribute("org.forgerock.authentication.principal", (Object)authcid);
                request.setAttribute("org.forgerock.authentication.context", (Object)authzid);
                sync.signal();
                if (sync.isAsync()) {
                    try {
                        chain.doFilter((ServletRequest)request, response);
                        if (response.isCommitted()) {
                            sync.signalAndComplete();
                        }
                    }
                    catch (Throwable t) {
                        sync.signalAndComplete((Throwable)Rest2LDAP.asResourceException((Throwable)t));
                    }
                }
            }
        }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

            public void handleException(LdapException exception) {
                sync.signalAndComplete((Throwable)Rest2LDAP.asResourceException((Throwable)exception));
            }
        });
    }

    private AuthenticationMethod parseAuthenticationMethod(JsonValue configuration) {
        if (configuration.isDefined("method")) {
            String method = configuration.get("method").asString();
            if ("simple".equalsIgnoreCase(method)) {
                return AuthenticationMethod.SIMPLE;
            }
            if ("sasl-plain".equalsIgnoreCase(method)) {
                return AuthenticationMethod.SASL_PLAIN;
            }
            if ("search-simple".equalsIgnoreCase(method)) {
                return AuthenticationMethod.SEARCH_SIMPLE;
            }
            throw new JsonValueException(configuration, "Illegal authentication method: must be either 'simple', 'sasl-plain', or 'search-simple'");
        }
        return AuthenticationMethod.SEARCH_SIMPLE;
    }

    private SearchScope parseSearchScope(JsonValue configuration) {
        if (configuration.isDefined("searchScope")) {
            String scope = configuration.get("searchScope").asString();
            if ("sub".equalsIgnoreCase(scope)) {
                return SearchScope.WHOLE_SUBTREE;
            }
            if ("one".equalsIgnoreCase(scope)) {
                return SearchScope.SINGLE_LEVEL;
            }
            throw new JsonValueException(configuration, "Illegal search scope: must be either 'sub' or 'one'");
        }
        return SearchScope.WHOLE_SUBTREE;
    }

    private static enum AuthenticationMethod {
        SASL_PLAIN,
        SEARCH_SIMPLE,
        SIMPLE;

    }
}

