/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.servlet;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.forgerock.json.resource.servlet.HttpUtils;
import org.forgerock.json.resource.servlet.Servlet2Adapter;
import org.forgerock.json.resource.servlet.ServletApiVersionAdapter;
import org.forgerock.json.resource.servlet.ServletSynchronizer;

final class Servlet3Adapter
extends ServletApiVersionAdapter {
    Servlet3Adapter() {
    }

    @Override
    public ServletSynchronizer createServletSynchronizer(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (httpRequest.isAsyncSupported()) {
            return new Servlet3Synchronizer(httpRequest, httpResponse);
        }
        return new Servlet2Adapter.Servlet2Synchronizer(httpRequest, httpResponse);
    }

    private static final class Servlet3Synchronizer
    implements ServletSynchronizer {
        private final AsyncContext asyncContext;
        private final HttpServletRequest httpRequest;
        private final HttpServletResponse httpResponse;

        private Servlet3Synchronizer(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
            this.httpRequest = httpRequest;
            this.httpResponse = httpResponse;
            if (httpRequest.isAsyncStarted()) {
                this.asyncContext = httpRequest.getAsyncContext();
            } else {
                this.asyncContext = httpRequest.startAsync();
                this.asyncContext.setTimeout(0L);
            }
        }

        @Override
        public void addAsyncListener(final Runnable runnable) {
            this.asyncContext.addListener(new AsyncListener(){

                public void onComplete(AsyncEvent event) throws IOException {
                    runnable.run();
                }

                public void onError(AsyncEvent event) throws IOException {
                    runnable.run();
                }

                public void onStartAsync(AsyncEvent event) throws IOException {
                    event.getAsyncContext().addListener((AsyncListener)this);
                }

                public void onTimeout(AsyncEvent event) throws IOException {
                    runnable.run();
                }
            });
        }

        @Override
        public void awaitIfNeeded() throws Exception {
        }

        @Override
        public boolean isAsync() {
            return true;
        }

        @Override
        public void signal() {
        }

        @Override
        public void signalAndComplete() {
            this.asyncContext.complete();
        }

        @Override
        public void signalAndComplete(Throwable t) {
            HttpUtils.fail(this.httpRequest, this.httpResponse, t);
            this.asyncContext.complete();
        }
    }
}

