/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.servlet;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.RootContext;
import org.forgerock.json.resource.SecurityContext;
import org.forgerock.json.resource.servlet.HttpServletContextFactory;

public final class SecurityContextFactory
implements HttpServletContextFactory {
    public static final String ATTRIBUTE_AUTHCID = "org.forgerock.security.authcid";
    public static final String ATTRIBUTE_AUTHZID = "org.forgerock.security.authzid";
    private static final SecurityContextFactory INSTANCE = new SecurityContextFactory();

    public static SecurityContextFactory getHttpServletContextFactory() {
        return INSTANCE;
    }

    private SecurityContextFactory() {
    }

    public SecurityContext createContext(Context parent, HttpServletRequest request) throws ResourceException {
        Map authzid;
        String authcid;
        try {
            authcid = (String)request.getAttribute(ATTRIBUTE_AUTHCID);
        }
        catch (ClassCastException e) {
            throw new InternalServerErrorException("The security context could not be created because the authentication ID attribute, org.forgerock.security.authcid, contained in the HTTP servlet request did not have the correct type", (Throwable)e);
        }
        try {
            authzid = (Map)request.getAttribute(ATTRIBUTE_AUTHZID);
        }
        catch (ClassCastException e) {
            throw new InternalServerErrorException("The security context could not be created because the authorization ID attribute, org.forgerock.security.authzid, contained in the HTTP servlet request did not have the correct type", (Throwable)e);
        }
        return new SecurityContext(parent, authcid, authzid);
    }

    public SecurityContext createContext(HttpServletRequest request) throws ResourceException {
        return this.createContext((Context)new RootContext(), request);
    }
}

