/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.servlet;

import java.io.Closeable;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonGenerator;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResult;
import org.forgerock.json.resource.QueryResultHandler;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestVisitor;
import org.forgerock.json.resource.Resource;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.json.resource.servlet.HttpUtils;
import org.forgerock.json.resource.servlet.ServletSynchronizer;

final class RequestRunner
implements ResultHandler<Connection>,
RequestVisitor<Void, Void> {
    private Connection connection = null;
    private final Context context;
    private final HttpServletRequest httpRequest;
    private final HttpServletResponse httpResponse;
    private final Request request;
    private final JsonGenerator writer;
    private final ServletSynchronizer sync;

    RequestRunner(Context context, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse, ServletSynchronizer sync) throws Exception {
        this.context = context;
        this.request = request;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.writer = HttpUtils.getJsonGenerator(httpRequest, httpResponse);
        this.sync = sync;
    }

    public final void handleError(ResourceException error) {
        this.onError((Exception)((Object)error));
    }

    public final void handleResult(Connection result) {
        this.connection = result;
        this.request.accept((RequestVisitor)this, null);
    }

    public final Void visitActionRequest(Void p, ActionRequest request) {
        this.connection.actionAsync(this.context, request, (ResultHandler)new ResultHandler<JsonValue>(){

            public void handleError(ResourceException error) {
                RequestRunner.this.onError((Exception)((Object)error));
            }

            public void handleResult(JsonValue result) {
                try {
                    if (result != null) {
                        RequestRunner.this.writeJsonValue(result);
                    } else {
                        RequestRunner.this.httpResponse.setStatus(204);
                    }
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
            }
        });
        return null;
    }

    public final Void visitCreateRequest(Void p, final CreateRequest request) {
        this.connection.createAsync(this.context, request, (ResultHandler)new ResultHandler<Resource>(){

            public void handleError(ResourceException error) {
                RequestRunner.this.onError((Exception)((Object)error));
            }

            public void handleResult(Resource result) {
                try {
                    if (result.getId() != null) {
                        RequestRunner.this.httpResponse.setHeader("Location", RequestRunner.this.getResourceURL(request, result));
                    }
                    RequestRunner.this.httpResponse.setStatus(201);
                    RequestRunner.this.writeResource(result);
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
            }
        });
        return null;
    }

    public final Void visitDeleteRequest(Void p, DeleteRequest request) {
        this.connection.deleteAsync(this.context, request, this.newResourceResultHandler());
        return null;
    }

    public final Void visitPatchRequest(Void p, PatchRequest request) {
        this.connection.patchAsync(this.context, request, this.newResourceResultHandler());
        return null;
    }

    public final Void visitQueryRequest(Void p, QueryRequest request) {
        this.connection.queryAsync(this.context, request, new QueryResultHandler(){
            private boolean isFirstResult = true;
            private int resultCount = 0;

            public void handleError(ResourceException error) {
                if (this.isFirstResult) {
                    RequestRunner.this.onError((Exception)((Object)error));
                } else {
                    try {
                        RequestRunner.this.writer.writeEndArray();
                        RequestRunner.this.writer.writeNumberField("resultCount", this.resultCount);
                        RequestRunner.this.writer.writeObjectField("error", error.toJsonValue().getObject());
                        RequestRunner.this.writer.writeEndObject();
                        RequestRunner.this.onSuccess();
                    }
                    catch (Exception e) {
                        RequestRunner.this.onError(e);
                    }
                }
            }

            public boolean handleResource(Resource resource) {
                try {
                    this.writeHeader();
                    RequestRunner.this.writeJsonValue(resource.getContent());
                    ++this.resultCount;
                    return true;
                }
                catch (Exception e) {
                    this.handleError(HttpUtils.adapt(e));
                    return false;
                }
            }

            public void handleResult(QueryResult result) {
                try {
                    this.writeHeader();
                    RequestRunner.this.writer.writeEndArray();
                    RequestRunner.this.writer.writeNumberField("resultCount", this.resultCount);
                    RequestRunner.this.writer.writeStringField("pagedResultsCookie", result.getPagedResultsCookie());
                    RequestRunner.this.writer.writeNumberField("remainingPagedResults", result.getRemainingPagedResults());
                    RequestRunner.this.writer.writeEndObject();
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
            }

            private void writeHeader() throws IOException {
                if (this.isFirstResult) {
                    RequestRunner.this.writer.writeStartObject();
                    RequestRunner.this.writer.writeArrayFieldStart("result");
                    this.isFirstResult = false;
                }
            }
        });
        return null;
    }

    public final Void visitReadRequest(Void p, ReadRequest request) {
        this.connection.readAsync(this.context, request, this.newResourceResultHandler());
        return null;
    }

    public final Void visitUpdateRequest(Void p, UpdateRequest request) {
        this.connection.updateAsync(this.context, request, this.newResourceResultHandler());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuccess() {
        try {
            HttpUtils.closeQuietly(new Closeable[]{this.connection, this.writer});
        }
        finally {
            this.sync.signalAndComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Exception e) {
        try {
            HttpUtils.closeQuietly(new Closeable[]{this.connection});
        }
        finally {
            this.sync.signalAndComplete(e);
        }
    }

    private String forceEmptyIfNull(String s) {
        return s != null ? s : "";
    }

    private String getResourceURL(CreateRequest request, Resource resource) {
        StringBuffer buffer = this.httpRequest.getRequestURL();
        buffer.setLength(buffer.length() - this.httpRequest.getRequestURI().length());
        buffer.append(this.forceEmptyIfNull(this.httpRequest.getContextPath()));
        buffer.append(this.forceEmptyIfNull(this.httpRequest.getServletPath()));
        buffer.append(request.getResourceName());
        if (!request.getResourceName().endsWith("/")) {
            buffer.append('/');
        }
        buffer.append(resource.getId());
        return buffer.toString();
    }

    private ResultHandler<Resource> newResourceResultHandler() {
        return new ResultHandler<Resource>(){

            public void handleError(ResourceException error) {
                RequestRunner.this.onError((Exception)((Object)error));
            }

            public void handleResult(Resource result) {
                try {
                    String rev;
                    if (RequestRunner.this.request instanceof ReadRequest && (rev = HttpUtils.getIfNoneMatch(RequestRunner.this.httpRequest)) != null && rev.equals(result.getRevision())) {
                        throw ResourceException.getException((int)304).setReason("Not Modified");
                    }
                    RequestRunner.this.writeResource(result);
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
            }
        };
    }

    private void writeJsonValue(JsonValue json) throws IOException {
        this.writer.writeObject(json.getObject());
    }

    private void writeResource(Resource resource) throws IOException {
        if (resource.getRevision() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append('\"');
            builder.append(resource.getRevision());
            builder.append('\"');
            this.httpResponse.setHeader("ETag", builder.toString());
        }
        this.writeJsonValue(resource.getContent());
    }
}

