/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ApiInfoContext;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.ConflictException;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryFilter;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.json.resource.servlet.HttpContext;
import org.forgerock.json.resource.servlet.HttpServletContextFactory;
import org.forgerock.json.resource.servlet.HttpUtils;
import org.forgerock.json.resource.servlet.RequestRunner;
import org.forgerock.json.resource.servlet.SecurityContextFactory;
import org.forgerock.json.resource.servlet.ServletApiVersionAdapter;
import org.forgerock.json.resource.servlet.ServletSynchronizer;

public final class HttpServletAdapter {
    private static final String THIS_API_URI;
    private static final String THIS_API_VERSION;
    private final ServletApiVersionAdapter syncFactory;
    private final ConnectionFactory connectionFactory;
    private final HttpServletContextFactory contextFactory;
    private final ServletContext servletContext;

    public HttpServletAdapter(ServletContext servletContext, ConnectionFactory connectionFactory) throws ServletException {
        this(servletContext, connectionFactory, (HttpServletContextFactory)null);
    }

    public HttpServletAdapter(ServletContext servletContext, ConnectionFactory connectionFactory, final Context parentContext) throws ServletException {
        this(servletContext, connectionFactory, new HttpServletContextFactory(){

            @Override
            public Context createContext(HttpServletRequest request) {
                return parentContext;
            }
        });
    }

    public HttpServletAdapter(ServletContext servletContext, ConnectionFactory connectionFactory, HttpServletContextFactory contextFactory) throws ServletException {
        this.servletContext = HttpUtils.checkNotNull(servletContext);
        this.contextFactory = contextFactory != null ? contextFactory : SecurityContextFactory.getHttpServletContextFactory();
        this.connectionFactory = HttpUtils.checkNotNull(connectionFactory);
        this.syncFactory = ServletApiVersionAdapter.getInstance(servletContext);
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String method = HttpUtils.getMethod(req);
        if ("DELETE".equals(method)) {
            this.doDelete(req, resp);
        } else if ("GET".equals(method)) {
            this.doGet(req, resp);
        } else if ("PATCH".equals(method)) {
            this.doPatch(req, resp);
        } else if ("POST".equals(method)) {
            this.doPost(req, resp);
        } else if ("PUT".equals(method)) {
            this.doPut(req, resp);
        } else {
            HttpUtils.fail(req, resp, (Throwable)new NotSupportedException("Method " + method + " not supported"));
        }
    }

    void doDelete(HttpServletRequest req, HttpServletResponse resp) {
        try {
            HttpUtils.prepareResponse(resp);
            this.preprocessRequest(req);
            HttpUtils.rejectIfNoneMatch(req);
            Map parameters = req.getParameterMap();
            DeleteRequest request = Requests.newDeleteRequest((String)this.getResourceName(req)).setRevision(HttpUtils.getIfMatch(req));
            for (Map.Entry p : parameters.entrySet()) {
                String[] values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (String[])p.getValue(), (Request)request)) continue;
                throw new BadRequestException("Unrecognized delete request parameter '" + name + "'");
            }
            this.doRequest(req, resp, (Request)request);
        }
        catch (Exception e) {
            HttpUtils.fail(req, resp, e);
        }
    }

    void doGet(HttpServletRequest req, HttpServletResponse resp) {
        block22: {
            try {
                HttpUtils.prepareResponse(resp);
                this.preprocessRequest(req);
                HttpUtils.rejectIfMatch(req);
                Map parameters = req.getParameterMap();
                if (HttpUtils.hasParameter(req, HttpUtils.PARAM_QUERY_ID) || HttpUtils.hasParameter(req, HttpUtils.PARAM_QUERY_EXPRESSION) || HttpUtils.hasParameter(req, HttpUtils.PARAM_QUERY_FILTER)) {
                    HttpUtils.rejectIfNoneMatch(req);
                    QueryRequest request = Requests.newQueryRequest((String)this.getResourceName(req));
                    for (Map.Entry p : parameters.entrySet()) {
                        String[] values;
                        String name = (String)p.getKey();
                        if (this.parseCommonParameter(name, values = (String[])p.getValue(), (Request)request)) continue;
                        if (name.equalsIgnoreCase(HttpUtils.PARAM_SORT_KEYS)) {
                            for (String s : values) {
                                try {
                                    request.addSortKey(s.split(","));
                                }
                                catch (IllegalArgumentException e) {
                                    throw new BadRequestException("The value '" + s + "' for parameter '" + name + "' could not be parsed as a comma " + "separated list of sort keys");
                                }
                            }
                            continue;
                        }
                        if (name.equalsIgnoreCase(HttpUtils.PARAM_QUERY_ID)) {
                            request.setQueryId(HttpUtils.asSingleValue(name, values));
                            continue;
                        }
                        if (name.equalsIgnoreCase(HttpUtils.PARAM_QUERY_EXPRESSION)) {
                            request.setQueryExpression(HttpUtils.asSingleValue(name, values));
                            continue;
                        }
                        if (name.equalsIgnoreCase(HttpUtils.PARAM_PAGED_RESULTS_COOKIE)) {
                            request.setPagedResultsCookie(HttpUtils.asSingleValue(name, values));
                            continue;
                        }
                        if (name.equalsIgnoreCase(HttpUtils.PARAM_PAGED_RESULTS_OFFSET)) {
                            request.setPagedResultsOffset(HttpUtils.asIntValue(name, values));
                            continue;
                        }
                        if (name.equalsIgnoreCase(HttpUtils.PARAM_PAGE_SIZE)) {
                            request.setPageSize(HttpUtils.asIntValue(name, values));
                            continue;
                        }
                        if (name.equalsIgnoreCase(HttpUtils.PARAM_QUERY_FILTER)) {
                            String s = HttpUtils.asSingleValue(name, values);
                            try {
                                request.setQueryFilter(QueryFilter.valueOf((String)s));
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                throw new BadRequestException("The value '" + s + "' for parameter '" + name + "' could not be parsed as a valid query filter");
                            }
                        }
                        request.setAdditionalQueryParameter(name, HttpUtils.asSingleValue(name, values));
                    }
                    if (request.getQueryId() != null && request.getQueryFilter() != null) {
                        throw new BadRequestException("The parameters " + HttpUtils.PARAM_QUERY_ID + " and " + HttpUtils.PARAM_QUERY_FILTER + " are mutually exclusive");
                    }
                    if (request.getQueryId() != null && request.getQueryExpression() != null) {
                        throw new BadRequestException("The parameters " + HttpUtils.PARAM_QUERY_ID + " and " + HttpUtils.PARAM_QUERY_EXPRESSION + " are mutually exclusive");
                    }
                    if (request.getQueryFilter() != null && request.getQueryExpression() != null) {
                        throw new BadRequestException("The parameters " + HttpUtils.PARAM_QUERY_FILTER + " and " + HttpUtils.PARAM_QUERY_EXPRESSION + " are mutually exclusive");
                    }
                    if (request.getQueryId() == null && !request.getAdditionalQueryParameters().isEmpty()) {
                        throw new BadRequestException("Additional query parameters can only be used with the parameter " + HttpUtils.PARAM_QUERY_ID);
                    }
                    this.doRequest(req, resp, (Request)request);
                    break block22;
                }
                String rev = HttpUtils.getIfNoneMatch(req);
                if ("*".equals(rev)) {
                    throw new PreconditionFailedException("If-None-Match * not appropriate for " + HttpUtils.getMethod(req) + " requests");
                }
                ReadRequest request = Requests.newReadRequest((String)this.getResourceName(req));
                for (Map.Entry p : parameters.entrySet()) {
                    String[] values;
                    String name = (String)p.getKey();
                    if (this.parseCommonParameter(name, values = (String[])p.getValue(), (Request)request)) continue;
                    throw new BadRequestException("Unrecognized read request parameter '" + name + "'");
                }
                this.doRequest(req, resp, (Request)request);
            }
            catch (Exception e) {
                HttpUtils.fail(req, resp, e);
            }
        }
    }

    void doPatch(HttpServletRequest req, HttpServletResponse resp) {
        try {
            HttpUtils.prepareResponse(resp);
            this.preprocessRequest(req);
            if (req.getHeader("If-None-Match") != null) {
                throw new PreconditionFailedException("Use of If-None-Match not supported for PATCH requests");
            }
            Map parameters = req.getParameterMap();
            PatchRequest request = Requests.newPatchRequest((String)this.getResourceName(req), (PatchOperation[])new PatchOperation[0]).setRevision(HttpUtils.getIfMatch(req));
            request.getPatchOperations().addAll(HttpUtils.getJsonPatchContent(req));
            for (Map.Entry p : parameters.entrySet()) {
                String[] values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (String[])p.getValue(), (Request)request)) continue;
                throw new BadRequestException("Unrecognized update request parameter '" + name + "'");
            }
            this.doRequest(req, resp, (Request)request);
        }
        catch (Exception e) {
            HttpUtils.fail(req, resp, e);
        }
    }

    void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            HttpUtils.prepareResponse(resp);
            this.preprocessRequest(req);
            HttpUtils.rejectIfNoneMatch(req);
            HttpUtils.rejectIfMatch(req);
            Map parameters = req.getParameterMap();
            String action = HttpUtils.asSingleValue(HttpUtils.PARAM_ACTION, HttpUtils.getParameter(req, HttpUtils.PARAM_ACTION));
            if (action.equalsIgnoreCase("create")) {
                JsonValue content = HttpUtils.getJsonContent(req);
                CreateRequest request = Requests.newCreateRequest((String)this.getResourceName(req), (JsonValue)content);
                for (Map.Entry p : parameters.entrySet()) {
                    String[] values;
                    String name = (String)p.getKey();
                    if (this.parseCommonParameter(name, values = (String[])p.getValue(), (Request)request) || name.equalsIgnoreCase(HttpUtils.PARAM_ACTION)) continue;
                    throw new BadRequestException("Unrecognized create request parameter '" + name + "'");
                }
                this.doRequest(req, resp, (Request)request);
            } else {
                JsonValue content = HttpUtils.getJsonContent(req);
                ActionRequest request = Requests.newActionRequest((String)this.getResourceName(req), (String)action).setContent(content);
                for (Map.Entry p : parameters.entrySet()) {
                    String[] values;
                    String name = (String)p.getKey();
                    if (this.parseCommonParameter(name, values = (String[])p.getValue(), (Request)request) || name.equalsIgnoreCase(HttpUtils.PARAM_ACTION)) continue;
                    request.setAdditionalActionParameter(name, HttpUtils.asSingleValue(name, values));
                }
                this.doRequest(req, resp, (Request)request);
            }
        }
        catch (Exception e) {
            HttpUtils.fail(req, resp, e);
        }
    }

    void doPut(HttpServletRequest req, HttpServletResponse resp) {
        try {
            HttpUtils.prepareResponse(resp);
            this.preprocessRequest(req);
            if (req.getHeader("If-Match") != null && req.getHeader("If-None-Match") != null) {
                throw new PreconditionFailedException("Simultaneous use of If-Match and If-None-Match not supported for PUT requests");
            }
            Map parameters = req.getParameterMap();
            JsonValue content = HttpUtils.getJsonContent(req);
            String rev = HttpUtils.getIfNoneMatch(req);
            if ("*".equals(rev)) {
                String resourceName = this.getResourceName(req);
                int i = resourceName.lastIndexOf(47);
                if (i < 0) {
                    throw new InternalServerErrorException("Invalid HTTP servlet request path info");
                }
                CreateRequest request = i == 0 ? Requests.newCreateRequest((String)"/", (JsonValue)content) : Requests.newCreateRequest((String)resourceName.substring(0, i), (JsonValue)content);
                String newResourceId = resourceName.substring(i + 1);
                if (newResourceId.isEmpty()) {
                    throw new BadRequestException("No new resource ID in HTTP PUT request");
                }
                request.setNewResourceId(newResourceId);
                for (Map.Entry p : parameters.entrySet()) {
                    String[] values;
                    String name = (String)p.getKey();
                    if (this.parseCommonParameter(name, values = (String[])p.getValue(), (Request)request)) continue;
                    throw new BadRequestException("Unrecognized create request parameter '" + name + "'");
                }
                this.doRequest(req, resp, (Request)request);
            } else {
                UpdateRequest request = Requests.newUpdateRequest((String)this.getResourceName(req), (JsonValue)content).setRevision(HttpUtils.getIfMatch(req));
                for (Map.Entry p : parameters.entrySet()) {
                    String[] values;
                    String name = (String)p.getKey();
                    if (this.parseCommonParameter(name, values = (String[])p.getValue(), (Request)request)) continue;
                    throw new BadRequestException("Unrecognized update request parameter '" + name + "'");
                }
                this.doRequest(req, resp, (Request)request);
            }
        }
        catch (Exception e) {
            HttpUtils.fail(req, resp, e);
        }
    }

    private void doRequest(HttpServletRequest req, HttpServletResponse resp, Request request) throws ResourceException, Exception {
        Context context = this.newRequestContext(req);
        ServletSynchronizer sync = this.syncFactory.createServletSynchronizer(req, resp);
        RequestRunner runner = new RequestRunner(context, request, req, resp, sync);
        this.connectionFactory.getConnectionAsync((ResultHandler)runner);
        sync.awaitIfNeeded();
    }

    private void dumpRequest(HttpServletRequest req) {
        String newline = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("Method=" + req.getMethod() + newline);
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            builder.append("Header " + headerName + "=" + req.getHeader(headerName) + newline);
        }
        builder.append("RequestURI=" + req.getRequestURI() + newline);
        builder.append("ContextPath=" + req.getContextPath() + newline);
        builder.append("ServletPath=" + req.getServletPath() + newline);
        builder.append("PathInfo=" + req.getPathInfo() + newline);
        builder.append("QueryString=" + req.getQueryString() + newline);
        Enumeration parameterNames = req.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            builder.append("Parameter " + parameterName + "=" + Arrays.asList(req.getParameterValues(parameterName)) + newline);
        }
        builder.append(newline);
        this.servletContext.log(builder.toString());
    }

    private String getResourceName(HttpServletRequest req) throws ResourceException {
        String resourceName = req.getPathInfo();
        return resourceName == null ? "/" : resourceName;
    }

    private Context newRequestContext(HttpServletRequest req) throws ResourceException {
        Context root = this.contextFactory.createContext(req);
        return new ApiInfoContext((Context)new HttpContext(root, req), THIS_API_URI, THIS_API_VERSION);
    }

    private boolean parseCommonParameter(String name, String[] values, Request request) throws ResourceException {
        if (name.equalsIgnoreCase(HttpUtils.PARAM_FIELDS)) {
            for (String s : values) {
                try {
                    request.addField(s.split(","));
                }
                catch (IllegalArgumentException e) {
                    throw new BadRequestException("The value '" + s + "' for parameter '" + name + "' could not be parsed as a comma separated list of JSON pointers");
                }
            }
            return true;
        }
        if (name.equalsIgnoreCase("_prettyPrint")) {
            HttpUtils.asBooleanValue(name, values);
            return true;
        }
        if (name.equalsIgnoreCase("_debug")) {
            HttpUtils.asBooleanValue(name, values);
            return true;
        }
        return false;
    }

    private void preprocessRequest(HttpServletRequest req) throws ResourceException {
        String contentType;
        if (HttpUtils.isDebugRequested(req)) {
            this.dumpRequest(req);
        }
        if ((contentType = req.getContentType()) != null && !HttpUtils.CONTENT_TYPE_REGEX.matcher(contentType).matches()) {
            throw new BadRequestException("The request could not be processed because it specified the content-type '" + req.getContentType() + "' when only the content-type '" + "application/json" + "' is supported");
        }
        if (req.getHeader("If-Modified-Since") != null) {
            throw new ConflictException("Header If-Modified-Since not supported");
        }
        if (req.getHeader("If-Unmodified-Since") != null) {
            throw new ConflictException("Header If-Unmodified-Since not supported");
        }
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle(HttpServletAdapter.class.getName());
        THIS_API_URI = bundle.getString("rest-api-uri");
        THIS_API_VERSION = bundle.getString("rest-api-version");
    }
}

