/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.servlet;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.servlet.HttpServletAdapter;
import org.forgerock.json.resource.servlet.HttpServletContextFactory;
import org.forgerock.json.resource.servlet.HttpUtils;

public class HttpServlet
extends javax.servlet.http.HttpServlet {
    private static final String INIT_PARAM_CONNECTION_CLASS = "connection-factory-class";
    private static final String INIT_PARAM_CONNECTION_METHOD = "connection-factory-method";
    private static final String INIT_PARAM_CONNECTION_METHOD_DEFAULT = "getConnectionFactory";
    private static final String INIT_PARAM_CONTEXT_CLASS = "context-factory-class";
    private static final String INIT_PARAM_CONTEXT_METHOD = "context-factory-method";
    private static final String INIT_PARAM_CONTEXT_METHOD_DEFAULT = "getHttpServletContextFactory";
    private static final String METHOD_PATCH = "PATCH";
    private static final long serialVersionUID = 6089858120348026823L;
    private HttpServletAdapter adapter;
    private ConnectionFactory connectionFactory;
    private HttpServletContextFactory contextFactory;

    public HttpServlet() {
        this.connectionFactory = null;
        this.contextFactory = null;
    }

    public HttpServlet(ConnectionFactory connectionFactory) {
        this.connectionFactory = HttpUtils.checkNotNull(connectionFactory);
        this.contextFactory = null;
    }

    public HttpServlet(ConnectionFactory connectionFactory, final Context parentContext) {
        this.connectionFactory = HttpUtils.checkNotNull(connectionFactory);
        HttpUtils.checkNotNull(parentContext);
        this.contextFactory = new HttpServletContextFactory(){

            @Override
            public Context createContext(HttpServletRequest request) {
                return parentContext;
            }
        };
    }

    public HttpServlet(ConnectionFactory connectionFactory, HttpServletContextFactory contextFactory) {
        this.connectionFactory = HttpUtils.checkNotNull(connectionFactory);
        this.contextFactory = HttpUtils.checkNotNull(contextFactory);
    }

    public void destroy() {
        if (this.connectionFactory != null) {
            this.connectionFactory.close();
        }
    }

    public void init() throws ServletException {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.getConnectionFactory();
        }
        if (this.contextFactory == null) {
            this.contextFactory = this.getHttpServletContextFactory();
        }
        this.adapter = new HttpServletAdapter(this.getServletContext(), this.connectionFactory, this.contextFactory);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.adapter.doDelete(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.adapter.doGet(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", "DELETE, GET, HEAD, PATCH, POST, PUT, OPTIONS, TRACE");
    }

    protected void doPatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.adapter.doPatch(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.adapter.doPost(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.adapter.doPut(req, resp);
    }

    protected ConnectionFactory getConnectionFactory() throws ServletException {
        String className;
        ServletConfig config = this.getServletConfig();
        if (config != null && (className = config.getInitParameter(INIT_PARAM_CONNECTION_CLASS)) != null) {
            try {
                Class<?> cls = Class.forName(className);
                String tmp = config.getInitParameter(INIT_PARAM_CONNECTION_METHOD);
                String methodName = tmp != null ? tmp : INIT_PARAM_CONNECTION_METHOD_DEFAULT;
                try {
                    Method factoryMethod = cls.getDeclaredMethod(methodName, ServletConfig.class);
                    return (ConnectionFactory)factoryMethod.invoke(null, config);
                }
                catch (NoSuchMethodException e) {
                    Method factoryMethod = cls.getDeclaredMethod(methodName, new Class[0]);
                    return (ConnectionFactory)factoryMethod.invoke(null, new Object[0]);
                }
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        throw new ServletException("Unable to initialize ConnectionFactory");
    }

    protected HttpServletContextFactory getHttpServletContextFactory() throws ServletException {
        String className;
        ServletConfig config = this.getServletConfig();
        if (config != null && (className = config.getInitParameter(INIT_PARAM_CONTEXT_CLASS)) != null) {
            try {
                Class<?> cls = Class.forName(className);
                String tmp = config.getInitParameter(INIT_PARAM_CONTEXT_METHOD);
                String methodName = tmp != null ? tmp : INIT_PARAM_CONTEXT_METHOD_DEFAULT;
                try {
                    Method factoryMethod = cls.getDeclaredMethod(methodName, ServletConfig.class);
                    return (HttpServletContextFactory)factoryMethod.invoke(null, config);
                }
                catch (NoSuchMethodException e) {
                    Method factoryMethod = cls.getDeclaredMethod(methodName, new Class[0]);
                    return (HttpServletContextFactory)factoryMethod.invoke(null, new Object[0]);
                }
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        return null;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if (method.equals(METHOD_PATCH)) {
            this.doPatch(req, resp);
        } else {
            super.service(req, resp);
        }
    }
}

