/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.servlet;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.PersistenceConfig;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.servlet.HttpUtils;
import org.forgerock.util.Factory;
import org.forgerock.util.LazyMap;

public final class HttpContext
extends Context {
    private static final String ATTR_HEADERS = "headers";
    private static final String ATTR_METHOD = "method";
    private static final String ATTR_PARAMETERS = "parameters";
    private static final String ATTR_PATH = "path";
    private final Map<String, List<String>> headers;
    private final String method;
    private final Map<String, List<String>> parameters;
    private final String path;

    public HttpContext(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super(savedContext, config);
        this.method = savedContext.get(ATTR_METHOD).required().asString();
        this.path = savedContext.get(ATTR_PATH).required().asString();
        this.headers = savedContext.get(ATTR_HEADERS).required().asMap();
        this.parameters = savedContext.get(ATTR_PARAMETERS).required().asMap();
    }

    HttpContext(Context parent, final HttpServletRequest req) {
        super(parent);
        this.method = HttpUtils.getMethod(req);
        this.path = req.getRequestURL().toString();
        this.headers = Collections.unmodifiableMap(new LazyMap((Factory)new Factory<Map<String, List<String>>>(){

            public Map<String, List<String>> newInstance() {
                LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
                Enumeration i = req.getHeaderNames();
                while (i.hasMoreElements()) {
                    String name = (String)i.nextElement();
                    Enumeration j = req.getHeaders(name);
                    LinkedList values = new LinkedList();
                    while (j.hasMoreElements()) {
                        values.add(j.nextElement());
                    }
                    result.put(name, values);
                }
                return result;
            }
        }));
        this.parameters = Collections.unmodifiableMap(new LazyMap((Factory)new Factory<Map<String, List<String>>>(){

            public Map<String, List<String>> newInstance() {
                LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
                Set parameters = req.getParameterMap().entrySet();
                for (Map.Entry parameter : parameters) {
                    String name = (String)parameter.getKey();
                    String[] values = (String[])parameter.getValue();
                    result.put(name, Arrays.asList(values));
                }
                return result;
            }
        }));
    }

    public List<String> getHeader(String name) {
        List<String> header = this.headers.get(name);
        return header != null ? header : Collections.emptyList();
    }

    public String getHeaderAsString(String name) {
        List<String> header = this.getHeader(name);
        return header.isEmpty() ? null : header.get(0);
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getParameter(String name) {
        List<String> parameter = this.parameters.get(name);
        return parameter != null ? parameter : Collections.emptyList();
    }

    public String getParameterAsString(String name) {
        List<String> parameter = this.getParameter(name);
        return parameter.isEmpty() ? null : parameter.get(0);
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public String getPath() {
        return this.path;
    }

    protected void saveToJson(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super.saveToJson(savedContext, config);
        savedContext.put(ATTR_METHOD, (Object)this.method);
        savedContext.put(ATTR_PATH, (Object)this.path);
        savedContext.put(ATTR_HEADERS, this.headers);
        savedContext.put(ATTR_PARAMETERS, this.parameters);
    }
}

