/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.servlet;

import com.forgerock.opendj.util.StaticUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.FutureResult;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.json.resource.Router;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.rest2ldap.AuthorizationPolicy;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;

public final class Rest2LDAPConnectionFactoryProvider {
    private static final String INIT_PARAM_CONFIG_FILE = "config-file";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static org.forgerock.json.resource.ConnectionFactory getConnectionFactory(ServletConfig config) throws ServletException {
        org.forgerock.json.resource.ConnectionFactory connectionFactory;
        org.forgerock.json.resource.ConnectionFactory factory;
        InputStream configFile;
        String configFileName;
        block10: {
            configFileName = config.getInitParameter(INIT_PARAM_CONFIG_FILE);
            if (configFileName == null) {
                throw new ServletException("Servlet initialization parameter 'config-file' not specified");
            }
            configFile = config.getServletContext().getResourceAsStream(configFileName);
            if (configFile == null) {
                throw new ServletException("Servlet configuration file '" + configFileName + "' not found");
            }
            Object content = JSON_MAPPER.readValue(configFile, Object.class);
            if (!(content instanceof Map)) {
                throw new ServletException("Servlet configuration file '" + configFileName + "' does not contain a valid JSON configuration");
            }
            JsonValue configuration = new JsonValue(content);
            AuthorizationPolicy authzPolicy = (AuthorizationPolicy)configuration.get("servlet").get("authorizationPolicy").required().asEnum(AuthorizationPolicy.class);
            String proxyAuthzTemplate = configuration.get("servlet").get("proxyAuthzIdTemplate").asString();
            String ldapFactoryName = configuration.get("servlet").get("ldapConnectionFactory").asString();
            final ConnectionFactory ldapFactory = ldapFactoryName != null ? Rest2LDAP.configureConnectionFactory((JsonValue)configuration.get("ldapConnectionFactories").required(), (String)ldapFactoryName) : null;
            Router router = new Router();
            JsonValue mappings = configuration.get("servlet").get("mappings").required();
            for (String mappingUrl : mappings.keys()) {
                JsonValue mapping = mappings.get(mappingUrl);
                CollectionResourceProvider provider = Rest2LDAP.builder().ldapConnectionFactory(ldapFactory).authorizationPolicy(authzPolicy).proxyAuthzIdTemplate(proxyAuthzTemplate).configureMapping(mapping).build();
                router.addRoute(mappingUrl, provider);
            }
            factory = Resources.newInternalConnectionFactory((RequestHandler)router);
            if (ldapFactory == null) break block10;
            connectionFactory = new org.forgerock.json.resource.ConnectionFactory(){

                public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
                    return factory.getConnectionAsync(handler);
                }

                public Connection getConnection() throws ResourceException {
                    return factory.getConnection();
                }

                public void close() {
                    ldapFactory.close();
                }
            };
            StaticUtils.closeSilently((Closeable[])new Closeable[]{configFile});
            return connectionFactory;
        }
        try {
            connectionFactory = factory;
        }
        catch (ServletException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new ServletException("Servlet configuration file '" + configFileName + "' could not be read: " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                StaticUtils.closeSilently((Closeable[])new Closeable[]{configFile});
                throw throwable;
            }
        }
        StaticUtils.closeSilently((Closeable[])new Closeable[]{configFile});
        return connectionFactory;
    }

    private Rest2LDAPConnectionFactoryProvider() {
    }
}

