/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.opendj.ldif.AbstractLDIFReader;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordReader;
import org.forgerock.opendj.ldif.RejectedLDIFListener;

public final class LDIFChangeRecordReader
extends AbstractLDIFReader
implements ChangeRecordReader {
    private static final Pattern CONTROL_REGEX = Pattern.compile("^\\s*(\\d+(.\\d+)*)(\\s+((true)|(false)))?\\s*(:(:)?\\s*?\\S+)?\\s*$");
    private static final ChangeRecord EOF = Requests.newAddRequest(DN.rootDN());
    private ChangeRecord nextChangeRecord = null;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChangeRecord valueOfLDIFChangeRecord(String ... ldifLines) {
        ChangeRecord message3222222;
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(ldifLines);
        try {
            if (!reader.hasNext()) {
                LocalizableMessage message2 = CoreMessages.WARN_READ_LDIF_RECORD_NO_CHANGE_RECORD_FOUND.get();
                throw new LocalizedIllegalArgumentException(message2);
            }
            ChangeRecord record = reader.readChangeRecord();
            if (reader.hasNext()) {
                LocalizableMessage message3222222 = CoreMessages.WARN_READ_LDIF_RECORD_MULTIPLE_CHANGE_RECORDS_FOUND.get();
                throw new LocalizedIllegalArgumentException(message3222222);
            }
            message3222222 = record;
        }
        catch (DecodeException e) {
            try {
                throw new LocalizedIllegalArgumentException(e.getMessageObject());
                catch (IOException e2) {
                    LocalizableMessage message4 = CoreMessages.WARN_READ_LDIF_RECORD_UNEXPECTED_IO_ERROR.get((Object)e2.getMessage());
                    throw new LocalizedIllegalArgumentException(message4);
                }
            }
            catch (Throwable throwable) {
                StaticUtils.closeSilently(reader);
                throw throwable;
            }
        }
        StaticUtils.closeSilently(reader);
        return message3222222;
    }

    public LDIFChangeRecordReader(InputStream in) {
        super(in);
    }

    public LDIFChangeRecordReader(List<String> ldifLines) {
        super(ldifLines);
    }

    public LDIFChangeRecordReader(Reader reader) {
        super(reader);
    }

    public LDIFChangeRecordReader(String ... ldifLines) {
        super(Arrays.asList(ldifLines));
    }

    @Override
    public void close() throws IOException {
        this.close0();
    }

    @Override
    public boolean hasNext() throws DecodeException, IOException {
        return this.getNextChangeRecord() != EOF;
    }

    @Override
    public ChangeRecord readChangeRecord() throws DecodeException, IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ChangeRecord changeRecord = this.nextChangeRecord;
        this.nextChangeRecord = null;
        return changeRecord;
    }

    public LDIFChangeRecordReader setExcludeAllOperationalAttributes(boolean excludeOperationalAttributes) {
        this.excludeOperationalAttributes = excludeOperationalAttributes;
        return this;
    }

    public LDIFChangeRecordReader setExcludeAllUserAttributes(boolean excludeUserAttributes) {
        this.excludeUserAttributes = excludeUserAttributes;
        return this;
    }

    public LDIFChangeRecordReader setExcludeAttribute(AttributeDescription attributeDescription) {
        Validator.ensureNotNull(attributeDescription);
        this.excludeAttributes.add(attributeDescription);
        return this;
    }

    public LDIFChangeRecordReader setExcludeBranch(DN excludeBranch) {
        Validator.ensureNotNull(excludeBranch);
        this.excludeBranches.add(excludeBranch);
        return this;
    }

    public LDIFChangeRecordReader setIncludeAttribute(AttributeDescription attributeDescription) {
        Validator.ensureNotNull(attributeDescription);
        this.includeAttributes.add(attributeDescription);
        return this;
    }

    public LDIFChangeRecordReader setIncludeBranch(DN includeBranch) {
        Validator.ensureNotNull(includeBranch);
        this.includeBranches.add(includeBranch);
        return this;
    }

    public LDIFChangeRecordReader setRejectedLDIFListener(RejectedLDIFListener listener) {
        this.rejectedRecordListener = listener;
        return this;
    }

    public LDIFChangeRecordReader setSchema(Schema schema) {
        Validator.ensureNotNull(schema);
        this.schema = this.schemaValidationPolicy.checkAttributesAndObjectClasses().needsChecking() ? schema.asStrictSchema() : schema.asNonStrictSchema();
        return this;
    }

    public LDIFChangeRecordReader setSchemaValidationPolicy(SchemaValidationPolicy policy) {
        this.schemaValidationPolicy = SchemaValidationPolicy.copyOf(policy);
        this.schema = this.schemaValidationPolicy.checkAttributesAndObjectClasses().needsChecking() ? this.schema.asStrictSchema() : this.schema.asNonStrictSchema();
        return this;
    }

    private ChangeRecord getNextChangeRecord() throws DecodeException, IOException {
        while (this.nextChangeRecord == null) {
            AbstractLDIFReader.LDIFRecord record = this.readLDIFRecord();
            if (record == null) {
                this.nextChangeRecord = EOF;
                break;
            }
            try {
                String ldifLine;
                AbstractLDIFReader.KeyValuePair pair;
                DN entryDN = this.readLDIFRecordDN(record);
                if (entryDN == null) continue;
                if (this.isBranchExcluded(entryDN)) {
                    LocalizableMessage message = CoreMessages.ERR_LDIF_CHANGE_EXCLUDED_BY_DN.get((Object)record.lineNumber, (Object)entryDN.toString());
                    this.handleSkippedRecord(record, message);
                    continue;
                }
                LinkedList<Control> controls = null;
                while (true) {
                    LocalizableMessage message;
                    if (!record.iterator.hasNext()) {
                        message = CoreMessages.ERR_LDIF_NO_CHANGE_TYPE.get((Object)record.lineNumber, (Object)entryDN.toString());
                        throw DecodeException.error(message);
                    }
                    pair = new AbstractLDIFReader.KeyValuePair();
                    ldifLine = this.readLDIFRecordKeyValuePair(record, pair, false);
                    if (pair.key == null) {
                        message = CoreMessages.ERR_LDIF_MALFORMED_CHANGE_TYPE.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)ldifLine);
                        throw DecodeException.error(message);
                    }
                    if (!StaticUtils.toLowerCase(pair.key).equals("control")) break;
                    if (controls == null) {
                        controls = new LinkedList<Control>();
                    }
                    controls.add(this.parseControl(entryDN, record, ldifLine, pair.value));
                }
                if (!StaticUtils.toLowerCase(pair.key).equals("changetype")) {
                    this.nextChangeRecord = this.parseAddChangeRecordEntry(entryDN, ldifLine, record);
                    continue;
                }
                String changeType = StaticUtils.toLowerCase(pair.value);
                if (changeType.equals("add")) {
                    this.nextChangeRecord = this.parseAddChangeRecordEntry(entryDN, null, record);
                } else if (changeType.equals("delete")) {
                    this.nextChangeRecord = this.parseDeleteChangeRecordEntry(entryDN, record);
                } else if (changeType.equals("modify")) {
                    this.nextChangeRecord = this.parseModifyChangeRecordEntry(entryDN, record);
                } else if (changeType.equals("modrdn")) {
                    this.nextChangeRecord = this.parseModifyDNChangeRecordEntry(entryDN, record);
                } else if (changeType.equals("moddn")) {
                    this.nextChangeRecord = this.parseModifyDNChangeRecordEntry(entryDN, record);
                } else {
                    LocalizableMessage message = CoreMessages.ERR_LDIF_BAD_CHANGE_TYPE.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)pair.value);
                    throw DecodeException.error(message);
                }
                if (controls == null) continue;
                for (Control control : controls) {
                    this.nextChangeRecord.addControl(control);
                }
            }
            catch (DecodeException e) {
                this.handleMalformedRecord(record, e.getMessageObject());
            }
        }
        return this.nextChangeRecord;
    }

    private ChangeRecord parseAddChangeRecordEntry(DN entryDN, String lastLDIFLine, AbstractLDIFReader.LDIFRecord record) throws DecodeException {
        LinkedHashMapEntry entry = new LinkedHashMapEntry(entryDN);
        boolean schemaValidationFailure = false;
        LinkedList<LocalizableMessage> schemaErrors = new LinkedList<LocalizableMessage>();
        if (lastLDIFLine != null && !this.readLDIFRecordAttributeValue(record, lastLDIFLine, entry, schemaErrors)) {
            schemaValidationFailure = true;
        }
        while (record.iterator.hasNext()) {
            String ldifLine = record.iterator.next();
            if (this.readLDIFRecordAttributeValue(record, ldifLine, entry, schemaErrors)) continue;
            schemaValidationFailure = true;
        }
        if (!this.schema.validateEntry(entry, this.schemaValidationPolicy, schemaErrors)) {
            schemaValidationFailure = true;
        }
        if (schemaValidationFailure) {
            this.handleSchemaValidationFailure(record, schemaErrors);
            return null;
        }
        if (!schemaErrors.isEmpty()) {
            this.handleSchemaValidationWarning(record, schemaErrors);
        }
        return Requests.newAddRequest(entry);
    }

    private Control parseControl(DN entryDN, AbstractLDIFReader.LDIFRecord record, String ldifLine, String value) throws DecodeException {
        Matcher matcher = CONTROL_REGEX.matcher(value);
        if (!matcher.matches()) {
            LocalizableMessage message = CoreMessages.ERR_LDIF_MALFORMED_CONTROL.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)ldifLine);
            throw DecodeException.error(message);
        }
        String oid = matcher.group(1);
        boolean isCritical = matcher.group(5) != null;
        String controlValueString = matcher.group(7);
        ByteString controlValue = null;
        if (controlValueString != null) {
            controlValue = this.parseSingleValue(record, ldifLine, entryDN, ldifLine.indexOf(58, 8), oid);
        }
        return GenericControl.newControl(oid, isCritical, controlValue);
    }

    private ChangeRecord parseDeleteChangeRecordEntry(DN entryDN, AbstractLDIFReader.LDIFRecord record) throws DecodeException {
        if (record.iterator.hasNext()) {
            LocalizableMessage message = CoreMessages.ERR_LDIF_MALFORMED_DELETE.get((Object)record.lineNumber, (Object)entryDN.toString());
            throw DecodeException.error(message);
        }
        return Requests.newDeleteRequest(entryDN);
    }

    private ChangeRecord parseModifyChangeRecordEntry(DN entryDN, AbstractLDIFReader.LDIFRecord record) throws DecodeException {
        ModifyRequest modifyRequest = Requests.newModifyRequest(entryDN);
        AbstractLDIFReader.KeyValuePair pair = new AbstractLDIFReader.KeyValuePair();
        ArrayList<ByteString> attributeValues = new ArrayList<ByteString>();
        boolean schemaValidationFailure = false;
        LinkedList<LocalizableMessage> schemaErrors = new LinkedList<LocalizableMessage>();
        block9: while (record.iterator.hasNext()) {
            LocalizableMessage message;
            AttributeDescription attributeDescription;
            ModificationType modType;
            String ldifLine = this.readLDIFRecordKeyValuePair(record, pair, false);
            if (pair.key == null) {
                LocalizableMessage message2 = CoreMessages.ERR_LDIF_MALFORMED_MODIFICATION_TYPE.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)ldifLine);
                throw DecodeException.error(message2);
            }
            String changeType = StaticUtils.toLowerCase(pair.key);
            if (changeType.equals("add")) {
                modType = ModificationType.ADD;
            } else if (changeType.equals("delete")) {
                modType = ModificationType.DELETE;
            } else if (changeType.equals("replace")) {
                modType = ModificationType.REPLACE;
            } else if (changeType.equals("increment")) {
                modType = ModificationType.INCREMENT;
            } else {
                LocalizableMessage message3 = CoreMessages.ERR_LDIF_BAD_MODIFICATION_TYPE.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)pair.key);
                throw DecodeException.error(message3);
            }
            try {
                attributeDescription = AttributeDescription.valueOf(pair.value, this.schema);
            }
            catch (UnknownSchemaElementException e) {
                message = CoreMessages.ERR_LDIF_UNKNOWN_ATTRIBUTE_TYPE.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)pair.value);
                switch (this.schemaValidationPolicy.checkAttributesAndObjectClasses()) {
                    case REJECT: {
                        schemaValidationFailure = true;
                        schemaErrors.add(message);
                        continue block9;
                    }
                    case WARN: {
                        schemaErrors.add(message);
                        continue block9;
                    }
                }
                throw new IllegalStateException("Schema is not consistent with policy", (Throwable)((Object)e));
            }
            catch (LocalizedIllegalArgumentException e) {
                message = CoreMessages.ERR_LDIF_MALFORMED_ATTRIBUTE_NAME.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)pair.value);
                throw DecodeException.error(message);
            }
            if (this.isAttributeExcluded(attributeDescription)) continue;
            Syntax syntax = attributeDescription.getAttributeType().getSyntax();
            if (!syntax.isBEREncodingRequired()) {
                if (this.schemaValidationPolicy.checkAttributeValues().needsChecking() && attributeDescription.hasOption("binary")) {
                    message = CoreMessages.ERR_LDIF_UNEXPECTED_BINARY_OPTION.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)pair.value);
                    if (this.schemaValidationPolicy.checkAttributeValues().isReject()) {
                        schemaValidationFailure = true;
                    }
                    schemaErrors.add(message);
                    continue;
                }
            } else {
                attributeDescription = attributeDescription.withOption("binary");
            }
            attributeValues.clear();
            while (record.iterator.hasNext() && !(ldifLine = record.iterator.next()).equals("-")) {
                LocalizableMessageBuilder builder;
                AttributeDescription attributeDescription2;
                int colonPos = this.parseColonPosition(record, ldifLine);
                String attrDescr = ldifLine.substring(0, colonPos);
                try {
                    attributeDescription2 = AttributeDescription.valueOf(attrDescr, this.schema);
                }
                catch (LocalizedIllegalArgumentException e) {
                    LocalizableMessage message4 = CoreMessages.ERR_LDIF_MALFORMED_ATTRIBUTE_NAME.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)attrDescr);
                    throw DecodeException.error(message4);
                }
                if (attributeDescription.getAttributeType().getSyntax().isBEREncodingRequired()) {
                    attributeDescription2 = attributeDescription2.withOption("binary");
                }
                if (!attributeDescription2.equals(attributeDescription)) {
                    LocalizableMessage message5 = CoreMessages.ERR_LDIF_ATTRIBUTE_NAME_MISMATCH.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)attributeDescription2.toString(), (Object)attributeDescription.toString());
                    throw DecodeException.error(message5);
                }
                ByteString value = this.parseSingleValue(record, ldifLine, entryDN, colonPos, attrDescr);
                if (this.schemaValidationPolicy.checkAttributeValues().needsChecking() && !syntax.valueIsAcceptable(value, builder = new LocalizableMessageBuilder())) {
                    if (this.schemaValidationPolicy.checkAttributeValues().isReject()) {
                        schemaValidationFailure = true;
                    }
                    schemaErrors.add(builder.toMessage());
                }
                attributeValues.add(value);
            }
            Modification change = new Modification(modType, new LinkedAttribute(attributeDescription, attributeValues));
            modifyRequest.addModification(change);
        }
        if (schemaValidationFailure) {
            this.handleSchemaValidationFailure(record, schemaErrors);
            return null;
        }
        if (!schemaErrors.isEmpty()) {
            this.handleSchemaValidationWarning(record, schemaErrors);
        }
        return modifyRequest;
    }

    private ChangeRecord parseModifyDNChangeRecordEntry(DN entryDN, AbstractLDIFReader.LDIFRecord record) throws DecodeException {
        LocalizableMessage message;
        ModifyDNRequest modifyDNRequest;
        if (!record.iterator.hasNext()) {
            LocalizableMessage message2 = CoreMessages.ERR_LDIF_NO_NEW_RDN.get((Object)record.lineNumber, (Object)entryDN.toString());
            throw DecodeException.error(message2);
        }
        AbstractLDIFReader.KeyValuePair pair = new AbstractLDIFReader.KeyValuePair();
        String ldifLine = this.readLDIFRecordKeyValuePair(record, pair, true);
        if (pair.key == null || !StaticUtils.toLowerCase(pair.key).equals("newrdn")) {
            LocalizableMessage message3 = CoreMessages.ERR_LDIF_MALFORMED_NEW_RDN.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)ldifLine);
            throw DecodeException.error(message3);
        }
        try {
            RDN newRDN = RDN.valueOf(pair.value, this.schema);
            modifyDNRequest = Requests.newModifyDNRequest(entryDN, newRDN);
        }
        catch (LocalizedIllegalArgumentException e) {
            LocalizableMessage message4 = CoreMessages.ERR_LDIF_MALFORMED_NEW_RDN.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)pair.value);
            throw DecodeException.error(message4);
        }
        if (!record.iterator.hasNext()) {
            message = CoreMessages.ERR_LDIF_NO_DELETE_OLD_RDN.get((Object)record.lineNumber, (Object)entryDN.toString());
            throw DecodeException.error(message);
        }
        ldifLine = this.readLDIFRecordKeyValuePair(record, pair, true);
        if (pair.key == null || !StaticUtils.toLowerCase(pair.key).equals("deleteoldrdn")) {
            message = CoreMessages.ERR_LDIF_MALFORMED_DELETE_OLD_RDN.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)ldifLine);
            throw DecodeException.error(message);
        }
        String delStr = StaticUtils.toLowerCase(pair.value);
        if (delStr.equals("false") || delStr.equals("no") || delStr.equals("0")) {
            modifyDNRequest.setDeleteOldRDN(false);
        } else if (delStr.equals("true") || delStr.equals("yes") || delStr.equals("1")) {
            modifyDNRequest.setDeleteOldRDN(true);
        } else {
            LocalizableMessage message5 = CoreMessages.ERR_LDIF_MALFORMED_DELETE_OLD_RDN.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)pair.value);
            throw DecodeException.error(message5);
        }
        if (record.iterator.hasNext()) {
            ldifLine = this.readLDIFRecordKeyValuePair(record, pair, true);
            if (pair.key == null || !StaticUtils.toLowerCase(pair.key).equals("newsuperior")) {
                LocalizableMessage message6 = CoreMessages.ERR_LDIF_MALFORMED_NEW_SUPERIOR.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)ldifLine);
                throw DecodeException.error(message6);
            }
            try {
                DN newSuperiorDN = DN.valueOf(pair.value, this.schema);
                modifyDNRequest.setNewSuperior(newSuperiorDN.toString());
            }
            catch (LocalizedIllegalArgumentException e) {
                LocalizableMessage message7 = CoreMessages.ERR_LDIF_MALFORMED_NEW_SUPERIOR.get((Object)record.lineNumber, (Object)entryDN.toString(), (Object)pair.value);
                throw DecodeException.error(message7);
            }
        }
        return modifyDNRequest;
    }
}

