/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.ErrorResultIOException;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordVisitorWriter;
import org.forgerock.opendj.ldif.ChangeRecordWriter;

public final class ConnectionChangeRecordWriter
implements ChangeRecordWriter {
    private final Connection connection;

    public ConnectionChangeRecordWriter(Connection connection) {
        Validator.ensureNotNull(connection);
        this.connection = connection;
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public void flush() {
    }

    @Override
    public ConnectionChangeRecordWriter writeChangeRecord(AddRequest change) throws ErrorResultIOException {
        Validator.ensureNotNull(change);
        try {
            this.connection.add(change);
        }
        catch (ErrorResultException e) {
            throw new ErrorResultIOException(e);
        }
        return this;
    }

    @Override
    public ConnectionChangeRecordWriter writeChangeRecord(ChangeRecord change) throws ErrorResultIOException {
        Validator.ensureNotNull(change);
        IOException e = change.accept(ChangeRecordVisitorWriter.getInstance(), this);
        try {
            if (e != null) {
                throw e;
            }
        }
        catch (ErrorResultIOException e1) {
            throw e1;
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        return this;
    }

    @Override
    public ConnectionChangeRecordWriter writeChangeRecord(DeleteRequest change) throws ErrorResultIOException {
        Validator.ensureNotNull(change);
        try {
            this.connection.delete(change);
        }
        catch (ErrorResultException e) {
            throw new ErrorResultIOException(e);
        }
        return this;
    }

    @Override
    public ConnectionChangeRecordWriter writeChangeRecord(ModifyDNRequest change) throws ErrorResultIOException {
        Validator.ensureNotNull(change);
        try {
            this.connection.modifyDN(change);
        }
        catch (ErrorResultException e) {
            throw new ErrorResultIOException(e);
        }
        return this;
    }

    @Override
    public ConnectionChangeRecordWriter writeChangeRecord(ModifyRequest change) throws ErrorResultIOException {
        Validator.ensureNotNull(change);
        try {
            this.connection.modify(change);
        }
        catch (ErrorResultException e) {
            throw new ErrorResultIOException(e);
        }
        return this;
    }

    @Override
    public ConnectionChangeRecordWriter writeComment(CharSequence comment) {
        Validator.ensureNotNull(comment);
        return this;
    }
}

