/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class UserPasswordSyntaxImpl
extends AbstractSyntaxImpl {
    UserPasswordSyntaxImpl() {
    }

    static String[] decodeUserPassword(String userPasswordValue) throws DecodeException {
        if (userPasswordValue == null || userPasswordValue.length() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_USERPW_NO_VALUE.get();
            throw DecodeException.error(message);
        }
        if (userPasswordValue.charAt(0) != '{') {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_USERPW_NO_OPENING_BRACE.get();
            throw DecodeException.error(message);
        }
        int closePos = userPasswordValue.indexOf(125);
        if (closePos < 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_USERPW_NO_CLOSING_BRACE.get();
            throw DecodeException.error(message);
        }
        String schemeName = userPasswordValue.substring(1, closePos);
        String encodedValue = userPasswordValue.substring(closePos + 1);
        if (schemeName.length() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_USERPW_NO_SCHEME.get();
            throw DecodeException.error(message);
        }
        return new String[]{StaticUtils.toLowerCase(schemeName), encodedValue};
    }

    static boolean isEncoded(ByteSequence value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        if (value.byteAt(0) != 123) {
            return false;
        }
        int closingBracePos = -1;
        for (int i = 1; i < value.length(); ++i) {
            if (value.byteAt(i) != 125) continue;
            closingBracePos = i;
            break;
        }
        if (closingBracePos < 0 || closingBracePos == 1) {
            return false;
        }
        return closingBracePos != value.length() - 1;
    }

    @Override
    public String getEqualityMatchingRule() {
        return "1.3.6.1.4.1.26027.1.4.2";
    }

    @Override
    public String getName() {
        return "ds-syntax-user-password";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        return true;
    }
}

