/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;

final class SchemaUtils {
    static List<String> readExtensions(SubstringReader reader) throws DecodeException {
        int length = 0;
        reader.skipWhitespaces();
        reader.mark();
        try {
            List<String> values;
            char c = reader.read();
            if (c == '\'') {
                reader.mark();
                while (reader.read() != '\'') {
                    ++length;
                }
                reader.reset();
                values = Collections.singletonList(reader.read(length));
                reader.read();
            } else if (c == '(') {
                reader.skipWhitespaces();
                reader.mark();
                c = reader.read();
                if (c == ')') {
                    values = Collections.emptyList();
                } else {
                    values = new ArrayList<String>();
                    do {
                        reader.reset();
                        values.add(SchemaUtils.readQuotedString(reader));
                        reader.skipWhitespaces();
                        reader.mark();
                    } while (reader.read() != ')');
                    values = Collections.unmodifiableList(values);
                }
            } else {
                do {
                    ++length;
                } while (reader.read() != ' ');
                reader.reset();
                values = Collections.singletonList(reader.read(length));
            }
            return values;
        }
        catch (StringIndexOutOfBoundsException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TRUNCATED_VALUE1.get();
            throw DecodeException.error(message);
        }
    }

    static List<String> readNameDescriptors(SubstringReader reader, boolean allowCompatChars) throws DecodeException {
        reader.skipWhitespaces();
        try {
            List<String> values;
            reader.mark();
            char c = reader.read();
            if (c == '\'') {
                reader.reset();
                values = Collections.singletonList(SchemaUtils.readQuotedDescriptor(reader, allowCompatChars));
                reader.read();
            } else if (c == '(') {
                reader.skipWhitespaces();
                reader.mark();
                c = reader.read();
                if (c == ')') {
                    values = Collections.emptyList();
                } else {
                    values = new LinkedList<String>();
                    do {
                        reader.reset();
                        values.add(SchemaUtils.readQuotedDescriptor(reader, allowCompatChars));
                        reader.skipWhitespaces();
                        reader.mark();
                    } while (reader.read() != ')');
                    values = Collections.unmodifiableList(values);
                }
            } else {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ILLEGAL_CHAR_IN_STRING_OID1.get((Object)String.valueOf(c), (Object)(reader.pos() - 1));
                throw DecodeException.error(message);
            }
            return values;
        }
        catch (StringIndexOutOfBoundsException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TRUNCATED_VALUE1.get();
            throw DecodeException.error(message);
        }
    }

    static String readOID(SubstringReader reader, boolean allowCompatChars) throws DecodeException {
        int length = 0;
        boolean enclosingQuote = false;
        reader.skipWhitespaces();
        reader.mark();
        if (reader.remaining() > 0) {
            if (reader.read() == '\'') {
                enclosingQuote = true;
                reader.mark();
            } else {
                reader.reset();
            }
        }
        if (reader.remaining() > 0) {
            char c = reader.read();
            ++length;
            if (StaticUtils.isDigit(c)) {
                boolean lastWasPeriod = false;
                while (!(reader.remaining() <= 0 || (c = reader.read()) == ' ' || c == ')' || c == '\'' && enclosingQuote)) {
                    if (c == '.') {
                        if (lastWasPeriod) {
                            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OID_CONSECUTIVE_PERIODS1.get((Object)(reader.pos() - 1));
                            throw DecodeException.error(message);
                        }
                        lastWasPeriod = true;
                    } else {
                        if (!StaticUtils.isDigit(c)) {
                            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OID_ILLEGAL_CHARACTER1.get((Object)String.valueOf(c), (Object)(reader.pos() - 1));
                            throw DecodeException.error(message);
                        }
                        lastWasPeriod = false;
                    }
                    ++length;
                }
                if (lastWasPeriod) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OID_ENDS_WITH_PERIOD1.get((Object)(reader.pos() - 1));
                    throw DecodeException.error(message);
                }
            } else if (StaticUtils.isAlpha(c)) {
                while (!(reader.remaining() <= 0 || (c = reader.read()) == ' ' || c == ')' || c == '\'' && enclosingQuote)) {
                    if (length == 0 && !StaticUtils.isAlpha(c)) {
                        LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ILLEGAL_CHAR_IN_STRING_OID1.get((Object)String.valueOf(c), (Object)(reader.pos() - 1));
                        throw DecodeException.error(message);
                    }
                    if (!StaticUtils.isKeyChar(c, allowCompatChars)) {
                        LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ILLEGAL_CHAR_IN_STRING_OID1.get((Object)String.valueOf(c), (Object)(reader.pos() - 1));
                        throw DecodeException.error(message);
                    }
                    ++length;
                }
            } else {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ILLEGAL_CHAR_IN_STRING_OID1.get((Object)String.valueOf(c), (Object)(reader.pos() - 1));
                throw DecodeException.error(message);
            }
            if (enclosingQuote && c != '\'') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_EXPECTED_QUOTE_AT_POS1.get((Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw DecodeException.error(message);
            }
        }
        if (length == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OID_NO_VALUE1.get((Object)(reader.pos() - 1));
            throw DecodeException.error(message);
        }
        reader.reset();
        String oid = reader.read(length);
        if (enclosingQuote) {
            reader.read();
        }
        return oid;
    }

    static String readOIDLen(SubstringReader reader, boolean allowCompatChars) throws DecodeException {
        int length = 1;
        boolean enclosingQuote = false;
        reader.skipWhitespaces();
        reader.mark();
        try {
            char c = reader.read();
            if (c == '\'') {
                enclosingQuote = true;
                reader.mark();
                c = reader.read();
            }
            if (StaticUtils.isDigit(c)) {
                boolean lastWasPeriod = false;
                while (!((c = reader.read()) == ' ' || c == '{' || c == '\'' && enclosingQuote)) {
                    if (c == '.') {
                        if (lastWasPeriod) {
                            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OID_CONSECUTIVE_PERIODS1.get((Object)(reader.pos() - 1));
                            throw DecodeException.error(message);
                        }
                        lastWasPeriod = true;
                    } else {
                        if (!StaticUtils.isDigit(c)) {
                            if (c == ')') break;
                            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OID_ILLEGAL_CHARACTER1.get((Object)String.valueOf(c), (Object)(reader.pos() - 1));
                            throw DecodeException.error(message);
                        }
                        lastWasPeriod = false;
                    }
                    ++length;
                }
                if (length == 0) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OID_NO_VALUE1.get((Object)(reader.pos() - 1));
                    throw DecodeException.error(message);
                }
            } else if (StaticUtils.isAlpha(c)) {
                while (!((c = reader.read()) == ' ' || c == ')' || c == '{' || c == '\'' && enclosingQuote)) {
                    if (length == 0 && !StaticUtils.isAlpha(c)) {
                        LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ILLEGAL_CHAR_IN_STRING_OID1.get((Object)String.valueOf(c), (Object)(reader.pos() - 1));
                        throw DecodeException.error(message);
                    }
                    if (!StaticUtils.isKeyChar(c, allowCompatChars)) {
                        LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ILLEGAL_CHAR_IN_STRING_OID1.get((Object)String.valueOf(c), (Object)(reader.pos() - 1));
                        throw DecodeException.error(message);
                    }
                    ++length;
                }
            } else {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ILLEGAL_CHAR_IN_STRING_OID1.get((Object)String.valueOf(c), (Object)(reader.pos() - 1));
                throw DecodeException.error(message);
            }
            reader.reset();
            String oid = reader.read(length);
            reader.mark();
            c = reader.read();
            if (c == '{') {
                reader.mark();
                while ((c = reader.read()) != '}') {
                    if (StaticUtils.isDigit(c)) continue;
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OID_ILLEGAL_CHARACTER1.get((Object)reader.getString(), (Object)(reader.pos() - 1));
                    throw DecodeException.error(message);
                }
            } else if (c == '\'') {
                reader.mark();
            } else {
                reader.reset();
            }
            return oid;
        }
        catch (StringIndexOutOfBoundsException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TRUNCATED_VALUE1.get();
            throw DecodeException.error(message);
        }
    }

    static Set<String> readOIDs(SubstringReader reader, boolean allowCompatChars) throws DecodeException {
        reader.skipWhitespaces();
        reader.mark();
        try {
            Set<String> values;
            char c = reader.read();
            if (c == '(') {
                values = new LinkedHashSet<String>();
                do {
                    values.add(SchemaUtils.readOID(reader, allowCompatChars));
                    reader.skipWhitespaces();
                } while (reader.read() != ')');
                values = Collections.unmodifiableSet(values);
            } else {
                reader.reset();
                values = Collections.singleton(SchemaUtils.readOID(reader, allowCompatChars));
            }
            return values;
        }
        catch (StringIndexOutOfBoundsException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TRUNCATED_VALUE1.get();
            throw DecodeException.error(message);
        }
    }

    static String readQuotedString(SubstringReader reader) throws DecodeException {
        int length = 0;
        reader.skipWhitespaces();
        try {
            char c = reader.read();
            if (c != '\'') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_EXPECTED_QUOTE_AT_POS1.get((Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw DecodeException.error(message);
            }
            reader.mark();
            while (reader.read() != '\'') {
                ++length;
            }
            reader.reset();
            String str = reader.read(length);
            reader.read();
            return str;
        }
        catch (StringIndexOutOfBoundsException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TRUNCATED_VALUE1.get();
            throw DecodeException.error(message);
        }
    }

    static Integer readRuleID(SubstringReader reader) throws DecodeException {
        int length = 0;
        reader.skipWhitespaces();
        reader.mark();
        try {
            while (reader.read() != ' ') {
                ++length;
            }
            if (length == 0) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_RULE_ID_NO_VALUE1.get((Object)(reader.pos() - 1));
                throw DecodeException.error(message);
            }
            reader.reset();
            String ruleID = reader.read(length);
            try {
                return Integer.valueOf(ruleID);
            }
            catch (NumberFormatException e) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_RULE_ID_INVALID1.get((Object)ruleID);
                throw DecodeException.error(message);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TRUNCATED_VALUE1.get();
            throw DecodeException.error(message);
        }
    }

    static Set<Integer> readRuleIDs(SubstringReader reader) throws DecodeException {
        reader.skipWhitespaces();
        reader.mark();
        try {
            Set<Integer> values;
            char c = reader.read();
            if (c == '(') {
                values = new LinkedHashSet<Integer>();
                do {
                    values.add(SchemaUtils.readRuleID(reader));
                    reader.skipWhitespaces();
                } while (reader.read() != ')');
                values = Collections.unmodifiableSet(values);
            } else {
                reader.reset();
                values = Collections.singleton(SchemaUtils.readRuleID(reader));
            }
            return values;
        }
        catch (StringIndexOutOfBoundsException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TRUNCATED_VALUE1.get();
            throw DecodeException.error(message);
        }
    }

    static String readTokenName(SubstringReader reader) throws DecodeException {
        String token = null;
        int length = 0;
        reader.skipWhitespaces();
        reader.mark();
        try {
            char c;
            while ((c = reader.read()) != ' ' && c != ')') {
                ++length;
            }
            if (length > 0) {
                reader.reset();
                token = reader.read(length);
            }
            reader.skipWhitespaces();
            if (token == null && reader.remaining() > 0) {
                reader.reset();
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UNEXPECTED_CLOSE_PARENTHESIS1.get((Object)length);
                throw DecodeException.error(message);
            }
            return token;
        }
        catch (StringIndexOutOfBoundsException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TRUNCATED_VALUE1.get();
            throw DecodeException.error(message);
        }
    }

    static Map<String, List<String>> unmodifiableCopyOfExtraProperties(Map<String, List<String>> extraProperties) {
        if (extraProperties == null || extraProperties.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> tmp = new LinkedHashMap<String, List<String>>(extraProperties.size());
        for (Map.Entry<String, List<String>> e : extraProperties.entrySet()) {
            tmp.put(e.getKey(), SchemaUtils.unmodifiableCopyOfList(e.getValue()));
        }
        return Collections.unmodifiableMap(tmp);
    }

    static <E> List<E> unmodifiableCopyOfList(List<E> l) {
        if (l == null || l.isEmpty()) {
            return Collections.emptyList();
        }
        if (l.size() == 1) {
            return Collections.singletonList(l.get(0));
        }
        LinkedList<E> copy = new LinkedList<E>(l);
        return Collections.unmodifiableList(copy);
    }

    static <E> Set<E> unmodifiableCopyOfSet(Set<E> s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptySet();
        }
        if (s.size() == 1) {
            return Collections.singleton(s.iterator().next());
        }
        LinkedHashSet<E> copy = new LinkedHashSet<E>(s);
        return Collections.unmodifiableSet(copy);
    }

    private static String readQuotedDescriptor(SubstringReader reader, boolean allowCompatChars) throws DecodeException {
        int length = 0;
        reader.skipWhitespaces();
        try {
            char c = reader.read();
            if (c != '\'') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_EXPECTED_QUOTE_AT_POS1.get((Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw DecodeException.error(message);
            }
            reader.mark();
            while ((c = reader.read()) != '\'') {
                if (length == 0 && !StaticUtils.isAlpha(c)) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ILLEGAL_CHAR_IN_STRING_OID1.get((Object)String.valueOf(c), (Object)(reader.pos() - 1));
                    throw DecodeException.error(message);
                }
                if (!StaticUtils.isKeyChar(c, allowCompatChars)) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ILLEGAL_CHAR_IN_STRING_OID1.get((Object)String.valueOf(c), (Object)(reader.pos() - 1));
                    throw DecodeException.error(message);
                }
                ++length;
            }
            reader.reset();
            String descr = reader.read(length);
            reader.read();
            return descr;
        }
        catch (StringIndexOutOfBoundsException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TRUNCATED_VALUE1.get();
            throw DecodeException.error(message);
        }
    }

    private SchemaUtils() {
    }
}

