/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class SchemaElement {
    final String description;
    final Map<String, List<String>> extraProperties;

    SchemaElement(String description, Map<String, List<String>> extraProperties) {
        Validator.ensureNotNull((Object)description, extraProperties);
        this.description = description;
        this.extraProperties = extraProperties;
    }

    public abstract boolean equals(Object var1);

    public final String getDescription() {
        return this.description;
    }

    public final List<String> getExtraProperty(String name) {
        List<String> values = this.extraProperties.get(name);
        return values != null ? values : Collections.emptyList();
    }

    public final Set<String> getExtraPropertyNames() {
        return this.extraProperties.keySet();
    }

    public abstract int hashCode();

    public abstract String toString();

    final String buildDefinition() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("( ");
        this.toStringContent(buffer);
        if (!this.extraProperties.isEmpty()) {
            for (Map.Entry<String, List<String>> e : this.extraProperties.entrySet()) {
                String property = e.getKey();
                List<String> valueList = e.getValue();
                buffer.append(" ");
                buffer.append(property);
                if (valueList.size() == 1) {
                    buffer.append(" '");
                    buffer.append(valueList.get(0));
                    buffer.append("'");
                    continue;
                }
                buffer.append(" ( ");
                for (String value : valueList) {
                    buffer.append("'");
                    buffer.append(value);
                    buffer.append("' ");
                }
                buffer.append(")");
            }
        }
        buffer.append(" )");
        return buffer.toString();
    }

    abstract void toStringContent(StringBuilder var1);
}

