/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.ObjectIdentifierEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class ObjectIdentifierFirstComponentEqualityMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    ObjectIdentifierFirstComponentEqualityMatchingRuleImpl() {
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
        String definition = value.toString();
        SubstringReader reader = new SubstringReader(definition);
        String normalized = ObjectIdentifierEqualityMatchingRuleImpl.resolveNames(schema, SchemaUtils.readOID(reader, schema.allowMalformedNamesAndOptions()));
        return new AbstractMatchingRuleImpl.DefaultEqualityAssertion(ByteString.valueOf(normalized));
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String definition = value.toString();
        SubstringReader reader = new SubstringReader(definition);
        reader.skipWhitespaces();
        if (reader.remaining() <= 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_EMPTY_VALUE.get();
            throw DecodeException.error(message);
        }
        char c = reader.read();
        if (c != '(') {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
            throw DecodeException.error(message);
        }
        reader.skipWhitespaces();
        String normalized = ObjectIdentifierEqualityMatchingRuleImpl.resolveNames(schema, SchemaUtils.readOID(reader, schema.allowMalformedNamesAndOptions()));
        return ByteString.valueOf(normalized);
    }
}

