/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class ObjectIdentifierEqualityMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    ObjectIdentifierEqualityMatchingRuleImpl() {
    }

    static String resolveNames(Schema schema, String oid) {
        if (!StaticUtils.isDigit(oid.charAt(0))) {
            String schemaName = null;
            if (schema.hasAttributeType(oid)) {
                schemaName = schema.getAttributeType(oid).getOID();
            }
            if (schemaName == null && schema.hasDITContentRule(oid)) {
                schemaName = schema.getDITContentRule(oid).getStructuralClass().getOID();
            }
            if (schemaName == null && schema.hasSyntax(oid)) {
                schemaName = schema.getSyntax(oid).getOID();
            }
            if (schemaName == null && schema.hasObjectClass(oid)) {
                schemaName = schema.getObjectClass(oid).getOID();
            }
            if (schemaName == null && schema.hasMatchingRule(oid)) {
                schemaName = schema.getMatchingRule(oid).getOID();
            }
            if (schemaName == null && schema.hasMatchingRuleUse(oid)) {
                schemaName = schema.getMatchingRuleUse(oid).getMatchingRule().getOID();
            }
            if (schemaName == null && schema.hasNameForm(oid)) {
                schemaName = schema.getNameForm(oid).getOID();
            }
            if (schemaName != null) {
                return schemaName;
            }
            return StaticUtils.toLowerCase(oid);
        }
        return oid;
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
        String definition = value.toString();
        SubstringReader reader = new SubstringReader(definition);
        String normalized = ObjectIdentifierEqualityMatchingRuleImpl.resolveNames(schema, SchemaUtils.readOID(reader, schema.allowMalformedNamesAndOptions()));
        return new AbstractMatchingRuleImpl.DefaultEqualityAssertion(ByteString.valueOf(normalized));
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String definition = value.toString();
        SubstringReader reader = new SubstringReader(definition);
        String normalized = ObjectIdentifierEqualityMatchingRuleImpl.resolveNames(schema, SchemaUtils.readOID(reader, schema.allowMalformedNamesAndOptions()));
        return ByteString.valueOf(normalized);
    }
}

