/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class NameAndOptionalUIDSyntaxImpl
extends AbstractSyntaxImpl {
    NameAndOptionalUIDSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.23";
    }

    @Override
    public String getName() {
        return "NameAndOptionalUID";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        int valueLength;
        String valueString = value.toString().trim();
        int dnEndPos = valueLength = valueString.length();
        int sharpPos = -1;
        if ((valueString.endsWith("'B") || valueString.endsWith("'b")) && (sharpPos = valueString.lastIndexOf("#'")) > 0) {
            dnEndPos = sharpPos;
        }
        try {
            DN.valueOf(valueString.substring(0, dnEndPos), schema);
        }
        catch (LocalizedIllegalArgumentException e) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_NAMEANDUID_INVALID_DN.get((Object)valueString, (Object)e.getMessageObject()));
            return false;
        }
        if (sharpPos > 0) {
            int endPos = valueLength - 2;
            for (int i = sharpPos + 2; i < endPos; ++i) {
                char c = valueString.charAt(i);
                if (c == '0' || c == '1') continue;
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_NAMEANDUID_ILLEGAL_BINARY_DIGIT.get((Object)valueString, (Object)String.valueOf(c), (Object)i));
                return false;
            }
        }
        return true;
    }
}

