/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.Validator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class MatchingRule
extends SchemaElement {
    private final String oid;
    private final List<String> names;
    private final boolean isObsolete;
    private final String syntaxOID;
    private final String definition;
    private MatchingRuleImpl impl;
    private Syntax syntax;
    private Schema schema;

    MatchingRule(String oid, List<String> names, String description, boolean obsolete, String syntax, Map<String, List<String>> extraProperties, String definition, MatchingRuleImpl implementation) {
        super(description, extraProperties);
        Validator.ensureNotNull((Object)oid, names, (Object)description, (Object)syntax);
        Validator.ensureNotNull(extraProperties);
        this.oid = oid;
        this.names = names;
        this.isObsolete = obsolete;
        this.syntaxOID = syntax;
        this.definition = definition != null ? definition : this.buildDefinition();
        this.impl = implementation;
    }

    public Comparator<ByteSequence> comparator() {
        return this.impl.comparator(this.schema);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MatchingRule) {
            MatchingRule other = (MatchingRule)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public Assertion getAssertion(ByteSequence value) throws DecodeException {
        return this.impl.getAssertion(this.schema, value);
    }

    public Assertion getAssertion(ByteSequence subInitial, List<? extends ByteSequence> subAnyElements, ByteSequence subFinal) throws DecodeException {
        return this.impl.getAssertion(this.schema, subInitial, subAnyElements, subFinal);
    }

    public Assertion getGreaterOrEqualAssertion(ByteSequence value) throws DecodeException {
        return this.impl.getGreaterOrEqualAssertion(this.schema, value);
    }

    public Assertion getLessOrEqualAssertion(ByteSequence value) throws DecodeException {
        return this.impl.getLessOrEqualAssertion(this.schema, value);
    }

    public String getNameOrOID() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getOID() {
        return this.oid;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOID(String value) {
        return this.hasName(value) || this.getOID().equals(value);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public ByteString normalizeAttributeValue(ByteSequence value) throws DecodeException {
        return this.impl.normalizeAttributeValue(this.schema, value);
    }

    @Override
    public String toString() {
        return this.definition;
    }

    MatchingRule duplicate() {
        return new MatchingRule(this.oid, this.names, this.description, this.isObsolete, this.syntaxOID, this.extraProperties, this.definition, this.impl);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            Iterator<String> iterator = this.names.iterator();
            String firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" SYNTAX ");
        buffer.append(this.syntaxOID);
    }

    void validate(Schema schema, List<LocalizableMessage> warnings) throws SchemaException {
        if (this.impl == null && Schema.getDefaultSchema().hasMatchingRule(this.oid)) {
            this.impl = Schema.getDefaultSchema().getMatchingRule((String)this.oid).impl;
        }
        if (this.impl == null && Schema.getCoreSchema().hasMatchingRule(this.oid)) {
            this.impl = Schema.getCoreSchema().getMatchingRule((String)this.oid).impl;
        }
        if (this.impl == null) {
            this.impl = Schema.getDefaultMatchingRule().impl;
            LocalizableMessage message = CoreMessages.WARN_MATCHING_RULE_NOT_IMPLEMENTED1.get((Object)this.getNameOrOID(), (Object)Schema.getDefaultMatchingRule().getOID());
            warnings.add(message);
        }
        try {
            this.syntax = schema.getSyntax(this.syntaxOID);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MR_UNKNOWN_SYNTAX1.get((Object)this.getNameOrOID(), (Object)this.syntaxOID);
            throw new SchemaException(message, (Throwable)((Object)e));
        }
        this.schema = schema;
    }
}

