/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class IntegerFirstComponentEqualityMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    IntegerFirstComponentEqualityMatchingRuleImpl() {
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
        try {
            String definition = value.toString();
            SubstringReader reader = new SubstringReader(definition);
            final int intValue = SchemaUtils.readRuleID(reader);
            return new Assertion(){

                @Override
                public ConditionResult matches(ByteSequence attributeValue) {
                    int actualIntValue = attributeValue.toByteString().toInt();
                    return intValue == actualIntValue ? ConditionResult.TRUE : ConditionResult.FALSE;
                }
            };
        }
        catch (Exception e) {
            StaticUtils.DEBUG_LOG.throwing("IntegerFirstComponentEqualityMatchingRule", "getAssertion", e);
            LocalizableMessage message = CoreMessages.ERR_EMR_INTFIRSTCOMP_FIRST_COMPONENT_NOT_INT.get((Object)value.toString());
            throw DecodeException.error(message);
        }
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String definition = value.toString();
        SubstringReader reader = new SubstringReader(definition);
        reader.skipWhitespaces();
        if (reader.remaining() <= 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_EMPTY_VALUE.get();
            throw DecodeException.error(message);
        }
        char c = reader.read();
        if (c != '(') {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
            throw DecodeException.error(message);
        }
        reader.skipWhitespaces();
        return ByteString.valueOf(SchemaUtils.readRuleID(reader));
    }
}

