/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class DirectoryStringSyntaxImpl
extends AbstractSyntaxImpl {
    DirectoryStringSyntaxImpl() {
    }

    @Override
    public String getApproximateMatchingRule() {
        return "1.3.6.1.4.1.26027.1.4.1";
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.2";
    }

    @Override
    public String getName() {
        return "DirectoryString";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.3";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        if (value.length() > 0 || schema.allowZeroLengthDirectoryStrings()) {
            return true;
        }
        invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_DIRECTORYSTRING_INVALID_ZEROLENGTH_VALUE.get());
        return false;
    }
}

