/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class DITStructureRule
extends SchemaElement {
    private final Integer ruleID;
    private final List<String> names;
    private final boolean isObsolete;
    private final String nameFormOID;
    private final Set<Integer> superiorRuleIDs;
    private final String definition;
    private NameForm nameForm;
    private Set<DITStructureRule> superiorRules = Collections.emptySet();
    private boolean needsValidating = true;
    private boolean isValid = false;

    DITStructureRule(Integer ruleID, List<String> names, String description, boolean obsolete, String nameFormOID, Set<Integer> superiorRuleIDs, Map<String, List<String>> extraProperties, String definition) {
        super(description, extraProperties);
        Validator.ensureNotNull((Object)ruleID, (Object)nameFormOID, superiorRuleIDs);
        this.ruleID = ruleID;
        this.names = names;
        this.isObsolete = obsolete;
        this.nameFormOID = nameFormOID;
        this.superiorRuleIDs = superiorRuleIDs;
        this.definition = definition != null ? definition : this.buildDefinition();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DITStructureRule) {
            DITStructureRule other = (DITStructureRule)o;
            return this.ruleID.equals(other.ruleID);
        }
        return false;
    }

    public NameForm getNameForm() {
        return this.nameForm;
    }

    public String getNameOrRuleID() {
        if (this.names.isEmpty()) {
            return this.ruleID.toString();
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public Integer getRuleID() {
        return this.ruleID;
    }

    public Set<DITStructureRule> getSuperiorRules() {
        return this.superiorRules;
    }

    @Override
    public int hashCode() {
        return this.ruleID.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    @Override
    public String toString() {
        return this.definition;
    }

    DITStructureRule duplicate() {
        return new DITStructureRule(this.ruleID, this.names, this.description, this.isObsolete, this.nameFormOID, this.superiorRuleIDs, this.extraProperties, this.definition);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        Iterator<Object> iterator;
        buffer.append(this.ruleID);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            String firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append((String)iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" FORM ");
        buffer.append(this.nameFormOID);
        if (this.superiorRuleIDs != null && !this.superiorRuleIDs.isEmpty()) {
            iterator = this.superiorRuleIDs.iterator();
            Integer firstRule = (Integer)iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" SUP ( ");
                buffer.append(firstRule);
                while (iterator.hasNext()) {
                    buffer.append(" ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" SUP ");
                buffer.append(firstRule);
            }
        }
    }

    boolean validate(Schema schema, List<DITStructureRule> invalidSchemaElements, List<LocalizableMessage> warnings) {
        if (!this.needsValidating) {
            return this.isValid;
        }
        this.needsValidating = false;
        try {
            this.nameForm = schema.getNameForm(this.nameFormOID);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DSR_UNKNOWN_NAME_FORM.get((Object)this.getNameOrRuleID(), (Object)this.nameFormOID);
            this.failValidation(invalidSchemaElements, warnings, message);
            return false;
        }
        if (!this.superiorRuleIDs.isEmpty()) {
            this.superiorRules = new HashSet<DITStructureRule>(this.superiorRuleIDs.size());
            for (Integer id : this.superiorRuleIDs) {
                DITStructureRule rule;
                try {
                    rule = schema.getDITStructureRule(id);
                }
                catch (UnknownSchemaElementException e) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DSR_UNKNOWN_RULE_ID.get((Object)this.getNameOrRuleID(), (Object)id);
                    this.failValidation(invalidSchemaElements, warnings, message);
                    return false;
                }
                this.superiorRules.add(rule);
            }
        }
        this.superiorRules = Collections.unmodifiableSet(this.superiorRules);
        this.isValid = true;
        return true;
    }

    private void failValidation(List<DITStructureRule> invalidSchemaElements, List<LocalizableMessage> warnings, LocalizableMessage message) {
        invalidSchemaElements.add(this);
        warnings.add(CoreMessages.ERR_DSR_VALIDATION_FAIL.get((Object)this.toString(), (Object)message));
    }
}

