/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class DITContentRule
extends SchemaElement {
    private final String structuralClassOID;
    private final List<String> names;
    private final boolean isObsolete;
    private final Set<String> auxiliaryClassOIDs;
    private final Set<String> optionalAttributeOIDs;
    private final Set<String> prohibitedAttributeOIDs;
    private final Set<String> requiredAttributeOIDs;
    private final String definition;
    private ObjectClass structuralClass;
    private Set<ObjectClass> auxiliaryClasses = Collections.emptySet();
    private Set<AttributeType> optionalAttributes = Collections.emptySet();
    private Set<AttributeType> prohibitedAttributes = Collections.emptySet();
    private Set<AttributeType> requiredAttributes = Collections.emptySet();

    DITContentRule(String structuralClassOID, List<String> names, String description, boolean obsolete, Set<String> auxiliaryClassOIDs, Set<String> optionalAttributeOIDs, Set<String> prohibitedAttributeOIDs, Set<String> requiredAttributeOIDs, Map<String, List<String>> extraProperties, String definition) {
        super(description, extraProperties);
        Validator.ensureNotNull((Object)structuralClassOID, names);
        Validator.ensureNotNull(auxiliaryClassOIDs, optionalAttributeOIDs, prohibitedAttributeOIDs, requiredAttributeOIDs);
        this.names = names;
        this.isObsolete = obsolete;
        this.structuralClassOID = structuralClassOID;
        this.auxiliaryClassOIDs = auxiliaryClassOIDs;
        this.optionalAttributeOIDs = optionalAttributeOIDs;
        this.prohibitedAttributeOIDs = prohibitedAttributeOIDs;
        this.requiredAttributeOIDs = requiredAttributeOIDs;
        this.definition = definition != null ? definition : this.buildDefinition();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DITContentRule) {
            DITContentRule other = (DITContentRule)o;
            return this.structuralClassOID.equals(other.structuralClassOID);
        }
        return false;
    }

    public Set<ObjectClass> getAuxiliaryClasses() {
        return this.auxiliaryClasses;
    }

    public String getNameOrOID() {
        if (this.names.isEmpty()) {
            return this.structuralClassOID;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public Set<AttributeType> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Set<AttributeType> getProhibitedAttributes() {
        return this.prohibitedAttributes;
    }

    public Set<AttributeType> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public ObjectClass getStructuralClass() {
        return this.structuralClass;
    }

    public String getStructuralClassOID() {
        return this.structuralClassOID;
    }

    @Override
    public int hashCode() {
        return this.structuralClassOID.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOID(String value) {
        return this.hasName(value) || this.structuralClassOID.equals(value);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public boolean isOptional(AttributeType attributeType) {
        return this.optionalAttributes.contains(attributeType);
    }

    public boolean isRequired(AttributeType attributeType) {
        return this.requiredAttributes.contains(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        return this.isRequired(attributeType) || this.isOptional(attributeType);
    }

    @Override
    public String toString() {
        return this.definition;
    }

    DITContentRule duplicate() {
        return new DITContentRule(this.structuralClassOID, this.names, this.description, this.isObsolete, this.auxiliaryClassOIDs, this.optionalAttributeOIDs, this.prohibitedAttributeOIDs, this.requiredAttributeOIDs, this.extraProperties, this.definition);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        String firstName;
        Iterator<String> iterator;
        buffer.append(this.structuralClassOID);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (!this.auxiliaryClassOIDs.isEmpty()) {
            iterator = this.auxiliaryClassOIDs.iterator();
            String firstClass = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" AUX (");
                buffer.append(firstClass);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" AUX ");
                buffer.append(firstClass);
            }
        }
        if (!this.requiredAttributeOIDs.isEmpty()) {
            iterator = this.requiredAttributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MUST ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MUST ");
                buffer.append(firstName);
            }
        }
        if (!this.optionalAttributeOIDs.isEmpty()) {
            iterator = this.optionalAttributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MAY ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MAY ");
                buffer.append(firstName);
            }
        }
        if (!this.prohibitedAttributeOIDs.isEmpty()) {
            iterator = this.prohibitedAttributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NOT ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" NOT ");
                buffer.append(firstName);
            }
        }
    }

    void validate(Schema schema, List<LocalizableMessage> warnings) throws SchemaException {
        AttributeType attributeType;
        if (this.structuralClassOID != null) {
            try {
                this.structuralClass = schema.getObjectClass(this.structuralClassOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_STRUCTURAL_CLASS1.get((Object)this.getNameOrOID(), (Object)this.structuralClassOID);
                throw new SchemaException(message, (Throwable)((Object)e));
            }
            if (this.structuralClass.getObjectClassType() != ObjectClassType.STRUCTURAL) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_STRUCTURAL_CLASS_NOT_STRUCTURAL1.get((Object)this.getNameOrOID(), (Object)this.structuralClass.getNameOrOID(), (Object)this.structuralClass.getObjectClassType().toString());
                warnings.add(message);
            }
        }
        if (!this.auxiliaryClassOIDs.isEmpty()) {
            this.auxiliaryClasses = new HashSet<ObjectClass>(this.auxiliaryClassOIDs.size());
            for (String oid : this.auxiliaryClassOIDs) {
                ObjectClass objectClass;
                try {
                    objectClass = schema.getObjectClass(oid);
                }
                catch (UnknownSchemaElementException e) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_AUXILIARY_CLASS1.get((Object)this.getNameOrOID(), (Object)oid);
                    throw new SchemaException(message, (Throwable)((Object)e));
                }
                if (objectClass.getObjectClassType() != ObjectClassType.AUXILIARY) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_AUXILIARY_CLASS_NOT_AUXILIARY1.get((Object)this.getNameOrOID(), (Object)this.structuralClass.getOID(), (Object)this.structuralClass.getObjectClassType().toString());
                    throw new SchemaException(message);
                }
                this.auxiliaryClasses.add(objectClass);
            }
        }
        if (!this.requiredAttributeOIDs.isEmpty()) {
            this.requiredAttributes = new HashSet<AttributeType>(this.requiredAttributeOIDs.size());
            for (String oid : this.requiredAttributeOIDs) {
                try {
                    attributeType = schema.getAttributeType(oid);
                }
                catch (UnknownSchemaElementException e) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_REQUIRED_ATTR1.get((Object)this.getNameOrOID(), (Object)oid);
                    throw new SchemaException(message, (Throwable)((Object)e));
                }
                this.requiredAttributes.add(attributeType);
            }
        }
        if (!this.optionalAttributeOIDs.isEmpty()) {
            this.optionalAttributes = new HashSet<AttributeType>(this.optionalAttributeOIDs.size());
            for (String oid : this.optionalAttributeOIDs) {
                try {
                    attributeType = schema.getAttributeType(oid);
                }
                catch (UnknownSchemaElementException e) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_OPTIONAL_ATTR1.get((Object)this.getNameOrOID(), (Object)oid);
                    throw new SchemaException(message, (Throwable)((Object)e));
                }
                this.optionalAttributes.add(attributeType);
            }
        }
        if (!this.prohibitedAttributeOIDs.isEmpty()) {
            this.prohibitedAttributes = new HashSet<AttributeType>(this.prohibitedAttributeOIDs.size());
            for (String oid : this.prohibitedAttributeOIDs) {
                try {
                    attributeType = schema.getAttributeType(oid);
                }
                catch (UnknownSchemaElementException e) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_PROHIBITED_ATTR1.get((Object)this.getNameOrOID(), (Object)oid);
                    throw new SchemaException(message, (Throwable)((Object)e));
                }
                this.prohibitedAttributes.add(attributeType);
            }
        }
        for (AttributeType t : this.prohibitedAttributes) {
            if (this.structuralClass.isRequired(t)) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_STRUCTURAL.get((Object)this.getNameOrOID(), (Object)t.getNameOrOID(), (Object)this.structuralClass.getNameOrOID());
                throw new SchemaException(message);
            }
            for (ObjectClass oc : this.auxiliaryClasses) {
                if (!oc.isRequired(t)) continue;
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_AUXILIARY.get((Object)this.getNameOrOID(), (Object)t.getNameOrOID(), (Object)oc.getNameOrOID());
                throw new SchemaException(message);
            }
        }
        this.auxiliaryClasses = Collections.unmodifiableSet(this.auxiliaryClasses);
        this.optionalAttributes = Collections.unmodifiableSet(this.optionalAttributes);
        this.prohibitedAttributes = Collections.unmodifiableSet(this.prohibitedAttributes);
        this.requiredAttributes = Collections.unmodifiableSet(this.requiredAttributes);
    }
}

