/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StringPrepProfile;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaConstants;

final class CaseIgnoreListEqualityMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    CaseIgnoreListEqualityMatchingRuleImpl() {
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) {
        StringBuilder buffer = new StringBuilder();
        StringPrepProfile.prepareUnicode(buffer, value, true, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.length() > 0) {
                return SchemaConstants.SINGLE_SPACE_VALUE;
            }
            return ByteString.empty();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ') continue;
            char c = buffer.charAt(pos - 1);
            if (c == ' ') {
                buffer.delete(pos, pos + 1);
                continue;
            }
            if (c == '$') {
                if (pos > 1 && buffer.charAt(pos - 2) == '\\') continue;
                buffer.delete(pos, pos + 1);
                continue;
            }
            if (buffer.charAt(pos + 1) != '$') continue;
            buffer.delete(pos, pos + 1);
        }
        return ByteString.valueOf(buffer.toString());
    }
}

