/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StringPrepProfile;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaConstants;

final class CaseExactIA5SubstringMatchingRuleImpl
extends AbstractSubstringMatchingRuleImpl {
    CaseExactIA5SubstringMatchingRuleImpl() {
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        return this.normalize(true, value);
    }

    @Override
    ByteString normalizeSubString(Schema schema, ByteSequence value) throws DecodeException {
        return this.normalize(false, value);
    }

    private ByteString normalize(boolean trim, ByteSequence value) throws DecodeException {
        StringBuilder buffer = new StringBuilder();
        StringPrepProfile.prepareUnicode(buffer, value, trim, false);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.length() > 0) {
                return SchemaConstants.SINGLE_SPACE_VALUE;
            }
            return ByteString.empty();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            char c = buffer.charAt(pos);
            if (c == ' ') {
                if (buffer.charAt(pos - 1) != ' ') continue;
                buffer.delete(pos, pos + 1);
                continue;
            }
            if ((c & 0x7F) == c) continue;
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_IA5_ILLEGAL_CHARACTER.get((Object)value.toString(), (Object)String.valueOf(c));
            throw DecodeException.error(message);
        }
        return ByteString.valueOf(buffer.toString());
    }
}

