/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class BooleanSyntaxImpl
extends AbstractSyntaxImpl {
    BooleanSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.13";
    }

    @Override
    public String getName() {
        return "Boolean";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        boolean returnValue;
        String valueString = value.toString().toUpperCase();
        boolean bl = returnValue = valueString.equals("TRUE") || valueString.equals("YES") || valueString.equals("ON") || valueString.equals("1") || valueString.equals("FALSE") || valueString.equals("NO") || valueString.equals("OFF") || valueString.equals("0");
        if (!returnValue) {
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN.get((Object)value.toString()));
        }
        return returnValue;
    }
}

